/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.value.Value;

public class H2PlainRow
extends H2Row {
    @GridToStringInclude
    private Value[] vals;
    int memory = -1;

    public H2PlainRow(Value[] vals) {
        this.vals = vals;
    }

    public H2PlainRow(int len) {
        this.vals = new Value[len];
    }

    @Override
    public int getColumnCount() {
        return this.vals.length;
    }

    @Override
    public Value getValue(int idx) {
        return this.vals[idx];
    }

    @Override
    public void setValue(int idx, Value v) {
        this.vals[idx] = v;
    }

    @Override
    public boolean indexSearchRow() {
        return true;
    }

    @Override
    public boolean hasSharedData(Row other) {
        if (other.getClass() == H2PlainRow.class) {
            return this.vals == ((H2PlainRow)other).vals;
        }
        return false;
    }

    @Override
    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        int size = 24;
        if (!F.isEmpty(this.vals)) {
            int len = this.vals.length;
            size += 24 + len * 8;
            for (Value v : this.vals) {
                if (v == null) continue;
                size += v.getMemory();
            }
        }
        this.memory = size;
        return this.memory;
    }

    public String toString() {
        return S.toString(H2PlainRow.class, this);
    }
}

