/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.List;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2IndexCostedBase;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModel;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModelMultiplier;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.jetbrains.annotations.NotNull;

public abstract class GridH2IndexBase
extends H2IndexCostedBase {
    protected GridH2IndexBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        super(tbl, name, cols, type);
    }

    @Override
    public final void close(Session ses) {
    }

    public void destroy(boolean rmv) {
    }

    protected int segment(QueryContext qctx) {
        if (this.segmentsCount() == 1) {
            return 0;
        }
        if (qctx == null) {
            throw new IllegalStateException("GridH2QueryContext is not initialized.");
        }
        return qctx.segment();
    }

    public abstract H2CacheRow put(H2CacheRow var1);

    public abstract boolean putx(H2CacheRow var1);

    public abstract boolean removex(SearchRow var1);

    public final int getDistributedMultiplier(Session ses, TableFilter[] filters, int filter) {
        CollocationModelMultiplier mul = CollocationModel.distributedMultiplier(ses, filters, filter);
        return mul.multiplier();
    }

    @Override
    public GridH2Table getTable() {
        return (GridH2Table)super.getTable();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    @Override
    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException("add");
    }

    @Override
    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException("remove row");
    }

    @Override
    public void remove(Session ses) {
    }

    @Override
    public void truncate(Session ses) {
        throw DbException.getUnsupportedException("truncate");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        assert (this.table instanceof GridH2Table);
        ((GridH2Table)this.table).removeIndex(session, this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    public abstract int segmentsCount();

    public int segmentForPartition(int part) {
        return GridH2IndexBase.calculateSegment(this.segmentsCount(), part);
    }

    public static int calculateSegment(int segmentCnt, int part) {
        return segmentCnt == 1 ? 0 : part % segmentCnt;
    }

    protected int segmentForRow(GridCacheContext ctx, SearchRow row) {
        assert (row != null);
        if (this.segmentsCount() == 1 || ctx == null) {
            return 0;
        }
        Value keyColValue = row.getValue(0);
        assert (keyColValue != null);
        Object o = keyColValue.getObject();
        CacheObject key = o instanceof CacheObject ? (CacheObject)o : ctx.toCacheKeyObject(o);
        return this.segmentForPartition(ctx.affinity().partition(key));
    }

    public void refreshColumnIds() {
        assert (this.columnIds.length == this.columns.length);
        for (int pos = 0; pos < this.columnIds.length; ++pos) {
            this.columnIds[pos] = this.columns[pos].getColumnId();
        }
    }

    protected GridH2RowDescriptor rowDescriptor() {
        return ((GridH2Table)this.table).rowDescriptor();
    }

    protected QueryContextRegistry queryContextRegistry() {
        return ((GridH2Table)this.table).rowDescriptor().indexing().queryContextRegistry();
    }

    @NotNull
    public static IndexColumn[] columnsArray(GridH2Table tbl, List<IndexColumn> colsList) {
        IndexColumn[] cols = colsList.toArray(H2Utils.EMPTY_COLUMNS);
        IndexColumn.mapColumns(cols, tbl);
        return cols;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.table.getRowCountApproximation(ses);
    }

    public abstract long totalRowCount(IndexingQueryCacheFilter var1);
}

