/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.disk;

import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.ignite.internal.processors.query.h2.disk.AbstractExternalResult;
import org.apache.ignite.internal.processors.query.h2.disk.ExternalResultData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

public class GroupedExternalResult
extends AbstractExternalResult<Object> {
    private Queue<ExternalResultData.Chunk> resQueue;
    private final Comparator<ExternalResultData.Chunk> chunkCmp;
    private final Comparator<Value> cmp;

    public GroupedExternalResult(Session ses, long initSize) {
        super(ses, false, 0L, Object.class);
        this.cmp = ses.getDatabase().getCompareMode();
        this.chunkCmp = new Comparator<ExternalResultData.Chunk>(){

            @Override
            public int compare(ExternalResultData.Chunk o1, ExternalResultData.Chunk o2) {
                int c = GroupedExternalResult.this.cmp.compare((Value)o1.currentRow().getKey(), (Value)o2.currentRow().getKey());
                if (c != 0) {
                    return c;
                }
                return Long.compare(o1.start(), o2.start());
            }
        };
    }

    public Map.Entry<ValueRow, Object[]> next() {
        if (this.resQueue.isEmpty()) {
            return null;
        }
        ExternalResultData.Chunk batch = this.resQueue.poll();
        Map.Entry<ValueRow, Object[]> row = batch.currentRow();
        if (batch.next()) {
            this.resQueue.offer(batch);
        }
        return row;
    }

    public void spillGroupsToDisk(Map<ValueRow, Object[]> groups) {
        this.size += groups.size();
        this.data.store(groups.entrySet());
    }

    public void reset() {
        if (this.resQueue != null) {
            this.resQueue.clear();
            for (ExternalResultData.Chunk chunk : this.data.chunks()) {
                chunk.reset();
            }
        } else {
            this.resQueue = new PriorityQueue<ExternalResultData.Chunk>(this.chunkCmp);
        }
        for (ExternalResultData.Chunk chunk : this.data.chunks()) {
            if (!chunk.next()) continue;
            this.resQueue.offer(chunk);
        }
    }
}

