/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.defragmentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.LinkMap;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.TreeIterator;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.database.io.AbstractH2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.AbstractH2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.AbstractH2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.AbstractH2LeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2IOUtils;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.Value;

public class IndexingDefragmentation {
    private final IgniteH2Indexing indexing;

    public IndexingDefragmentation(IgniteH2Indexing indexing) {
        this.indexing = indexing;
    }

    public void defragment(CacheGroupContext grpCtx, CacheGroupContext newCtx, PageMemoryEx partPageMem, IntMap<LinkMap> mappingByPartition, CheckpointTimeoutLock cpLock, Runnable cancellationChecker, IgniteLogger log, IgniteThreadPoolExecutor defragmentationThreadPool) throws IgniteCheckedException {
        int pageSize = grpCtx.cacheObjectContext().kernalContext().grid().configuration().getDataStorageConfiguration().getPageSize();
        PageMemoryEx oldCachePageMem = (PageMemoryEx)grpCtx.dataRegion().pageMemory();
        PageMemoryEx newCachePageMemory = partPageMem;
        Collection<GridH2Table> tables = this.indexing.schemaManager().dataTables();
        long cpLockThreshold = 150L;
        AtomicLong lastCpLockTs = new AtomicLong(System.currentTimeMillis());
        IgniteUtils.doInParallel(defragmentationThreadPool, tables, table -> this.defragmentTable(grpCtx, newCtx, mappingByPartition, cpLock, cancellationChecker, log, pageSize, oldCachePageMem, newCachePageMemory, cpLockThreshold, lastCpLockTs, (GridH2Table)table));
        if (log.isInfoEnabled()) {
            log.info("Defragmentation indexes completed for group '" + grpCtx.groupId() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean defragmentTable(CacheGroupContext grpCtx, CacheGroupContext newCtx, IntMap<LinkMap> mappingByPartition, CheckpointTimeoutLock cpLock, Runnable cancellationChecker, IgniteLogger log, int pageSize, PageMemoryEx oldCachePageMem, PageMemory newCachePageMemory, long cpLockThreshold, AtomicLong lastCpLockTs, GridH2Table table) throws IgniteCheckedException {
        cpLock.checkpointReadLock();
        try {
            TreeIterator treeIterator = new TreeIterator(pageSize);
            GridCacheContext cctx = table.cacheContext();
            if (cctx.groupId() != grpCtx.groupId()) {
                boolean bl = false;
                return bl;
            }
            cancellationChecker.run();
            GridH2RowDescriptor rowDesc = table.rowDescriptor();
            ArrayList<Index> indexes = table.getIndexes();
            List oldIndexes = indexes.stream().filter(index -> index instanceof H2TreeIndex).map(H2TreeIndex.class::cast).collect(Collectors.toList());
            for (H2TreeIndex oldH2Idx : oldIndexes) {
                int segments = oldH2Idx.segmentsCount();
                H2Tree firstTree = oldH2Idx.treeForRead(0);
                PageIoResolver pageIoRslvr = pageAddr -> {
                    PageIO io = PageIoResolver.DEFAULT_PAGE_IO_RESOLVER.resolve(pageAddr);
                    if (io instanceof BPlusMetaIO) {
                        return io;
                    }
                    return IndexingDefragmentation.wrap((BPlusIO)io);
                };
                H2TreeIndex newIdx = H2TreeIndex.createIndex(cctx, null, table, oldH2Idx.getName(), firstTree.getPk(), firstTree.getAffinityKey(), Arrays.asList(firstTree.cols()), Arrays.asList(firstTree.cols()), oldH2Idx.inlineSize(), segments, newCachePageMemory, newCtx.offheap(), pageIoRslvr, log);
                for (int segment = 0; segment < segments; ++segment) {
                    int finalSegment = segment;
                    H2Tree tree = oldH2Idx.treeForRead(segment);
                    H2Tree.MetaPageInfo oldInfo = tree.getMetaInfo();
                    H2Tree newTree = newIdx.treeForRead(segment);
                    BPlusInnerIO innerIO = (BPlusInnerIO)IndexingDefragmentation.wrap(newTree.latestInnerIO());
                    BPlusLeafIO leafIo = (BPlusLeafIO)IndexingDefragmentation.wrap(newTree.latestLeafIO());
                    newTree.setIos(new IOVersions((PageIO[])new BPlusInnerIO[]{innerIO}), new IOVersions((PageIO[])new BPlusLeafIO[]{leafIo}));
                    newTree.copyMetaInfo(oldInfo);
                    newTree.enableSequentialWriteMode();
                    AtomicBoolean warningPrinted = new AtomicBoolean();
                    treeIterator.iterate(tree, oldCachePageMem, (theTree, io, pageAddr, idx) -> {
                        cancellationChecker.run();
                        if (System.currentTimeMillis() - lastCpLockTs.get() >= cpLockThreshold) {
                            cpLock.checkpointReadUnlock();
                            cpLock.checkpointReadLock();
                            lastCpLockTs.set(System.currentTimeMillis());
                        }
                        assert (1 == io.getVersion()) : "IO version " + io.getVersion() + " is not supported by current defragmentation algorithm. Please implement copying of tree in a new format.";
                        BPlusIO<H2Row> h2IO = IndexingDefragmentation.wrap(io);
                        H2Row row = (H2Row)theTree.getRow(h2IO, pageAddr, idx);
                        if (row instanceof H2CacheRowWithIndex) {
                            H2CacheRowWithIndex h2CacheRow = (H2CacheRowWithIndex)row;
                            CacheDataRow cacheDataRow = h2CacheRow.getRow();
                            int partition = cacheDataRow.partition();
                            long link = h2CacheRow.link();
                            LinkMap map = (LinkMap)mappingByPartition.get(partition);
                            long newLink = map.get(link);
                            if (newLink == 0L) {
                                if (warningPrinted.compareAndSet(false, true)) {
                                    log.warning(S.toString("Broken link found in SQL index. Some entries will be skipped. Please consider rebuilding the index.", "grpId", (Object)grpCtx.groupId(), false, "name", (Object)oldH2Idx.getName(), false, "segment", (Object)finalSegment, false));
                                }
                                return true;
                            }
                            H2CacheRowWithIndex newRow = H2CacheRowWithIndex.create(rowDesc, newLink, h2CacheRow, ((H2RowLinkIO)((Object)io)).storeMvccInfo());
                            InlineIndexColumnFactory.setCurrentInlineIndexes(newTree.inlineIndexes());
                            assert (cctx.shared().database().checkpointLockIsHeldByThread());
                            newTree.putx(newRow);
                        }
                        return true;
                    });
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            cpLock.checkpointReadUnlock();
        }
    }

    private static <T extends BPlusIO<H2Row>> H2Row lookupRow(BPlusTree<H2Row, ?> tree, long pageAddr, int idx, T io) throws IgniteCheckedException {
        long link = ((H2RowLinkIO)((Object)io)).getLink(pageAddr, idx);
        List<InlineIndexColumn> inlineIdxs = ((H2Tree)tree).inlineIndexes();
        int off = io.offset(idx);
        int payloadSize = ((H2RowLinkIO)((Object)io)).getPayloadSize();
        byte[] values = inlineIdxs != null ? PageUtils.getBytes(pageAddr, off, payloadSize) : Utils.EMPTY_BYTES;
        if (((H2RowLinkIO)((Object)io)).storeMvccInfo()) {
            long mvccCrdVer = ((H2RowLinkIO)((Object)io)).getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = ((H2RowLinkIO)((Object)io)).getMvccCounter(pageAddr, idx);
            int mvccOpCntr = ((H2RowLinkIO)((Object)io)).getMvccOperationCounter(pageAddr, idx);
            H2CacheRow row = (H2CacheRow)((H2Tree)tree).createMvccRow(link, mvccCrdVer, mvccCntr, mvccOpCntr, CacheDataRowAdapter.RowData.LINK_ONLY);
            return new H2CacheRowWithIndex(row.getDesc(), row.getRow(), values);
        }
        H2CacheRow row = (H2CacheRow)((H2Tree)tree).createRow(link, false);
        return new H2CacheRowWithIndex(row.getDesc(), row.getRow(), values);
    }

    private static BPlusIO<H2Row> wrap(BPlusIO<H2Row> io) {
        assert (io instanceof H2RowLinkIO);
        if (io instanceof BPlusInnerIO) {
            assert (io instanceof AbstractH2ExtrasInnerIO || io instanceof AbstractH2InnerIO);
            return new BPlusInnerIoDelegate<BPlusInnerIO>((BPlusInnerIO)io);
        }
        assert (io instanceof AbstractH2ExtrasLeafIO || io instanceof AbstractH2LeafIO);
        return new BPlusLeafIoDelegate<BPlusLeafIO>((BPlusLeafIO)io);
    }

    private static <IO extends BPlusIO<?>> void storeByOffset(IO io, long pageAddr, int off, H2CacheRowWithIndex row) {
        int payloadSize = ((H2RowLinkIO)((Object)io)).getPayloadSize();
        assert (row.link() != 0L);
        PageUtils.putBytes(pageAddr, off, row.values);
        H2IOUtils.storeRow(row, pageAddr, off + payloadSize, ((H2RowLinkIO)((Object)io)).storeMvccInfo());
    }

    private static class H2CacheRowWithIndex
    extends H2CacheRow {
        private final byte[] values;

        public H2CacheRowWithIndex(GridH2RowDescriptor desc, CacheDataRow row, byte[] values) {
            super(desc, row);
            this.values = values;
        }

        public static H2CacheRowWithIndex create(GridH2RowDescriptor desc, long newLink, H2CacheRowWithIndex oldValue, boolean storeMvcc) {
            CacheDataRowAdapter newDataRow;
            CacheDataRow row = oldValue.getRow();
            if (storeMvcc) {
                newDataRow = new MvccDataRow(newLink);
                newDataRow.mvccVersion(row);
            } else {
                newDataRow = new CacheDataRowAdapter(newLink);
            }
            return new H2CacheRowWithIndex(desc, newDataRow, oldValue.values);
        }

        @Override
        public Value getValue(int col) {
            return null;
        }
    }

    private static class BPlusLeafIoDelegate<IO extends BPlusLeafIO<H2Row>>
    extends BPlusLeafIO<H2Row>
    implements H2RowLinkIO {
        private final IO io;

        public BPlusLeafIoDelegate(IO io) {
            super(((PageIO)io).getType(), ((PageIO)io).getVersion(), ((BPlusIO)io).getItemSize());
            this.io = io;
        }

        @Override
        public void storeByOffset(long pageAddr, int off, H2Row row) throws IgniteCheckedException {
            this.assertPageType(pageAddr);
            IndexingDefragmentation.storeByOffset(this.io, pageAddr, off, (H2CacheRowWithIndex)row);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<H2Row> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
            this.assertPageType(dstPageAddr);
            ((BPlusIO)this.io).store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
        }

        @Override
        public H2Row getLookupRow(BPlusTree<H2Row, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
            return IndexingDefragmentation.lookupRow(tree, pageAddr, idx, this);
        }

        @Override
        public long getLink(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getLink(pageAddr, idx);
        }

        @Override
        public long getMvccCoordinatorVersion(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getMvccCoordinatorVersion(pageAddr, idx);
        }

        @Override
        public long getMvccCounter(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getMvccCounter(pageAddr, idx);
        }

        @Override
        public int getMvccOperationCounter(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getMvccOperationCounter(pageAddr, idx);
        }

        @Override
        public boolean storeMvccInfo() {
            return ((H2RowLinkIO)this.io).storeMvccInfo();
        }

        @Override
        public int getPayloadSize() {
            return ((H2RowLinkIO)this.io).getPayloadSize();
        }
    }

    private static class BPlusInnerIoDelegate<IO extends BPlusInnerIO<H2Row>>
    extends BPlusInnerIO<H2Row>
    implements H2RowLinkIO {
        private final IO io;

        public BPlusInnerIoDelegate(IO io) {
            super(((PageIO)io).getType(), ((PageIO)io).getVersion(), ((BPlusIO)io).canGetRow(), ((BPlusIO)io).getItemSize());
            this.io = io;
        }

        @Override
        public void storeByOffset(long pageAddr, int off, H2Row row) throws IgniteCheckedException {
            this.assertPageType(pageAddr);
            IndexingDefragmentation.storeByOffset(this.io, pageAddr, off, (H2CacheRowWithIndex)row);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<H2Row> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
            this.assertPageType(dstPageAddr);
            ((BPlusIO)this.io).store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
        }

        @Override
        public H2Row getLookupRow(BPlusTree<H2Row, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
            return IndexingDefragmentation.lookupRow(tree, pageAddr, idx, this);
        }

        @Override
        public long getLink(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getLink(pageAddr, idx);
        }

        @Override
        public long getMvccCoordinatorVersion(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getMvccCoordinatorVersion(pageAddr, idx);
        }

        @Override
        public long getMvccCounter(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getMvccCounter(pageAddr, idx);
        }

        @Override
        public int getMvccOperationCounter(long pageAddr, int idx) {
            return ((H2RowLinkIO)this.io).getMvccOperationCounter(pageAddr, idx);
        }

        @Override
        public boolean storeMvccInfo() {
            return ((H2RowLinkIO)this.io).storeMvccInfo();
        }

        @Override
        public int getPayloadSize() {
            return ((H2RowLinkIO)this.io).getPayloadSize();
        }
    }
}

