/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueByte;

public class ByteInlineIndexColumn
extends AbstractInlineIndexColumn {
    public ByteInlineIndexColumn(Column col) {
        super(col, 2, (short)1);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        byte byte1 = PageUtils.getByte(pageAddr, off + 1);
        byte byte2 = v.getByte();
        return Integer.signum(byte1 - byte2);
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte(pageAddr, off, (byte)val.getValueType());
        PageUtils.putByte(pageAddr, off + 1, val.getByte());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueByte.get(PageUtils.getByte(pageAddr, off + 1));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

