/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.systemview.walker.SqlIndexViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlSchemaViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlTableColumnViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlTableViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlViewColumnViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlViewViewWalker;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2Schema;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2TableEngine;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.IndexRebuildPartialClosure;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sys.SqlSystemTableEngine;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewBaselineNodes;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewCacheGroupsIOStatistics;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewNodeAttributes;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewNodeMetrics;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.systemview.view.SqlIndexView;
import org.apache.ignite.spi.systemview.view.SqlSchemaView;
import org.apache.ignite.spi.systemview.view.SqlTableColumnView;
import org.apache.ignite.spi.systemview.view.SqlTableView;
import org.apache.ignite.spi.systemview.view.SqlViewColumnView;
import org.apache.ignite.spi.systemview.view.SqlViewView;
import org.gridgain.internal.h2.index.Index;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaManager {
    public static final String SQL_SCHEMA_VIEW = "schemas";
    public static final String SQL_SCHEMA_VIEW_DESC = "SQL schemas";
    public static final String SQL_TBLS_VIEW = "tables";
    public static final String SQL_TBLS_VIEW_DESC = "SQL tables";
    public static final String SQL_VIEWS_VIEW = "views";
    public static final String SQL_VIEWS_VIEW_DESC = "SQL views";
    public static final String SQL_IDXS_VIEW = "indexes";
    public static final String SQL_IDXS_VIEW_DESC = "SQL indexes";
    public static final String SQL_TBL_COLS_VIEW = MetricUtils.metricName("table", "columns");
    public static final String SQL_TBL_COLS_VIEW_DESC = "SQL table columns";
    public static final String SQL_VIEW_COLS_VIEW = MetricUtils.metricName("view", "columns");
    public static final String SQL_VIEW_COLS_VIEW_DESC = "SQL view columns";
    private final ConnectionManager connMgr;
    private final ConcurrentMap<String, H2Schema> schemas = new ConcurrentHashMap<String, H2Schema>();
    private final Map<String, String> cacheName2schema = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<QueryTable, GridH2Table> dataTables = new ConcurrentHashMap<QueryTable, GridH2Table>();
    private final Set<SqlSystemView> systemViews = new GridConcurrentHashSet<SqlSystemView>();
    private final Object schemaMux = new Object();
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final Set<BiConsumer<GridH2Table, List<String>>> dropColsLsnrs = ConcurrentHashMap.newKeySet();
    private final Set<BiConsumer<String, String>> dropTblLsnrs = ConcurrentHashMap.newKeySet();

    public SchemaManager(GridKernalContext ctx, ConnectionManager connMgr) {
        this.ctx = ctx;
        this.connMgr = connMgr;
        this.log = ctx.log(SchemaManager.class);
    }

    public void start(String[] schemaNames) throws IgniteCheckedException {
        this.schemas.put("PUBLIC", new H2Schema("PUBLIC", true));
        this.createSystemViews();
        this.createPredefinedSchemas(schemaNames);
        this.ctx.systemView().registerView(SQL_SCHEMA_VIEW, SQL_SCHEMA_VIEW_DESC, new SqlSchemaViewWalker(), this.schemas.values(), SqlSchemaView::new);
        this.ctx.systemView().registerView(SQL_TBLS_VIEW, SQL_TBLS_VIEW_DESC, new SqlTableViewWalker(), this.dataTables.values(), SqlTableView::new);
        this.ctx.systemView().registerView(SQL_VIEWS_VIEW, SQL_VIEWS_VIEW_DESC, new SqlViewViewWalker(), this.systemViews, SqlViewView::new);
        this.ctx.systemView().registerInnerCollectionView(SQL_IDXS_VIEW, SQL_IDXS_VIEW_DESC, new SqlIndexViewWalker(), this.dataTables.values(), GridH2Table::indexesInformation, SqlIndexView::new);
        this.ctx.systemView().registerInnerArrayView(SQL_TBL_COLS_VIEW, SQL_TBL_COLS_VIEW_DESC, new SqlTableColumnViewWalker(), this.dataTables.values(), GridH2Table::getColumns, SqlTableColumnView::new);
        this.ctx.systemView().registerInnerArrayView(SQL_VIEW_COLS_VIEW, SQL_VIEW_COLS_VIEW_DESC, new SqlViewColumnViewWalker(), this.systemViews, SqlSystemView::getColumns, SqlViewColumnView::new);
    }

    public void stop() {
        this.schemas.clear();
        this.cacheName2schema.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSystemView(String schema, SqlSystemView view) throws IgniteCheckedException {
        boolean disabled = IgniteSystemProperties.getBoolean("IGNITE_SQL_DISABLE_SYSTEM_VIEWS");
        if (disabled) {
            if (this.log.isInfoEnabled()) {
                this.log.info("SQL system views will not be created because they are disabled (see IGNITE_SQL_DISABLE_SYSTEM_VIEWS system property)");
            }
            return;
        }
        try {
            Object object = this.schemaMux;
            synchronized (object) {
                this.createSchema(schema, true);
            }
            try (H2PooledConnection c = this.connMgr.connection(schema);){
                SqlSystemTableEngine.registerView(c.connection(), view);
                this.systemViews.add(view);
            }
        }
        catch (SQLException | IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to register system view.", e);
        }
    }

    private void createSystemViews() throws IgniteCheckedException {
        for (SqlSystemView view : this.systemViews(this.ctx)) {
            this.createSystemView(QueryUtils.sysSchemaName(), view);
        }
    }

    private Collection<SqlSystemView> systemViews(GridKernalContext ctx) {
        ArrayList<SqlSystemView> views = new ArrayList<SqlSystemView>();
        views.add(new SqlSystemViewNodeAttributes(ctx));
        views.add(new SqlSystemViewBaselineNodes(ctx));
        views.add(new SqlSystemViewNodeMetrics(ctx));
        views.add(new SqlSystemViewCacheGroupsIOStatistics(ctx));
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPredefinedSchemas(String[] schemaNames) throws IgniteCheckedException {
        if (F.isEmpty(schemaNames)) {
            return;
        }
        LinkedHashSet<String> schemaNames0 = new LinkedHashSet<String>();
        for (String schemaName : schemaNames) {
            if (F.isEmpty(schemaName)) continue;
            schemaName = QueryUtils.normalizeSchemaName(null, schemaName);
            schemaNames0.add(schemaName);
        }
        Object object = this.schemaMux;
        synchronized (object) {
            for (String schemaName : schemaNames0) {
                this.createSchema(schemaName, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheCreated(String cacheName, String schemaName, Class<?>[] sqlFuncs) throws IgniteCheckedException {
        Object object = this.schemaMux;
        synchronized (object) {
            this.createSchema(schemaName, false);
        }
        this.cacheName2schema.put(cacheName, schemaName);
        H2Utils.registerSqlFunctions(this.log, this.connMgr, schemaName, sqlFuncs);
    }

    public void onCacheTypeCreated(GridCacheContextInfo cacheInfo, IgniteH2Indexing idx, GridQueryTypeDescriptor type, boolean isSql) throws IgniteCheckedException {
        String schemaName = this.schemaName(cacheInfo.name());
        H2TableDescriptor tblDesc = new H2TableDescriptor(idx, schemaName, type, cacheInfo, isSql);
        H2Schema schema = this.schema(schemaName);
        try (H2PooledConnection conn = this.connMgr.connection(schema.schemaName());){
            GridH2Table h2tbl = this.createTable(schema.schemaName(), schema, tblDesc, conn);
            schema.add(tblDesc);
            if (this.dataTables.putIfAbsent(h2tbl.identifier(), h2tbl) != null) {
                throw new IllegalStateException("Table already exists: " + h2tbl.identifierString());
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to register query type: " + tblDesc, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheDestroyed(String cacheName, boolean destroy, boolean clearIdx) {
        String schemaName = this.schemaName(cacheName);
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        this.cacheName2schema.remove(cacheName);
        HashSet<H2TableDescriptor> rmvTbls = new HashSet<H2TableDescriptor>();
        for (H2TableDescriptor tbl : schema.tables()) {
            if (!F.eq(tbl.cacheName(), cacheName)) continue;
            try {
                tbl.table().setRemoveIndexOnDestroy(clearIdx);
                this.dropTable(tbl, destroy);
            }
            catch (Exception e) {
                U.error(this.log, "Failed to drop table on cache stop (will ignore): " + tbl.fullTableName(), e);
            }
            schema.drop(tbl);
            rmvTbls.add(tbl);
            GridH2Table h2Tbl = tbl.table();
            this.dataTables.remove(h2Tbl.identifier(), h2Tbl);
        }
        Iterator iterator = this.schemaMux;
        synchronized (iterator) {
            if (schema.decrementUsageCount()) {
                this.schemas.remove(schemaName);
                try {
                    this.dropSchema(schemaName);
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to drop schema on cache stop (will ignore): " + cacheName, e);
                }
            }
        }
        for (H2TableDescriptor tbl : rmvTbls) {
            for (Index idx : tbl.table().getIndexes()) {
                idx.close(null);
            }
        }
    }

    private void createSchema(String schemaName, boolean predefined) throws IgniteCheckedException {
        H2Schema schema;
        H2Schema oldSchema;
        assert (Thread.holdsLock(this.schemaMux));
        if (!predefined) {
            predefined = this.isSchemaPredefined(schemaName);
        }
        if ((oldSchema = this.schemas.putIfAbsent(schemaName, schema = new H2Schema(schemaName, predefined))) == null) {
            this.createSchema0(schemaName);
        } else {
            schema = oldSchema;
        }
        schema.incrementUsageCount();
    }

    private void createSchema0(String schema) throws IgniteCheckedException {
        this.connMgr.executeSystemStatement("CREATE SCHEMA IF NOT EXISTS " + H2Utils.withQuotes(schema));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created H2 schema for index database: " + schema);
        }
    }

    private boolean isSchemaPredefined(String schemaName) {
        if (F.eq("PUBLIC", schemaName)) {
            return true;
        }
        for (H2Schema schema : this.schemas.values()) {
            if (!F.eq(schema.schemaName(), schemaName) || !schema.predefined()) continue;
            return true;
        }
        return false;
    }

    public String schemaName(String cacheName) {
        String res = this.cacheName2schema.get(cacheName);
        if (res == null) {
            res = "";
        }
        return res;
    }

    public Set<String> schemaNames() {
        return new HashSet<String>(this.schemas.keySet());
    }

    private H2Schema schema(String schemaName) {
        return (H2Schema)this.schemas.get(schemaName);
    }

    private GridH2Table createTable(String schemaName, H2Schema schema, H2TableDescriptor tbl, H2PooledConnection conn) throws SQLException, IgniteCheckedException {
        assert (schema != null);
        assert (tbl != null);
        String sql = H2Utils.tableCreateSql(tbl);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating DB table with SQL: " + sql);
        }
        GridH2RowDescriptor rowDesc = new GridH2RowDescriptor(tbl, tbl.type());
        GridH2Table h2Tbl = H2TableEngine.createTable(conn.connection(), sql, rowDesc, tbl);
        for (GridH2IndexBase usrIdx : tbl.createUserIndexes()) {
            this.createInitialUserIndex(schemaName, tbl, usrIdx);
        }
        return h2Tbl;
    }

    private void dropTable(H2TableDescriptor tbl, boolean destroy) {
        assert (tbl != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing query index table: " + tbl.fullTableName());
        }
        try (H2PooledConnection c = this.connMgr.connection(tbl.schemaName());){
            Statement stmt;
            block19: {
                stmt = null;
                try {
                    String schema = tbl.schemaName();
                    String tblName = tbl.tableName();
                    stmt = c.connection().createStatement();
                    String sql = "DROP TABLE IF EXISTS " + tbl.fullTableName();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Dropping database index table with SQL: " + sql);
                    }
                    stmt.executeUpdate(sql);
                    if (!destroy) break block19;
                    this.afterDropTable(schema, tblName);
                }
                catch (SQLException e) {
                    try {
                        throw new IgniteSQLException("Failed to drop database index table [type=" + tbl.type().name() + ", table=" + tbl.fullTableName() + "]", 3004, e);
                    }
                    catch (Throwable throwable) {
                        U.close(stmt, this.log);
                        throw throwable;
                    }
                }
            }
            U.close(stmt, this.log);
        }
    }

    private void dropSchema(String schema) throws IgniteCheckedException {
        this.connMgr.executeSystemStatement("DROP SCHEMA IF EXISTS " + H2Utils.withQuotes(schema));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dropped H2 schema for index database: " + schema);
        }
    }

    private void createInitialUserIndex(String schemaName, H2TableDescriptor desc, GridH2IndexBase h2Idx) throws IgniteCheckedException {
        GridH2Table h2Tbl = desc.table();
        h2Tbl.proposeUserIndex(h2Idx);
        try {
            String sql = H2Utils.indexCreateSql(desc.fullTableName(), h2Idx, false);
            this.connMgr.executeStatement(schemaName, sql);
        }
        catch (Exception e) {
            h2Tbl.rollbackUserIndex(h2Idx.getName());
            throw e;
        }
    }

    public void createIndex(String schemaName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = this.schema(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ", tblName=" + tblName + ']');
        }
        GridH2Table h2Tbl = desc.table();
        GridH2IndexBase h2Idx = desc.createUserIndex(idxDesc);
        this.createIndex(h2Tbl, desc, schemaName, h2Idx, ifNotExists, cacheVisitor);
    }

    public void createIndex(GridH2Table h2Tbl, H2TableDescriptor desc, String schemaName, GridH2IndexBase h2Idx, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        h2Tbl.proposeUserIndex(h2Idx);
        try {
            if (h2Tbl.cacheInfo().affinityNode()) {
                IndexRebuildPartialClosure idxBuild = new IndexRebuildPartialClosure(h2Tbl.cacheContext());
                idxBuild.addIndex(h2Tbl, h2Idx);
                cacheVisitor.visit(idxBuild);
            }
            String sql = H2Utils.indexCreateSql(desc.fullTableName(), h2Idx, ifNotExists);
            this.connMgr.executeStatement(schemaName, sql);
        }
        catch (Exception e) {
            h2Tbl.rollbackUserIndex(h2Idx.getName());
            throw e;
        }
    }

    public void dropIndex(String schemaName, String idxName, boolean ifExists) throws IgniteCheckedException {
        String sql = H2Utils.indexDropSql(schemaName, idxName, ifExists);
        GridH2Table tbl = this.dataTableForIndex(schemaName, idxName);
        tbl.setRemoveIndexOnDestroy(true);
        this.connMgr.executeStatement(schemaName, sql);
    }

    public void addColumn(String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifColNotExists) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = this.schema(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            if (!ifTblExists) {
                throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ", tblName=" + tblName + ']');
            }
            return;
        }
        desc.table().addColumns(cols, ifColNotExists);
    }

    public void dropColumn(String schemaName, String tblName, List<String> cols, boolean ifTblExists, boolean ifColExists) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = this.schema(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            if (!ifTblExists) {
                throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ",tblName=" + tblName + ']');
            }
            return;
        }
        desc.table().dropColumns(cols, ifColExists);
        this.dropColsLsnrs.forEach(l -> l.accept(desc.table(), cols));
    }

    @Nullable
    public H2TableDescriptor tableForType(String schemaName, String cacheName, String type) {
        H2Schema schema = this.schema(schemaName);
        if (schema == null) {
            return null;
        }
        return schema.tableByTypeName(cacheName, type);
    }

    public Collection<H2TableDescriptor> tablesForCache(String cacheName) {
        H2Schema schema = this.schema(this.schemaName(cacheName));
        if (schema == null) {
            return Collections.emptySet();
        }
        ArrayList<H2TableDescriptor> tbls = new ArrayList<H2TableDescriptor>();
        for (H2TableDescriptor tbl : schema.tables()) {
            if (!F.eq(tbl.cacheName(), cacheName)) continue;
            tbls.add(tbl);
        }
        return tbls;
    }

    public GridH2Table dataTable(String schemaName, String tblName) {
        return (GridH2Table)this.dataTables.get(new QueryTable(schemaName, tblName));
    }

    public Collection<GridH2Table> dataTables() {
        return this.dataTables.values();
    }

    public Collection<SqlSystemView> systemViews() {
        return Collections.unmodifiableSet(this.systemViews);
    }

    public GridH2Table dataTableForIndex(String schemaName, String idxName) {
        for (Map.Entry dataTableEntry : this.dataTables.entrySet()) {
            GridH2Table h2Tbl;
            if (!F.eq(((QueryTable)dataTableEntry.getKey()).schema(), schemaName) || (h2Tbl = (GridH2Table)dataTableEntry.getValue()).userIndex(idxName) == null) continue;
            return h2Tbl;
        }
        return null;
    }

    public void registerDropColumnsListener(@NotNull BiConsumer<GridH2Table, List<String>> lsnr) {
        Objects.requireNonNull(lsnr, "Drop columns listener should be not-null.");
        this.dropColsLsnrs.add(lsnr);
    }

    public void unregisterDropColumnsListener(@NotNull BiConsumer<GridH2Table, List<String>> lsnr) {
        Objects.requireNonNull(lsnr, "Drop columns listener should be not-null.");
        this.dropColsLsnrs.remove(lsnr);
    }

    public void registerDropTableListener(@NotNull BiConsumer<String, String> lsnr) {
        Objects.requireNonNull(lsnr, "Drop table listener should be not-null.");
        this.dropTblLsnrs.add(lsnr);
    }

    public void unregisterDropTableListener(@NotNull BiConsumer<String, String> lsnr) {
        Objects.requireNonNull(lsnr, "Drop table listener should be not-null.");
        this.dropTblLsnrs.remove(lsnr);
    }

    private void afterDropTable(String schema, String tblName) {
        this.dropTblLsnrs.forEach(l -> l.accept(schema, tblName));
    }
}

