/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.gridgain.internal.h2.api.JavaObjectSerializer;
import org.jetbrains.annotations.NotNull;

class H2JavaObjectSerializer
implements JavaObjectSerializer {
    private final ClassLoader clsLdr;
    private final Marshaller marshaller;

    H2JavaObjectSerializer(@NotNull GridKernalContext ctx) {
        this.marshaller = ctx.config().getMarshaller();
        this.clsLdr = U.resolveClassLoader(ctx.config());
    }

    @Override
    public byte[] serialize(Object obj) throws Exception {
        return U.marshal(this.marshaller, obj);
    }

    @Override
    public Object deserialize(byte[] bytes) throws Exception {
        return U.unmarshal(this.marshaller, bytes, this.clsLdr);
    }
}

