/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.jdbc.JdbcStatement;
import org.jetbrains.annotations.Nullable;

public class H2Connection
implements AutoCloseable {
    private static final int STATEMENT_CACHE_SIZE = 256;
    private final Connection conn;
    private volatile String schema;
    private volatile H2StatementCache statementCache;
    private IgniteLogger log;

    H2Connection(Connection conn, IgniteLogger log) {
        this.conn = conn;
        this.log = log;
        this.initStatementCache();
    }

    String schema() {
        return this.schema;
    }

    void schema(@Nullable String schema) {
        if (schema != null && !F.eq(this.schema, schema)) {
            try {
                this.schema = schema;
                this.conn.setSchema(schema);
            }
            catch (SQLException e) {
                throw new IgniteSQLException("Failed to set schema for DB connection for thread [schema=" + schema + "]", e);
            }
        }
    }

    Connection connection() {
        return this.conn;
    }

    void clearStatementCache() {
        this.initStatementCache();
    }

    H2StatementCache statementCache() {
        return this.statementCache;
    }

    public int statementCacheSize() {
        return this.statementCache == null ? 0 : this.statementCache.size();
    }

    private void initStatementCache() {
        this.statementCache = new H2StatementCache(256);
    }

    PreparedStatement prepareStatement(String sql, byte qryFlags) {
        try {
            PreparedStatement stmt = this.cachedPreparedStatement(sql, qryFlags);
            if (stmt == null) {
                H2CachedStatementKey key = new H2CachedStatementKey(this.schema, sql, qryFlags);
                stmt = this.prepareStatementNoCache(sql);
                this.statementCache.put(key, stmt);
            }
            return stmt;
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Failed to parse query. " + e.getMessage(), 1001, e);
        }
    }

    @Nullable
    private PreparedStatement cachedPreparedStatement(String sql, byte qryFlags) throws SQLException {
        H2CachedStatementKey key = new H2CachedStatementKey(this.schema, sql, qryFlags);
        PreparedStatement stmt = this.statementCache.get(key);
        if (stmt == null) {
            return null;
        }
        if (stmt.isClosed() || stmt.unwrap(JdbcStatement.class).isCancelled() || GridSqlQueryParser.prepared(stmt).needRecompile()) {
            this.statementCache.remove(this.schema, sql, qryFlags);
            return null;
        }
        return stmt;
    }

    PreparedStatement prepareStatementNoCache(String sql) {
        try {
            return this.conn.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Failed to parse query. " + e.getMessage(), 1001, e);
        }
    }

    public String toString() {
        return S.toString(H2Connection.class, this);
    }

    @Override
    public void close() {
        U.close(this.conn, this.log);
    }
}

