/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderIndex;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.gridgain.internal.h2.table.IndexColumn;
import org.jetbrains.annotations.Nullable;

public class DurableBackgroundCleanupIndexTreeTask
implements DurableBackgroundTask {
    private static final long serialVersionUID = 0L;
    private List<Long> rootPages;
    private volatile transient List<H2Tree> trees;
    private String cacheGrpName;
    private String cacheName;
    private String schemaName;
    private final String treeName;
    private String idxName;
    private String id;
    @Nullable
    private volatile transient IgniteLogger log;
    @Nullable
    private volatile transient GridWorker worker;

    public DurableBackgroundCleanupIndexTreeTask(List<Long> rootPages, List<H2Tree> trees, String cacheGrpName, String cacheName, String schemaName, String treeName, String idxName) {
        this.rootPages = rootPages;
        this.trees = trees;
        this.cacheGrpName = cacheGrpName;
        this.cacheName = cacheName;
        this.schemaName = schemaName;
        this.treeName = treeName;
        this.idxName = idxName;
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public String name() {
        return "DROP_SQL_INDEX-" + this.schemaName + "." + this.idxName + "-" + this.id;
    }

    public IgniteInternalFuture<DurableBackgroundTaskResult> executeAsync(final GridKernalContext ctx) {
        this.log = ctx.log(this.getClass());
        assert (this.worker == null);
        final GridFutureAdapter<DurableBackgroundTaskResult> fut = new GridFutureAdapter<DurableBackgroundTaskResult>();
        this.worker = new GridWorker(ctx.igniteInstanceName(), "async-durable-background-task-executor-" + this.name(), this.log){

            @Override
            protected void body() {
                try {
                    DurableBackgroundCleanupIndexTreeTask.this.execute(ctx);
                    DurableBackgroundCleanupIndexTreeTask.this.worker = null;
                    fut.onDone(DurableBackgroundTaskResult.complete(null));
                }
                catch (Throwable t2) {
                    DurableBackgroundCleanupIndexTreeTask.this.worker = null;
                    fut.onDone(DurableBackgroundTaskResult.restart(t2));
                }
            }
        };
        new IgniteThread(this.worker).start();
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute(GridKernalContext ctx) {
        List<H2Tree> trees0 = this.trees;
        if (trees0 == null) {
            trees0 = new ArrayList<H2Tree>(this.rootPages.size());
            int grpId = CU.cacheGroupId(this.cacheName, this.cacheGrpName);
            CacheGroupContext cacheGroupContext = ctx.cache().cacheGroup(grpId);
            if (cacheGroupContext == null) {
                return;
            }
            IgniteCacheOffheapManager offheap = cacheGroupContext.offheap();
            if (this.treeName != null) {
                ctx.cache().context().database().checkpointReadLock();
                try {
                    int cacheId = CU.cacheId(this.cacheName);
                    for (int segment = 0; segment < this.rootPages.size(); ++segment) {
                        try {
                            RootPage rootPage = offheap.findRootPageForIndex(cacheId, this.treeName, segment);
                            if (rootPage == null || this.rootPages.get(segment).longValue() != rootPage.pageId().pageId()) continue;
                            offheap.dropRootPageForIndex(cacheId, this.treeName, segment);
                            continue;
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    }
                }
                finally {
                    ctx.cache().context().database().checkpointReadUnlock();
                }
            }
            IoStatisticsHolderIndex stats = new IoStatisticsHolderIndex(IoStatisticsType.SORTED_INDEX, this.cacheGrpName, this.idxName, cacheGroupContext.statisticsHolderData(), ctx.metric());
            PageMemory pageMem = cacheGroupContext.dataRegion().pageMemory();
            for (int i = 0; i < this.rootPages.size(); ++i) {
                Long rootPage = this.rootPages.get(i);
                assert (rootPage != null);
                if (this.skipDeletedRoot(grpId, pageMem, rootPage)) {
                    ctx.log(this.getClass()).warning(S.toString("Skipping deletion of the index tree", "cacheGrpName", (Object)this.cacheGrpName, false, "cacheName", (Object)this.cacheName, false, "idxName", (Object)this.idxName, false, "segment", (Object)i, false, "rootPageId", (Object)PageIdUtils.toDetailString(rootPage), false));
                    continue;
                }
                try {
                    String treeName = "deletedTree_" + i + "_" + this.name();
                    H2TreeToDestroy tree = new H2TreeToDestroy(cacheGroupContext, null, treeName, this.idxName, this.cacheName, null, offheap.reuseListForIndex(treeName), grpId, this.cacheGrpName, pageMem, ctx.cache().context().wal(), (AtomicLong)offheap.globalRemoveId(), (long)rootPage, false, Collections.emptyList(), Collections.emptyList(), new AtomicInteger(0), false, false, false, null, ctx.failure(), ctx.cache().context().diagnostic().pageLockTracker(), null, (IoStatisticsHolder)stats, null, 0, PageIoResolver.DEFAULT_PAGE_IO_RESOLVER);
                    trees0.add(tree);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        }
        ctx.cache().context().database().checkpointReadLock();
        try {
            for (BPlusTree bPlusTree : trees0) {
                try {
                    bPlusTree.destroy(null, true);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                    return;
                }
            }
        }
        finally {
            ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean skipDeletedRoot(int grpId, PageMemory pageMem, long rootPageId) {
        try {
            long page = pageMem.acquirePage(grpId, rootPageId);
            try {
                boolean bl;
                block9: {
                    long pageAddr = pageMem.readLock(grpId, rootPageId, page);
                    try {
                        boolean bl2 = bl = pageAddr == 0L;
                        if (pageAddr == 0L) break block9;
                    }
                    catch (Throwable throwable) {
                        if (pageAddr != 0L) {
                            pageMem.readUnlock(grpId, rootPageId, page);
                        }
                        throw throwable;
                    }
                    pageMem.readUnlock(grpId, rootPageId, page);
                }
                return bl;
            }
            finally {
                pageMem.releasePage(grpId, rootPageId, page);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Cannot acquire tree root page.", e);
        }
    }

    @Override
    public void cancel() {
        this.trees = null;
        GridWorker w = this.worker;
        if (w != null) {
            this.worker = null;
            U.awaitForWorkersStop(Collections.singleton(w), true, this.log);
        }
    }

    @Override
    public DurableBackgroundTask<?> convertAfterRestoreIfNeeded() {
        return new DurableBackgroundCleanupIndexTreeTaskV2(this.cacheGrpName, this.cacheName, this.idxName, this.treeName, UUID.randomUUID().toString(), this.rootPages.size(), null);
    }

    public String toString() {
        return S.toString(DurableBackgroundCleanupIndexTreeTask.class, this);
    }

    public static class H2TreeToDestroy
    extends H2Tree {
        private final CacheGroupContext grpCtx;

        public H2TreeToDestroy(CacheGroupContext grpCtx, GridH2Table table, String name, String idxName, String cacheName, String tblName, ReuseList reuseList, int grpId, String grpName, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, long metaPageId, boolean initNew, List<IndexColumn> unwrappedCols, List<IndexColumn> wrappedCols, AtomicInteger maxCalculatedInlineSize, boolean pk, boolean affinityKey, boolean mvccEnabled, @Nullable H2RowCache rowCache, @Nullable FailureProcessor failureProcessor, PageLockTrackerManager pageLockTrackerManager, IgniteLogger log, IoStatisticsHolder stats, InlineIndexColumnFactory factory, int configuredInlineSize, PageIoResolver pageIoRslvr) throws IgniteCheckedException {
            super(null, table, name, idxName, cacheName, tblName, reuseList, grpId, grpName, pageMem, wal, globalRmvId, metaPageId, initNew, unwrappedCols, wrappedCols, maxCalculatedInlineSize, pk, affinityKey, mvccEnabled, rowCache, failureProcessor, pageLockTrackerManager, log, stats, factory, configuredInlineSize, pageIoRslvr);
            this.grpCtx = grpCtx;
        }

        @Override
        protected void temporaryReleaseLock() {
            this.grpCtx.shared().database().checkpointReadUnlock();
            this.grpCtx.shared().database().checkpointReadLock();
        }

        @Override
        protected long maxLockHoldTime() {
            long sysWorkerBlockedTimeout = this.grpCtx.shared().kernalContext().workersRegistry().getSystemWorkerBlockedTimeout();
            return sysWorkerBlockedTimeout == 0L ? Long.MAX_VALUE : sysWorkerBlockedTimeout / 10L;
        }
    }
}

