/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.UUID;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.QueryRunningFuture;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridRunningQueryInfo {
    private final long id;
    private final UUID nodeId;
    private final String qry;
    private final GridCacheQueryType qryType;
    private final String schemaName;
    private final long startTime;
    @GridToStringExclude
    private final GridQueryCancel cancel;
    private final boolean loc;
    private final GridQueryMemoryMetricProvider memMetricProvider;
    @GridToStringExclude
    private final QueryRunningFuture fut = new QueryRunningFuture();
    private final String qryInitiatorId;
    private final Span span;
    private final boolean enforceJoinOrder;
    private final boolean lazy;
    private final boolean distributedJoins;
    private final String label;

    public GridRunningQueryInfo(long id, UUID nodeId, String qry, GridCacheQueryType qryType, String schemaName, long startTime, GridQueryCancel cancel, boolean loc, GridQueryMemoryMetricProvider memMetricProvider, String qryInitiatorId, boolean enforceJoinOrder, boolean lazy, boolean distributedJoins, String label) {
        this.id = id;
        this.nodeId = nodeId;
        this.qry = qry;
        this.qryType = qryType;
        this.schemaName = schemaName;
        this.startTime = startTime;
        this.cancel = cancel;
        this.loc = loc;
        this.memMetricProvider = memMetricProvider;
        this.qryInitiatorId = qryInitiatorId;
        this.enforceJoinOrder = enforceJoinOrder;
        this.lazy = lazy;
        this.distributedJoins = distributedJoins;
        this.span = MTC.span();
        this.label = label;
    }

    public long id() {
        return this.id;
    }

    public String globalQueryId() {
        return QueryUtils.globalQueryId(this.nodeId, this.id);
    }

    public String query() {
        return this.qry;
    }

    public GridCacheQueryType queryType() {
        return this.qryType;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public long startTime() {
        return this.startTime;
    }

    public GridQueryMemoryMetricProvider memoryMetricProvider() {
        return this.memMetricProvider;
    }

    public boolean longQuery(long curTime, long duration) {
        return curTime - this.startTime > duration;
    }

    public void cancel() {
        if (this.cancel != null) {
            this.cancel.cancel();
        }
    }

    public QueryRunningFuture runningFuture() {
        return this.fut;
    }

    public boolean cancelable() {
        return this.cancel != null;
    }

    public boolean local() {
        return this.loc;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public String queryInitiatorId() {
        return this.qryInitiatorId;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public String toString() {
        return S.toString(GridRunningQueryInfo.class, this);
    }

    public Span span() {
        return this.span;
    }

    public boolean enforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean lazy() {
        return this.lazy;
    }

    public String label() {
        return this.label;
    }
}

