/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.util.EnumSet;
import java.util.TimeZone;
import org.apache.ignite.internal.ThinProtocolFeature;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolVersionFeature;

public class ClientProtocolContext {
    private final ClientListenerProtocolVersion ver;
    private final EnumSet<ClientBitmaskFeature> features;
    private TimeZone clientTz;

    public ClientProtocolContext(ClientListenerProtocolVersion ver, EnumSet<ClientBitmaskFeature> features) {
        this.ver = ver;
        this.features = features != null ? features : EnumSet.noneOf(ClientBitmaskFeature.class);
    }

    public boolean isFeatureSupported(ClientBitmaskFeature feature) {
        return this.features.contains(feature);
    }

    public boolean isFeatureSupported(ClientProtocolVersionFeature feature) {
        return ClientProtocolContext.isFeatureSupported(this.ver, feature);
    }

    public EnumSet<ClientBitmaskFeature> features() {
        return this.features;
    }

    public byte[] featureBytes() {
        return ThinProtocolFeature.featuresAsBytes(this.features);
    }

    public ClientListenerProtocolVersion version() {
        return this.ver;
    }

    public static boolean isFeatureSupported(ClientListenerProtocolVersion ver, ClientProtocolVersionFeature feature) {
        return ver.compareTo(feature.verIntroduced()) >= 0;
    }

    public TimeZone clientTimeZone() {
        return this.clientTz;
    }

    public void clientTimeZone(TimeZone clientTz) {
        this.clientTz = clientTz;
    }
}

