/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.odbc.ClientListenerNioListener;

public class ClientListenerMetrics {
    public static final String METRIC_REJECTED_TIMEOUT = "RejectedSessionsTimeout";
    public static final String METRIC_REJECTED_AUTHENTICATION = "RejectedSessionsAuthenticationFailed";
    public static final String METRIC_REJECTED_TOTAL = "RejectedSessionsTotal";
    public static final String METRIC_ACEPTED = "AcceptedSessions";
    private final IntMetricImpl rejectedTimeout;
    private final IntMetricImpl rejectedAuth;
    private final IntMetricImpl rejectedTotal;
    private final IntMetricImpl[] accepted;

    public ClientListenerMetrics(GridKernalContext ctx) {
        MetricRegistry mreg = ctx.metric().registry(GridMetricManager.CLIENT_CONNECTOR_METRICS);
        this.rejectedTimeout = mreg.intMetric(METRIC_REJECTED_TIMEOUT, "TCP sessions count that were rejected due to handshake timeout.");
        this.rejectedAuth = mreg.intMetric(METRIC_REJECTED_AUTHENTICATION, "TCP sessions count that were rejected due to failed authentication.");
        this.rejectedTotal = mreg.intMetric(METRIC_REJECTED_TOTAL, "Total number of rejected TCP connections.");
        this.accepted = new IntMetricImpl[ClientListenerNioListener.CLI_TYPES.length];
        for (byte clientType : ClientListenerNioListener.CLI_TYPES) {
            String clientLabel = ClientListenerMetrics.clientTypeLabel(clientType);
            String labelAccepted = MetricUtils.metricName(clientLabel, METRIC_ACEPTED);
            this.accepted[clientType] = mreg.intMetric(labelAccepted, "Number of successfully established sessions for the client type.");
        }
    }

    public void onHandshakeTimeout() {
        this.rejectedTimeout.increment();
        this.rejectedTotal.increment();
    }

    public void onFailedAuth() {
        this.rejectedAuth.increment();
        this.rejectedTotal.increment();
    }

    public void onGeneralReject() {
        this.rejectedTotal.increment();
    }

    public void onHandshakeAccept(byte clientType) {
        this.accepted[clientType].increment();
    }

    public static String clientTypeLabel(byte clientType) {
        switch (clientType) {
            case 0: {
                return "odbc";
            }
            case 1: {
                return "jdbc";
            }
            case 2: {
                return "thin";
            }
        }
        return "unknown";
    }
}

