/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class ChangeGlobalStateFinishMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final UUID reqId;
    @Deprecated
    private final boolean clusterActive;
    private final ClusterState state;
    private Boolean transitionRes;

    public ChangeGlobalStateFinishMessage(UUID reqId, ClusterState state, Boolean transitionRes) {
        assert (reqId != null);
        assert (state != null);
        this.reqId = reqId;
        this.state = state;
        this.clusterActive = ClusterState.active(state);
        this.transitionRes = transitionRes;
    }

    public UUID requestId() {
        return this.reqId;
    }

    @Deprecated
    public boolean clusterActive() {
        return this.clusterActive;
    }

    public boolean success() {
        if (this.transitionRes == null) {
            if (this.state != null) {
                return ClusterState.active(this.state);
            }
            return this.clusterActive;
        }
        return this.transitionRes;
    }

    public ClusterState state() {
        return this.state != null ? this.state : (this.clusterActive ? ClusterState.ACTIVE : ClusterState.INACTIVE);
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean stopProcess() {
        return false;
    }

    @Override
    @Nullable
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(ChangeGlobalStateFinishMessage.class, this);
    }
}

