/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.checker.objects.VersionedValue;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.util.typedef.internal.U;

public class RepairMeta
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean fixed;
    private CacheObject val;
    private RepairAlgorithm repairAlg;
    private Map<UUID, VersionedValue> previousValue;

    public RepairMeta() {
    }

    public RepairMeta(boolean fixed, CacheObject val, RepairAlgorithm repairAlg, Map<UUID, VersionedValue> previousValue) {
        this.fixed = fixed;
        this.val = val;
        this.repairAlg = repairAlg;
        this.previousValue = previousValue;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.fixed);
        out.writeObject(this.val);
        U.writeEnum(out, this.repairAlg);
        U.writeMap(out, this.previousValue);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixed = in.readBoolean();
        this.val = (CacheObject)in.readObject();
        this.repairAlg = RepairAlgorithm.fromOrdinal(in.readByte());
        this.previousValue = U.readMap(in);
    }

    public Map<UUID, VersionedValue> getPreviousValue() {
        return this.previousValue;
    }

    public boolean fixed() {
        return this.fixed;
    }

    public CacheObject value() {
        return this.val;
    }

    public RepairAlgorithm repairAlg() {
        return this.repairAlg;
    }
}

