/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.events.WalSegmentArchivedEvent;
import org.apache.ignite.events.WalSegmentCompactedEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledRecord;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.RolloverType;
import org.apache.ignite.internal.pagemem.wal.record.SwitchSegmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.WalStateManager;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIODecorator;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentArchiveResult;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentRouter;
import org.apache.ignite.internal.processors.cache.persistence.wal.SingleSegmentLogicalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentAware;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.AbstractFileHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileHandleManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileHandleManagerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileWriteHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.LockedSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.io.GridFileUtils;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.CO;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class FileWriteAheadLogManager
extends GridCacheSharedManagerAdapter
implements IgniteWriteAheadLogManager {
    private static final FileDescriptor[] EMPTY_DESCRIPTORS = new FileDescriptor[0];
    private static final byte[] FILL_BUF = new byte[0x100000];
    public static final Pattern WAL_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal");
    public static final Pattern WAL_TEMP_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal\\.tmp");
    public static final FileFilter WAL_SEGMENT_FILE_FILTER = file -> !file.isDirectory() && WAL_NAME_PATTERN.matcher(file.getName()).matches();
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_FILTER = file -> !file.isDirectory() && WAL_TEMP_NAME_PATTERN.matcher(file.getName()).matches();
    public static final Pattern WAL_SEGMENT_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip");
    public static final FileFilter WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER = file -> !file.isDirectory() && (WAL_NAME_PATTERN.matcher(file.getName()).matches() || WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches());
    private static final Pattern WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip\\.tmp");
    private static final FileFilter WAL_SEGMENT_FILE_COMPACTED_FILTER = file -> !file.isDirectory() && WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER = file -> !file.isDirectory() && WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
    private static final int BUF_SIZE = 0x100000;
    public static final boolean DFLT_WAL_MMAP = true;
    public static final int DFLT_WAL_COMPRESSOR_WORKER_THREAD_CNT = 4;
    public static final double DFLT_CHECKPOINT_TRIGGER_ARCHIVE_SIZE_PERCENTAGE = 0.75;
    public static final double DFLT_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE = 0.5;
    public static final long DFLT_THRESHOLD_WAIT_TIME_NEXT_WAL_SEGMENT = 1000L;
    private final boolean mmap = IgniteSystemProperties.getBoolean("IGNITE_WAL_MMAP", true);
    private final int WAL_COMPRESSOR_WORKER_THREAD_CNT = IgniteSystemProperties.getInteger("IGNITE_WAL_COMPRESSOR_WORKER_THREAD_CNT", 4);
    private static final long THRESHOLD_WAIT_TIME_NEXT_WAL_SEGMENT = IgniteSystemProperties.getLong("IGNITE_THRESHOLD_WAIT_TIME_NEXT_WAL_SEGMENT", 1000L);
    private final boolean alwaysWriteFullPages;
    private final long maxWalSegmentSize;
    private final long maxSegCountWithoutCheckpoint;
    private final long maxWalArchiveSize;
    private final long minWalArchiveSize;
    private final WALMode mode;
    private final long flushFreq;
    private final DataStorageConfiguration dsCfg;
    private final GridEventStorageManager evt;
    private final FailureProcessor failureProcessor;
    private final IgniteConfiguration igCfg;
    private DataStorageMetricsImpl metrics;
    private File walWorkDir;
    private File walArchiveDir;
    private RecordSerializer serializer;
    private final int serializerVer = IgniteSystemProperties.getInteger("IGNITE_WAL_SERIALIZER_VERSION", 2);
    private volatile FileIOFactory ioFactory;
    private final SegmentFileInputFactory segmentFileInputFactory;
    private volatile SegmentAware segmentAware;
    private static final AtomicReferenceFieldUpdater<FileWriteAheadLogManager, FileWriteHandle> CURR_HND_UPD = AtomicReferenceFieldUpdater.newUpdater(FileWriteAheadLogManager.class, FileWriteHandle.class, "currHnd");
    @Nullable
    private FileArchiver archiver;
    @Nullable
    private FileCompressor compressor;
    @Nullable
    private FileDecompressor decompressor;
    @Nullable
    private FileCleaner cleaner;
    private volatile FileWriteHandle currHnd;
    private FileHandleManager fileHandleManager;
    private WalStateManager.WALDisableContext walDisableContext;
    private final long walAutoArchiveAfterInactivity;
    private final AtomicLong lastRecordLoggedMs = new AtomicLong();
    @Nullable
    private volatile GridTimeoutProcessor.CancelableTask backgroundFlushSchedule;
    @Nullable
    private TimeoutRollover timeoutRollover;
    @Nullable
    private final Object timeoutRolloverMux;
    @Nullable
    private volatile IgniteInClosure<FileIO> createWalFileListener;
    private SegmentRouter segmentRouter;
    private SegmentFileInputFactory lockedSegmentFileInputFactory;
    private final FileHandleManagerFactory fileHandleManagerFactory;
    @Nullable
    private final AtomicLongArray switchSegmentRecordOffset;
    private DiskPageCompression pageCompression;
    private int pageCompressionLevel;
    private final Map<Long, Long> segmentSize = new ConcurrentHashMap<Long, Long>();
    private volatile FileWALPointer lastCheckpointPtr = new FileWALPointer(0L, 0, 0);

    public FileWriteAheadLogManager(GridKernalContext ctx) {
        this.igCfg = ctx.config();
        DataStorageConfiguration dsCfg = this.igCfg.getDataStorageConfiguration();
        assert (dsCfg != null);
        this.dsCfg = dsCfg;
        this.maxWalSegmentSize = dsCfg.getWalSegmentSize();
        this.mode = dsCfg.getWalMode();
        this.flushFreq = dsCfg.getWalFlushFrequency();
        this.alwaysWriteFullPages = dsCfg.isAlwaysWriteFullPages();
        this.ioFactory = this.mode == WALMode.FSYNC ? dsCfg.getFileIOFactory() : new RandomAccessFileIOFactory();
        this.segmentFileInputFactory = new SimpleSegmentFileInputFactory();
        this.walAutoArchiveAfterInactivity = dsCfg.getWalAutoArchiveAfterInactivity();
        this.timeoutRolloverMux = this.walAutoArchiveAfterInactivity > 0L ? new Object() : null;
        this.maxWalArchiveSize = dsCfg.getMaxWalArchiveSize();
        this.minWalArchiveSize = FileWriteAheadLogManager.minWalArchiveSize(dsCfg);
        this.evt = ctx.event();
        this.failureProcessor = ctx.failure();
        this.fileHandleManagerFactory = new FileHandleManagerFactory(dsCfg);
        double cpTriggerArchiveSizePercentage = IgniteSystemProperties.getDouble("IGNITE_CHECKPOINT_TRIGGER_ARCHIVE_SIZE_PERCENTAGE", 0.75);
        this.maxSegCountWithoutCheckpoint = (long)((double)U.adjustedWalHistorySize(dsCfg, this.log) * cpTriggerArchiveSizePercentage / (double)dsCfg.getWalSegmentSize());
        this.switchSegmentRecordOffset = this.isArchiverEnabled() ? new AtomicLongArray(dsCfg.getWalSegments()) : null;
    }

    public void setFileIOFactory(FileIOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start0() throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        PdsFolderSettings<GridCacheDatabaseSharedManager.NodeFileLockHolder> resolveFolders = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
        this.checkWalConfiguration();
        FileWriteAheadLogManager fileWriteAheadLogManager = this;
        synchronized (fileWriteAheadLogManager) {
            final File walWorkDir0 = this.walWorkDir = this.initDirectory(this.dsCfg.getWalPath(), "db/wal", resolveFolders.folderName(), "write ahead log work directory");
            final File walArchiveDir0 = this.walArchiveDir = this.initDirectory(this.dsCfg.getWalArchivePath(), "db/wal/archive", resolveFolders.folderName(), "write ahead log archive directory");
            this.serializer = new RecordSerializerFactoryImpl(this.cctx).createSerializer(this.serializerVer);
            GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.cctx.database();
            this.metrics = dbMgr.persistentStoreMetricsImpl();
            if (this.metrics != null) {
                this.metrics.setWalSizeProvider((IgniteOutClosure<Long>)new CO<Long>(){

                    @Override
                    public Long apply() {
                        long size = 0L;
                        for (File f : walWorkDir0.listFiles()) {
                            size += f.length();
                        }
                        if (FileWriteAheadLogManager.this.isArchiverEnabled()) {
                            for (File f : walArchiveDir0.listFiles()) {
                                size += f.length();
                            }
                        }
                        return size;
                    }
                });
            }
            this.segmentAware = new SegmentAware(this.log, this.dsCfg.getWalSegments(), this.dsCfg.isWalCompactionEnabled(), this.minWalArchiveSize, this.maxWalArchiveSize);
            if (this.dsCfg.isWalCompactionEnabled()) {
                this.compressor = new FileCompressor(this.log);
                this.decompressor = new FileDecompressor(this.log);
            }
            if (this.isArchiverEnabled()) {
                this.archiver = new FileArchiver(this.log);
            }
            if (!this.walArchiveUnlimited()) {
                this.cleaner = new FileCleaner(this.log);
            }
            this.prepareAndCheckWalFiles();
            if (this.compressor != null) {
                this.compressor.initAlreadyCompressedSegments();
            }
            if (this.archiver != null) {
                this.archiver.init(this.segmentAware);
            }
            this.segmentRouter = new SegmentRouter(this.walWorkDir, this.walArchiveDir, this.segmentAware, this.dsCfg);
            this.fileHandleManager = this.fileHandleManagerFactory.build(this.cctx, this.metrics, this.mmap, this.serializer, this::currentHandle);
            this.lockedSegmentFileInputFactory = new LockedSegmentFileInputFactory(this.segmentAware, this.segmentRouter, this.ioFactory);
            this.pageCompression = this.dsCfg.getWalPageCompression();
            if (this.pageCompression != DiskPageCompression.DISABLED) {
                if (this.serializerVer < 2) {
                    throw new IgniteCheckedException("WAL page snapshots compression not supported for serializerVer=" + this.serializerVer);
                }
                this.cctx.kernalContext().compress().checkPageCompressionSupported();
                this.pageCompressionLevel = this.dsCfg.getWalPageCompressionLevel() != null ? CompressionProcessor.checkCompressionLevelBounds(this.dsCfg.getWalPageCompressionLevel(), this.pageCompression) : CompressionProcessor.getDefaultCompressionLevel(this.pageCompression);
            }
        }
    }

    public SegmentRouter getSegmentRouter() {
        return this.segmentRouter;
    }

    private void startArchiveWorkers() {
        this.segmentAware.reset();
        this.segmentAware.resetWalArchiveSizes();
        for (FileDescriptor descriptor : this.walArchiveFiles()) {
            this.segmentAware.addSize(descriptor.idx, descriptor.file.length());
        }
        if (this.isArchiverEnabled()) {
            assert (this.archiver != null) : "FileArchiver should be initialized.";
            this.archiver.restart();
        }
        if (this.dsCfg.isWalCompactionEnabled() && !this.cctx.kernalContext().recoveryMode()) {
            assert (this.compressor != null) : "Compressor should be initialized.";
            this.compressor.restart();
            assert (this.decompressor != null) : "Compressor should be initialized.";
            this.decompressor.restart();
        }
        if (!this.walArchiveUnlimited()) {
            assert (this.cleaner != null) : "FileCleaner should be initialized.";
            this.cleaner.restart();
        }
    }

    private boolean isArchiverEnabled() {
        if (this.walArchiveDir != null && this.walWorkDir != null) {
            return !this.walArchiveDir.equals(this.walWorkDir);
        }
        return !new File(this.dsCfg.getWalArchivePath()).equals(new File(this.dsCfg.getWalPath()));
    }

    public Collection<File> getWalFilesFromArchive(FileWALPointer low, FileWALPointer high) throws IgniteCheckedException {
        this.segmentAware.awaitSegmentArchived(high.index() - 1L);
        ArrayList<File> res = new ArrayList<File>();
        for (long i = low.index(); i < high.index(); ++i) {
            String segmentName = FileDescriptor.fileName(i);
            File file = new File(this.walArchiveDir, segmentName);
            File fileZip = new File(this.walArchiveDir, segmentName + ".zip");
            if (file.exists()) {
                res.add(file);
                continue;
            }
            if (fileZip.exists()) {
                res.add(fileZip);
                continue;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Segment not found: " + file.getName() + "/" + fileZip.getName());
            }
            res.clear();
            break;
        }
        return res;
    }

    private void checkWalConfiguration() throws IgniteCheckedException {
        if (this.dsCfg.getWalPath() == null ^ this.dsCfg.getWalArchivePath() == null) {
            throw new IgniteCheckedException("Properties should be either both specified or both null [walStorePath = " + this.dsCfg.getWalPath() + ", walArchivePath = " + this.dsCfg.getWalArchivePath() + "]");
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        GridTimeoutProcessor.CancelableTask schedule = this.backgroundFlushSchedule;
        if (schedule != null) {
            schedule.close();
        }
        this.stopAutoRollover();
        try {
            this.fileHandleManager.onDeactivate();
        }
        catch (Exception e) {
            U.error(this.log, "Failed to gracefully close WAL segment: " + this.currHnd, e);
        }
        this.segmentAware.interrupt();
        try {
            if (this.archiver != null) {
                this.archiver.shutdown();
            }
            if (this.compressor != null) {
                this.compressor.shutdown();
            }
            if (this.decompressor != null) {
                this.decompressor.shutdown();
            }
            if (this.cleaner != null) {
                this.cleaner.shutdown();
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            U.error(this.log, "Failed to gracefully shutdown WAL components, thread was interrupted.", e);
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activated file write ahead log manager [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate file write ahead log [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.stop0(true);
        this.currHnd = null;
    }

    @Override
    public boolean isAlwaysWriteFullPages() {
        return this.alwaysWriteFullPages;
    }

    @Override
    public boolean isFullSync() {
        return this.mode == WALMode.FSYNC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeLogging(WALPointer lastPtr) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("File write ahead log manager resuming logging [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        FileWriteAheadLogManager fileWriteAheadLogManager = this;
        synchronized (fileWriteAheadLogManager) {
            this.walDisableContext = this.cctx.walState().walDisableContext();
        }
        assert (this.currHnd == null);
        assert (lastPtr == null || lastPtr instanceof FileWALPointer);
        this.startArchiveWorkers();
        assert (this.isArchiverEnabled() && this.archiver != null || !this.isArchiverEnabled() && this.archiver == null) : "Trying to restore FileWriteHandle on deactivated write ahead log manager";
        FileWALPointer filePtr = (FileWALPointer)lastPtr;
        this.fileHandleManager.resumeLogging();
        this.updateCurrentHandle(this.restoreWriteHandle(filePtr), null);
        if (filePtr == null) {
            this.currHnd.writeHeader();
        }
        if (this.currHnd.serializerVersion() != this.serializer.version()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Record serializer version change detected, will start logging with a new WAL record serializer to a new WAL segment [curFile=" + this.currHnd + ", newVer=" + this.serializer.version() + ", oldVer=" + this.currHnd.serializerVersion() + ']');
            }
            this.rollOver(this.currHnd, null);
        }
        this.currHnd.finishResumeLogging();
        if (this.mode == WALMode.BACKGROUND) {
            this.backgroundFlushSchedule = this.cctx.time().schedule(this::doFlush, this.flushFreq, this.flushFreq);
        }
        if (this.walAutoArchiveAfterInactivity > 0L) {
            this.scheduleNextInactivityPeriodElapsedCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextInactivityPeriodElapsedCheck() {
        assert (this.walAutoArchiveAfterInactivity > 0L);
        assert (this.timeoutRolloverMux != null);
        Object object = this.timeoutRolloverMux;
        synchronized (object) {
            long lastRecMs = this.lastRecordLoggedMs.get();
            long nextEndTime = lastRecMs <= 0L ? U.currentTimeMillis() : lastRecMs + this.walAutoArchiveAfterInactivity;
            this.timeoutRollover = new TimeoutRollover(nextEndTime);
            this.cctx.time().addTimeoutObject(this.timeoutRollover);
        }
    }

    @Override
    public int serializerVersion() {
        return this.serializerVer;
    }

    private void checkWalRolloverRequiredDuringInactivityPeriod() {
        if (this.walAutoArchiveAfterInactivity <= 0L) {
            return;
        }
        long lastRecMs = this.lastRecordLoggedMs.get();
        if (lastRecMs == 0L) {
            return;
        }
        long elapsedMs = U.currentTimeMillis() - lastRecMs;
        if (elapsedMs <= this.walAutoArchiveAfterInactivity) {
            return;
        }
        if (!this.lastRecordLoggedMs.compareAndSet(lastRecMs, 0L)) {
            return;
        }
        FileWriteHandle handle = this.currentHandle();
        try {
            this.closeBufAndRollover(handle, null, RolloverType.NONE);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Unable to perform segment rollover: " + e.getMessage(), e);
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    @Override
    public WALPointer log(WALRecord rec) throws IgniteCheckedException {
        return this.log(rec, RolloverType.NONE);
    }

    @Override
    public WALPointer log(WALRecord rec, RolloverType rolloverType) throws IgniteCheckedException {
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return null;
        }
        if (this.cctx.kernalContext().recoveryMode() && !(rec instanceof PageDeltaRecord) && !(rec instanceof PageSnapshot) && !(rec instanceof MemoryRecoveryRecord)) {
            return null;
        }
        FileWriteHandle currWrHandle = this.currentHandle();
        WalStateManager.WALDisableContext isDisable = this.walDisableContext;
        if (currWrHandle == null || isDisable != null && isDisable.check()) {
            return null;
        }
        if (this.pageCompression != DiskPageCompression.DISABLED && rec instanceof PageSnapshot) {
            PageSnapshot pageSnapshot = (PageSnapshot)rec;
            int pageSize = pageSnapshot.realPageSize();
            ByteBuffer pageData = pageSnapshot.pageDataBuffer();
            ByteBuffer compressedPage = this.cctx.kernalContext().compress().compressPage(pageData, pageSize, 1, this.pageCompression, this.pageCompressionLevel);
            if (compressedPage != pageData) {
                assert (compressedPage.isDirect()) : "Is direct buffer: " + compressedPage.isDirect();
                rec = new PageSnapshot(pageSnapshot.fullPageId(), GridUnsafe.bufferAddress(compressedPage), compressedPage.limit(), pageSize);
            }
        }
        rec.size(this.serializer.size(rec));
        do {
            WALPointer ptr;
            if (rolloverType == RolloverType.NONE) {
                ptr = currWrHandle.addRecord(rec);
            } else {
                assert (this.cctx.database().checkpointLockIsHeldByThread());
                if (rolloverType == RolloverType.NEXT_SEGMENT) {
                    WALPointer pos = rec.position();
                    do {
                        currWrHandle = this.closeBufAndRollover(currWrHandle, rec, rolloverType);
                    } while (Objects.equals(pos, rec.position()));
                    ptr = rec.position();
                } else if (rolloverType == RolloverType.CURRENT_SEGMENT) {
                    ptr = currWrHandle.addRecord(rec);
                    if (ptr != null) {
                        currWrHandle = this.closeBufAndRollover(currWrHandle, rec, rolloverType);
                    }
                } else {
                    throw new IgniteCheckedException("Unknown rollover type: " + (Object)((Object)rolloverType));
                }
            }
            if (ptr != null) {
                this.metrics.onWalRecordLogged(rec.size());
                if (this.walAutoArchiveAfterInactivity > 0L) {
                    this.lastRecordLoggedMs.set(U.currentTimeMillis());
                }
                return ptr;
            }
            currWrHandle = this.rollOver(currWrHandle, null);
            this.checkNode();
        } while (!this.isStopping());
        throw new IgniteCheckedException("Stopping.");
    }

    private FileWriteHandle closeBufAndRollover(FileWriteHandle currWriteHandle, @Nullable WALRecord rec, RolloverType rolloverType) throws IgniteCheckedException {
        long idx = currWriteHandle.getSegmentId();
        currWriteHandle.closeBuffer();
        FileWriteHandle res = this.rollOver(currWriteHandle, rolloverType == RolloverType.NEXT_SEGMENT ? rec : null);
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info("Rollover segment [" + idx + " to " + res.getSegmentId() + "], recordType=" + (Object)((Object)(rec == null ? null : rec.type())));
        }
        return res;
    }

    @Override
    public WALPointer flush(WALPointer ptr, boolean explicitFsync) throws IgniteCheckedException, StorageException {
        return this.fileHandleManager.flush(ptr, explicitFsync);
    }

    @Override
    public WALRecord read(WALPointer ptr) throws IgniteCheckedException {
        Throwable throwable = null;
        try (WALIterator it = this.replay(ptr);){
            IgniteBiTuple rec = (IgniteBiTuple)it.next();
            if (rec != null && ((WALRecord)rec.get2()).position().equals(ptr)) {
                WALRecord wALRecord = (WALRecord)rec.get2();
                return wALRecord;
            }
            try {
                throw new StorageException("Failed to read record by pointer [ptr=" + ptr + ", rec=" + rec + "]");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public WALIterator replay(WALPointer start) throws IgniteCheckedException, StorageException {
        return this.replay(start, null);
    }

    @Override
    public WALIterator replay(WALPointer start, @Nullable IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordDeserializeFilter) throws IgniteCheckedException, StorageException {
        assert (start == null || start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        FileWriteHandle hnd = this.currentHandle();
        FileWALPointer end = null;
        if (hnd != null) {
            end = hnd.position();
        }
        RecordsIterator iter = new RecordsIterator(this.cctx, this.walArchiveDir, this.walWorkDir, (FileWALPointer)start, end, this.dsCfg, new RecordSerializerFactoryImpl(this.cctx).recordDeserializeFilter((IgniteBiPredicate)recordDeserializeFilter), this.ioFactory, this.archiver, this.decompressor, this.log, this.segmentAware, this.segmentRouter, this.lockedSegmentFileInputFactory);
        try {
            iter.init();
        }
        catch (Throwable t2) {
            iter.close();
            throw t2;
        }
        return iter;
    }

    @Override
    public boolean reserve(WALPointer start) {
        assert (start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return false;
        }
        boolean reserved = this.segmentAware.reserve(((FileWALPointer)start).index());
        if (reserved && !this.hasIndex(((FileWALPointer)start).index())) {
            this.segmentAware.release(((FileWALPointer)start).index());
            reserved = false;
        }
        return reserved;
    }

    @Override
    public void release(WALPointer start) {
        assert (start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return;
        }
        this.segmentAware.release(((FileWALPointer)start).index());
    }

    private boolean hasIndex(long absIdx) {
        boolean inArchive;
        String segmentName = FileDescriptor.fileName(absIdx);
        boolean bl = inArchive = new File(this.walArchiveDir, segmentName).exists() || new File(this.walArchiveDir, segmentName + ".zip").exists();
        if (inArchive) {
            return true;
        }
        if (absIdx <= this.lastArchivedIndex()) {
            return new File(this.walArchiveDir, segmentName).exists() || new File(this.walArchiveDir, segmentName + ".zip").exists();
        }
        FileWriteHandle cur = this.currHnd;
        return cur != null && cur.getSegmentId() >= absIdx;
    }

    @Override
    public int truncate(@Nullable WALPointer high) {
        if (high == null) {
            return 0;
        }
        assert (high instanceof FileWALPointer) : high;
        FileWALPointer highPtr = (FileWALPointer)high;
        FileDescriptor[] descs = this.walArchiveFiles();
        int deleted = 0;
        ArrayList<String> deletedSegments = null;
        long lastCpIdx = this.lastCheckpointPtr.index();
        for (FileDescriptor desc : descs) {
            long lastArchived;
            long archivedAbsIdx = this.segmentAware.lastArchivedAbsoluteIndex();
            long l = lastArchived = archivedAbsIdx >= 0L ? archivedAbsIdx : this.lastArchivedIndex();
            if (desc.idx >= lastCpIdx || desc.idx >= lastArchived || desc.idx >= highPtr.index() || !this.segmentAware.minReserveIndex(desc.idx)) break;
            long len = desc.file.length();
            if (!desc.file.delete()) {
                U.warn(this.log, "Failed to remove obsolete WAL segment (make sure the process has enough rights): " + desc.file.getAbsolutePath());
            } else {
                ++deleted;
                if (deletedSegments == null) {
                    deletedSegments = new ArrayList<String>();
                }
                deletedSegments.add(desc.file().getName());
                long idx = desc.idx();
                this.segmentSize.remove(idx);
                this.segmentAware.addSize(idx, -len);
            }
            if (this.segmentAware.lastTruncatedArchiveIdx() < desc.idx) {
                this.segmentAware.lastTruncatedArchiveIdx(desc.idx);
            }
            this.cctx.kernalContext().encryption().onWalSegmentRemoved(desc.idx);
        }
        if (this.log.isInfoEnabled() && deletedSegments != null) {
            this.log.info("Segments removed after WAL archive cleaning [cleanedSegments=" + deletedSegments + ", lastCpIdx=" + lastCpIdx + ", highIdx=" + highPtr.index() + ']');
        }
        return deleted;
    }

    private boolean segmentReservedOrLocked(long absIdx) {
        FileArchiver archiver0 = this.archiver;
        return archiver0 != null && this.segmentAware.locked(absIdx) || this.segmentAware.reserved(absIdx);
    }

    @Override
    public void notchLastCheckpointPtr(WALPointer ptr) {
        assert (ptr instanceof FileWALPointer) : "Invalid start pointer: " + ptr;
        this.lastCheckpointPtr = (FileWALPointer)ptr;
        this.segmentAware.lastCheckpointIdx(((FileWALPointer)ptr).index());
    }

    @Override
    public long currentSegment() {
        return this.segmentAware.curAbsWalIdx();
    }

    @Override
    public int walArchiveSegments() {
        long lastTruncated = this.segmentAware.lastTruncatedArchiveIdx();
        long lastArchived = this.segmentAware.lastArchivedAbsoluteIndex();
        if (lastArchived == -1L) {
            return 0;
        }
        return Math.max((int)(lastArchived - lastTruncated), 0);
    }

    @Override
    public long lastArchivedSegment() {
        return this.segmentAware.lastArchivedAbsoluteIndex();
    }

    @Override
    public long lastCompactedSegment() {
        return this.segmentAware.lastCompressedIdx();
    }

    @Override
    public boolean reserved(WALPointer ptr) {
        FileWALPointer fPtr = (FileWALPointer)ptr;
        return this.segmentReservedOrLocked(fPtr.index());
    }

    @Override
    public int reserved(WALPointer low, WALPointer high) {
        long lowIdx;
        if (high == null) {
            return 0;
        }
        assert (high instanceof FileWALPointer) : high;
        assert (low == null || low instanceof FileWALPointer) : low;
        FileWALPointer lowPtr = (FileWALPointer)low;
        FileWALPointer highPtr = (FileWALPointer)high;
        long highIdx = highPtr.index();
        for (lowIdx = lowPtr != null ? lowPtr.index() : 0L; lowIdx < highIdx && !this.segmentReservedOrLocked(lowIdx); ++lowIdx) {
        }
        return (int)(highIdx - lowIdx + 1L);
    }

    @Override
    public boolean disabled(int grpId) {
        return this.cctx.walState().isDisabled(grpId);
    }

    private long lastArchivedIndex() {
        long lastIdx = -1L;
        for (File file : this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
            try {
                long idx = Long.parseLong(file.getName().substring(0, 16));
                lastIdx = Math.max(lastIdx, idx);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return lastIdx;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private FileDescriptor readFileDescriptor(File file, FileIOFactory ioFactory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File initDirectory(String cfg, String defDir, String consId, String msg) throws IgniteCheckedException {
        File workDir0;
        File dir = cfg != null ? ((workDir0 = new File(cfg)).isAbsolute() ? new File(workDir0, consId) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), cfg, false), consId)) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), defDir, false), consId);
        U.ensureDirectory(dir, msg, this.log);
        return dir;
    }

    private FileWriteHandle currentHandle() {
        return this.currHnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWriteHandle rollOver(FileWriteHandle cur, @Nullable WALRecord rec) throws IgniteCheckedException {
        FileWriteHandle hnd = this.currentHandle();
        if (hnd != cur) {
            return hnd;
        }
        if (hnd.close(true)) {
            FileWriteHandle next;
            if (this.metrics.metricsEnabled()) {
                this.metrics.onWallRollOver();
            }
            if (this.switchSegmentRecordOffset != null) {
                int idx = (int)(cur.getSegmentId() % (long)this.dsCfg.getWalSegments());
                this.switchSegmentRecordOffset.set(idx, hnd.getSwitchSegmentRecordOffset());
            }
            long idx = cur.getSegmentId() + 1L;
            long currSize = 0L;
            long reservedSize = this.maxWalSegmentSize;
            if (this.archiver == null) {
                this.segmentAware.addSize(idx, reservedSize);
            }
            try {
                try {
                    next = this.initNextWriteHandle(cur);
                }
                catch (IgniteCheckedException e) {
                    cur.signalNextAvailable();
                    throw e;
                }
                if (rec != null) {
                    WALPointer ptr = next.addRecord(rec);
                    assert (ptr != null);
                }
                currSize = reservedSize;
                this.segmentSize.put(idx, currSize);
            }
            finally {
                if (this.archiver == null) {
                    this.segmentAware.addSize(idx, currSize - reservedSize);
                }
            }
            if (next.getSegmentId() - this.lastCheckpointPtr.index() >= this.maxSegCountWithoutCheckpoint) {
                this.cctx.database().forceCheckpoint("too big size of WAL without checkpoint");
            }
            boolean updated = this.updateCurrentHandle(next, hnd);
            assert (updated) : "Concurrent updates on rollover are not allowed";
            if (this.walAutoArchiveAfterInactivity > 0L) {
                this.lastRecordLoggedMs.set(0L);
            }
            hnd.signalNextAvailable();
        } else {
            hnd.awaitNext();
        }
        return this.currentHandle();
    }

    private FileWriteHandle restoreWriteHandle(@Nullable FileWALPointer lastReadPtr) throws StorageException {
        long absIdx = lastReadPtr == null ? 0L : lastReadPtr.index();
        @Nullable FileArchiver archiver0 = this.archiver;
        long segNo = archiver0 == null ? absIdx : absIdx % (long)this.dsCfg.getWalSegments();
        File curFile = new File(this.walWorkDir, FileDescriptor.fileName(segNo));
        int off = lastReadPtr == null ? 0 : lastReadPtr.fileOffset();
        int len = lastReadPtr == null ? 0 : lastReadPtr.length();
        try {
            SegmentIO fileIO = new SegmentIO(absIdx, this.ioFactory.create(curFile));
            IgniteInClosure<FileIO> lsnr = this.createWalFileListener;
            if (lsnr != null) {
                lsnr.apply(fileIO);
            }
            try {
                int serVer = this.serializerVer;
                if (lastReadPtr != null) {
                    try {
                        serVer = RecordV1Serializer.readSegmentHeader(fileIO, this.segmentFileInputFactory).getSerializerVersion();
                    }
                    catch (EOFException | SegmentEofException ignore) {
                        serVer = this.serializerVer;
                    }
                }
                RecordSerializer ser = new RecordSerializerFactoryImpl(this.cctx).createSerializer(serVer);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Resuming logging to WAL segment [file=" + curFile.getAbsolutePath() + ", offset=" + off + ", ver=" + serVer + ']');
                }
                FileWriteHandle hnd = this.fileHandleManager.initHandle(fileIO, off + len, ser);
                this.segmentAware.curAbsWalIdx(absIdx);
                FileDescriptor[] walArchiveFiles = this.walArchiveFiles();
                this.segmentAware.minReserveIndex(F.isEmpty(walArchiveFiles) ? -1L : walArchiveFiles[0].idx - 1L);
                this.segmentAware.lastTruncatedArchiveIdx(F.isEmpty(walArchiveFiles) ? -1L : walArchiveFiles[0].idx - 1L);
                if (archiver0 == null) {
                    this.segmentAware.setLastArchivedAbsoluteIndex(absIdx - 1L);
                }
                F.asList(this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)).stream().map(FileDescriptor::new).forEach(fd -> {
                    if (fd.isCompressed()) {
                        this.segmentSize.put(fd.idx(), fd.file().length());
                    } else {
                        this.segmentSize.putIfAbsent(fd.idx(), fd.file().length());
                    }
                });
                if (archiver0 != null) {
                    for (long i = absIdx - absIdx % (long)this.dsCfg.getWalSegments(); i < absIdx; ++i) {
                        this.segmentSize.putIfAbsent(i, this.maxWalSegmentSize);
                    }
                }
                return hnd;
            }
            catch (IOException | IgniteCheckedException e) {
                try {
                    fileIO.close();
                }
                catch (IOException suppressed) {
                    e.addSuppressed(suppressed);
                }
                if (e instanceof StorageException) {
                    throw (StorageException)e;
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to restore WAL write handle: " + curFile.getAbsolutePath(), e);
        }
    }

    private FileWriteHandle initNextWriteHandle(FileWriteHandle cur) throws IgniteCheckedException {
        IgniteCheckedException error = null;
        try {
            FileWriteHandle hnd;
            File nextFile = this.pollNextFile(cur.getSegmentId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Switching to a new WAL segment: " + nextFile.getAbsolutePath());
            }
            FileIODecorator fileIO = null;
            boolean interrupted = false;
            if (this.switchSegmentRecordOffset != null) {
                this.switchSegmentRecordOffset.set((int)((cur.getSegmentId() + 1L) % (long)this.dsCfg.getWalSegments()), 0L);
            }
            while (true) {
                try {
                    fileIO = new SegmentIO(cur.getSegmentId() + 1L, this.ioFactory.create(nextFile));
                    IgniteInClosure<FileIO> lsnr = this.createWalFileListener;
                    if (lsnr != null) {
                        lsnr.apply(fileIO);
                    }
                    hnd = this.fileHandleManager.nextHandle((SegmentIO)fileIO, this.serializer);
                    if (!interrupted) break;
                    Thread.currentThread().interrupt();
                }
                catch (ClosedByInterruptException ignore) {
                    interrupted = true;
                    Thread.interrupted();
                    if (fileIO == null) continue;
                    try {
                        fileIO.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fileIO = null;
                    continue;
                }
                break;
            }
            hnd.writeHeader();
            FileWriteHandle fileWriteHandle = hnd;
            return fileWriteHandle;
        }
        catch (IgniteCheckedException e) {
            error = e;
            throw error;
        }
        catch (IOException e) {
            error = new StorageException("Unable to initialize WAL segment", e);
            throw error;
        }
        finally {
            if (error != null) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, error));
            }
        }
    }

    private void prepareAndCheckWalFiles() throws StorageException {
        HashSet<File[]> tmpFiles = new HashSet<File[]>();
        for (File file : F.asList(new File[]{this.walWorkDir, this.walArchiveDir})) {
            tmpFiles.addAll(F.asList(file.listFiles(WAL_SEGMENT_TEMP_FILE_FILTER)));
            tmpFiles.addAll(F.asList(file.listFiles(WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER)));
        }
        for (File file : tmpFiles) {
            if (!file.exists() || file.delete()) continue;
            throw new StorageException("Failed to delete previously created temp file (make sure Ignite process has enough rights): " + file.getAbsolutePath());
        }
        if (F.isEmpty(this.walWorkDir.listFiles(WAL_SEGMENT_FILE_FILTER))) {
            this.createFile(new File(this.walWorkDir, FileDescriptor.fileName(0L)));
        }
        if (this.isArchiverEnabled()) {
            this.moveSegmentsToArchive();
            this.renameLastSegment();
            this.formatWorkSegments();
            this.checkFiles(0, false, null, null);
        }
    }

    private void formatFile(File file) throws StorageException {
        this.formatFile(file, this.dsCfg.getWalSegmentSize());
    }

    private void formatFile(File file, int bytesCntToFormat) throws StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Formatting file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        try (FileIO fileIO = this.ioFactory.create(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            int left = bytesCntToFormat;
            if (this.mode == WALMode.FSYNC || this.mmap) {
                while ((left -= fileIO.writeFully(FILL_BUF, 0, Math.min(FILL_BUF.length, left))) > 0) {
                }
                fileIO.force();
            } else {
                fileIO.clear();
            }
        }
        catch (IOException e) {
            StorageException ex = new StorageException("Failed to format WAL segment file: " + file.getAbsolutePath(), e);
            if (this.failureProcessor != null) {
                this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, ex));
            }
            throw ex;
        }
    }

    private void createFile(File file) throws StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating new file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        File tmp = new File(file.getParent(), file.getName() + ".tmp");
        this.formatFile(tmp);
        try {
            Files.move(tmp.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new StorageException("Failed to move temp file to a regular WAL segment file: " + file.getAbsolutePath(), e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created WAL segment [file=" + file.getAbsolutePath() + ", size=" + file.length() + ']');
        }
    }

    private File pollNextFile(long curIdx) throws StorageException, IgniteInterruptedCheckedException {
        FileArchiver archiver0 = this.archiver;
        if (archiver0 == null) {
            this.segmentAware.curAbsWalIdx(curIdx + 1L);
            this.segmentAware.setLastArchivedAbsoluteIndex(curIdx);
            return new File(this.walWorkDir, FileDescriptor.fileName(curIdx + 1L));
        }
        long absNextIdxStartTime = System.nanoTime();
        long absNextIdx = archiver0.nextAbsoluteSegmentIndex();
        assert (absNextIdx == curIdx + 1L) : "curIdx=" + curIdx + ", nextIdx=" + absNextIdx;
        long absNextIdxWaitTime = U.nanosToMillis(System.nanoTime() - absNextIdxStartTime);
        if (absNextIdxWaitTime > THRESHOLD_WAIT_TIME_NEXT_WAL_SEGMENT) {
            this.log.warning(String.format("Waiting for next wal segment was too long [waitingTime=%s, curIdx=%s, absNextIdx=%s, walSegments=%s]", absNextIdxWaitTime, curIdx, absNextIdx, this.dsCfg.getWalSegments()));
        }
        long segmentIdx = absNextIdx % (long)this.dsCfg.getWalSegments();
        return new File(this.walWorkDir, FileDescriptor.fileName(segmentIdx));
    }

    public FileDescriptor[] walArchiveFiles() {
        return FileWriteAheadLogManager.scan(this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
    }

    public static FileDescriptor[] scan(@Nullable File[] allFiles) {
        if (allFiles == null) {
            return EMPTY_DESCRIPTORS;
        }
        Object[] descs = new FileDescriptor[allFiles.length];
        for (int i = 0; i < allFiles.length; ++i) {
            File f = allFiles[i];
            descs[i] = new FileDescriptor(f);
        }
        Arrays.sort(descs);
        return descs;
    }

    private void checkNode() throws StorageException {
        if (this.cctx.kernalContext().invalid()) {
            throw new StorageException("Failed to perform WAL operation (environment was invalidated by a previous error)");
        }
    }

    public void setCreateWalFileListener(@Nullable IgniteInClosure<FileIO> createWalFileListener) {
        this.createWalFileListener = createWalFileListener;
    }

    public long maxWalSegmentSize() {
        return this.maxWalSegmentSize;
    }

    private void checkFiles(int startWith, boolean create, @Nullable IgnitePredicate<Integer> p, @Nullable IgniteInClosure<Integer> completionCb) throws StorageException {
        for (int i = startWith; i < this.dsCfg.getWalSegments() && (p == null || p.apply(i)); ++i) {
            File checkFile = new File(this.walWorkDir, FileDescriptor.fileName(i));
            if (checkFile.exists()) {
                if (checkFile.isDirectory()) {
                    throw new StorageException("Failed to initialize WAL log segment (a directory with the same name already exists): " + checkFile.getAbsolutePath());
                }
                if (checkFile.length() != (long)this.dsCfg.getWalSegmentSize() && this.mode == WALMode.FSYNC) {
                    throw new StorageException("Failed to initialize WAL log segment (WAL segment size change is not supported in 'DEFAULT' WAL mode) [filePath=" + checkFile.getAbsolutePath() + ", fileSize=" + checkFile.length() + ", configSize=" + this.dsCfg.getWalSegmentSize() + ']');
                }
            } else if (create) {
                this.createFile(checkFile);
            }
            if (completionCb == null) continue;
            completionCb.apply(i);
        }
    }

    public static ByteBuffer prepareSerializerVersionBuffer(long idx, int ver, boolean compacted, ByteBuffer buf) {
        buf.put((byte)(WALRecord.RecordType.HEADER_RECORD.ordinal() + 1));
        RecordV1Serializer.putPosition(buf, new FileWALPointer(idx, 0, 0));
        buf.putLong(compacted ? 5622654036411574606L : -5705984118950656934L);
        buf.putInt(ver);
        if (!RecordV1Serializer.skipCrc) {
            int curPos = buf.position();
            buf.position(0);
            int crcVal = FastCrc.calcCrc(buf, curPos);
            buf.putInt(crcVal);
        } else {
            buf.putInt(0);
        }
        buf.position(0);
        return buf;
    }

    private void doFlush() {
        FileWriteHandle hnd = this.currentHandle();
        try {
            hnd.flushAll();
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to flush WAL record queue", e);
        }
    }

    public static FileDescriptor[] loadFileDescriptors(File walFilesDir) throws IgniteCheckedException {
        File[] files = walFilesDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER);
        if (files == null) {
            throw new IgniteCheckedException("WAL files directory does not not denote a directory, or if an I/O error occurs: [" + walFilesDir.getAbsolutePath() + "]");
        }
        return FileWriteAheadLogManager.scan(files);
    }

    @Override
    public long segmentSize(long idx) {
        return this.segmentSize.getOrDefault(idx, 0L);
    }

    @Override
    public WALPointer lastWritePointer() {
        return this.currHnd.position();
    }

    private boolean updateCurrentHandle(FileWriteHandle n, @Nullable FileWriteHandle c) {
        boolean res = true;
        if (c == null) {
            this.currHnd = n;
        } else {
            res = CURR_HND_UPD.compareAndSet(this, c, n);
        }
        return res;
    }

    public static boolean isSegmentFileName(@Nullable String name) {
        return name != null && (WAL_NAME_PATTERN.matcher(name).matches() || WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(name).matches());
    }

    public long lastTruncatedSegment() {
        return this.segmentAware.lastTruncatedArchiveIdx();
    }

    public static long totalSize(FileDescriptor ... fileDescriptors) {
        long len = 0L;
        for (FileDescriptor descriptor : fileDescriptors) {
            len += descriptor.file.length();
        }
        return len;
    }

    private boolean walArchiveUnlimited() {
        return this.maxWalArchiveSize == -1L;
    }

    private long deleteArchiveFiles(File ... files) {
        long size = 0L;
        for (File file : files) {
            if (!file.exists()) continue;
            long len = file.length();
            if (file.delete()) {
                size += len;
                continue;
            }
            if (!file.exists()) continue;
            U.warn(this.log, "Unable to delete file from WAL archive (make sure the process has enough rights):  " + file.getAbsolutePath());
        }
        return size;
    }

    public void dumpWalFiles(File baseDumpDir) {
        try {
            long lastCpIdx = this.lastCheckpointPtr.index();
            long currIdx = this.currentHandle().getSegmentId();
            boolean reserved = false;
            while (!reserved) {
                if (lastCpIdx > currIdx) {
                    return;
                }
                reserved = this.reserve(new FileWALPointer(lastCpIdx, 0, 0));
                if (reserved) continue;
                this.log.warning("Unable to reserve WAL segment " + lastCpIdx + " for dumping, skipping.");
                ++lastCpIdx;
            }
            File dumpDir = new File(baseDumpDir, "wal");
            boolean[] copied = new boolean[(int)(currIdx - lastCpIdx + 1L)];
            ArrayList<File> walFiles = new ArrayList<File>();
            if (this.archiver != null) {
                walFiles.addAll(Arrays.asList(this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)));
            }
            walFiles.addAll(Arrays.asList(this.walWorkDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)));
            for (File file : walFiles) {
                int i;
                long idx;
                FileDescriptor desc = this.readFileDescriptor(file, this.ioFactory);
                if (desc == null || (idx = desc.idx) < lastCpIdx || idx > currIdx || copied[i = (int)(idx - lastCpIdx)]) continue;
                copied[i] = true;
                if (idx == this.currentHandle().getSegmentId()) {
                    this.currentHandle().flushAll();
                }
                U.copy(file, new File(dumpDir, FileDescriptor.fileName(idx)), false);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to dump wal files", e);
        }
    }

    private void moveSegmentsToArchive() throws StorageException {
        assert (this.isArchiverEnabled());
        FileDescriptor[] workSegments = FileWriteAheadLogManager.scan(this.walWorkDir.listFiles(WAL_SEGMENT_FILE_FILTER));
        ArrayList<FileDescriptor[]> toMove = new ArrayList<FileDescriptor[]>();
        if (!(F.isEmpty(workSegments) || workSegments.length <= this.dsCfg.getWalSegments() && workSegments[0].idx() == 0L)) {
            toMove.addAll(F.asList(workSegments).subList(0, workSegments.length - 1));
        }
        toMove.addAll(F.asList(FileWriteAheadLogManager.scan(this.walWorkDir.listFiles(WAL_SEGMENT_FILE_COMPACTED_FILTER))));
        if (!toMove.isEmpty()) {
            this.log.warning("Content of WAL working directory needs rearrangement, some WAL segments will be moved to archive: " + this.walArchiveDir.getAbsolutePath() + ". Segments from " + ((FileDescriptor)toMove.get(0)).file().getName() + " to " + ((FileDescriptor)toMove.get(toMove.size() - 1)).file().getName() + " will be moved, total number of files: " + toMove.size() + ". This operation may take some time.");
            int j = 0;
            for (int i = 0; i < toMove.size(); ++i) {
                FileDescriptor fd = (FileDescriptor)toMove.get(i);
                File tmpDst = new File(this.walArchiveDir, fd.file().getName() + ".tmp");
                File dst = new File(this.walArchiveDir, fd.file().getName());
                try {
                    Files.copy(fd.file().toPath(), tmpDst.toPath(), new CopyOption[0]);
                    Files.move(tmpDst.toPath(), dst.toPath(), new CopyOption[0]);
                    Files.delete(fd.file().toPath());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("WAL segment moved [src=" + fd.file().getAbsolutePath() + ", dst=" + dst.getAbsolutePath() + ']');
                    }
                    if (!this.log.isInfoEnabled() || i != toMove.size() - 1 && (i == 0 || i % 9 != 0)) continue;
                    this.log.info("WAL segments moved: " + ((FileDescriptor)toMove.get(j)).file().getName() + (i == j ? "" : " - " + ((FileDescriptor)toMove.get(i)).file().getName()));
                    j = i + 1;
                    continue;
                }
                catch (IOException e) {
                    throw new StorageException("Failed to move WAL segment [src=" + fd.file().getAbsolutePath() + ", dst=" + dst.getAbsolutePath() + ']', e);
                }
            }
        }
    }

    private void renameLastSegment() throws StorageException {
        assert (this.isArchiverEnabled());
        FileDescriptor[] workSegments = FileWriteAheadLogManager.scan(this.walWorkDir.listFiles(WAL_SEGMENT_FILE_FILTER));
        if (workSegments.length == 1 && workSegments[0].idx() != workSegments[0].idx() % (long)this.dsCfg.getWalSegments()) {
            FileDescriptor toRen = workSegments[0];
            if (this.log.isInfoEnabled()) {
                this.log.info("Last WAL segment file has to be renamed from " + toRen.file().getName() + " to " + FileDescriptor.fileName(toRen.idx() % (long)this.dsCfg.getWalSegments()) + '.');
            }
            String toRenFileName = FileDescriptor.fileName(toRen.idx() % (long)this.dsCfg.getWalSegments());
            File tmpDst = new File(this.walWorkDir, toRenFileName + ".tmp");
            File dst = new File(this.walWorkDir, toRenFileName);
            try {
                Files.copy(toRen.file().toPath(), tmpDst.toPath(), new CopyOption[0]);
                Files.move(tmpDst.toPath(), dst.toPath(), new CopyOption[0]);
                Files.delete(toRen.file().toPath());
                if (this.log.isInfoEnabled()) {
                    this.log.info("WAL segment renamed [src=" + toRen.file().getAbsolutePath() + ", dst=" + dst.getAbsolutePath() + ']');
                }
            }
            catch (IOException e) {
                throw new StorageException("Failed to rename WAL segment [src=" + toRen.file().getAbsolutePath() + ", dst=" + dst.getAbsolutePath() + ']', e);
            }
        }
    }

    private void formatWorkSegments() throws StorageException {
        List toFormat;
        assert (this.isArchiverEnabled());
        if ((this.mode == WALMode.FSYNC || this.mmap) && !(toFormat = Arrays.stream(FileWriteAheadLogManager.scan(this.walWorkDir.listFiles(WAL_SEGMENT_FILE_FILTER))).filter(fd -> fd.file().length() < (long)this.dsCfg.getWalSegmentSize()).collect(Collectors.toList())).isEmpty()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("WAL segments in working directory should have the same size: '" + U.humanReadableByteCount(this.dsCfg.getWalSegmentSize()) + "'. Segments that need reformat found: " + F.viewReadOnly(toFormat, fd -> fd.file().getName(), new IgnitePredicate[0]) + '.');
            }
            int j = 0;
            for (int i = 0; i < toFormat.size(); ++i) {
                File segFile = ((FileDescriptor)toFormat.get(i)).file();
                File tmpDst = segFile.getAbsoluteFile().toPath().getParent().resolve(segFile.getName() + ".tmp").toFile();
                try {
                    Files.copy(segFile.toPath(), tmpDst.toPath(), new CopyOption[0]);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Start formatting WAL segment [filePath=" + tmpDst.getAbsolutePath() + ", fileSize=" + U.humanReadableByteCount(tmpDst.length()) + ", toSize=" + U.humanReadableByteCount(this.dsCfg.getWalSegmentSize()) + ']');
                    }
                    try (FileIO fileIO = this.ioFactory.create(tmpDst, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                        fileIO.position(tmpDst.length());
                        for (int left = (int)((long)this.dsCfg.getWalSegmentSize() - tmpDst.length()); left > 0; left -= fileIO.writeFully(FILL_BUF, 0, Math.min(FILL_BUF.length, left))) {
                        }
                        fileIO.force();
                    }
                    Files.move(tmpDst.toPath(), segFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("WAL segment formatted: " + segFile.getAbsolutePath());
                    }
                    if (!this.log.isInfoEnabled() || i != toFormat.size() - 1 && (i == 0 || i % 9 != 0)) continue;
                    this.log.info("WAL segments formatted: " + ((FileDescriptor)toFormat.get(j)).file().getName() + (i == j ? "" : " - " + FileDescriptor.fileName(i)));
                    j = i + 1;
                    continue;
                }
                catch (IOException e) {
                    throw new StorageException("Failed to format WAL segment: " + segFile.getAbsolutePath(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAutoRollover() {
        if (this.walAutoArchiveAfterInactivity > 0L) {
            assert (this.timeoutRolloverMux != null);
            Object object = this.timeoutRolloverMux;
            synchronized (object) {
                TimeoutRollover timeoutRollover = this.timeoutRollover;
                if (timeoutRollover != null) {
                    timeoutRollover.cancel();
                    this.cctx.time().removeTimeoutObject(timeoutRollover);
                }
            }
        }
    }

    static long minWalArchiveSize(DataStorageConfiguration dsCfg) {
        long max = dsCfg.getMaxWalArchiveSize();
        long min2 = dsCfg.getMinWalArchiveSize();
        double percentage = IgniteSystemProperties.getDouble("IGNITE_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE", -1.0);
        return max == -1L ? max : (min2 != -1L ? min2 : (percentage == -1.0 ? max / 2L : (long)((double)max * percentage)));
    }

    @Override
    public void startAutoReleaseSegments() {
        this.segmentAware.startAutoReleaseSegments();
    }

    private class TimeoutRollover
    implements GridTimeoutObject {
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private final long endTime;
        private boolean cancel;

        private TimeoutRollover(long endTime) {
            if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                FileWriteAheadLogManager.this.log.debug("Schedule WAL rollover check at " + new Time(endTime).toString());
            }
            this.endTime = endTime;
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.id;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            assert (FileWriteAheadLogManager.this.walAutoArchiveAfterInactivity > 0L);
            assert (FileWriteAheadLogManager.this.timeoutRolloverMux != null);
            Object object = FileWriteAheadLogManager.this.timeoutRolloverMux;
            synchronized (object) {
                if (!this.cancel) {
                    if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FileWriteAheadLogManager.this.log.debug("Checking if WAL rollover required (" + new Time(U.currentTimeMillis()).toString() + ")");
                    }
                    FileWriteAheadLogManager.this.checkWalRolloverRequiredDuringInactivityPeriod();
                    FileWriteAheadLogManager.this.scheduleNextInactivityPeriodElapsedCheck();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            assert (FileWriteAheadLogManager.this.walAutoArchiveAfterInactivity > 0L);
            assert (FileWriteAheadLogManager.this.timeoutRolloverMux != null);
            Object object = FileWriteAheadLogManager.this.timeoutRolloverMux;
            synchronized (object) {
                if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FileWriteAheadLogManager.this.log.debug("Auto rollover is canceled");
                }
                this.cancel = true;
            }
        }
    }

    private class FileCleaner
    extends GridWorker {
        public FileCleaner(IgniteLogger log) {
            super(FileWriteAheadLogManager.this.cctx.igniteInstanceName(), "wal-file-cleaner%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName(), log);
            assert (!FileWriteAheadLogManager.this.walArchiveUnlimited());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            Throwable err = null;
            try {
                while (!this.isCancelled()) {
                    FileWriteAheadLogManager.this.segmentAware.awaitExceedMaxArchiveSize(FileWriteAheadLogManager.this.minWalArchiveSize);
                    FileWriteAheadLogManager.this.segmentAware.awaitAvailableTruncateArchive();
                    FileDescriptor[] walArchiveFiles = FileWriteAheadLogManager.this.walArchiveFiles();
                    FileDescriptor high = null;
                    long size = 0L;
                    long totalSize = FileWriteAheadLogManager.totalSize(walArchiveFiles);
                    for (FileDescriptor fileDesc : walArchiveFiles) {
                        if (fileDesc.idx >= FileWriteAheadLogManager.this.lastCheckpointPtr.index() || FileWriteAheadLogManager.this.segmentAware.reserved(fileDesc.idx)) break;
                        high = fileDesc;
                        if (totalSize - (size += fileDesc.file.length()) < FileWriteAheadLogManager.this.minWalArchiveSize) break;
                    }
                    if (high == null) continue;
                    FileWALPointer highPtr = new FileWALPointer(high.idx + 1L, 0, 0);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Starting to clean WAL archive [highIdx=" + highPtr.index() + ", currSize=" + U.humanReadableByteCount(totalSize) + ", maxSize=" + U.humanReadableByteCount(FileWriteAheadLogManager.this.maxWalArchiveSize) + ']');
                    }
                    ((GridCacheDatabaseSharedManager)FileWriteAheadLogManager.this.cctx.database()).onWalTruncated(highPtr);
                    int truncated = FileWriteAheadLogManager.this.truncate(highPtr);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("Finish clean WAL archive [cleanCnt=" + truncated + ", currSize=" + U.humanReadableByteCount(FileWriteAheadLogManager.totalSize(FileWriteAheadLogManager.this.walArchiveFiles())) + ", maxSize=" + U.humanReadableByteCount(FileWriteAheadLogManager.this.maxWalArchiveSize) + ']');
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                Thread.currentThread().interrupt();
                this.isCancelled.set(true);
            }
            catch (Throwable t2) {
                err = t2;
            }
            finally {
                if (err == null && !this.isCancelled()) {
                    err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    FileWriteAheadLogManager.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    FileWriteAheadLogManager.this.failureProcessor.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        private void shutdown() throws IgniteInterruptedCheckedException {
            this.isCancelled.set(true);
            U.join(this.runner());
        }

        public void restart() {
            assert (this.runner() == null) : "FileCleaner is still running [worker=" + this + ']';
            this.isCancelled.set(false);
            new IgniteThread(this).start();
        }
    }

    private static class RecordsIterator
    extends AbstractWalRecordsIterator {
        private static final long serialVersionUID = 0L;
        private final File walArchiveDir;
        private final File walWorkDir;
        @Nullable
        private final FileArchiver archiver;
        private final FileDecompressor decompressor;
        private final DataStorageConfiguration dsCfg;
        @Nullable
        private final FileWALPointer start;
        @Nullable
        private final FileWALPointer end;
        private final SegmentRouter segmentRouter;
        private final SegmentAware segmentAware;

        private RecordsIterator(GridCacheSharedContext<?, ?> cctx, File walArchiveDir, File walWorkDir, @Nullable FileWALPointer start, @Nullable FileWALPointer end, DataStorageConfiguration dsCfg, RecordSerializerFactory serializerFactory, FileIOFactory ioFactory, @Nullable FileArchiver archiver, FileDecompressor decompressor, IgniteLogger log, SegmentAware segmentAware, SegmentRouter segmentRouter, SegmentFileInputFactory segmentFileInputFactory) throws IgniteCheckedException {
            super(log, cctx, serializerFactory, ioFactory, dsCfg.getWalRecordIteratorBufferSize(), segmentFileInputFactory);
            this.walArchiveDir = walArchiveDir;
            this.walWorkDir = walWorkDir;
            this.archiver = archiver;
            this.start = start;
            this.end = end;
            this.dsCfg = dsCfg;
            this.decompressor = decompressor;
            this.segmentRouter = segmentRouter;
            this.segmentAware = segmentAware;
        }

        @Override
        protected ReadFileHandle initReadHandle(AbstractWalRecordsIterator.AbstractFileDescriptor desc, @Nullable FileWALPointer start) throws IgniteCheckedException, FileNotFoundException {
            AbstractWalRecordsIterator.AbstractFileDescriptor currDesc = desc;
            if (!desc.file().exists()) {
                FileDescriptor zipFile = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(desc.idx()) + ".zip"));
                if (!zipFile.file.exists()) {
                    throw new FileNotFoundException("Both compressed and raw segment files are missing in archive [segmentIdx=" + desc.idx() + "]");
                }
                if (this.decompressor != null) {
                    this.decompressor.decompressFile(desc.idx()).get();
                } else {
                    currDesc = zipFile;
                }
            }
            return (ReadFileHandle)super.initReadHandle(currDesc, start);
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            super.onClose();
            this.curRec = null;
            this.closeCurrentWalSegment();
            this.curWalSegmIdx = Integer.MAX_VALUE;
        }

        private void init() throws IgniteCheckedException {
            FileDescriptor[] descs = FileWriteAheadLogManager.loadFileDescriptors(this.walArchiveDir);
            if (this.start != null) {
                if (!F.isEmpty(descs)) {
                    if (descs[0].idx() > this.start.index()) {
                        throw new IgniteCheckedException("WAL history is too short [descs=" + Arrays.asList(descs) + ", start=" + this.start + ']');
                    }
                    for (FileDescriptor desc : descs) {
                        if (desc.idx() != this.start.index()) continue;
                        this.curWalSegmIdx = this.start.index();
                        break;
                    }
                    if (this.curWalSegmIdx == -1L) {
                        long lastArchived = descs[descs.length - 1].idx();
                        if (lastArchived > this.start.index()) {
                            throw new IgniteCheckedException("WAL history is corrupted (segment is missing): " + this.start);
                        }
                        this.curWalSegmIdx = this.start.index();
                    }
                } else {
                    this.curWalSegmIdx = this.start.index();
                }
            } else {
                this.curWalSegmIdx = !F.isEmpty(descs) ? descs[0].idx() : 0L;
            }
            --this.curWalSegmIdx;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized WAL cursor [start=" + this.start + ", end=" + this.end + ", curWalSegmIdx=" + this.curWalSegmIdx + ']');
            }
            this.advance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle advanceSegment(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
            if (curWalSegment != null) {
                curWalSegment.close();
            }
            if (this.end != null && this.curWalSegmIdx + 1L > this.end.index()) {
                return null;
            }
            ++this.curWalSegmIdx;
            if (!this.segmentAware.reserve(this.curWalSegmIdx)) {
                throw new IgniteCheckedException("Segment does not exist: " + this.curWalSegmIdx);
            }
            try {
                ReadFileHandle nextHandle;
                boolean readArchive = this.archiver != null && !this.segmentAware.lock(this.curWalSegmIdx);
                FileDescriptor fd = null;
                try {
                    fd = this.segmentRouter.findSegment(this.curWalSegmIdx);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Reading next file [absIdx=" + this.curWalSegmIdx + ", file=" + fd.file.getAbsolutePath() + ']');
                    }
                    nextHandle = this.initReadHandle(fd, this.start != null && this.curWalSegmIdx == this.start.index() ? this.start : null);
                }
                catch (FileNotFoundException e) {
                    if (readArchive) {
                        throw new IgniteCheckedException("Missing WAL segment in the archive: " + curWalSegment, e);
                    }
                    if (this.curRec == null && curWalSegment == null) {
                        File workDirFile = new File(this.walWorkDir, FileDescriptor.fileName(this.curWalSegmIdx % (long)this.dsCfg.getWalSegments()));
                        File archiveDirFile = new File(this.walArchiveDir, FileDescriptor.fileName(this.curWalSegmIdx));
                        U.warn(this.log, "Next segment file is not found [curWalSegmIdx=" + this.curWalSegmIdx + ", start=" + this.start + ", end=" + this.end + ", filePath=" + (fd == null ? "<empty>" : fd.file.getAbsolutePath()) + ", walWorkDir=" + this.walWorkDir + ", walWorkDirContent=" + RecordsIterator.listFileNames(this.walWorkDir) + ", walArchiveDir=" + this.walArchiveDir + ", walArchiveDirContent=" + RecordsIterator.listFileNames(this.walArchiveDir) + ", workDirFile=" + workDirFile.getName() + ", exists=" + workDirFile.exists() + ", archiveDirFile=" + archiveDirFile.getName() + ", exists=" + archiveDirFile.exists() + "]", e);
                    }
                    nextHandle = null;
                }
                finally {
                    if (this.archiver != null && !readArchive) {
                        this.segmentAware.unlock(this.curWalSegmIdx);
                    }
                }
                this.curRec = null;
                ReadFileHandle readFileHandle = nextHandle;
                return readFileHandle;
            }
            finally {
                this.segmentAware.release(this.curWalSegmIdx);
            }
        }

        private static List<String> listFileNames(File dir) {
            File[] files = dir.listFiles();
            if (files == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(files).map(File::getName).sorted().collect(Collectors.toList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IgniteCheckedException handleRecordException(Exception e, @Nullable FileWALPointer ptr) {
            block13: {
                if (e instanceof IgniteCheckedException && X.hasCause((Throwable)e, IgniteDataIntegrityViolationException.class) && this.end == null) {
                    long nextWalSegmentIdx = this.curWalSegmIdx + 1L;
                    if (this.archiver == null) {
                        if (this.canIgnoreCrcError(nextWalSegmentIdx, nextWalSegmentIdx, e, ptr)) {
                            return null;
                        }
                    } else if (this.segmentAware.reserve(nextWalSegmentIdx)) {
                        try {
                            if (!this.segmentAware.lock(nextWalSegmentIdx)) break block13;
                            try {
                                long workIdx = nextWalSegmentIdx % (long)this.dsCfg.getWalSegments();
                                if (this.canIgnoreCrcError(workIdx, nextWalSegmentIdx, e, ptr)) {
                                    IgniteCheckedException igniteCheckedException = null;
                                    return igniteCheckedException;
                                }
                            }
                            finally {
                                this.segmentAware.unlock(nextWalSegmentIdx);
                            }
                        }
                        finally {
                            this.segmentAware.release(nextWalSegmentIdx);
                        }
                    }
                }
            }
            return super.handleRecordException(e, ptr);
        }

        private boolean canIgnoreCrcError(long workIdx, long walSegmentIdx, Exception e, @Nullable FileWALPointer ptr) {
            FileDescriptor fd = new FileDescriptor(new File(this.walWorkDir, FileDescriptor.fileName(workIdx)), walSegmentIdx);
            try {
                if (!fd.file().exists()) {
                    return true;
                }
                ReadFileHandle nextHandle = this.initReadHandle(fd, ptr);
                if (nextHandle == null) {
                    return true;
                }
            }
            catch (FileNotFoundException | IgniteCheckedException initReadHandleException) {
                e.addSuppressed(initReadHandleException);
            }
            return false;
        }

        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle createReadFileHandle(SegmentIO fileIO, RecordSerializer ser, FileInput in) {
            return new ReadFileHandle(fileIO, ser, in, this.segmentAware);
        }
    }

    public static class ReadFileHandle
    extends AbstractFileHandle
    implements AbstractWalRecordsIterator.AbstractReadFileHandle {
        RecordSerializer ser;
        FileInput in;
        private final SegmentAware segmentAware;

        public ReadFileHandle(SegmentIO fileIO, RecordSerializer ser, FileInput in, SegmentAware aware) {
            super(fileIO);
            this.ser = ser;
            this.in = in;
            this.segmentAware = aware;
        }

        @Override
        public void close() throws IgniteCheckedException {
            try {
                this.fileIO.close();
                this.in.io().close();
            }
            catch (IOException e) {
                throw new IgniteCheckedException(e);
            }
        }

        @Override
        public long idx() {
            return this.getSegmentId();
        }

        @Override
        public FileInput in() {
            return this.in;
        }

        @Override
        public RecordSerializer ser() {
            return this.ser;
        }

        @Override
        public boolean workDir() {
            return this.segmentAware != null && this.segmentAware.lastArchivedAbsoluteIndex() < this.getSegmentId();
        }
    }

    private class FileDecompressor
    extends GridWorker {
        private final Map<Long, GridFutureAdapter<Void>> decompressionFutures;
        private final PriorityBlockingQueue<Long> segmentsQueue;
        private final byte[] arr;

        FileDecompressor(IgniteLogger log) {
            super(FileWriteAheadLogManager.this.cctx.igniteInstanceName(), "wal-file-decompressor%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName(), log, FileWriteAheadLogManager.this.cctx.kernalContext().workersRegistry());
            this.decompressionFutures = new HashMap<Long, GridFutureAdapter<Void>>();
            this.segmentsQueue = new PriorityBlockingQueue();
            this.arr = new byte[0x100000];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void body() {
            Throwable err = null;
            try {
                while (!this.isCancelled()) {
                    IgniteCheckedException ex;
                    long segmentToDecompress;
                    block53: {
                        segmentToDecompress = -1L;
                        this.blockingSectionBegin();
                        try {
                            segmentToDecompress = this.segmentsQueue.take();
                        }
                        finally {
                            this.blockingSectionEnd();
                        }
                        if (this.isCancelled()) {
                            return;
                        }
                        if (segmentToDecompress == -1L) continue;
                        String segmentFileName = FileDescriptor.fileName(segmentToDecompress);
                        File zip = new File(FileWriteAheadLogManager.this.walArchiveDir, segmentFileName + ".zip");
                        File unzipTmp = new File(FileWriteAheadLogManager.this.walArchiveDir, segmentFileName + ".tmp");
                        File unzip = new File(FileWriteAheadLogManager.this.walArchiveDir, segmentFileName);
                        long currSize = 0L;
                        long reservedSize = U.uncompressedSize(zip);
                        FileWriteAheadLogManager.this.segmentAware.addSize(segmentToDecompress, reservedSize);
                        ex = null;
                        try {
                            if (unzip.exists()) {
                                throw new FileAlreadyExistsException(unzip.getAbsolutePath());
                            }
                            try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
                                 FileIO io = FileWriteAheadLogManager.this.ioFactory.create(unzipTmp);){
                                zis.getNextEntry();
                                while (io.writeFully(this.arr, 0, zis.read(this.arr)) > 0) {
                                    this.updateHeartbeat();
                                }
                            }
                            Files.move(unzipTmp.toPath(), unzip.toPath(), new CopyOption[0]);
                            currSize = unzip.length();
                        }
                        catch (IOException e) {
                            FileWriteAheadLogManager.this.deleteArchiveFiles(new File[]{unzipTmp});
                            if (e instanceof FileAlreadyExistsException) {
                                U.error(this.log, "Can't rename temporary unzipped segment: raw segment is already present [tmp=" + unzipTmp + ", raw=" + unzip + "]", e);
                                break block53;
                            }
                            if (!this.isCancelled.get()) {
                                ex = new IgniteCheckedException("Error during WAL segment decompression [segmentIdx=" + segmentToDecompress + "]", e);
                            }
                        }
                        finally {
                            FileWriteAheadLogManager.this.segmentAware.addSize(segmentToDecompress, currSize - reservedSize);
                        }
                    }
                    this.updateHeartbeat();
                    FileDecompressor fileDecompressor = this;
                    synchronized (fileDecompressor) {
                        this.decompressionFutures.remove(segmentToDecompress).onDone(ex);
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (this.isCancelled.get()) return;
                err = e;
                return;
            }
            catch (Throwable t2) {
                err = t2;
                return;
            }
            finally {
                if (err == null && !this.isCancelled.get()) {
                    err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    FileWriteAheadLogManager.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    FileWriteAheadLogManager.this.failureProcessor.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        synchronized IgniteInternalFuture<Void> decompressFile(long idx) {
            if (this.decompressionFutures.containsKey(idx)) {
                return this.decompressionFutures.get(idx);
            }
            File f = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(idx));
            if (f.exists()) {
                return new GridFinishedFuture<Void>();
            }
            this.segmentsQueue.put(idx);
            GridFutureAdapter<Void> res = new GridFutureAdapter<Void>();
            this.decompressionFutures.put(idx, res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            FileDecompressor fileDecompressor = this;
            synchronized (fileDecompressor) {
                U.cancel(this);
                this.segmentsQueue.put(-1L);
            }
            U.join(this.runner(), this.log);
        }

        void restart() {
            assert (this.runner() == null) : "FileDecompressor is still running [worker=" + this + ']';
            this.isCancelled.set(false);
            new IgniteThread(this).start();
        }
    }

    private class FileCompressorWorker
    extends GridWorker {
        private volatile Throwable lastCompressionError;

        FileCompressorWorker(int idx, IgniteLogger log) {
            super(FileWriteAheadLogManager.this.cctx.igniteInstanceName(), "wal-file-compressor-%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName() + "%-" + idx, log);
        }

        void restart() {
            assert (this.runner() == null) : "FileCompressorWorker is still running [worker=" + this + ']';
            this.isCancelled.set(false);
            new IgniteThread(this).start();
        }

        private long tryReserveNextSegmentOrWait() throws IgniteInterruptedCheckedException {
            long segmentToCompress = FileWriteAheadLogManager.this.segmentAware.waitNextSegmentToCompress();
            boolean reserved = FileWriteAheadLogManager.this.reserve(new FileWALPointer(segmentToCompress, 0, 0));
            if (reserved) {
                return segmentToCompress;
            }
            FileWriteAheadLogManager.this.segmentAware.onSegmentCompressed(segmentToCompress);
            return -1L;
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            this.body0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void body0() {
            while (!this.isCancelled()) {
                long segIdx = -1L;
                try {
                    segIdx = this.tryReserveNextSegmentOrWait();
                    if (segIdx == -1L) continue;
                    String segmentFileName = FileDescriptor.fileName(segIdx);
                    File tmpZip = new File(FileWriteAheadLogManager.this.walArchiveDir, segmentFileName + ".zip" + ".tmp");
                    File zip = new File(FileWriteAheadLogManager.this.walArchiveDir, segmentFileName + ".zip");
                    File raw = new File(FileWriteAheadLogManager.this.walArchiveDir, segmentFileName);
                    long currSize = 0L;
                    long reservedSize = raw.length();
                    FileWriteAheadLogManager.this.segmentAware.addSize(segIdx, reservedSize);
                    try {
                        this.deleteObsoleteRawSegments();
                        if (!Files.exists(raw.toPath(), new LinkOption[0])) {
                            throw new IgniteCheckedException("WAL archive segment is missing: " + raw);
                        }
                        this.compressSegmentToFile(segIdx, raw, tmpZip);
                        Files.move(tmpZip.toPath(), zip.toPath(), new CopyOption[0]);
                        try (FileIO f0 = FileWriteAheadLogManager.this.ioFactory.create(zip, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                            f0.force();
                        }
                        currSize = zip.length();
                        FileWriteAheadLogManager.this.segmentSize.put(segIdx, currSize);
                        FileWriteAheadLogManager.this.metrics.onWalSegmentCompressed(currSize);
                        FileWriteAheadLogManager.this.segmentAware.onSegmentCompressed(segIdx);
                        if (!FileWriteAheadLogManager.this.evt.isRecordable(134) || FileWriteAheadLogManager.this.cctx.kernalContext().recoveryMode()) continue;
                        FileWriteAheadLogManager.this.evt.record(new WalSegmentCompactedEvent(FileWriteAheadLogManager.this.cctx.localNode(), segIdx, zip.getAbsoluteFile()));
                    }
                    catch (IOException | IgniteCheckedException e) {
                        FileWriteAheadLogManager.this.deleteArchiveFiles(new File[]{zip, tmpZip});
                        this.lastCompressionError = e;
                        U.error(this.log, "Compression of WAL segment [idx=" + segIdx + "] was skipped due to unexpected error", this.lastCompressionError);
                        FileWriteAheadLogManager.this.segmentAware.onSegmentCompressed(segIdx);
                    }
                    finally {
                        FileWriteAheadLogManager.this.segmentAware.addSize(segIdx, currSize - reservedSize);
                    }
                }
                catch (IgniteInterruptedCheckedException ignore) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (segIdx == -1L) continue;
                    FileWriteAheadLogManager.this.release(new FileWALPointer(segIdx, 0, 0));
                }
            }
        }

        private void compressSegmentToFile(long idx, File raw, File zip) throws IOException, IgniteCheckedException {
            int serializerVer;
            try (FileIO fileIO = FileWriteAheadLogManager.this.ioFactory.create(raw);){
                serializerVer = RecordV1Serializer.readSegmentHeader(new SegmentIO(idx, fileIO), FileWriteAheadLogManager.this.segmentFileInputFactory).getSerializerVersion();
            }
            var7_5 = null;
            try (final ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));){
                zos.setLevel(FileWriteAheadLogManager.this.dsCfg.getWalCompactionLevel());
                zos.putNextEntry(new ZipEntry(idx + ".wal"));
                ByteBuffer buf = ByteBuffer.allocate(29);
                buf.order(ByteOrder.nativeOrder());
                zos.write(FileWriteAheadLogManager.prepareSerializerVersionBuffer(idx, serializerVer, true, buf).array());
                CIX1<WALRecord> appendToZipC = new CIX1<WALRecord>(){

                    @Override
                    public void applyx(WALRecord record) throws IgniteCheckedException {
                        MarshalledRecord marshRec = (MarshalledRecord)record;
                        try {
                            zos.write(marshRec.buffer().array(), 0, marshRec.buffer().remaining());
                        }
                        catch (IOException e) {
                            throw new IgniteCheckedException(e);
                        }
                    }
                };
                try (SingleSegmentLogicalRecordsIterator iter = new SingleSegmentLogicalRecordsIterator(this.log, FileWriteAheadLogManager.this.cctx, FileWriteAheadLogManager.this.ioFactory, 0x100000, idx, FileWriteAheadLogManager.this.walArchiveDir, appendToZipC);){
                    while (iter.hasNextX()) {
                        iter.nextX();
                    }
                }
                RecordSerializer ser = new RecordSerializerFactoryImpl(FileWriteAheadLogManager.this.cctx).createSerializer(serializerVer);
                ByteBuffer heapBuf = this.prepareSwitchSegmentRecordBuffer(idx, ser);
                zos.write(heapBuf.array());
            }
            catch (Throwable throwable) {
                var7_5 = throwable;
                throw throwable;
            }
        }

        private ByteBuffer prepareSwitchSegmentRecordBuffer(long idx, RecordSerializer ser) throws IgniteCheckedException {
            SwitchSegmentRecord switchRecord = new SwitchSegmentRecord();
            int switchRecordSize = ser.size(switchRecord);
            switchRecord.size(switchRecordSize);
            switchRecord.position(new FileWALPointer(idx, 0, switchRecordSize));
            ByteBuffer heapBuf = ByteBuffer.allocate(switchRecordSize);
            ser.writeRecord(switchRecord, heapBuf);
            return heapBuf;
        }

        private void deleteObsoleteRawSegments() {
            FileDescriptor[] descs = FileWriteAheadLogManager.this.walArchiveFiles();
            HashSet<Long> indices = new HashSet<Long>();
            HashSet<Long> duplicateIndices = new HashSet<Long>();
            long lastCpIndex = FileWriteAheadLogManager.this.lastCheckpointPtr.index();
            for (FileDescriptor desc : descs) {
                if (indices.add(desc.idx)) continue;
                duplicateIndices.add(desc.idx);
            }
            ArrayList<Long> deletedRawSegments = null;
            for (FileDescriptor desc : descs) {
                long cleanedUpSize;
                if (desc.isCompressed()) continue;
                if (FileWriteAheadLogManager.this.segmentReservedOrLocked(desc.idx)) break;
                if (desc.idx >= lastCpIndex || !duplicateIndices.contains(desc.idx) || (cleanedUpSize = FileWriteAheadLogManager.this.deleteArchiveFiles(new File[]{desc.file})) <= 0L) continue;
                if (deletedRawSegments == null) {
                    deletedRawSegments = new ArrayList<Long>();
                }
                deletedRawSegments.add(desc.idx);
                FileWriteAheadLogManager.this.segmentAware.addSize(desc.idx, -cleanedUpSize);
            }
            if (this.log.isInfoEnabled() && deletedRawSegments != null) {
                this.log.info("Raw segments removed after compression [deletedSegments=" + deletedRawSegments + ", lastCpIndex=" + lastCpIndex + ']');
            }
        }
    }

    private class FileCompressor
    extends FileCompressorWorker {
        private final List<FileCompressorWorker> workers;

        FileCompressor(IgniteLogger log) {
            super(0, log);
            this.workers = new ArrayList<FileCompressorWorker>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            for (int i = 1; i < this.calculateThreadCount(); ++i) {
                FileCompressorWorker worker = new FileCompressorWorker(i, this.log);
                worker.restart();
                FileCompressor fileCompressor = this;
                synchronized (fileCompressor) {
                    this.workers.add(worker);
                    continue;
                }
            }
        }

        private void initAlreadyCompressedSegments() {
            FileDescriptor[] alreadyCompressed = FileWriteAheadLogManager.scan(FileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_FILE_COMPACTED_FILTER));
            if (alreadyCompressed.length > 0) {
                FileWriteAheadLogManager.this.segmentAware.onSegmentCompressed(alreadyCompressed[alreadyCompressed.length - 1].idx());
            }
            for (FileDescriptor fd : alreadyCompressed) {
                FileWriteAheadLogManager.this.metrics.onWalSegmentCompressed(fd.file().length());
            }
        }

        private int calculateThreadCount() {
            int procNum = Runtime.getRuntime().availableProcessors();
            if (procNum >> 2 >= FileWriteAheadLogManager.this.WAL_COMPRESSOR_WORKER_THREAD_CNT) {
                return FileWriteAheadLogManager.this.WAL_COMPRESSOR_WORKER_THREAD_CNT;
            }
            return procNum >> 2;
        }

        @Override
        public void body() throws InterruptedException, IgniteInterruptedCheckedException {
            this.init();
            ((FileCompressorWorker)this).body0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileCompressor fileCompressor = this;
            synchronized (fileCompressor) {
                for (FileCompressorWorker worker : this.workers) {
                    U.cancel(worker);
                }
                for (FileCompressorWorker worker : this.workers) {
                    U.join(worker);
                }
                this.workers.clear();
                U.cancel(this);
            }
            U.join(this.runner());
        }
    }

    private class FileArchiver
    extends GridWorker {
        private StorageException cleanErr;
        private int formatted;

        private FileArchiver(IgniteLogger log) {
            super(FileWriteAheadLogManager.this.cctx.igniteInstanceName(), "wal-file-archiver%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName(), log, FileWriteAheadLogManager.this.cctx.kernalContext().workersRegistry());
        }

        private void init(SegmentAware segmentAware) throws IgniteCheckedException {
            long lastAbsArchivedIdx;
            IgniteBiTuple<Long, Long> tup = this.scanMinMaxArchiveIndices();
            segmentAware.lastTruncatedArchiveIdx(tup == null ? -1L : tup.get1() - 1L);
            long l = lastAbsArchivedIdx = tup == null ? -1L : tup.get2();
            if (lastAbsArchivedIdx >= 0L) {
                segmentAware.setLastArchivedAbsoluteIndex(lastAbsArchivedIdx);
            }
        }

        private IgniteBiTuple<Long, Long> scanMinMaxArchiveIndices() throws IgniteCheckedException {
            TreeMap<Long, FileDescriptor> archiveIndices = new TreeMap<Long, FileDescriptor>();
            for (File file : FileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
                try {
                    long idx = new FileDescriptor(file).idx();
                    FileDescriptor desc = FileWriteAheadLogManager.this.readFileDescriptor(file, FileWriteAheadLogManager.this.ioFactory);
                    if (desc != null) {
                        if (desc.idx() != idx) continue;
                        archiveIndices.put(idx, desc);
                        continue;
                    }
                    this.log.warning("Skip file, failed read file header " + file);
                }
                catch (IndexOutOfBoundsException | NumberFormatException ignore) {
                    this.log.warning("Skip file " + file);
                }
            }
            if (!archiveIndices.isEmpty()) {
                Long min2 = (Long)archiveIndices.navigableKeySet().first();
                Long max = (Long)archiveIndices.navigableKeySet().last();
                if (max - min2 == (long)(archiveIndices.size() - 1)) {
                    return F.t(min2, max);
                }
                for (Long idx : archiveIndices.descendingKeySet()) {
                    if (archiveIndices.containsKey(idx - 1L)) continue;
                    return F.t(idx, max);
                }
                throw new IllegalStateException("Should never happen if archiveIndices TreeMap is valid.");
            }
            TreeMap<Long, FileDescriptor> workIndices = new TreeMap<Long, FileDescriptor>();
            for (File file : FileWriteAheadLogManager.this.walWorkDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
                FileDescriptor desc = FileWriteAheadLogManager.this.readFileDescriptor(file, FileWriteAheadLogManager.this.ioFactory);
                if (desc == null) continue;
                workIndices.put(desc.idx(), desc);
            }
            if (!workIndices.isEmpty()) {
                FileDescriptor first = (FileDescriptor)workIndices.firstEntry().getValue();
                FileDescriptor last = (FileDescriptor)workIndices.lastEntry().getValue();
                if (first.idx() != last.idx()) {
                    this.archiveSegment(first.idx());
                    return F.t(first.idx(), first.idx());
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                this.isCancelled.set(true);
                this.notifyAll();
            }
            U.join(this.runner());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() {
            this.blockingSectionBegin();
            try {
                this.allocateRemainingFiles();
            }
            catch (StorageException e) {
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    this.cleanErr = e;
                    FileWriteAheadLogManager.this.segmentAware.forceInterrupt();
                    this.notifyAll();
                }
                FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                return;
            }
            finally {
                this.blockingSectionEnd();
            }
            Throwable err = null;
            try {
                this.blockingSectionBegin();
                try {
                    FileWriteAheadLogManager.this.segmentAware.awaitSegment(0L);
                }
                finally {
                    this.blockingSectionEnd();
                }
                while (!Thread.currentThread().isInterrupted() && !this.isCancelled()) {
                    SegmentArchiveResult res;
                    long toArchive;
                    this.blockingSectionBegin();
                    try {
                        toArchive = FileWriteAheadLogManager.this.segmentAware.waitNextSegmentForArchivation();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    if (this.isCancelled()) {
                        break;
                    }
                    this.blockingSectionBegin();
                    try {
                        res = this.archiveSegment(toArchive);
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    this.blockingSectionBegin();
                    try {
                        FileWriteAheadLogManager.this.segmentAware.markAsMovedToArchive(toArchive);
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    if (FileWriteAheadLogManager.this.evt.isRecordable(128) && !FileWriteAheadLogManager.this.cctx.kernalContext().recoveryMode()) {
                        FileWriteAheadLogManager.this.evt.record(new WalSegmentArchivedEvent(FileWriteAheadLogManager.this.cctx.discovery().localNode(), res.getAbsIdx(), res.getDstArchiveFile()));
                    }
                    this.onIdle();
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                Thread.currentThread().interrupt();
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    this.isCancelled.set(true);
                }
            }
            catch (Throwable t2) {
                err = t2;
            }
            finally {
                if (err == null && !this.isCancelled()) {
                    err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    FileWriteAheadLogManager.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    FileWriteAheadLogManager.this.failureProcessor.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long nextAbsoluteSegmentIndex() throws StorageException, IgniteInterruptedCheckedException {
            if (this.cleanErr != null) {
                throw this.cleanErr;
            }
            try {
                long nextIdx;
                boolean interrupted = false;
                while (true) {
                    try {
                        nextIdx = FileWriteAheadLogManager.this.segmentAware.nextAbsoluteSegmentIndex();
                    }
                    catch (IgniteInterruptedCheckedException e) {
                        if (this.isCancelled.get()) {
                            throw e;
                        }
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    while (nextIdx % (long)FileWriteAheadLogManager.this.dsCfg.getWalSegments() > (long)this.formatted && this.cleanErr == null) {
                        this.wait();
                    }
                }
                if (this.cleanErr != null) {
                    throw this.cleanErr;
                }
                return nextIdx;
            }
            catch (IgniteInterruptedCheckedException e) {
                if (this.cleanErr != null) {
                    throw this.cleanErr;
                }
                throw e;
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedCheckedException(e);
            }
        }

        public SegmentArchiveResult archiveSegment(long absIdx) throws StorageException {
            long segIdx = absIdx % (long)FileWriteAheadLogManager.this.dsCfg.getWalSegments();
            File origFile = new File(FileWriteAheadLogManager.this.walWorkDir, FileDescriptor.fileName(segIdx));
            String name = FileDescriptor.fileName(absIdx);
            File dstTmpFile = new File(FileWriteAheadLogManager.this.walArchiveDir, name + ".tmp");
            File dstFile = new File(FileWriteAheadLogManager.this.walArchiveDir, name);
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting to copy WAL segment [absIdx=" + absIdx + ", segIdx=" + segIdx + ", origFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstFile.getAbsolutePath() + ']');
            }
            assert (FileWriteAheadLogManager.this.switchSegmentRecordOffset != null);
            long offs = FileWriteAheadLogManager.this.switchSegmentRecordOffset.getAndSet((int)segIdx, 0L);
            long origLen = origFile.length();
            long currSize = 0L;
            long reservedSize = offs > 0L && offs < origLen ? offs : origLen;
            FileWriteAheadLogManager.this.segmentAware.addSize(absIdx, reservedSize);
            try {
                if (offs > 0L && offs < origLen) {
                    GridFileUtils.copy(origFile, dstTmpFile, offs);
                } else {
                    Files.copy(origFile.toPath(), dstTmpFile.toPath(), new CopyOption[0]);
                }
                Files.move(dstTmpFile.toPath(), dstFile.toPath(), new CopyOption[0]);
                if (FileWriteAheadLogManager.this.mode != WALMode.NONE) {
                    try (FileIO f0 = FileWriteAheadLogManager.this.ioFactory.create(dstFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                        f0.force();
                    }
                }
                currSize = dstFile.length();
                FileWriteAheadLogManager.this.segmentSize.put(absIdx, currSize);
            }
            catch (IOException e) {
                FileWriteAheadLogManager.this.deleteArchiveFiles(new File[]{dstFile, dstTmpFile});
                throw new StorageException("Failed to archive WAL segment [srcFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstTmpFile.getAbsolutePath() + ']', e);
            }
            finally {
                FileWriteAheadLogManager.this.segmentAware.addSize(absIdx, currSize - reservedSize);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Copied file [src=" + origFile.getAbsolutePath() + ", dst=" + dstFile.getAbsolutePath() + ']');
            }
            return new SegmentArchiveResult(absIdx, origFile, dstFile);
        }

        private boolean checkStop() {
            return this.isCancelled();
        }

        private void allocateRemainingFiles() throws StorageException {
            FileWriteAheadLogManager.this.checkFiles(1, true, integer -> !this.checkStop(), idx -> {
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    this.formatted = idx;
                    this.notifyAll();
                }
            });
        }

        public void restart() {
            assert (this.runner() == null) : "FileArchiver is still running [worker=" + this + ']';
            this.isCancelled.set(false);
            new IgniteThread(FileWriteAheadLogManager.this.archiver).start();
        }
    }
}

