/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public class MarkerPageIO
extends PageIO {
    private static final int MARKER_TYPE_OFF = 40;
    private static final int WAL_RECORD_SERIALIZER_VERSION_OFF = 44;
    public static final int WAL_RECORDS_CNT_OFF = 48;
    public static final int MARKER_TYPE_TERMINATION = 1;
    public static final IOVersions<MarkerPageIO> VERSIONS = new IOVersions((PageIO[])new MarkerPageIO[]{new MarkerPageIO(1)});

    public MarkerPageIO(int ver) {
        super(33, ver);
    }

    protected MarkerPageIO(int type, int ver) {
        super(type, ver);
    }

    public int markerType(long pageAddr) {
        return PageUtils.getInt(pageAddr, 40);
    }

    public int markerType(ByteBuffer buf) {
        return buf.getInt(40);
    }

    public void setMarkerType(long pageAddr, int markerType) {
        this.assertPageType(pageAddr);
        PageUtils.putInt(pageAddr, 40, markerType);
    }

    public int walRecordSerializerVersion(long pageAddr) {
        return PageUtils.getInt(pageAddr, 44);
    }

    public int walRecordSerializerVersion(ByteBuffer buf) {
        return buf.getInt(44);
    }

    public void setWalRecordSerializerVersion(long pageAddr, int v) {
        this.assertPageType(pageAddr);
        PageUtils.putInt(pageAddr, 44, v);
    }

    public int walRecordsCnt(long pageAddr) {
        return PageUtils.getInt(pageAddr, 48);
    }

    public int walRecordsCnt(ByteBuffer buf) {
        return buf.getInt(48);
    }

    public void setWalRecordsCnt(long pageAddr, int v) {
        this.assertPageType(pageAddr);
        PageUtils.putInt(pageAddr, 48, v);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("MarkerPage [markerType=" + this.markerType(addr) + ", walRecordSerializerVersion=" + this.walRecordSerializerVersion(addr) + "]");
    }
}

