/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.Factory;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.encryption.ReencryptStateUtils;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdAllocator;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageSupport;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.RollbackRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateIndexDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecordV4;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionDestroyRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMvccEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManagerImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteHistoricalIterator;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteHistoricalIteratorException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedPartitionMetaPageException;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStructure;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorage;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorageImpl;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.freelist.AbstractFreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.CacheFreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.SimpleDataRow;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.partstorage.PartitionMetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.partstorage.PartitionMetaStorageImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIOV2;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionCountersIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOGG;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV3;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseListImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.PendingEntriesTree;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateResult;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccLinkAwareSearchRow;
import org.apache.ignite.internal.processors.cache.tree.updatelog.PartitionLogTree;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLog;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.IgniteClosure2X;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class GridCacheOffheapManager
extends IgniteCacheOffheapManagerImpl
implements CheckpointListener {
    public static final int DFLT_WAL_MARGIN_FOR_ATOMIC_CACHE_HISTORICAL_REBALANCE = 5;
    @SystemProperty(value="The WAL iterator margin that is used to prevent partitions divergence on the historical rebalance of atomic caches", type=Long.class, defaults="5")
    public static final String WAL_MARGIN_FOR_ATOMIC_CACHE_HISTORICAL_REBALANCE = "WAL_MARGIN_FOR_ATOMIC_CACHE_HISTORICAL_REBALANCE";
    private final long walAtomicCacheMargin = IgniteSystemProperties.getLong("WAL_MARGIN_FOR_ATOMIC_CACHE_HISTORICAL_REBALANCE", 5L);
    private final DynamicCacheDescriptor cacheDescriptor;
    private IndexStorage indexStorage;
    private ReuseListImpl reuseList;
    private AtomicLong pageListCacheLimit;
    private volatile boolean partitionStatesRestored;
    private DataStorageMetricsImpl persStoreMetrics;

    public GridCacheOffheapManager(DynamicCacheDescriptor descriptor) {
        this.cacheDescriptor = descriptor;
    }

    protected void initPendingTree(GridCacheContext cctx) throws IgniteCheckedException {
    }

    @Override
    protected void initDataStructures() throws IgniteCheckedException {
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        Metas metas = this.getOrAllocateCacheMetas();
        String reuseListName = this.grp.cacheOrGroupName() + "##ReuseList";
        String indexStorageTreeName = this.grp.cacheOrGroupName() + "##IndexStorageTree";
        RootPage reuseListRoot = metas.reuseListRoot;
        GridCacheDatabaseSharedManager databaseSharedManager = (GridCacheDatabaseSharedManager)this.ctx.database();
        this.pageListCacheLimit = databaseSharedManager.pageListCacheLimitHolder(this.grp.dataRegion());
        this.reuseList = new ReuseListImpl(this.grp.groupId(), reuseListName, this.grp.dataRegion().pageMemory(), this.ctx.wal(), reuseListRoot.pageId().pageId(), reuseListRoot.isAllocated(), this.ctx.diagnostic().pageLockTracker(), this.ctx.kernalContext(), this.pageListCacheLimit, 2);
        RootPage metastoreRoot = metas.treeRoot;
        this.indexStorage = new IndexStorageImpl(indexStorageTreeName, this.grp.dataRegion().pageMemory(), this.ctx.wal(), this.globalRemoveId(), this.grp.groupId(), this.grp.sharedGroup(), 65535, 2, this.reuseList, metastoreRoot.pageId().pageId(), metastoreRoot.isAllocated(), this.ctx.kernalContext().failure(), this.ctx.diagnostic().pageLockTracker());
        this.persStoreMetrics = databaseSharedManager.persistentStoreMetricsImpl();
        databaseSharedManager.addCheckpointListener(this, this.grp.dataRegion());
    }

    public IndexStorage getIndexStorage() {
        return this.indexStorage;
    }

    @Override
    protected IgniteCacheOffheapManager.CacheDataStore createCacheDataStore0(int p) throws IgniteCheckedException {
        if (this.ctx.database() instanceof GridCacheDatabaseSharedManager) {
            ((GridCacheDatabaseSharedManager)this.ctx.database()).cancelOrWaitPartitionDestroy(this.grp.groupId(), p);
        }
        boolean exists = this.ctx.pageStore() != null && this.ctx.pageStore().exists(this.grp.groupId(), p);
        return this.createGridCacheDataStore(this.grp, p, exists, this.log);
    }

    @Override
    public void onCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
    }

    @Override
    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        assert (this.grp.dataRegion().pageMemory() instanceof PageMemoryEx);
        this.syncMetadata(ctx);
    }

    @Override
    public void beforeCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        assert (F.size(this.cacheDataStores().iterator(), IgniteCacheOffheapManager.CacheDataStore::destroyed) == 0);
        this.syncMetadata(ctx, ctx.executor(), false);
    }

    private void syncMetadata(CheckpointListener.Context ctx) throws IgniteCheckedException {
        boolean needSnapshot;
        Executor execSvc = ctx.executor();
        boolean bl = needSnapshot = ctx.nextSnapshot() && ctx.needToSnapshot(this.grp.cacheOrGroupName());
        if (needSnapshot) {
            if (execSvc == null) {
                this.addPartitions(ctx);
            } else {
                execSvc.execute(() -> {
                    try {
                        this.addPartitions(ctx);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                });
            }
        }
        this.syncMetadata(ctx, ctx.executor(), needSnapshot);
    }

    public void syncMetadata(CheckpointListener.Context ctx, Executor execSvc, boolean needSnapshot) throws IgniteCheckedException {
        if (execSvc == null) {
            this.reuseList.saveMetadata(this.grp.statisticsHolderData());
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                this.saveStoreMetadata(store, ctx, false, needSnapshot);
            }
        } else {
            execSvc.execute(() -> {
                try {
                    this.reuseList.saveMetadata(this.grp.statisticsHolderData());
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                execSvc.execute(() -> {
                    try {
                        this.saveStoreMetadata(store, ctx, false, needSnapshot);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                });
            }
        }
        if (this.grp.config().isEncryptionEnabled()) {
            this.saveIndexReencryptionStatus(this.grp.groupId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveStoreMetadata(IgniteCacheOffheapManager.CacheDataStore store, CheckpointListener.Context ctx, boolean beforeDestroy, boolean needSnapshot) throws IgniteCheckedException {
        RowStore rowStore0 = store.rowStore();
        boolean staticallyConfigured = this.cacheDescriptor.staticallyConfigured();
        if (rowStore0 != null && (staticallyConfigured || this.partitionStatesRestored || this.grp.isLocal())) {
            ((PagesList)((Object)rowStore0.freeList())).saveMetadata(this.grp.statisticsHolderData());
            long updCntr = store.updateCounter();
            long size = store.fullSize();
            long rmvId = this.globalRemoveId().get();
            PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
            IgniteWriteAheadLogManager wal = this.ctx.wal();
            GridEncryptionManager encMgr = this.ctx.kernalContext().encryption();
            if (size > 0L || updCntr > 0L || !store.partUpdateCounter().sequential() || this.grp.config().isEncryptionEnabled() && encMgr.getEncryptionState(this.grp.groupId(), store.partId()) > 0L) {
                GridDhtPartitionState state = null;
                GridDhtLocalPartition part = null;
                if (!this.grp.isLocal()) {
                    if (beforeDestroy) {
                        state = GridDhtPartitionState.EVICTED;
                    } else {
                        part = this.getPartition(store);
                        if (part != null && part.state() != GridDhtPartitionState.EVICTED) {
                            GridDhtPartitionState gridDhtPartitionState = state = part.state() == GridDhtPartitionState.LOST ? GridDhtPartitionState.OWNING : part.state();
                        }
                    }
                    if (state == null) {
                        return;
                    }
                }
                assert (state != null || this.grp.isLocal()) : "Partition state is undefined [grp=" + this.grp.cacheOrGroupName() + ", part=" + part + "]";
                int grpId = this.grp.groupId();
                long partMetaId = pageMem.partitionMetaPageId(grpId, store.partId());
                long partMetaPage = pageMem.acquirePage(grpId, partMetaId);
                try {
                    long partMetaPageAddr = pageMem.writeLock(grpId, partMetaId, partMetaPage);
                    if (partMetaPageAddr == 0L) {
                        U.warn(this.log, "Failed to acquire write lock for meta page [metaPage=" + partMetaPage + ", beforeDestroy=" + beforeDestroy + ", size=" + size + ", updCntr=" + updCntr + ", state=" + (Object)((Object)state) + ']');
                        return;
                    }
                    boolean changed = false;
                    try {
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(partMetaPageAddr);
                        changed |= io.setPartitionState(partMetaPageAddr, state != null ? (byte)state.ordinal() : (byte)-1);
                        changed |= io.setUpdateCounter(partMetaPageAddr, updCntr);
                        changed |= io.setGlobalRemoveId(partMetaPageAddr, rmvId);
                        changed |= io.setSize(partMetaPageAddr, size);
                        changed |= io.setTombstonesCount(partMetaPageAddr, store.tombstonesCount());
                        changed |= this.savePartitionUpdateCounterGaps(store, io, partMetaPageAddr);
                        changed |= this.saveCacheSizes(store, io, partMetaPageAddr);
                        changed |= this.saveEncryptionState(store, encMgr, io, partMetaPageAddr);
                        if (needSnapshot) {
                            changed |= this.savePagesCount(ctx, part, store, io, partMetaPageAddr);
                        }
                        if (!changed || !PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, partMetaId, partMetaPage, wal, null)) return;
                        wal.log(new MetaPageUpdatePartitionDataRecordV4(grpId, partMetaId, updCntr, rmvId, (int)size, io.getCacheSizesPageId(partMetaPageAddr), io.getPartitionState(partMetaPageAddr), io.getCandidatePageCount(partMetaPageAddr), io.getGapsLink(partMetaPageAddr), io.getEncryptedPageIndex(partMetaPageAddr), io.getEncryptedPageCount(partMetaPageAddr), io.getTombstonesCount(partMetaPageAddr)));
                        return;
                    }
                    finally {
                        pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, changed);
                    }
                }
                finally {
                    pageMem.releasePage(grpId, partMetaId, partMetaPage);
                }
            } else {
                if (!needSnapshot) return;
                this.tryAddEmptyPartitionToSnapshot(store, ctx);
            }
            return;
        } else {
            if (!needSnapshot) return;
            this.tryAddEmptyPartitionToSnapshot(store, ctx);
        }
    }

    private boolean savePartitionUpdateCounterGaps(IgniteCacheOffheapManager.CacheDataStore store, PagePartitionMetaIO io, long partMetaPageAddr) throws IgniteCheckedException {
        PartitionMetaStorage<SimpleDataRow> partStore = store.partStorage();
        byte[] updCntrsBytes = store.partUpdateCounter().getBytes();
        long gapsLink = io.getGapsLink(partMetaPageAddr);
        boolean changed = false;
        if (updCntrsBytes == null && gapsLink != 0L) {
            partStore.removeDataRowByLink(gapsLink, this.grp.statisticsHolderData());
            io.setGapsLink(partMetaPageAddr, 0L);
            changed = true;
        } else if (updCntrsBytes != null && gapsLink == 0L) {
            SimpleDataRow row = new SimpleDataRow(store.partId(), updCntrsBytes);
            partStore.insertDataRow(row, this.grp.statisticsHolderData());
            io.setGapsLink(partMetaPageAddr, row.link());
            changed = true;
        } else if (updCntrsBytes != null && gapsLink != 0L) {
            byte[] prev = partStore.readRow(gapsLink);
            assert (prev != null) : "Read null gaps using link=" + gapsLink;
            if (!Arrays.equals(prev, updCntrsBytes)) {
                partStore.removeDataRowByLink(gapsLink, this.grp.statisticsHolderData());
                SimpleDataRow row = new SimpleDataRow(store.partId(), updCntrsBytes);
                partStore.insertDataRow(row, this.grp.statisticsHolderData());
                io.setGapsLink(partMetaPageAddr, row.link());
                changed = true;
            }
        }
        if (changed) {
            partStore.saveMetadata(this.grp.statisticsHolderData());
            io.setPartitionMetaStoreReuseListRoot(partMetaPageAddr, partStore.metaPageId());
        }
        return changed;
    }

    private boolean saveCacheSizes(IgniteCacheOffheapManager.CacheDataStore store, PagePartitionMetaIO io, long partMetaPageAddr) throws IgniteCheckedException {
        if (this.grp.sharedGroup()) {
            PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
            long oldCacheSizesPageId = io.getCacheSizesPageId(partMetaPageAddr);
            Map<Integer, Long> newSizes = store.cacheSizes();
            Map<Integer, Long> prevSizes = GridCacheOffheapManager.readSharedGroupCacheSizes(pageMem, this.grp.groupId(), oldCacheSizesPageId);
            if (prevSizes == null || !prevSizes.equals(newSizes)) {
                long cacheSizesPageId = GridCacheOffheapManager.writeSharedGroupCacheSizes(pageMem, this.grp.groupId(), oldCacheSizesPageId, store.partId(), newSizes);
                if (oldCacheSizesPageId == 0L && cacheSizesPageId != 0L) {
                    io.setCacheSizesPageId(partMetaPageAddr, cacheSizesPageId);
                    return true;
                }
            }
        } else {
            io.setCacheSizesPageId(partMetaPageAddr, 0L);
        }
        return false;
    }

    private boolean saveEncryptionState(IgniteCacheOffheapManager.CacheDataStore store, GridEncryptionManager encMgr, PagePartitionMetaIO io, long partMetaPageAddr) {
        long reencryptState;
        if (this.grp.config().isEncryptionEnabled() && (reencryptState = encMgr.getEncryptionState(this.grp.groupId(), store.partId())) != 0L) {
            int encryptCnt;
            int encryptIdx = ReencryptStateUtils.pageIndex(reencryptState);
            if (encryptIdx == (encryptCnt = ReencryptStateUtils.pageCount(reencryptState))) {
                encMgr.setEncryptionState(this.grp, store.partId(), 0, 0);
                encryptCnt = 0;
                encryptIdx = 0;
            }
            boolean changed = false;
            changed |= io.setEncryptedPageIndex(partMetaPageAddr, encryptIdx);
            return changed |= io.setEncryptedPageCount(partMetaPageAddr, encryptCnt);
        }
        return false;
    }

    private boolean savePagesCount(CheckpointListener.Context ctx, GridDhtLocalPartition part, IgniteCacheOffheapManager.CacheDataStore store, PagePartitionMetaIO io, long partMetaPageAddr) throws IgniteCheckedException {
        int grpId = this.grp.groupId();
        int pageCnt = this.ctx.pageStore().pages(grpId, store.partId());
        io.setCandidatePageCount(partMetaPageAddr, io.getSize(partMetaPageAddr) == 0L ? 0 : pageCnt);
        if (part.state() == GridDhtPartitionState.OWNING) {
            assert (part != null);
            if (!GridCacheOffheapManager.addPartition(part, ctx.partitionStatMap(), partMetaPageAddr, io, grpId, store.partId(), this.ctx.pageStore().pages(this.grp.groupId(), store.partId()), store.fullSize())) {
                U.warn(this.log, "Partition was concurrently evicted grpId=" + grpId + ", partitionId=" + part.id());
            }
        } else if ((part.state() == GridDhtPartitionState.MOVING || part.state() == GridDhtPartitionState.RENTING) && ctx.partitionStatMap().forceSkipIndexPartition(grpId) && this.log.isInfoEnabled()) {
            this.log.info("Will not include SQL indexes to snapshot because there is a partition not in " + (Object)((Object)GridDhtPartitionState.OWNING) + " state [grp=" + this.grp.cacheOrGroupName() + ", partId=" + store.partId() + ", state=" + (Object)((Object)part.state()) + ']');
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long restoreStateOfPartition(int p, @Nullable Integer recoveryState) throws IgniteCheckedException {
        if (this.grp.isLocal() || !this.grp.affinityNode() || !this.grp.dataRegion().config().isPersistenceEnabled() || this.partitionStatesRestored) {
            return 0L;
        }
        PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        long startTime = U.currentTimeMillis();
        long res = 0L;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started restoring partition state [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ']');
        }
        if (this.ctx.pageStore().exists(this.grp.groupId(), p)) {
            this.ctx.pageStore().ensure(this.grp.groupId(), p);
            if (this.ctx.pageStore().pages(this.grp.groupId(), p) <= 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipping partition on recovery (pages less than or equals 1) [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ']');
                }
                return 0L;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creating partition on recovery (exists in page store) [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ']');
            }
            GridDhtLocalPartition part = this.grp.topology().forceCreatePartition(p);
            part.dataStore().init();
            this.ctx.database().checkpointReadLock();
            try {
                long partMetaId = pageMem.partitionMetaPageId(this.grp.groupId(), p);
                long partMetaPage = pageMem.acquirePage(this.grp.groupId(), partMetaId);
                try {
                    long pageAddr = pageMem.writeLock(this.grp.groupId(), partMetaId, partMetaPage);
                    boolean changed = false;
                    try {
                        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
                        if (recoveryState != null) {
                            changed = io.setPartitionState(pageAddr, (byte)recoveryState.intValue());
                            this.updateState(part, recoveryState);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Restored partition state (from WAL) [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ", state=" + (Object)((Object)part.state()) + ", updCntr=" + part.initialUpdateCounter() + ", size=" + part.fullSize() + ']');
                            }
                        } else {
                            byte stateId = io.getPartitionState(pageAddr);
                            this.updateState(part, stateId);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Restored partition state (from page memory) [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ", state=" + (Object)((Object)part.state()) + ", updCntr=" + part.initialUpdateCounter() + ", stateId=" + stateId + ", size=" + part.fullSize() + ']');
                            }
                        }
                    }
                    finally {
                        pageMem.writeUnlock(this.grp.groupId(), partMetaId, partMetaPage, null, changed);
                    }
                }
                finally {
                    pageMem.releasePage(this.grp.groupId(), partMetaId, partMetaPage);
                }
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
            res = U.currentTimeMillis() - startTime;
        } else if (recoveryState != null) {
            GridDhtLocalPartition part = this.grp.topology().forceCreatePartition(p);
            this.updateState(part, recoveryState);
            res = U.currentTimeMillis() - startTime;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Restored partition state (from WAL) [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ", state=" + (Object)((Object)part.state()) + ", updCntr=" + part.initialUpdateCounter() + ", size=" + part.fullSize() + ']');
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Skipping partition on recovery (no page store OR wal state) [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ']');
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished restoring partition state [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ", time=" + U.humanReadableDuration(U.currentTimeMillis() - startTime) + ']');
        }
        return res;
    }

    @Override
    public void restorePartitionStates(Map<GroupPartitionId, Integer> partRecoveryStates) throws IgniteCheckedException {
        if (this.grp.isLocal() || !this.grp.affinityNode() || !this.grp.dataRegion().config().isPersistenceEnabled() || this.partitionStatesRestored) {
            return;
        }
        for (int p = 0; p < this.grp.affinity().partitions(); ++p) {
            this.restoreStateOfPartition(p, partRecoveryStates.get(new GroupPartitionId(this.grp.groupId(), p)));
        }
        this.confirmPartitionStatesRestored();
    }

    @Override
    public void confirmPartitionStatesRestored() {
        this.partitionStatesRestored = true;
    }

    private void updateState(GridDhtLocalPartition part, int stateId) {
        if (stateId != -1) {
            GridDhtPartitionState state = GridDhtPartitionState.fromOrdinal(stateId);
            assert (state != null);
            part.restoreState(state == GridDhtPartitionState.EVICTED ? GridDhtPartitionState.RENTING : state);
        }
    }

    private void tryAddEmptyPartitionToSnapshot(IgniteCacheOffheapManager.CacheDataStore store, CheckpointListener.Context ctx) {
        GridDhtLocalPartition locPart = this.getPartition(store);
        if (locPart != null && locPart.state() == GridDhtPartitionState.OWNING) {
            ctx.partitionStatMap().put(new GroupPartitionId(this.grp.groupId(), store.partId()), new PagesAllocationRange(0, 0));
        }
    }

    private GridDhtLocalPartition getPartition(IgniteCacheOffheapManager.CacheDataStore store) {
        return this.grp.topology().localPartition(store.partId(), AffinityTopologyVersion.NONE, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Long> readSharedGroupCacheSizes(PageSupport pageMem, int grpId, long cntrsPageId) throws IgniteCheckedException {
        if (cntrsPageId == 0L) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Long> cacheSizes = new HashMap<Integer, Long>();
        long nextId = cntrsPageId;
        while (true) {
            long curId = nextId;
            long curPage = pageMem.acquirePage(grpId, curId);
            try {
                long curAddr = pageMem.readLock(grpId, curId, curPage);
                assert (curAddr != 0L);
                try {
                    PagePartitionCountersIO cntrsIO = (PagePartitionCountersIO)PageIO.getPageIO(curAddr);
                    if (!cntrsIO.readCacheSizes(curAddr, cacheSizes)) {
                        nextId = cntrsIO.getNextCountersPageId(curAddr);
                        assert (nextId != 0L);
                        continue;
                    }
                }
                finally {
                    pageMem.readUnlock(grpId, curId, curPage);
                    continue;
                }
            }
            finally {
                pageMem.releasePage(grpId, curId, curPage);
                continue;
            }
            break;
        }
        return cacheSizes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeSharedGroupCacheSizes(PageMemory pageMem, int grpId, long cntrsPageId, int partId, Map<Integer, Long> sizes) throws IgniteCheckedException {
        boolean init;
        byte[] data = PagePartitionCountersIO.VERSIONS.latest().serializeCacheSizes(sizes);
        int items = data.length / 12;
        boolean bl = init = cntrsPageId == 0L;
        if (init && !sizes.isEmpty()) {
            cntrsPageId = pageMem.allocatePage(grpId, partId, (byte)4);
        }
        long nextId = cntrsPageId;
        int written = 0;
        PageMetrics metrics = pageMem.metrics().cacheGrpPageMetrics(grpId);
        while (written != items) {
            long curId = nextId;
            long curPage = pageMem.acquirePage(grpId, curId);
            try {
                long curAddr = pageMem.writeLock(grpId, curId, curPage);
                assert (curAddr != 0L);
                try {
                    PagePartitionCountersIO partCntrIo;
                    if (init) {
                        partCntrIo = PagePartitionCountersIO.VERSIONS.latest();
                        partCntrIo.initNewPage(curAddr, curId, pageMem.realPageSize(grpId), metrics);
                    } else {
                        partCntrIo = (PagePartitionCountersIO)PageIO.getPageIO(curAddr);
                    }
                    written += partCntrIo.writeCacheSizes(pageMem.realPageSize(grpId), curAddr, data, written);
                    nextId = partCntrIo.getNextCountersPageId(curAddr);
                    if (written == items || !(init = nextId == 0L)) continue;
                    nextId = pageMem.allocatePage(grpId, partId, (byte)4);
                    partCntrIo.setNextCountersPageId(curAddr, nextId);
                }
                finally {
                    pageMem.writeUnlock(grpId, curId, curPage, Boolean.TRUE, true);
                }
            }
            finally {
                pageMem.releasePage(grpId, curId, curPage);
            }
        }
        return cntrsPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPartitions(CheckpointListener.Context ctx) throws IgniteCheckedException {
        int grpId = this.grp.groupId();
        PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        long metaPageId = PageIdUtils.pageId(65535, (byte)2, 0);
        long metaPage = pageMem.acquirePage(grpId, metaPageId);
        try {
            long metaPageAddr = pageMem.writeLock(grpId, metaPageId, metaPage);
            if (metaPageAddr == 0L) {
                U.warn(this.log, "Failed to acquire write lock for index meta page [grpId=" + grpId + ", metaPageId=" + metaPageId + ']');
                return;
            }
            boolean changed = false;
            try {
                PageMetaIO metaIo = (PageMetaIO)PageMetaIO.getPageIO(metaPageAddr);
                int pageCnt = this.ctx.pageStore().pages(grpId, 65535);
                changed = metaIo.setCandidatePageCount(metaPageAddr, pageCnt);
                GridCacheOffheapManager.addPartition(null, ctx.partitionStatMap(), metaPageAddr, metaIo, grpId, 65535, pageCnt, -1L);
            }
            finally {
                pageMem.writeUnlock(grpId, metaPageId, metaPage, null, changed);
            }
        }
        finally {
            pageMem.releasePage(grpId, metaPageId, metaPage);
        }
    }

    private static boolean addPartition(GridDhtLocalPartition part, PartitionAllocationMap map, long metaPageAddr, PageMetaIO io, int grpId, int partId, int currAllocatedPageCnt, long partSize) {
        if (part != null) {
            boolean reserved = part.reserve();
            if (!reserved) {
                return false;
            }
        } else assert (partId == 65535) : partId;
        assert (PageIO.getPageId(metaPageAddr) != 0L);
        int lastAllocatedPageCnt = io.getLastAllocatedPageCount(metaPageAddr);
        int curPageCnt = partSize == 0L ? 0 : currAllocatedPageCnt;
        map.put(new GroupPartitionId(grpId, partId), new PagesAllocationRange(lastAllocatedPageCnt, curPageCnt));
        return true;
    }

    @Override
    public void destroyCacheDataStore(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        this.ctx.database().checkpointReadLock();
        try {
            super.destroyCacheDataStore(store);
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    @Override
    protected void destroyCacheDataStore0(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        assert (this.ctx.database() instanceof GridCacheDatabaseSharedManager) : "Destroying cache data store when persistence is not enabled: " + this.ctx.database();
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        int partId = store.partId();
        this.saveStoreMetadata(store, null, true, false);
        store.markDestroyed();
        ((GridCacheDatabaseSharedManager)this.ctx.database()).schedulePartitionDestroy(this.grp.groupId(), partId);
    }

    public void destroyPartitionStore(int partId) throws IgniteCheckedException {
        PageMemoryEx pageMemory = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        if (this.grp.config().isEncryptionEnabled()) {
            this.ctx.kernalContext().encryption().onDestroyPartitionStore(this.grp, partId);
        }
        int tag = pageMemory.invalidate(this.grp.groupId(), partId);
        if (this.grp.walEnabled()) {
            this.ctx.wal().log(new PartitionDestroyRecord(this.grp.groupId(), partId));
        }
        this.ctx.pageStore().truncate(this.grp.groupId(), partId, tag);
    }

    @Override
    public RootPage rootPageForIndex(int cacheId, String idxName, int segment) throws IgniteCheckedException {
        return this.indexStorage.allocateCacheIndex(cacheId, idxName, segment);
    }

    @Override
    @Nullable
    public RootPage findRootPageForIndex(int cacheId, String idxName, int segment) throws IgniteCheckedException {
        return this.indexStorage.findCacheIndex(cacheId, idxName, segment);
    }

    @Override
    @Nullable
    public RootPage dropRootPageForIndex(int cacheId, String idxName, int segment) throws IgniteCheckedException {
        return this.indexStorage.dropCacheIndex(cacheId, idxName, segment);
    }

    @Override
    @Nullable
    public RootPage renameRootPageForIndex(int cacheId, String oldIdxName, String newIdxName, int segment) throws IgniteCheckedException {
        return this.indexStorage.renameCacheIndex(cacheId, oldIdxName, newIdxName, segment);
    }

    @Override
    public ReuseList reuseListForIndex(String idxName) {
        return this.reuseList;
    }

    @Override
    public void stop() {
        if (this.reuseList != null) {
            this.reuseList.close();
        }
        if (this.grp.affinityNode()) {
            ((GridCacheDatabaseSharedManager)this.ctx.database()).removeCheckpointListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metas getOrAllocateCacheMetas() throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        IgniteWriteAheadLogManager wal = this.ctx.wal();
        int grpId = this.grp.groupId();
        long metaId = PageMemory.META_PAGE_ID;
        long metaPage = pageMem.acquirePage(grpId, metaId);
        try {
            Metas metas;
            long pageAddr = pageMem.writeLock(grpId, metaId, metaPage);
            boolean allocated = false;
            boolean markDirty = false;
            try {
                long reuseListRoot;
                long metastoreRoot;
                PageMetaIOV2 io = (PageMetaIOV2)PageMetaIO.VERSIONS.latest();
                if (PageIO.getType(pageAddr) != 11) {
                    PageMetrics metrics = pageMem.metrics().cacheGrpPageMetrics(grpId);
                    io.initNewPage(pageAddr, metaId, pageMem.realPageSize(grpId), metrics);
                    metastoreRoot = pageMem.allocatePage(grpId, 65535, (byte)2);
                    reuseListRoot = pageMem.allocatePage(grpId, 65535, (byte)2);
                    io.setTreeRoot(pageAddr, metastoreRoot);
                    io.setReuseListRoot(pageAddr, reuseListRoot);
                    if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, metaId, metaPage, wal, null)) {
                        assert (io.getType() == 11);
                        wal.log(new MetaPageInitRecord(grpId, metaId, io.getType(), io.getVersion(), metastoreRoot, reuseListRoot));
                    }
                    allocated = true;
                } else {
                    if (io != PageIO.getPageIO(pageAddr)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Upgrade index partition meta page version: [grpId=" + grpId + ", oldVer=" + PagePartitionMetaIO.getVersion(pageAddr) + ", newVer=" + io.getVersion() + ']');
                        }
                        io.upgradePage(pageAddr);
                        markDirty = true;
                    }
                    metastoreRoot = io.getTreeRoot(pageAddr);
                    reuseListRoot = io.getReuseListRoot(pageAddr);
                    int encrPageCnt = io.getEncryptedPageCount(pageAddr);
                    if (encrPageCnt > 0) {
                        this.ctx.kernalContext().encryption().setEncryptionState(this.grp, 65535, io.getEncryptedPageIndex(pageAddr), encrPageCnt);
                        markDirty = true;
                    }
                    assert (reuseListRoot != 0L);
                    if (markDirty && PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, metaId, metaPage, wal, null)) {
                        wal.log(new PageSnapshot(new FullPageId(65535L, grpId), pageAddr, pageMem.pageSize(), pageMem.realPageSize(grpId)));
                    }
                }
                metas = new Metas(new RootPage(new FullPageId(metastoreRoot, grpId), allocated), new RootPage(new FullPageId(reuseListRoot, grpId), allocated), null, null, null);
                pageMem.writeUnlock(grpId, metaId, metaPage, null, allocated || markDirty);
            }
            catch (Throwable throwable) {
                pageMem.writeUnlock(grpId, metaId, metaPage, null, allocated || markDirty);
                throw throwable;
            }
            return metas;
        }
        finally {
            pageMem.releasePage(grpId, metaId, metaPage);
        }
    }

    @Override
    @Nullable
    protected IgniteHistoricalIterator historicalIterator(CachePartitionPartialCountersMap partCntrs, Set<Integer> missing) throws IgniteCheckedException {
        if (partCntrs == null || partCntrs.isEmpty()) {
            return null;
        }
        if (this.grp.mvccEnabled()) {
            return super.historicalIterator(partCntrs, missing);
        }
        GridCacheDatabaseSharedManager database = (GridCacheDatabaseSharedManager)this.grp.shared().database();
        HashMap<Integer, Long> partsCounters = new HashMap<Integer, Long>();
        for (int i = 0; i < partCntrs.size(); ++i) {
            int p = partCntrs.partitionAt(i);
            long initCntr = partCntrs.initialUpdateCounterAt(i);
            partsCounters.put(p, initCntr);
        }
        try {
            FileWALPointer minPtr = database.checkpointHistory().searchEarliestWalPointer(this.grp.groupId(), partsCounters, this.grp.hasAtomicCaches() ? this.walAtomicCacheMargin : 0L);
            FileWALPointer latestReservedPointer = (FileWALPointer)database.latestWalPointerReservedForPreloading();
            assert (latestReservedPointer == null || latestReservedPointer.compareTo(minPtr) <= 0) : "Historical iterator tries to iterate WAL out of reservation [cache=" + this.grp.cacheOrGroupName() + ", reservedPointer=" + latestReservedPointer + ", historicalPointer=" + minPtr + ']';
            if (latestReservedPointer == null) {
                this.log.warning("History for the preloading has not reserved yet.");
            }
            WALIterator it = this.grp.shared().wal().replay(minPtr);
            WALHistoricalIterator iterator = new WALHistoricalIterator(this.log, this.grp, partCntrs, partsCounters, it);
            missing.addAll(iterator.missingParts);
            return iterator;
        }
        catch (Exception ex) {
            if (!X.hasCause((Throwable)ex, IgniteHistoricalIteratorException.class)) {
                throw new IgniteHistoricalIteratorException(ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expireTombstones(IgniteClosure2X<GridCacheEntryEx, Long, Boolean> c, int amount, long now) {
        long tsCnt = this.tombstonesCount();
        DiscoCache discoCache = this.ctx.discovery().discoCache();
        long tsLimit = this.ctx.ttl().tombstonesLimit();
        GridDhtPartitionsExchangeFuture fut = this.ctx.exchange().lastTopologyFuture();
        if (!(tsCnt > tsLimit || discoCache.fullBaseline() && fut.isDone() && fut.rebalanced() && !this.ctx.ttl().tombstoneCleanupSuspended())) {
            return false;
        }
        if (tsCnt > tsLimit) {
            amount = (int)(tsCnt - tsLimit);
            now = Long.MAX_VALUE;
        }
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            boolean bl = this.ctx.evict().expire(true, c, amount, now);
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long fillQueue(boolean tombstone, long upper, ToIntFunction<PendingRow> c) throws IgniteCheckedException {
        long tsLimit;
        long tombstonesCount;
        long nextExpirationTask = Long.MAX_VALUE;
        if (!this.busyLock.enterBusy()) {
            return nextExpirationTask;
        }
        if (tombstone && (tombstonesCount = this.tombstonesCount()) > (tsLimit = this.ctx.ttl().tombstonesLimit())) {
            upper = Long.MAX_VALUE;
        }
        try {
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                if (!store.init()) continue;
                GridDhtLocalPartition part = null;
                int partId = store.partId();
                if (!this.grp.isLocal() && ((part = this.grp.topology().localPartition(partId, AffinityTopologyVersion.NONE, false, false)) == null || part.state() != GridDhtPartitionState.OWNING && part.state() != GridDhtPartitionState.MOVING) || part != null && !part.reserve()) continue;
                try {
                    for (GridCacheContext ctx : this.grp.caches()) {
                        long nextCacheEntryExpireTs;
                        if (ctx.started() && (nextExpirationTask = Math.min(nextExpirationTask, nextCacheEntryExpireTs = this.fillQueueInternal(store.pendingTree(), ctx, this.grp.sharedGroup() ? ctx.cacheId() : 0, tombstone, upper, c))) <= upper) break;
                    }
                }
                finally {
                    if (part == null) continue;
                    part.release();
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
        return nextExpirationTask;
    }

    private long tombstoneCount(@Nullable GridDhtLocalPartition part) {
        return part == null || part.state() == GridDhtPartitionState.EVICTED ? 0L : part.dataStore().tombstonesCount();
    }

    @Override
    public long expiredSize() throws IgniteCheckedException {
        long size = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
            size += ((GridCacheDataStore)store).expiredSize();
        }
        return size;
    }

    @Override
    public void preloadPartition(int partId) throws IgniteCheckedException {
        if (this.grp.isLocal()) {
            this.dataStore(null).preload();
            return;
        }
        GridDhtLocalPartition locPart = this.grp.topology().localPartition(partId, AffinityTopologyVersion.NONE, false, false);
        assert (locPart != null && locPart.reservations() > 0);
        locPart.dataStore().preload();
    }

    long freeSpace() {
        long freeSpace = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
            assert (store instanceof GridCacheDataStore);
            AbstractFreeList<CacheDataRow> freeList = ((GridCacheDataStore)store).getCacheStoreFreeList();
            if (freeList == null) continue;
            freeSpace += freeList.freeSpace();
        }
        return freeSpace;
    }

    long emptyDataPages() {
        long emptyDataPages = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
            assert (store instanceof GridCacheDataStore);
            AbstractFreeList<CacheDataRow> freeList = ((GridCacheDataStore)store).getCacheStoreFreeList();
            if (freeList == null) continue;
            emptyDataPages += (long)freeList.emptyDataPages();
        }
        return emptyDataPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findAndCleanupLostIndexesForStoppedCache(int cacheId) throws IgniteCheckedException {
        for (String name : this.indexStorage.getIndexNames()) {
            if (!this.indexStorage.nameIsAssosiatedWithCache(name, cacheId)) continue;
            this.ctx.database().checkpointReadLock();
            try {
                RootPage page = this.indexStorage.allocateIndex(name);
                this.ctx.kernalContext().query().getIndexing().destroyOrphanIndex(page, name, this.grp.groupId(), this.grp.dataRegion().pageMemory(), this.globalRemoveId(), this.reuseListForIndex(name), this.grp.mvccEnabled());
                this.indexStorage.dropIndex(name);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIndexReencryptionStatus(int grpId) throws IgniteCheckedException {
        long state = this.ctx.kernalContext().encryption().getEncryptionState(grpId, 65535);
        if (state == 0L) {
            return;
        }
        PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        long metaPageId = PageIdAllocator.META_PAGE_ID;
        long metaPage = pageMem.acquirePage(grpId, metaPageId);
        try {
            boolean changed = false;
            long metaPageAddr = pageMem.writeLock(grpId, metaPageId, metaPage);
            try {
                PageMetaIOV2 metaIo = (PageMetaIOV2)PageMetaIO.getPageIO(metaPageAddr);
                int encryptIdx = ReencryptStateUtils.pageIndex(state);
                int encryptCnt = ReencryptStateUtils.pageCount(state);
                if (encryptIdx == encryptCnt) {
                    this.ctx.kernalContext().encryption().setEncryptionState(this.grp, 65535, 0, 0);
                    encryptCnt = 0;
                    encryptIdx = 0;
                }
                changed |= metaIo.setEncryptedPageIndex(metaPageAddr, encryptIdx);
                IgniteWriteAheadLogManager wal = this.ctx.cache().context().wal();
                if ((changed |= metaIo.setEncryptedPageCount(metaPageAddr, encryptCnt)) && PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, metaPageId, metaPage, wal, null)) {
                    wal.log(new MetaPageUpdateIndexDataRecord(grpId, metaPageId, encryptIdx, encryptCnt));
                }
            }
            finally {
                pageMem.writeUnlock(grpId, metaPageId, metaPage, null, changed);
            }
        }
        finally {
            pageMem.releasePage(grpId, metaPageId, metaPage);
        }
    }

    public GridCacheDataStore createGridCacheDataStore(CacheGroupContext grpCtx, int partId, boolean exists, IgniteLogger log) {
        return new GridCacheDataStore(grpCtx, partId, exists, this.busyLock, log);
    }

    public DynamicCacheDescriptor cacheDescriptor() {
        return this.cacheDescriptor;
    }

    public static class GridCacheDataStore
    implements IgniteCacheOffheapManager.CacheDataStore {
        private final int partId;
        private final CacheGroupContext grp;
        private volatile CacheFreeList freeList;
        private PendingEntriesTree pendingTree;
        private volatile IgniteCacheOffheapManagerImpl.CacheDataStoreImpl delegate;
        private volatile GridQueryRowCacheCleaner rowCacheCleaner;
        private PartitionMetaStorageImpl<SimpleDataRow> partStorage;
        private final boolean exists;
        private final GridSpinBusyLock busyLock;
        private final IgniteLogger log;
        private final AtomicBoolean init = new AtomicBoolean();
        private final CountDownLatch latch = new CountDownLatch(1);
        private CacheDataTree dataTree;

        public GridCacheDataStore(CacheGroupContext grp, int partId, boolean exists, GridSpinBusyLock busyLock, IgniteLogger log) {
            this.grp = grp;
            this.partId = partId;
            this.exists = exists;
            this.busyLock = busyLock;
            this.log = log;
        }

        public AbstractFreeList<CacheDataRow> getCacheStoreFreeList() {
            return this.freeList;
        }

        private String freeListName() {
            return this.grp.cacheOrGroupName() + "-" + this.partId;
        }

        private String partitionMetaStoreName() {
            return this.grp.cacheOrGroupName() + "-partstore-" + this.partId;
        }

        private String dataTreeName() {
            return this.grp.cacheOrGroupName() + "-" + BPlusTree.treeName("p-" + this.partId, "CacheData");
        }

        private String pendingEntriesTreeName() {
            return this.grp.cacheOrGroupName() + "-PendingEntries-" + this.partId;
        }

        private String updateLogTreeName() {
            return this.grp.cacheOrGroupName() + "-updateLog-" + this.partId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private IgniteCacheOffheapManager.CacheDataStore init0(boolean checkExists) throws IgniteCheckedException {
            IgniteCacheOffheapManagerImpl.CacheDataStoreImpl delegate0 = this.delegate;
            if (delegate0 != null) {
                return delegate0;
            }
            if (checkExists && !this.exists) {
                return null;
            }
            final GridCacheSharedContext ctx = this.grp.shared();
            AtomicLong pageListCacheLimit = ((GridCacheDatabaseSharedManager)ctx.database()).pageListCacheLimitHolder(this.grp.dataRegion());
            IgniteCacheDatabaseSharedManager dbMgr = ctx.database();
            dbMgr.checkpointReadLock();
            if (this.init.compareAndSet(false, true)) {
                try {
                    Metas metas = this.getOrAllocatePartitionMetas();
                    if (PageIdUtils.partId(metas.reuseListRoot.pageId().pageId()) != this.partId || PageIdUtils.partId(metas.treeRoot.pageId().pageId()) != this.partId || PageIdUtils.partId(metas.pendingTreeRoot.pageId().pageId()) != this.partId || PageIdUtils.partId(metas.partMetastoreReuseListRoot.pageId().pageId()) != this.partId || metas.updateLogTreeRoot != null && PageIdUtils.partId(metas.updateLogTreeRoot.pageId().pageId()) != this.partId) {
                        throw new IgniteCheckedException("Invalid meta root allocated [cacheOrGroupName=" + this.grp.cacheOrGroupName() + ", partId=" + this.partId + ", metas=" + metas + ']');
                    }
                    String freeListName = this.freeListName();
                    RootPage reuseRoot = metas.reuseListRoot;
                    this.freeList = new CacheFreeList(this.grp.groupId(), freeListName, this.grp.dataRegion(), ctx.wal(), reuseRoot.pageId().pageId(), reuseRoot.isAllocated(), ctx.diagnostic().pageLockTracker(), ctx.kernalContext(), pageListCacheLimit, 4){

                        @Override
                        protected long allocatePageNoReuse() throws IgniteCheckedException {
                            assert (grp.shared().database().checkpointLockIsHeldByThread());
                            return this.pageMem.allocatePage(this.grpId, partId, (byte)4);
                        }
                    };
                    RootPage partMetastoreReuseListRoot = metas.partMetastoreReuseListRoot;
                    String partMetastoreName = this.partitionMetaStoreName();
                    this.partStorage = new PartitionMetaStorageImpl<SimpleDataRow>(this.grp.groupId(), partMetastoreName, this.grp.dataRegion(), null, ctx.wal(), partMetastoreReuseListRoot.pageId().pageId(), partMetastoreReuseListRoot.isAllocated(), ctx.diagnostic().pageLockTracker(), ctx.kernalContext(), pageListCacheLimit, 4){

                        @Override
                        protected long allocatePageNoReuse() throws IgniteCheckedException {
                            assert (ctx.database().checkpointLockIsHeldByThread());
                            return this.pageMem.allocatePage(this.grpId, partId, (byte)4);
                        }
                    };
                    String dataTreeName = this.dataTreeName();
                    CacheDataRowStore rowStore = new CacheDataRowStore(this.grp, this.freeList, this.partId);
                    RootPage treeRoot = metas.treeRoot;
                    this.dataTree = new CacheDataTree(this.grp, dataTreeName, this.freeList, rowStore, treeRoot.pageId().pageId(), treeRoot.isAllocated(), ctx.diagnostic().pageLockTracker(), 4){

                        @Override
                        protected long allocatePageNoReuse() throws IgniteCheckedException {
                            assert (ctx.database().checkpointLockIsHeldByThread());
                            return this.pageMem.allocatePage(this.grpId, partId, (byte)4);
                        }
                    };
                    String pendingEntriesTreeName = this.pendingEntriesTreeName();
                    RootPage pendingTreeRoot = metas.pendingTreeRoot;
                    final PendingEntriesTree pendingTree0 = new PendingEntriesTree(this.grp, pendingEntriesTreeName, this.grp.dataRegion().pageMemory(), pendingTreeRoot.pageId().pageId(), this.freeList, pendingTreeRoot.isAllocated(), ctx.diagnostic().pageLockTracker(), 4){

                        @Override
                        protected long allocatePageNoReuse() throws IgniteCheckedException {
                            assert (ctx.database().checkpointLockIsHeldByThread());
                            return this.pageMem.allocatePage(this.grpId, partId, (byte)4);
                        }
                    };
                    RootPage logTreeRoot = metas.updateLogTreeRoot;
                    UpdateLogImpl updateLog = metas.updateLogTreeRoot != null ? new UpdateLogImpl(this.createLogTree(logTreeRoot.pageId().pageId(), logTreeRoot.isAllocated())) : new UpdateLogImpl(this.createLogTreeFactory());
                    final PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
                    final int grpId = this.grp.groupId();
                    delegate0 = new IgniteCacheOffheapManagerImpl.CacheDataStoreImpl(this.partId, rowStore, this.dataTree, updateLog, () -> pendingTree0, this.grp, this.busyLock, this.log, () -> this.rowCacheCleaner){

                        @Override
                        public PendingEntriesTree pendingTree() {
                            return pendingTree0;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void preload() throws IgniteCheckedException {
                            IgnitePageStoreManager pageStoreMgr = ctx.pageStore();
                            if (pageStoreMgr == null) {
                                return;
                            }
                            int pages = pageStoreMgr.pages(grpId, partId);
                            long pageId = pageMem.partitionMetaPageId(grpId, partId);
                            for (int pageNo = 0; pageNo < pages; ++pageNo) {
                                long pagePointer = -1L;
                                try {
                                    pagePointer = pageMem.acquirePage(grpId, pageId);
                                }
                                finally {
                                    if (pagePointer != -1L) {
                                        pageMem.releasePage(grpId, pageId, pagePointer);
                                    }
                                }
                                ++pageId;
                            }
                        }
                    };
                    this.pendingTree = pendingTree0;
                    long partMetaId = pageMem.partitionMetaPageId(grpId, this.partId);
                    long partMetaPage = pageMem.acquirePage(grpId, partMetaId);
                    try {
                        long pageAddr = pageMem.readLock(grpId, partMetaId, partMetaPage);
                        try {
                            if (PageIO.getType(pageAddr) != 0) {
                                PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.latest();
                                long gapsLink = io.getGapsLink(pageAddr);
                                byte[] updCntrGapsData = gapsLink == 0L ? null : this.partStorage.readRow(gapsLink);
                                delegate0.restoreState(io.getSize(pageAddr), io.getUpdateCounter(pageAddr), this.grp.sharedGroup() ? GridCacheOffheapManager.readSharedGroupCacheSizes(pageMem, grpId, io.getCacheSizesPageId(pageAddr)) : Collections.emptyMap(), updCntrGapsData, io.getTombstonesCount(pageAddr));
                                int encrPageCnt = io.getEncryptedPageCount(pageAddr);
                                if (encrPageCnt > 0) {
                                    ctx.kernalContext().encryption().setEncryptionState(this.grp, this.partId, io.getEncryptedPageIndex(pageAddr), encrPageCnt);
                                }
                                this.grp.offheap().globalRemoveId().setIfGreater(io.getGlobalRemoveId(pageAddr));
                            }
                        }
                        finally {
                            pageMem.readUnlock(grpId, partMetaId, partMetaPage);
                        }
                    }
                    finally {
                        pageMem.releasePage(grpId, partMetaId, partMetaPage);
                    }
                    this.delegate = delegate0;
                }
                catch (Throwable ex) {
                    U.error(this.log, "Unhandled exception during page store initialization. All further operations will be failed and local node will be stopped.", ex);
                    ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, ex));
                    throw ex;
                }
                finally {
                    this.latch.countDown();
                    dbMgr.checkpointReadUnlock();
                }
            }
            dbMgr.checkpointReadUnlock();
            U.await(this.latch);
            delegate0 = this.delegate;
            if (delegate0 == null) {
                throw new IgniteCheckedException("Cache store initialization failed.");
            }
            return delegate0;
        }

        private PartitionLogTree createLogTree(long pageId, boolean initNew) throws IgniteCheckedException {
            return new PartitionLogTree(this.grp, this.partId, this.updateLogTreeName(), this.grp.dataRegion().pageMemory(), pageId, this.freeList, initNew, this.grp.shared().diagnostic().pageLockTracker(), 4, this.log){

                @Override
                protected long allocatePageNoReuse() throws IgniteCheckedException {
                    assert (grp.shared().database().checkpointLockIsHeldByThread());
                    return this.pageMem.allocatePage(this.grpId, partId, (byte)4);
                }
            };
        }

        private Factory<PartitionLogTree> createLogTreeFactory() {
            return () -> {
                PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
                IgniteWriteAheadLogManager wal = this.grp.shared().wal();
                int grpId = this.grp.groupId();
                long partMetaId = pageMem.partitionMetaPageId(grpId, this.partId);
                AtomicBoolean metaPageAllocated = new AtomicBoolean(false);
                long partMetaPage = pageMem.acquirePage(grpId, partMetaId, metaPageAllocated);
                try {
                    PartitionLogTree partitionLogTree;
                    long pageAddr = pageMem.writeLock(grpId, partMetaId, partMetaPage);
                    try {
                        PagePartitionMetaIOV3 io = (PagePartitionMetaIOV3)PagePartitionMetaIO.VERSIONS.latest();
                        assert (PageIO.getType(pageAddr) == 14);
                        assert (PageIO.getPageIO(pageAddr) == io);
                        assert (io.getUpdateTreeRoot(pageAddr) == 0L);
                        long updateLogTreeRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                        io.setUpdateTreeRoot(pageAddr, updateLogTreeRoot);
                        if (PageIdUtils.flag(updateLogTreeRoot) != 4 && PageIdUtils.flag(updateLogTreeRoot) != 1) {
                            throw new StorageException("Wrong partition update log root page id flag: updateLogTreeRoot=" + U.hexLong(updateLogTreeRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                        if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, partMetaId, partMetaPage, wal, null)) {
                            wal.log(new PageSnapshot(new FullPageId(partMetaId, grpId), pageAddr, pageMem.pageSize(), pageMem.realPageSize(grpId)));
                        }
                        partitionLogTree = this.createLogTree(updateLogTreeRoot, true);
                    }
                    catch (Throwable throwable) {
                        pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, true);
                        throw throwable;
                    }
                    pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, true);
                    return partitionLogTree;
                }
                finally {
                    pageMem.releasePage(grpId, partMetaId, partMetaPage);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Metas getOrAllocatePartitionMetas() throws IgniteCheckedException {
            PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
            IgniteWriteAheadLogManager wal = this.grp.shared().wal();
            int grpId = this.grp.groupId();
            long partMetaId = pageMem.partitionMetaPageId(grpId, this.partId);
            AtomicBoolean metaPageAllocated = new AtomicBoolean(false);
            long partMetaPage = pageMem.acquirePage(grpId, partMetaId, metaPageAllocated);
            if (metaPageAllocated.get()) {
                this.grp.metrics().incrementInitializedLocalPartitions();
            }
            try {
                Metas metas;
                boolean allocated = false;
                boolean pageUpgraded = false;
                boolean pendingTreeAllocated = false;
                boolean partMetastoreReuseListAllocated = false;
                boolean updateLogTreeRootAllocated = false;
                boolean preallocateUpdateLogTree = this.grp.caches().stream().anyMatch(GridCacheContext::isDrEnabled);
                long pageAddr = pageMem.writeLock(grpId, partMetaId, partMetaPage);
                try {
                    long updateLogTreeRoot;
                    long partMetaStoreReuseListRoot;
                    long pendingTreeRoot;
                    long reuseListRoot;
                    long treeRoot;
                    PagePartitionMetaIOV3 io = (PagePartitionMetaIOV3)PagePartitionMetaIO.VERSIONS.latest();
                    if (PageIO.getType(pageAddr) != 14) {
                        PageMetrics metrics = pageMem.metrics().cacheGrpPageMetrics(grpId);
                        io.initNewPage(pageAddr, partMetaId, pageMem.realPageSize(grpId), metrics);
                        treeRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                        reuseListRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                        pendingTreeRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                        partMetaStoreReuseListRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                        assert (PageIdUtils.flag(treeRoot) == 4);
                        assert (PageIdUtils.flag(reuseListRoot) == 4);
                        assert (PageIdUtils.flag(pendingTreeRoot) == 4);
                        assert (PageIdUtils.flag(partMetaStoreReuseListRoot) == 4);
                        io.setTreeRoot(pageAddr, treeRoot);
                        io.setReuseListRoot(pageAddr, reuseListRoot);
                        io.setPendingTreeRoot(pageAddr, pendingTreeRoot);
                        io.setPartitionMetaStoreReuseListRoot(pageAddr, partMetaStoreReuseListRoot);
                        if (preallocateUpdateLogTree) {
                            updateLogTreeRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                            assert (PageIdUtils.flag(updateLogTreeRoot) == 4);
                        } else {
                            updateLogTreeRoot = 0L;
                        }
                        io.setUpdateTreeRoot(pageAddr, updateLogTreeRoot);
                        allocated = true;
                    } else {
                        if (io != PageIO.getPageIO(pageAddr)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Upgrade partition meta page version: [part=" + this.partId + ", grpId=" + grpId + ", oldVer=" + PagePartitionMetaIO.getVersion(pageAddr) + ", newVer=" + io.getVersion() + ']');
                            }
                            assert (io instanceof PagePartitionMetaIOGG) : "Unexpected page IO class [type=" + io.getType() + '(' + io.getClass().getSimpleName() + "), ver=" + io.getVersion() + ']';
                            ((PagePartitionMetaIOGG)((Object)io)).upgradePage(pageAddr);
                            pageUpgraded = true;
                        }
                        treeRoot = io.getTreeRoot(pageAddr);
                        reuseListRoot = io.getReuseListRoot(pageAddr);
                        pendingTreeRoot = io.getPendingTreeRoot(pageAddr);
                        if (pendingTreeRoot == 0L) {
                            pendingTreeRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                            io.setPendingTreeRoot(pageAddr, pendingTreeRoot);
                            pendingTreeAllocated = true;
                        }
                        this.checkGapsLinkAndPartMetaStorage(io, partMetaId, pageAddr, grpId, this.partId);
                        partMetaStoreReuseListRoot = io.getPartitionMetaStoreReuseListRoot(pageAddr);
                        if (partMetaStoreReuseListRoot == 0L) {
                            partMetaStoreReuseListRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                            io.setPartitionMetaStoreReuseListRoot(pageAddr, partMetaStoreReuseListRoot);
                            partMetastoreReuseListAllocated = true;
                        }
                        if ((updateLogTreeRoot = io.getUpdateTreeRoot(pageAddr)) == 0L && preallocateUpdateLogTree) {
                            updateLogTreeRoot = pageMem.allocatePage(grpId, this.partId, (byte)4);
                            io.setUpdateTreeRoot(pageAddr, updateLogTreeRoot);
                            updateLogTreeRootAllocated = true;
                        }
                        if (PageIdUtils.flag(treeRoot) != 4 && PageIdUtils.flag(treeRoot) != 1) {
                            throw new StorageException("Wrong tree root page id flag: treeRoot=" + U.hexLong(treeRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                        if (PageIdUtils.flag(reuseListRoot) != 4 && PageIdUtils.flag(reuseListRoot) != 1) {
                            throw new StorageException("Wrong reuse list root page id flag: reuseListRoot=" + U.hexLong(reuseListRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                        if (PageIdUtils.flag(pendingTreeRoot) != 4 && PageIdUtils.flag(pendingTreeRoot) != 1) {
                            throw new StorageException("Wrong pending tree root page id flag: reuseListRoot=" + U.hexLong(pendingTreeRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                        if (PageIdUtils.flag(partMetaStoreReuseListRoot) != 4 && PageIdUtils.flag(partMetaStoreReuseListRoot) != 1) {
                            throw new StorageException("Wrong partition meta store list root page id flag: partMetaStoreReuseListRoot=" + U.hexLong(partMetaStoreReuseListRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                        if (preallocateUpdateLogTree && PageIdUtils.flag(updateLogTreeRoot) != 4 && PageIdUtils.flag(updateLogTreeRoot) != 1) {
                            throw new StorageException("Wrong partition update log root page id flag: updateLogTreeRoot=" + U.hexLong(updateLogTreeRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                    }
                    if ((allocated || pageUpgraded || pendingTreeAllocated || partMetastoreReuseListAllocated || updateLogTreeRootAllocated) && PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, partMetaId, partMetaPage, wal, null)) {
                        wal.log(new PageSnapshot(new FullPageId(partMetaId, grpId), pageAddr, pageMem.pageSize(), pageMem.realPageSize(grpId)));
                    }
                    metas = new Metas(new RootPage(new FullPageId(treeRoot, grpId), allocated), new RootPage(new FullPageId(reuseListRoot, grpId), allocated), new RootPage(new FullPageId(pendingTreeRoot, grpId), allocated || pendingTreeAllocated), new RootPage(new FullPageId(partMetaStoreReuseListRoot, grpId), allocated || partMetastoreReuseListAllocated), updateLogTreeRoot == 0L ? null : new RootPage(new FullPageId(updateLogTreeRoot, grpId), allocated || updateLogTreeRootAllocated));
                    pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, allocated || pageUpgraded || pendingTreeAllocated || partMetastoreReuseListAllocated || updateLogTreeRootAllocated);
                }
                catch (Throwable throwable) {
                    pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, allocated || pageUpgraded || pendingTreeAllocated || partMetastoreReuseListAllocated || updateLogTreeRootAllocated);
                    throw throwable;
                }
                return metas;
            }
            finally {
                pageMem.releasePage(grpId, partMetaId, partMetaPage);
            }
        }

        private void checkGapsLinkAndPartMetaStorage(PagePartitionMetaIOV3 io, long pageId, long pageAddr, int grpId, int partId) {
            if (io.getPartitionMetaStoreReuseListRoot(pageAddr) == 0L && io.getGapsLink(pageAddr) != 0L) {
                String msg = "Partition meta page corruption: links to counter data page and partition meta store must both be present, or both be absent in partition [grpId=" + grpId + ", partId=" + partId + ", cntrUpdDataPageId=" + io.getGapsLink(pageAddr) + ", partitionMetaStoreReuseListRoot=" + io.getPartitionMetaStoreReuseListRoot(pageAddr) + ']';
                ArrayList<Long> pages = new ArrayList<Long>();
                pages.add(pageId);
                if (io.getPartitionMetaStoreReuseListRoot(pageAddr) != 0L) {
                    pages.add(io.getPartitionMetaStoreReuseListRoot(pageAddr));
                }
                if (io.getGapsLink(pageAddr) != 0L) {
                    pages.add(io.getGapsLink(pageAddr));
                }
                CorruptedPartitionMetaPageException e = new CorruptedPartitionMetaPageException(msg, null, grpId, pages.stream().mapToLong(l -> l).toArray());
                this.grp.shared().kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
        }

        @Override
        public CacheDataTree tree() {
            return this.dataTree;
        }

        @Override
        public boolean init() {
            try {
                return this.init0(true) != null;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public int partId() {
            return this.partId;
        }

        @Override
        public RowStore rowStore() {
            IgniteCacheOffheapManagerImpl.CacheDataStoreImpl delegate0 = this.delegate;
            return delegate0 == null ? null : delegate0.rowStore();
        }

        @Override
        public UpdateLog logTree() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? null : delegate0.logTree();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long fullSize() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.fullSize();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public boolean isEmpty() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null || delegate0.isEmpty();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long cacheSize(int cacheId) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.cacheSize(cacheId);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public Map<Integer, Long> cacheSizes() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? null : delegate0.cacheSizes();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void updateSize(int cacheId, long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                if (delegate0 != null) {
                    delegate0.updateSize(cacheId, delta);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long updateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.updateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long reservedCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.reservedCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public PartitionUpdateCounter partUpdateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? null : delegate0.partUpdateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long getAndIncrementUpdateCounter(long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                return delegate0 == null ? 0L : delegate0.getAndIncrementUpdateCounter(delta);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long reserve(long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                if (delegate0 == null) {
                    throw new IllegalStateException("Should be never called.");
                }
                return delegate0.reserve(delta);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void updateCounter(long val) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                if (delegate0 != null) {
                    delegate0.updateCounter(val);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public boolean updateCounter(long start, long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                return delegate0 != null && delegate0.updateCounter(start, delta);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public GridLongList finalizeUpdateCounters() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 != null ? delegate0.finalizeUpdateCounters() : null;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long nextUpdateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                if (delegate0 == null) {
                    throw new IllegalStateException("Should be never called.");
                }
                return delegate0.nextUpdateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long initialUpdateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.initialUpdateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void updateInitialCounter(long start, long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                delegate0.updateInitialCounter(start, delta);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void setRowCacheCleaner(GridQueryRowCacheCleaner rowCacheCleaner) {
            this.rowCacheCleaner = rowCacheCleaner;
        }

        @Override
        public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.update(cctx, key, val, ver, expireTime, oldRow);
        }

        @Override
        public boolean mvccInitialValue(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccInitialValue(cctx, key, val, ver, expireTime, mvccVer, newMvccVer);
        }

        @Override
        public boolean mvccApplyHistoryIfAbsent(GridCacheContext cctx, KeyCacheObject key, List<GridCacheMvccEntryInfo> hist) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccApplyHistoryIfAbsent(cctx, key, hist);
        }

        @Override
        public boolean mvccUpdateRowWithPreloadInfo(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte mvccTxState, byte newMvccTxState) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccUpdateRowWithPreloadInfo(cctx, key, val, ver, expireTime, mvccVer, newMvccVer, mvccTxState, newMvccTxState);
        }

        @Override
        public MvccUpdateResult mvccUpdate(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccVer, CacheEntryPredicate filter, EntryProcessor entryProc, Object[] invokeArgs, boolean primary, boolean needHistory, boolean noCreate, boolean needOldVal, boolean retVal, boolean keepBinary) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccUpdate(cctx, key, val, ver, expireTime, mvccVer, filter, entryProc, invokeArgs, primary, needHistory, noCreate, needOldVal, retVal, keepBinary);
        }

        @Override
        public MvccUpdateResult mvccRemove(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot mvccVer, CacheEntryPredicate filter, boolean primary, boolean needHistory, boolean needOldVal, boolean retVal) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccRemove(cctx, key, mvccVer, filter, primary, needHistory, needOldVal, retVal);
        }

        @Override
        public MvccUpdateResult mvccLock(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccLock(cctx, key, mvccSnapshot);
        }

        @Override
        public void mvccRemoveAll(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.mvccRemoveAll(cctx, key);
        }

        @Override
        public void mvccApplyUpdate(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.mvccApplyUpdate(cctx, key, val, ver, expireTime, mvccVer);
        }

        @Override
        public CacheDataRow createRow(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.createRow(cctx, key, val, ver, expireTime, oldRow);
        }

        @Override
        public CacheDataRow createRowForTtlUpdate(GridCacheContext cctx, long expireTime, CacheDataRow oldRow) throws IgniteCheckedException {
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.createRowForTtlUpdate(cctx, expireTime, oldRow);
        }

        @Override
        public int cleanup(GridCacheContext cctx, @Nullable List<MvccLinkAwareSearchRow> cleanupRows) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.cleanup(cctx, cleanupRows);
        }

        @Override
        public void updateTxState(GridCacheContext cctx, CacheSearchRow row) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.updateTxState(cctx, row);
        }

        @Override
        public void invoke(GridCacheContext cctx, KeyCacheObject key, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.invoke(cctx, key, c);
        }

        @Override
        public void remove(GridCacheContext cctx, KeyCacheObject key, int partId) throws IgniteCheckedException {
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.remove(cctx, key, partId);
        }

        @Override
        public void removeWithTombstone(GridCacheContext cctx, KeyCacheObject key, GridCacheVersion ver, GridDhtLocalPartition part) throws IgniteCheckedException {
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.removeWithTombstone(cctx, key, ver, part);
        }

        @Override
        public CacheDataRow find(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.find(cctx, key);
            }
            return null;
        }

        @Override
        public CacheDataRow find(GridCacheContext cctx, KeyCacheObject key, CacheDataRowAdapter.RowData x) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.find(cctx, key, x);
            }
            return null;
        }

        @Override
        public CacheDataRow mvccFind(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot snapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.mvccFind(cctx, key, snapshot);
            }
            return null;
        }

        @Override
        public List<IgniteBiTuple<Object, MvccVersion>> mvccFindAllVersions(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.mvccFindAllVersions(cctx, key);
            }
            return Collections.emptyList();
        }

        @Override
        public GridCursor<CacheDataRow> mvccAllVersionsCursor(GridCacheContext cctx, KeyCacheObject key, CacheDataRowAdapter.RowData x) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.mvccAllVersionsCursor(cctx, key, x);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int flags) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(flags);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(CacheDataRowAdapter.RowData x) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(x);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(mvccSnapshot);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, lower, upper);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, CacheDataRowAdapter.RowData x) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, lower, upper, x);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, CacheDataRowAdapter.RowData x, MvccSnapshot mvccSnapshot, int flags) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, lower, upper, x, mvccSnapshot, flags);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public void destroy() throws IgniteCheckedException {
            Stream.of(this.freeList, this.partStorage, this.dataTree, this.pendingTree).filter(Objects::nonNull).forEach(DataStructure::close);
        }

        @Override
        public void markDestroyed() throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                delegate.markDestroyed();
            }
        }

        @Override
        public boolean destroyed() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
                if (delegate != null) {
                    return delegate.destroyed();
                }
                return false;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, int flags) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, flags);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, mvccSnapshot);
            }
            return GridCursor.EMPTY_CURSOR;
        }

        @Override
        public void clear(int cacheId) throws IgniteCheckedException {
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
            if (delegate0 == null) {
                return;
            }
            if (this.pendingTree != null) {
                PendingRow row = new PendingRow(cacheId);
                GridCursor cursor = this.pendingTree.find(row, row, PendingEntriesTree.WITHOUT_KEY);
                while (cursor.next()) {
                    PendingRow row0 = (PendingRow)cursor.get();
                    assert (row0.link != 0L) : row;
                    boolean res = this.pendingTree.removex(row0);
                    assert (res);
                }
            }
            delegate0.clear(cacheId);
        }

        public long expiredSize() throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
            return delegate0 == null ? 0L : this.pendingTree.size();
        }

        @Override
        public PendingEntriesTree pendingTree() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? null : this.pendingTree;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void preload() throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
            if (delegate0 != null) {
                delegate0.preload();
            }
        }

        @Override
        public void resetUpdateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 == null) {
                    return;
                }
                delegate0.resetUpdateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void resetInitialUpdateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 == null) {
                    return;
                }
                delegate0.resetInitialUpdateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public PartitionMetaStorage<SimpleDataRow> partStorage() {
            return this.partStorage;
        }

        @Override
        public long tombstonesCount() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 == null) {
                    return 0L;
                }
                return delegate0.tombstonesCount();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void tombstoneRemoved() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 == null) {
                    return;
                }
                delegate0.tombstoneRemoved();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void tombstoneCreated() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 == null) {
                    return;
                }
                delegate0.tombstoneCreated();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        public void dropPartitionLogTree() throws IgniteCheckedException {
            assert (this.grp.shared().kernalContext().maintenanceRegistry().isMaintenanceMode());
            assert (this.grp.shared().database().checkpointLockIsHeldByThread());
            this.logTree().destroy();
            this.resetUpdateLogTreeLink();
            if (this.init.compareAndSet(true, false)) {
                this.delegate = null;
                this.init0(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetUpdateLogTreeLink() throws IgniteCheckedException {
            PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
            IgniteWriteAheadLogManager wal = this.grp.shared().wal();
            int grpId = this.grp.groupId();
            long partMetaId = pageMem.partitionMetaPageId(grpId, this.partId);
            long partMetaPage = pageMem.acquirePage(grpId, partMetaId);
            try {
                long partMetaPageAddr = pageMem.writeLock(grpId, partMetaId, partMetaPage);
                try {
                    PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.latest();
                    io.setUpdateTreeRoot(partMetaPageAddr, 0L);
                    if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, partMetaId, partMetaPage, wal, null)) {
                        wal.log(new PageSnapshot(new FullPageId(partMetaId, grpId), partMetaPageAddr, pageMem.pageSize(), pageMem.realPageSize(grpId)));
                    }
                }
                finally {
                    pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, true);
                }
            }
            finally {
                pageMem.releasePage(grpId, partMetaId, partMetaPage);
            }
        }
    }

    static class Metas {
        @GridToStringInclude
        public final RootPage reuseListRoot;
        @GridToStringInclude
        public final RootPage treeRoot;
        @GridToStringInclude
        public final RootPage pendingTreeRoot;
        @GridToStringInclude
        public final RootPage partMetastoreReuseListRoot;
        @GridToStringInclude
        @Nullable
        private final RootPage updateLogTreeRoot;

        Metas(RootPage treeRoot, RootPage reuseListRoot, RootPage pendingTreeRoot, RootPage partMetastoreReuseListRoot, @Nullable RootPage updateLogTreeRoot) {
            this.treeRoot = treeRoot;
            this.reuseListRoot = reuseListRoot;
            this.pendingTreeRoot = pendingTreeRoot;
            this.partMetastoreReuseListRoot = partMetastoreReuseListRoot;
            this.updateLogTreeRoot = updateLogTreeRoot;
        }

        public String toString() {
            return S.toString(Metas.class, this);
        }
    }

    private static class DataEntryRow
    implements CacheDataRow {
        private final DataEntry entry;

        private DataEntryRow(DataEntry entry) {
            this.entry = entry;
        }

        @Override
        public KeyCacheObject key() {
            return this.entry.key();
        }

        @Override
        public void key(KeyCacheObject key) {
            throw new IllegalStateException();
        }

        @Override
        public CacheObject value() {
            return this.entry.value();
        }

        @Override
        public GridCacheVersion version() {
            return this.entry.writeVersion();
        }

        @Override
        public long expireTime() {
            return this.entry.expireTime();
        }

        @Override
        public int partition() {
            return this.entry.partitionId();
        }

        @Override
        public int size() throws IgniteCheckedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int headerSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long link() {
            return 0L;
        }

        @Override
        public void link(long link) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hash() {
            return this.entry.key().hashCode();
        }

        @Override
        public int cacheId() {
            return this.entry.cacheId();
        }

        @Override
        public void cacheId(int cacheId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long mvccCoordinatorVersion() {
            return 0L;
        }

        @Override
        public long mvccCounter() {
            return 0L;
        }

        @Override
        public int mvccOperationCounter() {
            return 0;
        }

        @Override
        public long newMvccCoordinatorVersion() {
            return 0L;
        }

        @Override
        public long newMvccCounter() {
            return 0L;
        }

        @Override
        public int newMvccOperationCounter() {
            return 0;
        }

        @Override
        public byte mvccTxState() {
            return 0;
        }

        @Override
        public byte newMvccTxState() {
            return 0;
        }

        @Override
        public boolean tombstone() {
            return this.entry.op() == GridCacheOperation.DELETE;
        }
    }

    private static class WALHistoricalIterator
    implements IgniteHistoricalIterator {
        private static final long serialVersionUID = 0L;
        private final IgniteLogger log;
        private final CacheGroupContext grp;
        private final CachePartitionPartialCountersMap partMap;
        private final Set<Integer> missingParts = new HashSet<Integer>();
        private final Set<Integer> doneParts = new HashSet<Integer>();
        private final Set<Integer> cacheIds;
        private final WALIterator walIt;
        private Iterator<DataEntry> entryIt;
        private DataEntry next;
        private final long[] rebalancedCntrs;
        private int donePart = -1;

        private WALHistoricalIterator(IgniteLogger log, CacheGroupContext grp, CachePartitionPartialCountersMap partMap, Map<Integer, Long> updatedPartCntr, WALIterator walIt) {
            this.log = log;
            this.grp = grp;
            this.partMap = partMap;
            this.walIt = walIt;
            this.cacheIds = grp.cacheIds();
            this.rebalancedCntrs = new long[partMap.size()];
            for (int i = 0; i < this.rebalancedCntrs.length; ++i) {
                int p = partMap.partitionAt(i);
                this.rebalancedCntrs[i] = updatedPartCntr.get(p);
                partMap.initialUpdateCounterAt(i, this.rebalancedCntrs[i]);
            }
            this.reservePartitions();
            this.advance();
        }

        @Override
        public boolean contains(int partId) {
            return this.partMap.contains(partId);
        }

        @Override
        public boolean isDone(int partId) {
            return this.doneParts.contains(partId);
        }

        @Override
        public boolean allHistoricalPartitionsDone() {
            return this.doneParts.size() == this.partMap.size();
        }

        @Override
        public void close() throws IgniteCheckedException {
            this.walIt.close();
            this.releasePartitions();
        }

        @Override
        public boolean isClosed() {
            return this.walIt.isClosed();
        }

        @Override
        public boolean hasNextX() {
            return this.hasNext();
        }

        @Override
        public CacheDataRow nextX() throws IgniteCheckedException {
            return this.next();
        }

        @Override
        public void removeX() throws IgniteCheckedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<CacheDataRow> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public CacheDataRow next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            DataEntryRow val = new DataEntryRow(this.next);
            if (this.donePart != -1) {
                int pIdx = this.partMap.partitionIndex(this.donePart);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition done [grpId=" + this.grp.groupId() + ", partId=" + this.donePart + ", from=" + this.partMap.initialUpdateCounterAt(pIdx) + ", to=" + this.partMap.updateCounterAt(pIdx) + ']');
                }
                this.doneParts.add(this.donePart);
                this.donePart = -1;
            }
            this.advance();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void reservePartitions() {
            for (int i = 0; i < this.partMap.size(); ++i) {
                int p = this.partMap.partitionAt(i);
                GridDhtLocalPartition part = this.grp.topology().localPartition(p);
                if (part == null || !part.reserve()) {
                    this.missingParts.add(p);
                    continue;
                }
                if (part.state() == GridDhtPartitionState.OWNING) continue;
                part.release();
                this.missingParts.add(p);
            }
        }

        private void releasePartitions() {
            for (int i = 0; i < this.partMap.size(); ++i) {
                int p = this.partMap.partitionAt(i);
                if (this.missingParts.contains(p)) continue;
                GridDhtLocalPartition part = this.grp.topology().localPartition(p);
                assert (part != null && part.state() == GridDhtPartitionState.OWNING && part.reservations() > 0) : "Partition should in OWNING state and has at least 1 reservation";
                part.release();
            }
        }

        private void advance() {
            try {
                this.next = null;
                block2: while (this.doneParts.size() != this.partMap.size()) {
                    if (this.entryIt != null) {
                        while (this.entryIt.hasNext()) {
                            int idx;
                            DataEntry entry = this.entryIt.next();
                            if (!this.cacheIds.contains(entry.cacheId()) || (idx = this.partMap.partitionIndex(entry.partitionId())) < 0 || this.missingParts.contains(idx)) continue;
                            long from = this.partMap.initialUpdateCounterAt(idx);
                            long to = this.partMap.updateCounterAt(idx);
                            if (entry.partitionCounter() <= from || entry.partitionCounter() > to) continue;
                            int n = idx;
                            this.rebalancedCntrs[n] = this.rebalancedCntrs[n] + 1L;
                            if (this.rebalancedCntrs[n] == to) {
                                this.donePart = entry.partitionId();
                            }
                            this.next = entry;
                            return;
                        }
                    }
                    this.entryIt = null;
                    while (this.walIt.hasNext()) {
                        int idx;
                        IgniteBiTuple rec = (IgniteBiTuple)this.walIt.next();
                        if (rec.get2() instanceof DataRecord) {
                            DataRecord data = (DataRecord)rec.get2();
                            this.entryIt = data.writeEntries().iterator();
                            continue block2;
                        }
                        if (!(rec.get2() instanceof RollbackRecord)) continue;
                        RollbackRecord rbRec = (RollbackRecord)rec.get2();
                        if (this.grp.groupId() != rbRec.groupId() || (idx = this.partMap.partitionIndex(rbRec.partitionId())) < 0 || this.missingParts.contains(idx)) continue;
                        long from = this.partMap.initialUpdateCounterAt(idx);
                        long to = this.partMap.updateCounterAt(idx);
                        int n = idx;
                        this.rebalancedCntrs[n] = this.rebalancedCntrs[n] + rbRec.overlap(from, to);
                        if (this.rebalancedCntrs[idx] != this.partMap.updateCounterAt(idx)) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Partition done [grpId=" + this.grp.groupId() + ", partId=" + this.donePart + ", from=" + from + ", to=" + to + ']');
                        }
                        this.doneParts.add(rbRec.partitionId());
                    }
                    if (this.entryIt != null || this.doneParts.size() == this.partMap.size()) continue;
                    for (int i = 0; i < this.partMap.size(); ++i) {
                        int p = this.partMap.partitionAt(i);
                        if (this.doneParts.contains(p)) continue;
                        this.log.warning("Some partition entries were missed during historical rebalance [grp=" + this.grp + ", part=" + p + ", missed=" + (this.partMap.updateCounterAt(i) - this.rebalancedCntrs[i]) + ']');
                        this.doneParts.add(p);
                    }
                    return;
                }
            }
            catch (Exception ex) {
                throw new IgniteHistoricalIteratorException(ex);
            }
        }
    }
}

