/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.EntryGetWithTtlResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheLocalConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.local.GridLocalCacheEntry;
import org.apache.ignite.internal.processors.cache.local.GridLocalLockFuture;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridLocalCache<K, V>
extends GridCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private GridCachePreloader preldr;

    public GridLocalCache() {
    }

    public GridLocalCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        this.preldr = new GridCachePreloaderAdapter(ctx.group());
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.map == null) {
            this.map = new GridCacheLocalConcurrentMap(this.ctx, this.entryFactory(), DFLT_START_CACHE_SIZE);
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public GridCachePreloader preloader() {
        return this.preldr;
    }

    private GridCacheMapEntryFactory entryFactory() {
        return new GridCacheMapEntryFactory(){

            @Override
            public GridCacheMapEntry create(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key) {
                return new GridLocalCacheEntry(ctx, key);
            }
        };
    }

    @Nullable
    private GridLocalCacheEntry peekExx(KeyCacheObject key) {
        return (GridLocalCacheEntry)this.peekEx(key);
    }

    GridLocalCacheEntry entryExx(KeyCacheObject key) {
        return (GridLocalCacheEntry)this.entryEx(key);
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean invalidate, long createTtl, long accessTtl) {
        return this.lockAllAsync(keys, timeout, tx, CU.empty0());
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<? extends K> keys, long timeout) {
        IgniteTxLocalAdapter tx = this.ctx.tm().localTx();
        return this.lockAllAsync(this.ctx.cacheKeysView(keys), timeout, tx, CU.empty0());
    }

    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, @Nullable IgniteTxLocalEx tx, CacheEntryPredicate[] filter) {
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture<Boolean>(true);
        }
        GridLocalLockFuture fut = new GridLocalLockFuture(this.ctx, keys, tx, this, timeout, filter);
        try {
            if (!fut.addEntries(keys)) {
                return fut;
            }
            if (!this.ctx.mvcc().addFuture(fut)) {
                fut.onError(new IgniteCheckedException("Duplicate future ID (internal error): " + fut));
            }
            fut.checkLocks();
            return fut;
        }
        catch (IgniteCheckedException e) {
            fut.onError(e);
            return fut;
        }
    }

    @Override
    public void unlockAll(Collection<? extends K> keys) throws IgniteCheckedException {
        for (K key : keys) {
            GridLocalCacheEntry entry = this.peekExx(this.ctx.toCacheKeyObject(key));
            if (entry == null || !this.ctx.isAll(entry, CU.empty0())) continue;
            entry.releaseLocal();
            entry.touch();
        }
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        return this.ctx.closures().callLocalSafe(new GridPlainCallable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalCache.this.removeAll();
                return null;
            }
        });
    }

    void onFutureDone(GridLocalLockFuture fut) {
        if (this.ctx.mvcc().removeVersionedFuture(fut) && this.log().isDebugEnabled()) {
            this.log().debug("Explicitly removed future from map of futures: " + fut);
        }
    }

    @Override
    public long localSizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        GridCacheAdapter.PeekModes modes = GridLocalCache.parsePeekModes(peekModes, true);
        modes.primary = true;
        modes.backup = true;
        if (modes.offheap) {
            return this.ctx.offheap().cacheEntriesCount(this.ctx.cacheId());
        }
        if (modes.heap) {
            return this.size();
        }
        return 0L;
    }

    @Override
    public long localSizeLong(int part, CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.localSizeLong(peekModes);
    }

    @Override
    public void preloadPartition(int part) throws IgniteCheckedException {
        this.ctx.offheap().preloadPartition(part);
    }

    @Override
    public IgniteInternalFuture<?> preloadPartitionAsync(final int part) throws IgniteCheckedException {
        return this.ctx.closures().callLocalSafe(new GridPlainCallable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalCache.this.preloadPartition(part);
                return null;
            }
        });
    }

    @Override
    public boolean localPreloadPartition(int part) throws IgniteCheckedException {
        this.ctx.offheap().preloadPartition(part);
        return true;
    }

    @Override
    protected IgniteInternalFuture<Map<K, V>> getAllAsync(@Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, boolean skipVals, boolean needVer) {
        boolean checkTx;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        subjId = this.ctx.subjectIdPerCall(subjId, opCtx);
        boolean readThrough = opCtx == null || !opCtx.skipStore();
        boolean bl = checkTx = !skipTx;
        @Nullable IgniteCacheExpiryPolicy expiry = skipVals ? null : this.expiryPolicy(opCtx != null ? opCtx.expiry() : null);
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        this.warnIfUnordered(keys, GridCacheAdapter.BulkOperation.GET);
        return this.getAllAsync0(this.ctx.cacheKeysView(keys), readThrough, checkTx, subjId, taskName, deserializeBinary, expiry, skipVals, opCtx != null && opCtx.recovery(), needVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <K1, V1> IgniteInternalFuture<Map<K1, V1>> getAllAsync0(final @Nullable Collection<KeyCacheObject> keys, final boolean readThrough, boolean checkTx, @Nullable UUID subjId, String taskName, final boolean deserializeBinary, final @Nullable IgniteCacheExpiryPolicy expiry, final boolean skipVals, final boolean recovery, final boolean needVer) {
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture<Map<K1, V1>>(Collections.emptyMap());
        }
        IgniteTxAdapter tx = null;
        if (checkTx) {
            try {
                this.checkJta();
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture<Map<K1, V1>>(e);
            }
            tx = this.checkCurrentTx();
        }
        if (tx == null || tx.implicit()) {
            Object object;
            HashMap<KeyCacheObject, EntryGetResult> misses = null;
            HashSet<GridCacheEntryEx> newLocalEntries = null;
            this.ctx.shared().database().checkpointReadLock();
            try {
                CacheInvalidStateException ex;
                int keysSize = keys.size();
                GridDhtPartitionsExchangeFuture topFut = this.ctx.shared().exchange().lastFinishedFuture();
                CacheInvalidStateException cacheInvalidStateException = ex = topFut != null ? topFut.validateCache(this.ctx, recovery, true, null, keys) : null;
                if (ex != null) {
                    GridFinishedFuture<Map<K1, V1>> gridFinishedFuture = new GridFinishedFuture<Map<K1, V1>>(ex);
                    return gridFinishedFuture;
                }
                final Map<Object, Object> map = keysSize == 1 ? new IgniteBiTuple() : U.newHashMap(keysSize);
                boolean storeEnabled = !skipVals && readThrough && this.ctx.readThrough();
                boolean readNoEntry = this.ctx.readNoEntry(expiry, false);
                block14: for (KeyCacheObject key : keys) {
                    while (true) {
                        try {
                            EntryGetResult res = null;
                            boolean evt = !skipVals;
                            boolean updateMetrics = !skipVals;
                            GridCacheEntryEx entry = null;
                            boolean skipEntry = readNoEntry;
                            if (readNoEntry) {
                                CacheDataRow row = this.ctx.offheap().read(this.ctx, key);
                                if (row != null) {
                                    long expireTime = row.expireTime();
                                    if (expireTime != 0L) {
                                        if (expireTime > U.currentTimeMillis()) {
                                            res = new EntryGetWithTtlResult(row.value(), row.version(), false, expireTime, 0L);
                                        } else {
                                            skipEntry = false;
                                        }
                                    } else {
                                        res = new EntryGetResult(row.value(), row.version(), false);
                                    }
                                }
                                if (res != null) {
                                    if (evt) {
                                        this.ctx.events().readEvent(key, null, null, row.value(), subjId, taskName, !deserializeBinary);
                                    }
                                    if (updateMetrics && this.ctx.statisticsEnabled()) {
                                        this.ctx.cache().metrics0().onRead(true);
                                    }
                                } else if (storeEnabled) {
                                    skipEntry = false;
                                }
                            }
                            if (!skipEntry) {
                                boolean isNewLocalEntry = this.map.getEntry(this.ctx, key) == null;
                                entry = this.entryEx(key);
                                if (entry == null) {
                                    if (skipVals || !this.ctx.statisticsEnabled()) continue block14;
                                    this.ctx.cache().metrics0().onRead(false);
                                    continue block14;
                                }
                                if (isNewLocalEntry) {
                                    if (newLocalEntries == null) {
                                        newLocalEntries = new HashSet<GridCacheEntryEx>();
                                    }
                                    newLocalEntries.add(entry);
                                }
                                if (storeEnabled) {
                                    res = entry.innerGetAndReserveForLoad(updateMetrics, evt, subjId, taskName, expiry, !deserializeBinary, null);
                                    assert (res != null);
                                    if (res.value() == null) {
                                        if (misses == null) {
                                            misses = new HashMap<KeyCacheObject, EntryGetResult>();
                                        }
                                        misses.put(key, res);
                                        res = null;
                                    }
                                } else {
                                    res = entry.innerGetVersioned(null, null, updateMetrics, evt, subjId, null, taskName, expiry, !deserializeBinary, null);
                                    if (res == null) {
                                        entry.touch();
                                    }
                                }
                            }
                            if (res == null) continue block14;
                            this.ctx.addResult(map, key, res, skipVals, false, deserializeBinary, true, needVer);
                            if (entry != null && (tx == null || !tx.implicit() && tx.isolation() == TransactionIsolation.READ_COMMITTED)) {
                                entry.touch();
                            }
                            if (keysSize != 1) continue block14;
                            GridFinishedFuture<Map<K1, V1>> gridFinishedFuture = new GridFinishedFuture<Map<K1, V1>>(map);
                            return gridFinishedFuture;
                        }
                        catch (GridCacheEntryRemovedException ignored) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Got removed entry in getAllAsync(..) method (will retry): " + key);
                            continue;
                        }
                        break;
                    }
                }
                if (storeEnabled && misses != null) {
                    final HashMap<KeyCacheObject, EntryGetResult> loadKeys = misses;
                    IgniteTxAdapter tx0 = tx;
                    final HashSet loaded = new HashSet();
                    GridEmbeddedFuture gridEmbeddedFuture = new GridEmbeddedFuture(this.ctx.closures().callLocalSafe(this.ctx.projectSafe(new GPC<Map<K1, V1>>((IgniteTxLocalAdapter)tx0){
                        final /* synthetic */ IgniteTxLocalAdapter val$tx0;
                        {
                            this.val$tx0 = igniteTxLocalAdapter;
                        }

                        @Override
                        public Map<K1, V1> call() throws Exception {
                            GridLocalCache.this.ctx.store().loadAll(null, loadKeys.keySet(), (IgniteBiInClosure<KeyCacheObject, Object>)new CI2<KeyCacheObject, Object>(){

                                @Override
                                public void apply(KeyCacheObject key, Object val) {
                                    EntryGetResult res = (EntryGetResult)loadKeys.get(key);
                                    if (res == null || val == null) {
                                        return;
                                    }
                                    loaded.add(key);
                                    CacheObject cacheVal = GridLocalCache.this.ctx.toCacheObject(val);
                                    while (true) {
                                        GridCacheEntryEx entry = null;
                                        try {
                                            GridLocalCache.this.ctx.shared().database().ensureFreeSpace(GridLocalCache.this.ctx.dataRegion());
                                        }
                                        catch (IgniteCheckedException e) {
                                            throw new GridClosureException(e);
                                        }
                                        GridLocalCache.this.ctx.shared().database().checkpointReadLock();
                                        try {
                                            entry = GridLocalCache.this.entryEx(key);
                                            entry.unswap();
                                            GridCacheVersion newVer = GridLocalCache.this.nextVersion();
                                            EntryGetResult verVal = entry.versionedValue(cacheVal, res.version(), newVer, expiry, null);
                                            if (GridLocalCache.this.log.isDebugEnabled()) {
                                                GridLocalCache.this.log.debug("Set value loaded from store into entry [oldVer=" + res.version() + ", newVer=" + verVal.version() + ", entry=" + entry + ']');
                                            }
                                            if (verVal.value() != null) {
                                                GridLocalCache.this.ctx.addResult(map, key, verVal, skipVals, false, deserializeBinary, true, needVer);
                                            } else {
                                                GridLocalCache.this.ctx.addResult(map, key, new EntryGetResult(cacheVal, res.version()), skipVals, false, deserializeBinary, false, needVer);
                                            }
                                            if (val$tx0 != null && (val$tx0.implicit() || val$tx0.isolation() != TransactionIsolation.READ_COMMITTED)) break;
                                            entry.touch();
                                        }
                                        catch (GridCacheEntryRemovedException ignore) {
                                            if (!GridLocalCache.this.log.isDebugEnabled()) continue;
                                            GridLocalCache.this.log.debug("Got removed entry during getAllAsync (will retry): " + entry);
                                            continue;
                                        }
                                        catch (IgniteCheckedException e) {
                                            throw new GridClosureException(e);
                                        }
                                        finally {
                                            GridLocalCache.this.ctx.shared().database().checkpointReadUnlock();
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            });
                            GridLocalCache.this.clearReservationsIfNeeded(loadKeys, loaded, this.val$tx0);
                            return map;
                        }
                    }), true), new C2<Map<K, V>, Exception, IgniteInternalFuture<Map<K, V>>>((IgniteTxLocalAdapter)tx0){
                        final /* synthetic */ IgniteTxLocalAdapter val$tx0;
                        {
                            this.val$tx0 = igniteTxLocalAdapter;
                        }

                        @Override
                        public IgniteInternalFuture<Map<K, V>> apply(Map<K, V> map, Exception e) {
                            if (e != null) {
                                GridLocalCache.this.clearReservationsIfNeeded(loadKeys, loaded, this.val$tx0);
                                return new GridFinishedFuture(e);
                            }
                            if (this.val$tx0 == null || !this.val$tx0.implicit() && this.val$tx0.isolation() == TransactionIsolation.READ_COMMITTED) {
                                HashSet notFound = new HashSet(loadKeys.keySet());
                                notFound.removeAll(loaded);
                                for (KeyCacheObject key : notFound) {
                                    GridCacheEntryEx entry = GridLocalCache.this.peekEx(key);
                                    if (entry == null) continue;
                                    entry.touch();
                                }
                            }
                            return new GridFinishedFuture(Collections.emptyMap());
                        }
                    }, new C2<Map<K1, V1>, Exception, Map<K1, V1>>(){

                        @Override
                        public Map<K1, V1> apply(Map<K1, V1> loaded, Exception e) {
                            if (e == null) {
                                map.putAll(loaded);
                            }
                            return map;
                        }
                    });
                    return gridEmbeddedFuture;
                }
                assert (misses == null);
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture(map);
                return gridFinishedFuture;
            }
            catch (AssertionError | RuntimeException e) {
                if (misses != null) {
                    for (KeyCacheObject key0 : misses.keySet()) {
                        GridCacheEntryEx entry = this.peekEx(key0);
                        if (entry == null) continue;
                        entry.touch();
                    }
                }
                if (newLocalEntries != null) {
                    for (GridCacheEntryEx entry : newLocalEntries) {
                        this.removeEntry(entry);
                    }
                }
                object = new GridFinishedFuture((Throwable)e);
                return object;
            }
            catch (IgniteCheckedException e) {
                object = new GridFinishedFuture(e);
                return object;
            }
            finally {
                this.ctx.shared().database().checkpointReadUnlock();
            }
        }
        return this.asyncOp((GridNearTxLocal)tx, new GridCacheAdapter.AsyncOp<Map<K1, V1>>(keys){

            @Override
            public IgniteInternalFuture<Map<K1, V1>> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                return tx.getAllAsync(GridLocalCache.this.ctx, readyTopVer, keys, deserializeBinary, skipVals, false, !readThrough, recovery, needVer);
            }
        }, this.ctx.operationContextPerCall(), false);
    }

    @Override
    public GridCacheVersion nextVersion() {
        return this.ctx.versions().next(this.ctx.shared().kernalContext().discovery().topologyVersion());
    }
}

