/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridNearOptimisticSerializableTxPrepareFuture
extends GridNearOptimisticTxPrepareFutureAdapter {
    @GridToStringExclude
    private ClientRemapFuture remapFut;
    private int miniId;

    public GridNearOptimisticSerializableTxPrepareFuture(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.optimistic() && tx.serializable()) : tx;
    }

    @Override
    protected boolean ignoreFailure(Throwable err) {
        return IgniteCheckedException.class.isAssignableFrom(err.getClass());
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        IgniteTxEntry txEntry;
        if (log.isDebugEnabled()) {
            log.debug("Transaction future received owner changed callback: " + entry);
        }
        if ((entry.context().isNear() || entry.context().isLocal()) && owner != null && (txEntry = this.tx.entry(entry.txKey())) != null) {
            GridCacheVersion serReadVer;
            if (entry.context().isLocal() && (serReadVer = txEntry.entryReadVersion()) != null) {
                GridCacheContext ctx = entry.context();
                while (true) {
                    try {
                        if (entry.checkSerializableReadVersion(serReadVer)) break;
                        Object key = entry.key().value(ctx.cacheObjectContext(), false);
                        IgniteTxOptimisticCheckedException err0 = new IgniteTxOptimisticCheckedException(S.toString("Failed to prepare transaction, read/write conflict", "key", key, true, "cache", (Object)ctx.name(), false));
                        ERR_UPD.compareAndSet(this, null, err0);
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        entry = ctx.cache().entryEx(entry.key(), this.tx.topologyVersion());
                        txEntry.cached(entry);
                        continue;
                    }
                    break;
                }
            }
            if (this.keyLockFut != null) {
                this.keyLockFut.onKeyLocked(entry.txKey());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).primary().id().equals(nodeId)) continue;
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Remote node left grid: " + nodeId);
            e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
            f.onNodeLeft(e);
            found = true;
        }
        return found;
    }

    private void onError(@Nullable GridDistributedTxMapping m4, Throwable e) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.span);){
            if ((X.hasCause(e, ClusterTopologyCheckedException.class) || X.hasCause(e, ClusterTopologyException.class)) && this.tx.onePhaseCommit()) {
                this.tx.markForBackupCheck();
                this.onComplete();
                return;
            }
            if (e instanceof IgniteTxOptimisticCheckedException && m4 != null) {
                this.tx.removeMapping(m4.primary().id());
            }
            this.prepareError(e);
        }
    }

    private void prepareError(Throwable e) {
        ERR_UPD.compareAndSet(this, null, e);
        if (this.keyLockFut != null) {
            this.keyLockFut.onDone(e);
        }
    }

    @Override
    public void onResult(UUID nodeId, GridNearTxPrepareResponse res) {
        MiniFuture mini;
        if (!this.isDone() && (mini = this.miniFuture(res.miniId())) != null) {
            mini.onResult(res, true);
        }
    }

    @Override
    public boolean onDone(IgniteInternalTx t2, Throwable err) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.span);){
            if (this.isDone()) {
                boolean bl = false;
                return bl;
            }
            if (err != null) {
                ERR_UPD.compareAndSet(this, null, err);
                if (this.keyLockFut != null) {
                    this.keyLockFut.onDone(err);
                }
            }
            boolean bl = this.onComplete();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        this.compoundsReadLock();
        try {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || (mini = (MiniFuture)fut).futureId() != miniId) continue;
                if (!mini.isDone()) {
                    MiniFuture miniFuture = mini;
                    return miniFuture;
                }
                MiniFuture miniFuture = null;
                return miniFuture;
            }
        }
        finally {
            this.compoundsReadUnlock();
        }
        return null;
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private boolean onComplete() {
        Throwable err0 = this.err;
        if (!(this.tx.onePhaseCommit() && this.tx.mappings().get(this.cctx.localNodeId()) != null || err0 != null && !this.tx.needCheckBackup())) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(this.tx, err0)) {
            GridCacheMvccManager mvcc;
            if (err0 != null) {
                this.tx.setRollbackOnly();
            }
            if ((mvcc = this.cctx.mvcc()) != null) {
                mvcc.removeVersionedFuture(this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepare0(boolean remap, boolean topLocked) {
        boolean txStateCheck;
        boolean bl = remap ? this.tx.state() == TransactionState.PREPARING : (txStateCheck = this.tx.state(TransactionState.PREPARING));
        if (!txStateCheck) {
            if (this.tx.isRollbackOnly() || this.tx.setRollbackOnly()) {
                if (this.tx.timedOut()) {
                    this.onDone(null, (Throwable)this.tx.timeoutException());
                } else {
                    this.onDone(null, (Throwable)this.tx.rollbackException());
                }
            } else {
                this.onDone(null, (Throwable)new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
            }
            return;
        }
        boolean set = this.cctx.tm().setTxTopologyHint(this.tx.topologyVersionSnapshot());
        try {
            this.prepare(this.tx.readEntries(), this.tx.writeEntries(), remap, topLocked);
            this.markInitialized();
        }
        finally {
            if (set) {
                this.cctx.tm().setTxTopologyHint(null);
            }
        }
    }

    private void prepare(Iterable<IgniteTxEntry> reads, Iterable<IgniteTxEntry> writes, boolean remap, boolean topLocked) {
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        assert (topVer.topologyVersion() > 0L);
        GridDhtTxMapping txMapping = new GridDhtTxMapping();
        HashMap<UUID, GridDistributedTxMapping> mappings = new HashMap<UUID, GridDistributedTxMapping>();
        boolean hasNearCache = false;
        for (IgniteTxEntry igniteTxEntry : writes) {
            this.map(igniteTxEntry, topVer, mappings, txMapping, remap, topLocked);
            if (!igniteTxEntry.context().isNear()) continue;
            hasNearCache = true;
        }
        for (IgniteTxEntry igniteTxEntry : reads) {
            this.map(igniteTxEntry, topVer, mappings, txMapping, remap, topLocked);
            if (!igniteTxEntry.context().isNear()) continue;
            hasNearCache = true;
        }
        if (this.keyLockFut != null) {
            this.keyLockFut.onAllKeysAdded();
        }
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Abandoning (re)map because future is done: " + this);
            }
            return;
        }
        this.tx.addEntryMapping(mappings.values());
        this.recheckPendingLocks();
        this.tx.transactionNodes(txMapping.transactionNodes());
        if (!hasNearCache) {
            this.checkOnePhase(txMapping);
        }
        MiniFuture locNearEntriesFut = null;
        for (GridDistributedTxMapping m4 : mappings.values()) {
            assert (!m4.empty());
            MiniFuture fut = new MiniFuture(this, m4, ++this.miniId);
            this.add(fut);
            if (!m4.primary().isLocal() || !m4.hasNearCacheEntries() || !m4.hasColocatedCacheEntries()) continue;
            assert (locNearEntriesFut == null);
            locNearEntriesFut = fut;
            this.add(new MiniFuture(this, m4, ++this.miniId));
        }
        Collection collection = this.futures();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            MiniFuture fut;
            IgniteCheckedException err;
            IgniteInternalFuture fut0 = it.next();
            if (this.skipFuture(remap, fut0) || (err = this.prepare(fut = (MiniFuture)fut0, txMapping.transactionNodes(), locNearEntriesFut)) == null) continue;
            while (it.hasNext()) {
                fut0 = it.next();
                if (this.skipFuture(remap, fut0)) continue;
                fut = (MiniFuture)fut0;
                this.tx.removeMapping(fut.mapping().primary().id());
                fut.onResult(new IgniteCheckedException("Failed to prepare transaction.", err));
            }
            break block3;
        }
        this.markInitialized();
    }

    private boolean skipFuture(boolean remap, IgniteInternalFuture<?> fut) {
        return !this.isMini(fut) || remap && ((MiniFuture)fut).rcvRes == 1;
    }

    @Nullable
    private IgniteCheckedException prepare(MiniFuture fut, Map<UUID, Collection<UUID>> txNodes, @Nullable MiniFuture locNearEntriesFut) {
        GridDistributedTxMapping m4 = fut.mapping();
        ClusterNode primary = m4.primary();
        long timeout = this.tx.remainingTime();
        if (timeout == -1L) {
            IgniteCheckedException err = this.tx.timeoutException();
            fut.onResult(err);
            return err;
        }
        if (m4.hasNearCacheEntries()) {
            try {
                this.cctx.tm().prepareTx(this.tx, m4.nearCacheEntries());
            }
            catch (IgniteCheckedException e) {
                fut.onResult(e);
                return e;
            }
        }
        if (primary.isLocal()) {
            if (locNearEntriesFut != null) {
                boolean nearEntries = fut == locNearEntriesFut;
                GridNearTxPrepareRequest req = this.createRequest(txNodes, fut, timeout, nearEntries ? m4.nearEntriesReads() : m4.colocatedEntriesReads(), nearEntries ? m4.nearEntriesWrites() : m4.colocatedEntriesWrites());
                this.prepareLocal(req, fut, nearEntries);
            } else {
                GridNearTxPrepareRequest req = this.createRequest(txNodes, fut, timeout, m4.reads(), m4.writes());
                this.prepareLocal(req, fut, m4.hasNearCacheEntries());
            }
        } else {
            try {
                GridNearTxPrepareRequest req = this.createRequest(txNodes, fut, timeout, m4.reads(), m4.writes());
                this.cctx.io().send(primary, (GridCacheMessage)req, this.tx.ioPolicy());
            }
            catch (ClusterTopologyCheckedException e) {
                e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                fut.onNodeLeft(e);
                return e;
            }
            catch (IgniteCheckedException e) {
                fut.onResult(e);
                return e;
            }
        }
        return null;
    }

    private GridNearTxPrepareRequest createRequest(Map<UUID, Collection<UUID>> txNodes, MiniFuture fut, long timeout, Collection<IgniteTxEntry> reads, Collection<IgniteTxEntry> writes) {
        GridDistributedTxMapping m4 = fut.mapping();
        GridNearTxPrepareRequest req = new GridNearTxPrepareRequest(this.futId, this.tx.topologyVersion(), this.tx, timeout, reads, writes, m4.hasNearCacheEntries(), txNodes, m4.last(), this.tx.onePhaseCommit(), this.tx.needReturnValue() && this.tx.implicit(), this.tx.implicitSingle(), m4.explicitLock(), this.tx.subjectId(), this.tx.taskNameHash(), m4.clientFirst(), txNodes.size() == 1, this.tx.activeCachesDeploymentEnabled(), this.tx.txState().recovery());
        for (IgniteTxEntry txEntry : writes) {
            if (txEntry.op() != GridCacheOperation.TRANSFORM) continue;
            req.addDhtVersion(txEntry.txKey(), null);
        }
        req.miniId(fut.futureId());
        return req;
    }

    private void prepareLocal(GridNearTxPrepareRequest req, final MiniFuture fut, final boolean nearEntries) {
        IgniteInternalFuture<GridNearTxPrepareResponse> prepFut = nearEntries ? this.cctx.tm().txHandler().prepareNearTxLocal(this.tx, req) : this.cctx.tm().txHandler().prepareColocatedTx(this.tx, req);
        prepFut.listen((IgniteInClosure<IgniteInternalFuture<GridNearTxPrepareResponse>>)new CI1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

            @Override
            public void apply(IgniteInternalFuture<GridNearTxPrepareResponse> prepFut) {
                try {
                    fut.onResult(prepFut.get(), nearEntries);
                }
                catch (IgniteCheckedException e) {
                    fut.onResult(e);
                }
            }
        });
    }

    private void map(IgniteTxEntry entry, AffinityTopologyVersion topVer, Map<UUID, GridDistributedTxMapping> curMapping, GridDhtTxMapping txMapping, boolean remap, boolean topLocked) {
        GridDistributedTxMapping cur;
        List<ClusterNode> nodes;
        GridCacheContext<?, ?> cacheCtx = entry.context();
        List<ClusterNode> list = nodes = cacheCtx.isLocal() ? cacheCtx.affinity().nodesByKey(entry.key(), topVer) : cacheCtx.topology().nodes(cacheCtx.affinity().partition(entry.key()), topVer);
        if (F.isEmpty(nodes)) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys to nodes (partition is not mapped to any node) [key=" + entry.key() + ", partition=" + cacheCtx.affinity().partition(entry.key()) + ", topVer=" + topVer + ']'));
            return;
        }
        txMapping.addMapping(nodes);
        ClusterNode primary = F.first(nodes);
        assert (primary != null);
        if (log.isDebugEnabled()) {
            log.debug("Mapped key to primary node [key=" + entry.key() + ", part=" + cacheCtx.affinity().partition(entry.key()) + ", primary=" + U.toShortString(primary) + ", topVer=" + topVer + ']');
        }
        if (cacheCtx.isNear()) {
            entry.cached(cacheCtx.nearTx().entryExx(entry.key(), topVer));
        } else if (!cacheCtx.isLocal()) {
            entry.cached(cacheCtx.colocated().entryExx(entry.key(), topVer, true));
        } else {
            entry.cached(cacheCtx.local().entryEx(entry.key(), topVer));
        }
        if (!remap && (cacheCtx.isNear() || cacheCtx.isLocal()) && entry.explicitVersion() == null) {
            if (this.keyLockFut == null) {
                this.keyLockFut = new GridNearOptimisticTxPrepareFutureAdapter.KeyLockFuture();
                this.add(this.keyLockFut);
            }
            this.keyLockFut.addLockKey(entry.txKey());
        }
        if ((cur = curMapping.get(primary.id())) == null) {
            cur = new GridDistributedTxMapping(primary);
            curMapping.put(primary.id(), cur);
            cur.clientFirst(!topLocked && this.cctx.kernalContext().clientNode());
            cur.last(true);
        }
        if (primary.isLocal()) {
            if (cacheCtx.isNear()) {
                this.tx.nearLocallyMapped(true);
            } else if (cacheCtx.isColocated()) {
                this.tx.colocatedLocallyMapped(true);
            }
        }
        cur.add(entry);
        if (entry.explicitVersion() != null) {
            this.tx.markExplicit(primary.id());
            cur.markExplicitLock();
        }
        entry.nodeId(primary.id());
        if (cacheCtx.isNear()) {
            while (true) {
                try {
                    GridNearCacheEntry cached = (GridNearCacheEntry)entry.cached();
                    cached.dhtNodeId(this.tx.xidVersion(), primary.id());
                }
                catch (GridCacheEntryRemovedException ignore) {
                    entry.cached(cacheCtx.near().entryEx(entry.key(), topVer));
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (GridNearOptimisticSerializableTxPrepareFuture.this.isMini(f)) {
                    return "[node=" + ((MiniFuture)f).primary().id() + ", loc=" + ((MiniFuture)f).primary().isLocal() + ", done=" + f.isDone() + ", err=" + f.error() + "]";
                }
                return f.toString();
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearOptimisticSerializableTxPrepareFuture.class, this, "innerFuts", futs, "remap", (Object)(this.remapFut != null ? 1 : 0), "tx", (Object)this.tx, "super", (Object)super.toString());
    }

    private static class MiniFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        private static final AtomicIntegerFieldUpdater<MiniFuture> RCV_RES_UPD = AtomicIntegerFieldUpdater.newUpdater(MiniFuture.class, "rcvRes");
        private final int futId;
        private final GridNearOptimisticSerializableTxPrepareFuture parent;
        @GridToStringInclude
        private GridDistributedTxMapping m;
        private volatile int rcvRes;

        MiniFuture(GridNearOptimisticSerializableTxPrepareFuture parent, GridDistributedTxMapping m4, int futId) {
            this.parent = parent;
            this.m = m4;
            this.futId = futId;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode primary() {
            return this.m.primary();
        }

        public GridDistributedTxMapping mapping() {
            return this.m;
        }

        void onResult(Throwable e) {
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                this.parent.onError(this.m, e);
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
                }
                this.onDone(e);
            } else {
                U.warn(GridNearTxPrepareFutureAdapter.log, "Received error after another result has been processed [fut=" + this.parent + ", mini=" + this + ']', e);
            }
        }

        void onNodeLeft(ClusterTopologyCheckedException e) {
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("Remote node left grid while sending or waiting for reply (will not retry): " + this);
                }
                this.parent.onError(null, e);
                this.onDone(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(final GridNearTxPrepareResponse res, boolean updateMapping) {
            if (this.isDone()) {
                return;
            }
            if (RCV_RES_UPD.compareAndSet(this, 0, 1)) {
                if (res.error() != null) {
                    this.parent.onError(this.m, res.error());
                    this.onDone(res.error());
                } else if (res.clientRemapVersion() != null) {
                    assert (this.parent.cctx.kernalContext().clientNode());
                    assert (this.m.clientFirst());
                    this.parent.tx.removeMapping(this.m.primary().id());
                    ClientRemapFuture remapFut0 = null;
                    GridNearOptimisticSerializableTxPrepareFuture gridNearOptimisticSerializableTxPrepareFuture = this.parent;
                    synchronized (gridNearOptimisticSerializableTxPrepareFuture) {
                        if (this.parent.remapFut == null) {
                            this.parent.remapFut = new ClientRemapFuture();
                            remapFut0 = this.parent.remapFut;
                        }
                    }
                    if (remapFut0 != null) {
                        Collection futs = this.parent.futures();
                        for (IgniteInternalFuture fut : futs) {
                            if (!this.parent.isMini(fut) || fut == this) continue;
                            remapFut0.add((MiniFuture)fut);
                        }
                        remapFut0.markInitialized();
                        remapFut0.listen(new CI1<IgniteInternalFuture<Boolean>>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void apply(IgniteInternalFuture<Boolean> remapFut0) {
                                block10: {
                                    try {
                                        IgniteInternalFuture<AffinityTopologyVersion> affFut = ((MiniFuture)this).parent.cctx.exchange().affinityReadyFuture(res.clientRemapVersion());
                                        if (affFut == null) {
                                            affFut = new GridFinishedFuture<AffinityTopologyVersion>();
                                        }
                                        if (((Boolean)parent.remapFut.get()).booleanValue()) {
                                            if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                                                GridNearTxPrepareFutureAdapter.log.debug("Will remap client tx [fut=" + parent + ", topVer=" + res.topologyVersion() + ']');
                                            }
                                            GridNearOptimisticSerializableTxPrepareFuture gridNearOptimisticSerializableTxPrepareFuture = parent;
                                            synchronized (gridNearOptimisticSerializableTxPrepareFuture) {
                                                assert (remapFut0 == parent.remapFut);
                                                parent.remapFut = null;
                                            }
                                            ((MiniFuture)this).parent.cctx.time().waitAsync(affFut, ((MiniFuture)this).parent.tx.remainingTime(), new IgniteBiInClosure<IgniteCheckedException, Boolean>(){

                                                @Override
                                                public void apply(IgniteCheckedException e, Boolean timedOut) {
                                                    if (parent.errorOrTimeoutOnTopologyVersion(e, timedOut)) {
                                                        return;
                                                    }
                                                    this.remap(res);
                                                }
                                            });
                                            break block10;
                                        }
                                        ClusterTopologyCheckedException err0 = new ClusterTopologyCheckedException("Cluster topology changed while client transaction is preparing.");
                                        err0.retryReadyFuture(affFut);
                                        parent.prepareError(err0);
                                        this.onDone(err0);
                                    }
                                    catch (IgniteCheckedException e) {
                                        if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                                            GridNearTxPrepareFutureAdapter.log.debug("Prepare failed, will not remap tx: " + parent);
                                        }
                                        parent.prepareError(e);
                                        this.onDone(e);
                                    }
                                }
                            }
                        });
                    } else {
                        this.onDone(res);
                    }
                } else {
                    this.parent.onPrepareResponse(this.m, res, updateMapping);
                    this.onDone(this.parent.cctx.kernalContext().clientNode() ? res : null);
                }
            }
        }

        private void remap(final GridNearTxPrepareResponse res) {
            if (this.parent.tx.isRollbackOnly()) {
                this.onDone(new IgniteTxRollbackCheckedException("Failed to prepare the transaction, due to the transaction is marked as rolled back [tx=" + CU.txString(this.parent.tx) + ']'));
                return;
            }
            this.parent.prepareOnTopology(true, new Runnable(){

                @Override
                public void run() {
                    this.onDone(res);
                }
            });
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", (Object)this.isCancelled(), "err", (Object)this.error());
        }
    }

    private static class ClientRemapFutureReducer
    implements IgniteReducer<GridNearTxPrepareResponse, Boolean> {
        private static final long serialVersionUID = 0L;
        private boolean remap = true;

        private ClientRemapFutureReducer() {
        }

        @Override
        public boolean collect(@Nullable GridNearTxPrepareResponse res) {
            assert (res != null);
            if (res.clientRemapVersion() == null) {
                this.remap = false;
            }
            return true;
        }

        @Override
        public Boolean reduce() {
            return this.remap;
        }
    }

    private static class ClientRemapFuture
    extends GridCompoundFuture<GridNearTxPrepareResponse, Boolean> {
        private static final long serialVersionUID = 0L;

        ClientRemapFuture() {
            super(new ClientRemapFutureReducer());
        }
    }
}

