/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTransactionalCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

public class GridDhtCache<K, V>
extends GridDhtTransactionalCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private GridNearTransactionalCache<K, V> near;

    public GridDhtCache() {
    }

    public GridDhtCache(GridCacheContext<K, V> ctx) {
        super(ctx);
    }

    public GridDhtCache(GridCacheContext<K, V> ctx, GridCacheConcurrentMap map) {
        super(ctx, map);
    }

    @Override
    public boolean isDht() {
        return true;
    }

    @Override
    public String name() {
        String name = super.name();
        return name == null ? "defaultDhtCache" : name + "Dht";
    }

    @Override
    public void start() throws IgniteCheckedException {
        assert (this.metrics != null) : "Cache metrics instance isn't initialized.";
        this.metrics.delegate(this.ctx.dht().near().metrics0());
        this.ctx.dr().resetMetrics();
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(@Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, boolean skipVals, boolean needVer) {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        boolean readThrough = opCtx == null || !opCtx.skipStore();
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        this.warnIfUnordered(keys, GridCacheAdapter.BulkOperation.GET);
        return this.getAllAsync0(this.ctx.cacheKeysView(keys), null, readThrough, subjId, taskName, deserializeBinary, null, skipVals, false, opCtx != null && opCtx.recovery(), needVer, null, null, false);
    }

    @Override
    public GridNearTransactionalCache<K, V> near() {
        return this.near;
    }

    public void near(GridNearTransactionalCache<K, V> near) {
        this.near = near;
    }
}

