/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridDistributedCacheEntry
extends GridCacheMapEntry {
    private volatile List<GridCacheMvccCandidate> rmts = Collections.emptyList();

    public GridDistributedCacheEntry(GridCacheContext ctx, KeyCacheObject key) {
        super(ctx, key);
    }

    private void refreshRemotes() {
        GridCacheMvcc mvcc = this.mvccExtras();
        this.rmts = mvcc == null ? Collections.emptyList() : mvcc.remoteCandidates(new GridCacheVersion[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridCacheMvccCandidate addLocal(long threadId, GridCacheVersion ver, AffinityTopologyVersion topVer, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException {
        CacheObject val;
        CacheLockCandidates owner;
        GridCacheMvccCandidate cand;
        CacheLockCandidates prev;
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            prev = mvcc.allOwners();
            boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
            cand = mvcc.addLocal(this, threadId, ver, timeout, reenter, tx, implicitSingle, read);
            if (cand != null) {
                cand.topologyVersion(topVer);
            }
            owner = mvcc.allOwners();
            boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
            this.checkCallbacks(emptyBefore, emptyAfter);
            val = this.val;
            if (emptyAfter) {
                this.mvccExtras(null);
            }
        }
        finally {
            this.unlockEntry();
        }
        if (cand != null && !cand.reentry()) {
            this.cctx.mvcc().addNext(this.cctx, cand);
        }
        this.checkOwnerChanged(prev, owner, val);
        return cand;
    }

    @Override
    public Collection<GridCacheMvccCandidate> remoteMvccSnapshot(GridCacheVersion ... exclude) {
        List<GridCacheMvccCandidate> rmts = this.rmts;
        if (rmts.isEmpty() || F.isEmpty(exclude)) {
            return rmts;
        }
        ArrayList<GridCacheMvccCandidate> cands = new ArrayList<GridCacheMvccCandidate>(rmts.size());
        for (GridCacheMvccCandidate c : rmts) {
            assert (!c.reentry());
            if (U.containsObjectArray(exclude, c.version(), new Object[0])) continue;
            cands.add(c);
        }
        return cands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemote(UUID nodeId, @Nullable UUID otherNodeId, long threadId, GridCacheVersion ver, boolean tx, boolean implicitSingle, @Nullable GridCacheVersion owned) throws GridDistributedLockCancelledException, GridCacheEntryRemovedException {
        CacheObject val;
        CacheLockCandidates owner;
        CacheLockCandidates prev;
        this.lockEntry();
        try {
            this.checkRemoved(ver);
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            prev = mvcc.allOwners();
            boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
            mvcc.addRemote(this, nodeId, otherNodeId, threadId, ver, tx, implicitSingle, false);
            if (owned != null) {
                mvcc.markOwned(ver, owned);
            }
            owner = mvcc.allOwners();
            boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
            this.checkCallbacks(emptyBefore, emptyAfter);
            val = this.val;
            this.refreshRemotes();
            if (emptyAfter) {
                this.mvccExtras(null);
            }
        }
        finally {
            this.unlockEntry();
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitNodeLocks(UUID nodeId) throws GridCacheEntryRemovedException {
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        CacheObject val = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                owner = mvcc.removeExplicitNodeCandidates(nodeId);
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                val = this.val;
                this.refreshRemotes();
                if (emptyAfter) {
                    this.mvccExtras(null);
                }
            }
        }
        finally {
            this.unlockEntry();
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridCacheMvccCandidate removeLock() {
        CacheObject val;
        GridCacheMvccCandidate rmvd = null;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.cctx.tm().detectPossibleCollidingKeys(this);
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                rmvd = mvcc.releaseLocal();
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                } else {
                    owner = mvcc.allOwners();
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        if (log.isDebugEnabled()) {
            log.debug("Released local candidate from entry [owner=" + owner + ", prev=" + prev + ", rmvd=" + rmvd + ", entry=" + this + ']');
        }
        if (prev != null) {
            for (int i = 0; i < prev.size(); ++i) {
                GridCacheMvccCandidate cand = prev.candidate(i);
                this.checkThreadChain(cand);
            }
        }
        this.checkOwnerChanged(prev, owner, val);
        return rmvd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLock(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        CacheObject val;
        GridCacheMvccCandidate doomed;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.cctx.tm().detectPossibleCollidingKeys(this);
        this.lockEntry();
        try {
            GridCacheVersion obsoleteVer;
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = doomed = mvcc == null ? null : mvcc.candidate(ver);
            if (doomed == null) {
                this.addRemoved(ver);
            }
            if ((obsoleteVer = this.obsoleteVersionExtras()) != null && !obsoleteVer.equals(ver)) {
                this.checkObsolete();
            }
            if (doomed != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                mvcc.remove(doomed.version());
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                if (!doomed.local()) {
                    this.refreshRemotes();
                }
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                } else {
                    owner = mvcc.allOwners();
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        if (log.isDebugEnabled()) {
            log.debug("Removed lock candidate from entry [doomed=" + doomed + ", owner=" + owner + ", prev=" + prev + ", entry=" + this + ']');
        }
        if (doomed != null && doomed.nearLocal()) {
            this.cctx.mvcc().removeExplicitLock(doomed);
        }
        if (doomed != null) {
            this.checkThreadChain(doomed);
        }
        this.checkOwnerChanged(prev, owner, val);
        return doomed != null;
    }

    protected void checkRemoved(GridCacheVersion ver) throws GridDistributedLockCancelledException {
        assert (this.lockedByCurrentThread());
        GridCacheVersion obsoleteVer = this.obsoleteVersionExtras();
        if (obsoleteVer != null && obsoleteVer.equals(ver) || this.cctx.mvcc().isRemoved(this.cctx, ver)) {
            throw new GridDistributedLockCancelledException("Lock has been cancelled [key=" + this.key + ", ver=" + ver + ']');
        }
    }

    public boolean addRemoved(GridCacheVersion ver) {
        assert (this.lockedByCurrentThread());
        return this.cctx.mvcc().addRemoved(this.cctx, ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CacheLockCandidates readyLock(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                owner = mvcc.readyLocal(ver);
                assert (owner == null || owner.candidate(0).owner()) : "Owner flag not set for owner: " + owner;
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        this.checkOwnerChanged(prev, owner, val);
        return owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readyNearLock(GridCacheVersion ver, GridCacheVersion mapped, Collection<GridCacheVersion> committed, Collection<GridCacheVersion> rolledBack, Collection<GridCacheVersion> pending) throws GridCacheEntryRemovedException {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                owner = mvcc.readyNearLocal(ver, mapped, committed, rolledBack, pending);
                assert (owner == null || owner.candidate(0).owner()) : "Owner flag is not set for owner: " + owner;
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneRemote(GridCacheVersion lockVer, GridCacheVersion baseVer, @Nullable Collection<GridCacheVersion> pendingVers, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, boolean sysInvalidate) throws GridCacheEntryRemovedException {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                if (!F.isEmpty(committedVers) || !F.isEmpty(rolledbackVers)) {
                    mvcc.orderCompleted(lockVer, committedVers, rolledbackVers);
                    if (!baseVer.equals(lockVer)) {
                        mvcc.orderCompleted(baseVer, committedVers, rolledbackVers);
                    }
                }
                if (sysInvalidate && baseVer != null) {
                    mvcc.salvageRemote(baseVer, this.isNear());
                }
                owner = mvcc.doneRemote(lockVer, this.maskNull(pendingVers), this.maskNull(committedVers), this.maskNull(rolledbackVers));
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        this.checkOwnerChanged(prev, owner, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recheck(GridCacheVersion ver) {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner = null;
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                owner = mvcc.recheck();
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        boolean lockedByThreadChainVer = owner != null && owner.hasCandidate(ver);
        this.checkOwnerChanged(prev, owner, val, lockedByThreadChainVer);
        return !lockedByThreadChainVer;
    }

    @Override
    public boolean tmLock(IgniteInternalTx tx, long timeout, @Nullable GridCacheVersion serOrder, GridCacheVersion serReadVer, boolean read) throws GridCacheEntryRemovedException, GridDistributedLockCancelledException {
        if (tx.local()) {
            return this.addLocal(tx.threadId(), tx.xidVersion(), tx.topologyVersion(), timeout, false, true, tx.implicitSingle(), read) != null;
        }
        try {
            this.addRemote(tx.nodeId(), tx.otherNodeId(), tx.threadId(), tx.xidVersion(), true, tx.implicitSingle(), tx.ownedVersion(this.txKey()));
            return true;
        }
        catch (GridDistributedLockCancelledException ignored) {
            if (log.isDebugEnabled()) {
                log.debug("Attempted to enter tx lock for cancelled ID (will ignore): " + tx);
            }
            return false;
        }
    }

    protected void checkCallbacks(boolean emptyBefore, boolean emptyAfter) {
        assert (this.lockedByCurrentThread());
        if (emptyBefore != emptyAfter) {
            if (emptyBefore) {
                this.cctx.mvcc().callback().onLocked(this);
            }
            if (emptyAfter) {
                this.cctx.mvcc().callback().onFreed(this);
            }
        }
    }

    @Override
    protected final void checkThreadChain(GridCacheMvccCandidate owner) {
        assert (!this.lockedByCurrentThread());
        assert (owner != null);
        assert (owner.owner() || owner.used()) : "Neither owner or used flags are set on ready local candidate: " + owner;
        if (owner.local() && owner.next() != null) {
            for (GridCacheMvccCandidate cand = owner.next(); cand != null; cand = cand.next()) {
                GridCacheContext cctx0;
                GridDistributedCacheEntry e;
                assert (cand.local()) : "Remote candidate cannot be part of thread chain: " + cand;
                if (!cand.used() && (cand.owner() || (e = (GridDistributedCacheEntry)(cctx0 = cand.parent().context()).cache().peekEx(cand.parent().key())) == null || e.recheck(owner.version()))) break;
            }
        }
    }

    private Collection<GridCacheVersion> maskNull(Collection<GridCacheVersion> col) {
        return col == null ? Collections.emptyList() : col;
    }

    @Override
    public String toString() {
        return this.toStringWithTryLock(() -> S.toString(GridDistributedCacheEntry.class, this, super.toString()));
    }
}

