/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.objects;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.checker.objects.VersionedKey;
import org.apache.ignite.internal.processors.cache.checker.objects.VersionedValue;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;

public class VersionedEntry
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private VersionedKey key;
    private VersionedValue val;

    public VersionedEntry() {
    }

    public VersionedEntry(UUID nodeId, KeyCacheObject key, GridCacheVersion ver, CacheObject val, long updateCntr, long recheckStartTime) {
        this.key = new VersionedKey(nodeId, key, ver);
        this.val = new VersionedValue(val, ver, updateCntr, recheckStartTime);
    }

    public CacheObject val() {
        return this.val.value();
    }

    public long updateCntr() {
        return this.val.updateCounter();
    }

    public long recheckStartTime() {
        return this.val.recheckStartTime();
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.val);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = (VersionedKey)in.readObject();
        this.val = (VersionedValue)in.readObject();
    }

    public KeyCacheObject key() {
        return this.key.key();
    }

    public UUID nodeId() {
        return this.key.nodeId();
    }

    public GridCacheVersion ver() {
        return this.key.ver();
    }
}

