/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.objects;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationDataRowMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationKeyMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationSkippedEntityHolder;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationValueMeta;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ReconciliationAffectedEntries
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final String HIDDEN_DATA = "*****";
    protected Map<UUID, String> nodesIdsToConsistentIdsMap = new HashMap<UUID, String>();
    private Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> inconsistentKeys = new HashMap<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>>();
    private Set<PartitionReconciliationSkippedEntityHolder<String>> skippedCaches = new HashSet<PartitionReconciliationSkippedEntityHolder<String>>();
    private Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> skippedEntries = new HashMap<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>>();

    public ReconciliationAffectedEntries() {
    }

    public ReconciliationAffectedEntries(Map<UUID, String> nodesIdsToConsistentIdsMap, Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> inconsistentKeys, Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> skippedEntries) {
        this.nodesIdsToConsistentIdsMap = nodesIdsToConsistentIdsMap;
        this.inconsistentKeys = inconsistentKeys;
        this.skippedEntries = skippedEntries;
    }

    public ReconciliationAffectedEntries(Map<UUID, String> nodesIdsToConsistentIdsMap, Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> inconsistentKeys, Set<PartitionReconciliationSkippedEntityHolder<String>> skippedCaches, Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> skippedEntries) {
        this.nodesIdsToConsistentIdsMap = nodesIdsToConsistentIdsMap;
        this.inconsistentKeys = inconsistentKeys;
        this.skippedCaches = skippedCaches;
        this.skippedEntries = skippedEntries;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.nodesIdsToConsistentIdsMap);
        U.writeMap(out, this.inconsistentKeys);
        U.writeCollection(out, this.skippedCaches);
        U.writeMap(out, this.skippedEntries);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodesIdsToConsistentIdsMap = U.readMap(in);
        this.inconsistentKeys = U.readMap(in);
        this.skippedCaches = U.readSet(in);
        this.skippedEntries = U.readMap(in);
    }

    public void print(Consumer<String> printer, boolean includeSensitive) {
        if (this.inconsistentKeys != null && !this.inconsistentKeys.isEmpty()) {
            printer.accept("\nINCONSISTENT KEYS: " + this.inconsistentKeysCount() + "\n\n");
            printer.accept("<cacheName>\n");
            printer.accept("\t<partitionId>\n");
            printer.accept("\t\t<key>\n");
            printer.accept("\t\t\t<nodeConsistentId>, <nodeId>: <value> <version>\n");
            printer.accept("\t\t\t...\n");
            printer.accept("\t\t\t<info on whether confilct is fixed>\n\n");
            printer.accept(this.getConflictsAsString(this.inconsistentKeys, includeSensitive));
        }
        if (this.skippedCaches != null && !this.skippedCaches.isEmpty()) {
            printer.accept("\nSKIPPED CACHES: " + this.skippedCachesCount() + "\n\n");
            for (PartitionReconciliationSkippedEntityHolder<String> skippedCache : this.skippedCaches) {
                String entity = skippedCache.skippedEntity();
                String reason = skippedCache.skippingReason() != null ? ", reason=[" + skippedCache.skippingReason().reason() + ']' : "";
                printer.accept("Following cache was skipped during partition reconciliation check cache=[" + entity + "]" + reason + '\n');
            }
        }
        if (this.skippedEntries != null && !this.skippedEntries.isEmpty()) {
            printer.accept("\nSKIPPED ENTRIES: " + this.skippedEntriesCount() + "\n\n");
            printer.accept(this.skippedEntries(this.skippedEntries, includeSensitive));
        }
    }

    private String skippedEntries(Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> skippedEntries, boolean includeSensitive) {
        StringBuilder res = new StringBuilder();
        for (Map.Entry<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> cacheBoundedSkippedEntries : skippedEntries.entrySet()) {
            String cacheName = cacheBoundedSkippedEntries.getKey();
            for (Map.Entry<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>> partitionBoundedSkippedEntries : cacheBoundedSkippedEntries.getValue().entrySet()) {
                StringBuilder recordBuilder = new StringBuilder();
                Integer part = partitionBoundedSkippedEntries.getKey();
                recordBuilder.append("Following entry was skipped [cache='").append(cacheName).append("'");
                recordBuilder.append(", partition=").append(part);
                for (PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta> skippedEntry : partitionBoundedSkippedEntries.getValue()) {
                    recordBuilder.append(", entry=").append(ReconciliationAffectedEntries.getSkippedAsString(skippedEntry, includeSensitive, false));
                }
                recordBuilder.append("]\n");
                res.append((CharSequence)recordBuilder);
            }
        }
        return res.toString();
    }

    private String getConflictsAsString(Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> keys, boolean includeSensitive) {
        StringBuilder res = new StringBuilder();
        for (Map.Entry<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> cacheEntry : keys.entrySet()) {
            String cacheName = cacheEntry.getKey();
            res.append(cacheName).append('\n');
            for (Map.Entry<Integer, List<PartitionReconciliationDataRowMeta>> partEntry : cacheEntry.getValue().entrySet()) {
                Integer part = partEntry.getKey();
                res.append(this.getConflictsAsString(part, partEntry.getValue(), this.nodesIdsToConsistentIdsMap, includeSensitive));
            }
        }
        return res.toString();
    }

    private String getConflictsAsString(int partId, List<PartitionReconciliationDataRowMeta> rows, Map<UUID, String> nodesIdsToConsistentIdsMap, boolean includeSensitive) {
        StringBuilder res = new StringBuilder();
        res.append('\t').append(partId).append('\n');
        for (PartitionReconciliationDataRowMeta row : rows) {
            res.append(ReconciliationAffectedEntries.getConflictsAsString(row, nodesIdsToConsistentIdsMap, includeSensitive));
        }
        return res.toString();
    }

    public static String getConflictsAsString(PartitionReconciliationDataRowMeta row, Map<UUID, String> nodesIdsToConsistentIdsMap, boolean includeSensitive) {
        StringBuilder res = new StringBuilder();
        res.append("\t\t").append(row.keyMeta().stringView(includeSensitive)).append('\n');
        for (Map.Entry<UUID, PartitionReconciliationValueMeta> valMap : row.valueMeta().entrySet()) {
            res.append("\t\t\t").append(nodesIdsToConsistentIdsMap.get(valMap.getKey())).append(" ").append(U.id8(valMap.getKey())).append(valMap.getValue() != null ? ": " + valMap.getValue().stringView(includeSensitive) : "").append('\n');
        }
        if (row.repairMeta() != null) {
            res.append("\n\t\t\t").append(row.repairMeta().stringView(includeSensitive)).append("\n\n");
        }
        return res.toString();
    }

    public static String getSkippedAsString(PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta> row, boolean includeSensitive, boolean appendIndent) {
        StringBuilder res = new StringBuilder();
        res.append(appendIndent ? "\t\t" : "").append(row.skippedEntity().stringView(includeSensitive)).append(row.skippingReason() != null ? ", reason=" + row.skippingReason().reason() : "").append('\n');
        return res.toString();
    }

    public void merge(ReconciliationAffectedEntries outer) {
        Map map;
        assert (outer != null);
        this.nodesIdsToConsistentIdsMap.putAll(outer.nodesIdsToConsistentIdsMap);
        for (Map.Entry<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> entry : outer.inconsistentKeys.entrySet()) {
            map = this.inconsistentKeys.computeIfAbsent(entry.getKey(), key -> new HashMap());
            for (Map.Entry<Integer, List<PartitionReconciliationDataRowMeta>> listEntry : entry.getValue().entrySet()) {
                map.computeIfAbsent(listEntry.getKey(), k -> new ArrayList()).addAll((Collection)listEntry.getValue());
            }
        }
        for (Map.Entry<String, Map<Integer, Collection<IgniteDataTransferObject>>> entry : outer.skippedEntries.entrySet()) {
            map = this.skippedEntries.computeIfAbsent(entry.getKey(), key -> new HashMap());
            for (Map.Entry<Integer, Collection<IgniteDataTransferObject>> setEntry : entry.getValue().entrySet()) {
                map.computeIfAbsent(setEntry.getKey(), k -> new HashSet()).addAll(setEntry.getValue());
            }
        }
        this.skippedCaches.addAll(outer.skippedCaches);
    }

    public boolean isEmpty() {
        return this.inconsistentKeys.isEmpty() && this.skippedCaches.isEmpty() && this.skippedEntries().isEmpty();
    }

    public Map<UUID, String> nodesIdsToConsistentIdsMap() {
        return this.nodesIdsToConsistentIdsMap;
    }

    public Map<String, Map<Integer, List<PartitionReconciliationDataRowMeta>>> inconsistentKeys() {
        return this.inconsistentKeys;
    }

    public Set<PartitionReconciliationSkippedEntityHolder<String>> skippedCaches() {
        return this.skippedCaches;
    }

    public Map<String, Map<Integer, Set<PartitionReconciliationSkippedEntityHolder<PartitionReconciliationKeyMeta>>>> skippedEntries() {
        return this.skippedEntries;
    }

    public int inconsistentKeysCount() {
        return this.inconsistentKeys.values().stream().flatMap(m4 -> m4.values().stream()).mapToInt(List::size).sum();
    }

    public int skippedCachesCount() {
        return this.skippedCaches.size();
    }

    public int skippedEntriesCount() {
        return this.skippedEntries.values().stream().flatMap(m4 -> m4.values().stream()).mapToInt(Set::size).sum();
    }
}

