/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataFileStore;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataHolder;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataUpdatedListener;
import org.apache.ignite.internal.processors.cache.binary.ClientMetadataRequestFuture;
import org.apache.ignite.internal.processors.cache.binary.MetadataRemoveAcceptedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataRemoveProposedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataRequestMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataResponseMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateAcceptedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateProposedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateResult;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

final class BinaryMetadataTransport {
    public static final int REMOVED_VERSION = -2;
    private final GridDiscoveryManager discoMgr;
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final boolean clientNode;
    private final ConcurrentMap<Integer, BinaryMetadataHolder> metaLocCache;
    private final BinaryMetadataFileStore metadataFileStore;
    private final Queue<MetadataUpdateResultFuture> unlabeledFutures = new ConcurrentLinkedQueue<MetadataUpdateResultFuture>();
    private final ConcurrentMap<SyncKey, MetadataUpdateResultFuture> syncMap = new ConcurrentHashMap<SyncKey, MetadataUpdateResultFuture>();
    private final ConcurrentMap<Integer, GridFutureAdapter<?>> pendingTypeIdMap = new ConcurrentHashMap();
    private final ConcurrentMap<Integer, ClientMetadataRequestFuture> clientReqSyncMap = new ConcurrentHashMap<Integer, ClientMetadataRequestFuture>();
    private final ConcurrentMap<SyncKey, GridFutureAdapter<?>> schemaWaitFuts = new ConcurrentHashMap();
    private final List<BinaryMetadataUpdatedListener> binaryUpdatedLsnrs = new CopyOnWriteArrayList<BinaryMetadataUpdatedListener>();
    private final BinaryContext binCtx;
    private final boolean isPersistenceEnabled;
    private volatile boolean stopping;

    BinaryMetadataTransport(ConcurrentMap<Integer, BinaryMetadataHolder> metaLocCache, BinaryMetadataFileStore metadataFileStore, BinaryContext binCtx, final GridKernalContext ctx, IgniteLogger log) {
        this.metaLocCache = metaLocCache;
        this.metadataFileStore = metadataFileStore;
        this.ctx = ctx;
        this.binCtx = binCtx;
        this.log = log;
        this.discoMgr = ctx.discovery();
        this.clientNode = ctx.clientNode();
        this.isPersistenceEnabled = CU.isPersistenceEnabled(ctx.config()) && !this.clientNode;
        this.discoMgr.setCustomEventListener(MetadataUpdateProposedMessage.class, new MetadataUpdateProposedListener());
        this.discoMgr.setCustomEventListener(MetadataUpdateAcceptedMessage.class, new MetadataUpdateAcceptedListener());
        this.discoMgr.setCustomEventListener(MetadataRemoveProposedMessage.class, new MetadataRemoveProposedListener());
        this.discoMgr.setCustomEventListener(MetadataRemoveAcceptedMessage.class, new MetadataRemoveAcceptedListener());
        GridIoManager ioMgr = ctx.io();
        if (this.clientNode) {
            ioMgr.addMessageListener(GridTopic.TOPIC_METADATA_REQ, (GridMessageListener)new MetadataResponseListener());
        } else {
            ioMgr.addMessageListener(GridTopic.TOPIC_METADATA_REQ, (GridMessageListener)new MetadataRequestListener(ioMgr));
        }
        if (this.clientNode) {
            ctx.event().addLocalEventListener(new GridLocalEventListener(){

                @Override
                public void onEvent(Event evt) {
                    DiscoveryEvent evt0 = (DiscoveryEvent)evt;
                    if (!ctx.isStopping()) {
                        for (ClientMetadataRequestFuture fut : BinaryMetadataTransport.this.clientReqSyncMap.values()) {
                            fut.onNodeLeft(evt0.eventNode().id());
                        }
                    }
                }
            }, 11, 12);
        }
    }

    private static boolean obsoleteUpdate(int locP, int locA, int remP, int remA) {
        return remP < locP || remP == locP && remA < locA;
    }

    void addBinaryMetadataUpdateListener(BinaryMetadataUpdatedListener lsnr) {
        this.binaryUpdatedLsnrs.add(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridFutureAdapter<MetadataUpdateResult> requestMetadataUpdate(BinaryMetadata newMeta) {
        LinkedHashSet<Integer> changedSchemas;
        BinaryMetadata oldMeta;
        MetadataUpdateResultFuture resFut;
        int typeId = newMeta.typeId();
        do {
            BinaryMetadataHolder metaHolder;
            if ((metaHolder = (BinaryMetadataHolder)this.metaLocCache.get(typeId)) != null && metaHolder.removing()) {
                throw new IgniteException("The metadata is removing for type [typeId=" + typeId + ']');
            }
            oldMeta = Optional.ofNullable(metaHolder).map(BinaryMetadataHolder::metadata).orElse(null);
            BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta, null);
            if (mergedMeta != oldMeta) continue;
            if (metaHolder.pendingVersion() == metaHolder.acceptedVersion()) {
                return null;
            }
            return this.awaitMetadataUpdate(typeId, metaHolder.pendingVersion());
        } while (!this.putAndWaitPendingUpdate(typeId, resFut = new MetadataUpdateResultFuture(typeId)));
        BinaryMetadataHolder metadataHolder = (BinaryMetadataHolder)this.metaLocCache.get(typeId);
        oldMeta = Optional.ofNullable(metadataHolder).map(BinaryMetadataHolder::metadata).orElse(null);
        BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta, changedSchemas = new LinkedHashSet<Integer>());
        if (mergedMeta == oldMeta) {
            resFut.onDone(MetadataUpdateResult.createSuccessfulResult(-1));
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Requesting metadata update [typeId=" + typeId + ", typeName=" + mergedMeta.typeName() + ", changedSchemas=" + changedSchemas + ", holder=" + metadataHolder + ", fut=" + resFut + ']');
        }
        try {
            BinaryMetadataTransport binaryMetadataTransport = this;
            synchronized (binaryMetadataTransport) {
                this.unlabeledFutures.add(resFut);
                if (!this.stopping) {
                    this.discoMgr.sendCustomEvent(new MetadataUpdateProposedMessage(mergedMeta, this.ctx.localNodeId()));
                } else {
                    resFut.onDone(MetadataUpdateResult.createUpdateDisabledResult());
                }
            }
        }
        catch (Exception e) {
            resFut.onDone(MetadataUpdateResult.createUpdateDisabledResult(), (Throwable)e);
        }
        if (this.ctx.clientDisconnected()) {
            this.onDisconnected();
        }
        return resFut;
    }

    private boolean putAndWaitPendingUpdate(int typeId, GridFutureAdapter<?> newMetaFut) {
        GridFutureAdapter<?> oldFut = this.pendingTypeIdMap.putIfAbsent(typeId, newMetaFut);
        if (oldFut != null) {
            try {
                oldFut.get();
            }
            catch (IgniteCheckedException ignore) {
                this.log.warning("Pending update metadata process was failed. Trying to update to new metadata.");
            }
            return false;
        }
        return true;
    }

    GridFutureAdapter<MetadataUpdateResult> awaitMetadataUpdate(int typeId, int ver) {
        BinaryMetadataHolder holder;
        SyncKey key = new SyncKey(typeId, ver);
        MetadataUpdateResultFuture resFut = new MetadataUpdateResultFuture(key);
        MetadataUpdateResultFuture oldFut = this.syncMap.putIfAbsent(key, resFut);
        if (oldFut != null) {
            resFut = oldFut;
        }
        if ((holder = (BinaryMetadataHolder)this.metaLocCache.get(typeId)).acceptedVersion() >= ver) {
            resFut.onDone(MetadataUpdateResult.createSuccessfulResult(-1));
        }
        return resFut;
    }

    GridFutureAdapter<MetadataUpdateResult> awaitMetadataRemove(int typeId) {
        SyncKey key = new SyncKey(typeId, -2);
        MetadataUpdateResultFuture resFut = new MetadataUpdateResultFuture(key);
        MetadataUpdateResultFuture oldFut = this.syncMap.putIfAbsent(key, resFut);
        if (oldFut != null) {
            resFut = oldFut;
        }
        if (!this.metaLocCache.containsKey(typeId)) {
            resFut.onDone(MetadataUpdateResult.createSuccessfulResult(-1));
        }
        return resFut;
    }

    GridFutureAdapter<?> awaitSchemaUpdate(int typeId, int schemaId) {
        GridFutureAdapter fut = new GridFutureAdapter();
        GridFutureAdapter oldFut = this.schemaWaitFuts.putIfAbsent(new SyncKey(typeId, schemaId), fut);
        return oldFut == null ? fut : oldFut;
    }

    GridFutureAdapter<MetadataUpdateResult> requestUpToDateMetadata(int typeId) {
        assert (this.ctx.clientNode());
        ClientMetadataRequestFuture newFut = new ClientMetadataRequestFuture(this.ctx, typeId, this.clientReqSyncMap);
        ClientMetadataRequestFuture oldFut = this.clientReqSyncMap.putIfAbsent(typeId, newFut);
        if (oldFut != null) {
            return oldFut;
        }
        newFut.requestMetadata();
        return newFut;
    }

    void stop() {
        this.stopping = true;
        this.cancelFutures(MetadataUpdateResult.createUpdateDisabledResult());
    }

    void onDisconnected() {
        this.cancelFutures(MetadataUpdateResult.createFailureResult(new BinaryObjectException("Failed to update or wait for metadata, client node disconnected")));
    }

    private void cancelFutures(MetadataUpdateResult res) {
        MetadataUpdateResultFuture fut0;
        while ((fut0 = this.unlabeledFutures.poll()) != null) {
            fut0.onDone(res);
        }
        for (GridFutureAdapter fut : this.syncMap.values()) {
            fut.onDone(res);
        }
        for (GridFutureAdapter fut : this.clientReqSyncMap.values()) {
            fut.onDone(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridFutureAdapter<MetadataUpdateResult> requestMetadataRemove(int typeId) {
        MetadataUpdateResultFuture resFut;
        while (!this.putAndWaitPendingUpdate(typeId, resFut = new MetadataUpdateResultFuture(typeId))) {
        }
        try {
            BinaryMetadataTransport binaryMetadataTransport = this;
            synchronized (binaryMetadataTransport) {
                this.unlabeledFutures.add(resFut);
                if (!this.stopping) {
                    this.discoMgr.sendCustomEvent(new MetadataRemoveProposedMessage(typeId, this.ctx.localNodeId()));
                } else {
                    resFut.onDone(MetadataUpdateResult.createUpdateDisabledResult());
                }
            }
        }
        catch (Exception e) {
            resFut.onDone(MetadataUpdateResult.createUpdateDisabledResult(), (Throwable)e);
        }
        if (this.ctx.clientDisconnected()) {
            this.onDisconnected();
        }
        return resFut;
    }

    private void initSyncFor(int typeId, int pendingVer, final MetadataUpdateResultFuture fut) {
        if (this.stopping) {
            fut.onDone(MetadataUpdateResult.createUpdateDisabledResult());
            return;
        }
        SyncKey key = new SyncKey(typeId, pendingVer);
        MetadataUpdateResultFuture oldFut = this.syncMap.putIfAbsent(key, fut);
        if (oldFut != null) {
            oldFut.listen(new IgniteInClosure<IgniteInternalFuture<MetadataUpdateResult>>(){

                @Override
                public void apply(IgniteInternalFuture<MetadataUpdateResult> doneFut) {
                    fut.onDone(doneFut.result(), doneFut.error());
                }
            });
        }
        fut.key(key);
    }

    private boolean casBinaryMetadata(int typeId, BinaryMetadataHolder newHolder) {
        BinaryMetadataHolder oldHolder;
        do {
            if ((oldHolder = this.metaLocCache.putIfAbsent(typeId, newHolder)) == null) {
                return true;
            }
            if (!BinaryMetadataTransport.obsoleteUpdate(oldHolder.pendingVersion(), oldHolder.acceptedVersion(), newHolder.pendingVersion(), newHolder.acceptedVersion())) continue;
            return false;
        } while (!this.metaLocCache.replace(typeId, oldHolder, newHolder));
        return true;
    }

    private final class MetadataRemoveAcceptedListener
    implements CustomEventListener<MetadataRemoveAcceptedMessage> {
        private MetadataRemoveAcceptedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MetadataRemoveAcceptedMessage msg) {
            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                BinaryMetadataTransport.this.log.debug("Received MetadataRemoveAccepted message: " + msg);
            }
            if (msg.duplicated()) {
                return;
            }
            int typeId = msg.typeId();
            if (!BinaryMetadataTransport.this.metaLocCache.containsKey(typeId)) {
                msg.duplicated(true);
                return;
            }
            if (BinaryMetadataTransport.this.isPersistenceEnabled) {
                BinaryMetadataTransport.this.metadataFileStore.removeMetadataAsync(typeId);
            }
            GridFutureAdapter fut = (GridFutureAdapter)BinaryMetadataTransport.this.syncMap.get(new SyncKey(typeId, -2));
            BinaryMetadataTransport.this.metaLocCache.remove(typeId);
            BinaryMetadataTransport.this.binCtx.removeType(typeId);
            if (fut != null) {
                fut.onDone(MetadataUpdateResult.createSuccessfulResult(-2));
            }
        }
    }

    private final class MetadataRemoveProposedListener
    implements CustomEventListener<MetadataRemoveProposedMessage> {
        private MetadataRemoveProposedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MetadataRemoveProposedMessage msg) {
            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                BinaryMetadataTransport.this.log.debug("Received MetadataRemoveProposed message: " + msg);
            }
            int typeId = msg.typeId();
            BinaryMetadataHolder metaHld = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
            assert (metaHld != null) : "No metadata found for typeId: " + typeId;
            if (msg.isOnCoordinator()) {
                if (metaHld == null) {
                    msg.markRejected(new BinaryObjectException("Type not found [typeId=" + typeId + ']'));
                }
                if (metaHld.pendingVersion() != metaHld.acceptedVersion()) {
                    msg.markRejected(new BinaryObjectException("Remove type failed. Type is being updated now [typeId=" + typeId + ", pendingVersion=" + metaHld.pendingVersion() + ", acceptedVersion=" + metaHld.acceptedVersion() + ']'));
                }
                if (metaHld.removing()) {
                    msg.markRejected(new BinaryObjectException("Remove type failed. Type is being removed now [typeId=" + typeId + ']'));
                }
                msg.setOnCoordinator(false);
            }
            MetadataUpdateResultFuture fut = null;
            if (msg.origNodeId().equals(BinaryMetadataTransport.this.ctx.localNodeId())) {
                fut = (MetadataUpdateResultFuture)BinaryMetadataTransport.this.unlabeledFutures.poll();
            }
            if (msg.rejected()) {
                if (fut != null) {
                    fut.onDone(MetadataUpdateResult.createFailureResult(msg.rejectionError()));
                }
            } else {
                if (fut != null) {
                    BinaryMetadataTransport.this.initSyncFor(typeId, -2, fut);
                }
                BinaryMetadataTransport.this.metaLocCache.put(typeId, metaHld.createRemoving());
                if (BinaryMetadataTransport.this.isPersistenceEnabled) {
                    BinaryMetadataTransport.this.metadataFileStore.prepareMetadataRemove(typeId);
                }
            }
        }
    }

    private final class MetadataResponseListener
    implements GridMessageListener {
        private MetadataResponseListener() {
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            assert (msg instanceof MetadataResponseMessage) : msg;
            MetadataResponseMessage msg0 = (MetadataResponseMessage)msg;
            int typeId = msg0.typeId();
            byte[] binMetaBytes = msg0.binaryMetadataBytes();
            ClientMetadataRequestFuture fut = (ClientMetadataRequestFuture)BinaryMetadataTransport.this.clientReqSyncMap.get(typeId);
            if (fut == null) {
                return;
            }
            if (msg0.metadataNotFound()) {
                fut.onDone(MetadataUpdateResult.createSuccessfulResult(-1));
                return;
            }
            try {
                BinaryMetadataTransport.this.casBinaryMetadata(typeId, (BinaryMetadataHolder)U.unmarshal(BinaryMetadataTransport.this.ctx, binMetaBytes, U.resolveClassLoader(BinaryMetadataTransport.this.ctx.config())));
                fut.onDone(MetadataUpdateResult.createSuccessfulResult(-1));
            }
            catch (IgniteCheckedException e) {
                fut.onDone(MetadataUpdateResult.createFailureResult(new BinaryObjectException(e)));
            }
        }
    }

    private final class MetadataRequestListener
    implements GridMessageListener {
        private final GridIoManager ioMgr;

        MetadataRequestListener(GridIoManager ioMgr) {
            this.ioMgr = ioMgr;
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            assert (msg instanceof MetadataRequestMessage) : msg;
            MetadataRequestMessage msg0 = (MetadataRequestMessage)msg;
            int typeId = msg0.typeId();
            BinaryMetadataHolder metaHolder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
            MetadataResponseMessage resp = new MetadataResponseMessage(typeId);
            byte[] binMetaBytes = null;
            if (metaHolder != null) {
                try {
                    binMetaBytes = U.marshal(BinaryMetadataTransport.this.ctx, (Object)metaHolder);
                }
                catch (IgniteCheckedException e) {
                    U.error(BinaryMetadataTransport.this.log, "Failed to marshal binary metadata for [typeId=" + typeId + ']', e);
                    resp.markErrorOnRequest();
                }
            }
            resp.binaryMetadataBytes(binMetaBytes);
            try {
                this.ioMgr.sendToGridTopic(nodeId, GridTopic.TOPIC_METADATA_REQ, (Message)resp, (byte)2);
            }
            catch (ClusterTopologyCheckedException e) {
                if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                    BinaryMetadataTransport.this.log.debug("Failed to send metadata response, node failed: " + nodeId);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(BinaryMetadataTransport.this.log, "Failed to send up-to-date metadata response.", e);
            }
        }
    }

    public final class MetadataUpdateResultFuture
    extends GridFutureAdapter<MetadataUpdateResult> {
        private SyncKey key;

        MetadataUpdateResultFuture(int typeId) {
            this.key = new SyncKey(typeId, 0);
        }

        MetadataUpdateResultFuture(SyncKey key) {
            this.key = key;
        }

        @Override
        public boolean onDone(@Nullable MetadataUpdateResult res, @Nullable Throwable err) {
            assert (res != null);
            boolean done = super.onDone(res, err);
            if (done && this.key != null) {
                BinaryMetadataTransport.this.syncMap.remove(this.key, this);
                BinaryMetadataTransport.this.pendingTypeIdMap.remove(this.key.typeId, this);
            }
            return done;
        }

        void key(SyncKey key) {
            this.key = key;
        }

        public int typeVersion() {
            return this.key.ver;
        }

        @Override
        public String toString() {
            return S.toString(MetadataUpdateResultFuture.class, this);
        }
    }

    private final class MetadataUpdateAcceptedListener
    implements CustomEventListener<MetadataUpdateAcceptedMessage> {
        private MetadataUpdateAcceptedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MetadataUpdateAcceptedMessage msg) {
            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                BinaryMetadataTransport.this.log.debug("Received MetadataUpdateAcceptedMessage " + msg);
            }
            if (msg.duplicated()) {
                return;
            }
            int typeId = msg.typeId();
            BinaryMetadataHolder holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
            assert (holder != null) : "No metadata found for typeId " + typeId;
            int newAcceptedVer = msg.acceptedVersion();
            if (BinaryMetadataTransport.this.clientNode) {
                boolean success = BinaryMetadataTransport.this.casBinaryMetadata(typeId, new BinaryMetadataHolder(holder.metadata(), holder.pendingVersion(), newAcceptedVer));
                ClientMetadataRequestFuture fut = (ClientMetadataRequestFuture)BinaryMetadataTransport.this.clientReqSyncMap.get(typeId);
                if (success && fut != null) {
                    fut.onDone(MetadataUpdateResult.createSuccessfulResult(-1));
                }
            } else {
                int oldAcceptedVer = holder.acceptedVersion();
                if (oldAcceptedVer >= newAcceptedVer) {
                    if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                        BinaryMetadataTransport.this.log.debug("Marking ack as duplicate [holder=" + holder + ", newAcceptedVer=" + newAcceptedVer + ']');
                    }
                    msg.duplicated(true);
                    BinaryMetadataTransport.this.metadataFileStore.finishWrite(typeId, newAcceptedVer);
                    return;
                }
                BinaryMetadataTransport.this.metadataFileStore.writeMetadataAsync(typeId, newAcceptedVer);
                BinaryMetadataTransport.this.metaLocCache.put(typeId, new BinaryMetadataHolder(holder.metadata(), holder.pendingVersion(), newAcceptedVer));
            }
            for (BinaryMetadataUpdatedListener lsnr : BinaryMetadataTransport.this.binaryUpdatedLsnrs) {
                lsnr.binaryMetadataUpdated(holder.metadata());
            }
            GridFutureAdapter fut = (GridFutureAdapter)BinaryMetadataTransport.this.syncMap.get(new SyncKey(typeId, newAcceptedVer));
            holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                BinaryMetadataTransport.this.log.debug("Completing future " + fut + " for " + holder);
            }
            if (!BinaryMetadataTransport.this.schemaWaitFuts.isEmpty()) {
                Iterator iter = BinaryMetadataTransport.this.schemaWaitFuts.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    SyncKey key = (SyncKey)entry.getKey();
                    if (key.typeId() != typeId || !holder.metadata().hasSchema(key.version())) continue;
                    ((GridFutureAdapter)entry.getValue()).onDone();
                    iter.remove();
                }
            }
            if (fut != null) {
                fut.onDone(MetadataUpdateResult.createSuccessfulResult(newAcceptedVer));
            }
        }
    }

    private final class MetadataUpdateProposedListener
    implements CustomEventListener<MetadataUpdateProposedMessage> {
        private MetadataUpdateProposedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MetadataUpdateProposedMessage msg) {
            block27: {
                BinaryMetadata mergedMeta;
                LinkedHashSet<Integer> changedSchemas;
                BinaryMetadata locMeta;
                int acceptedVer;
                int pendingVer;
                if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                    BinaryMetadataTransport.this.log.debug("Received MetadataUpdateProposed message [typeId=" + msg.typeId() + ", typeName=" + msg.metadata().typeName() + ", pendingVer=" + msg.pendingVersion() + ", acceptedVer=" + msg.acceptedVersion() + ", schemasCnt=" + msg.metadata().schemas().size() + ']');
                }
                int typeId = msg.typeId();
                BinaryMetadataHolder holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
                if (msg.pendingVersion() == 0) {
                    if (holder != null) {
                        if (holder.removing()) {
                            msg.markRejected(new BinaryObjectException("The type is removing now [typeId=" + typeId + ']'));
                            pendingVer = -2;
                            acceptedVer = -2;
                        } else {
                            pendingVer = holder.pendingVersion() + 1;
                            acceptedVer = holder.acceptedVersion();
                        }
                    } else {
                        pendingVer = 1;
                        acceptedVer = 0;
                    }
                    if (!msg.rejected()) {
                        msg.pendingVersion(pendingVer);
                        msg.acceptedVersion(acceptedVer);
                        locMeta = holder != null ? holder.metadata() : null;
                        try {
                            changedSchemas = new LinkedHashSet<Integer>();
                            mergedMeta = BinaryUtils.mergeMetadata(locMeta, msg.metadata(), changedSchemas);
                            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                                BinaryMetadataTransport.this.log.debug("Versions are stamped on coordinator [typeId=" + typeId + ", changedSchemas=" + changedSchemas + ", pendingVer=" + pendingVer + ", acceptedVer=" + acceptedVer + "]");
                            }
                            msg.metadata(mergedMeta);
                        }
                        catch (BinaryObjectException err) {
                            BinaryMetadataTransport.this.log.warning("Exception with merging metadata for typeId: " + typeId, err);
                            msg.markRejected(err);
                        }
                    }
                } else {
                    pendingVer = msg.pendingVersion();
                    acceptedVer = msg.acceptedVersion();
                }
                if (BinaryMetadataTransport.this.ctx.localNodeId().equals(msg.origNodeId())) {
                    MetadataUpdateResultFuture fut = (MetadataUpdateResultFuture)BinaryMetadataTransport.this.unlabeledFutures.poll();
                    if (msg.rejected()) {
                        fut.onDone(MetadataUpdateResult.createFailureResult(msg.rejectionError()));
                    } else if (BinaryMetadataTransport.this.clientNode) {
                        boolean success = BinaryMetadataTransport.this.casBinaryMetadata(typeId, new BinaryMetadataHolder(msg.metadata(), pendingVer, acceptedVer));
                        if (success) {
                            BinaryMetadataTransport.this.initSyncFor(typeId, pendingVer, fut);
                        } else {
                            fut.onDone(MetadataUpdateResult.createSuccessfulResult(-1));
                        }
                    } else {
                        BinaryMetadataTransport.this.initSyncFor(typeId, pendingVer, fut);
                        BinaryMetadataHolder newHolder = new BinaryMetadataHolder(msg.metadata(), pendingVer, acceptedVer);
                        if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                            BinaryMetadataTransport.this.log.debug("Updated metadata on originating node: " + newHolder);
                        }
                        BinaryMetadataTransport.this.metaLocCache.put(typeId, newHolder);
                        BinaryMetadataTransport.this.metadataFileStore.prepareMetadataWriting(msg.metadata(), pendingVer);
                    }
                } else if (!msg.rejected()) {
                    locMeta = holder != null && !holder.removing() ? holder.metadata() : null;
                    changedSchemas = null;
                    if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                        changedSchemas = new LinkedHashSet();
                    }
                    try {
                        mergedMeta = BinaryUtils.mergeMetadata(locMeta, msg.metadata(), changedSchemas);
                        BinaryMetadataHolder newHolder = new BinaryMetadataHolder(mergedMeta, pendingVer, acceptedVer);
                        if (BinaryMetadataTransport.this.clientNode) {
                            BinaryMetadataTransport.this.casBinaryMetadata(typeId, newHolder);
                        } else {
                            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                                BinaryMetadataTransport.this.log.debug("Updated metadata on server node [holder=" + newHolder + ", changedSchemas=" + changedSchemas + ']');
                            }
                            BinaryMetadataTransport.this.metaLocCache.put(typeId, newHolder);
                            BinaryMetadataTransport.this.metadataFileStore.prepareMetadataWriting(mergedMeta, pendingVer);
                        }
                    }
                    catch (BinaryObjectException ignored) {
                        if ($assertionsDisabled) break block27;
                        throw new AssertionError(msg);
                    }
                }
            }
        }
    }

    private static final class SyncKey {
        private final int typeId;
        private final int ver;

        private SyncKey(int typeId, int ver) {
            this.typeId = typeId;
            this.ver = ver;
        }

        int typeId() {
            return this.typeId;
        }

        int version() {
            return this.ver;
        }

        public int hashCode() {
            return this.typeId + this.ver;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyncKey)) {
                return false;
            }
            SyncKey that = (SyncKey)o;
            return this.typeId == that.typeId && this.ver == that.ver;
        }

        public String toString() {
            return S.toString(SyncKey.class, this);
        }
    }
}

