/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridLongList;
import org.jetbrains.annotations.Nullable;

public class PartitionUpdateCounterVolatileImpl
implements PartitionUpdateCounter {
    private static final byte VERSION = 1;
    private final AtomicLong cntr = new AtomicLong();
    private volatile long initCntr;
    private final CacheGroupContext grp;
    private volatile long clearCntr;

    public PartitionUpdateCounterVolatileImpl(CacheGroupContext grp) {
        this.grp = grp;
    }

    @Override
    public synchronized void init(long initUpdCntr, @Nullable byte[] cntrUpdData) {
        this.cntr.set(initUpdCntr);
        this.initCntr = initUpdCntr;
        this.fromBytes(cntrUpdData);
    }

    @Override
    public long initial() {
        return this.initCntr;
    }

    @Override
    public long get() {
        return this.cntr.get();
    }

    @Override
    public long next() {
        return this.cntr.incrementAndGet();
    }

    @Override
    public void update(long val) {
        long cur;
        while (val > (cur = this.cntr.get()) && !this.cntr.compareAndSet(cur, val)) {
        }
    }

    @Override
    public boolean update(long start, long delta) {
        long cur;
        long val = start + delta;
        do {
            if (val > (cur = this.cntr.get())) continue;
            return false;
        } while (!this.cntr.compareAndSet(cur, val));
        return true;
    }

    @Override
    public synchronized void updateInitial(long start, long delta) {
        this.update(start + delta);
        this.initCntr = this.get();
    }

    @Override
    public GridLongList finalizeUpdateCounters() {
        return new GridLongList();
    }

    @Override
    public long reserve(long delta) {
        return this.next(delta);
    }

    @Override
    public long next(long delta) {
        return this.cntr.getAndAdd(delta);
    }

    @Override
    public boolean sequential() {
        return true;
    }

    @Override
    @Nullable
    public synchronized byte[] getBytes() {
        if (this.clearCntr == 0L) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(1);
            dos.writeLong(this.clearCntr);
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public synchronized void reset() {
        this.initCntr = 0L;
        this.cntr.set(0L);
    }

    @Override
    public void resetInitialCounter() {
        this.initCntr = 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionUpdateCounterVolatileImpl cntr = (PartitionUpdateCounterVolatileImpl)o;
        return this.cntr.get() == cntr.cntr.get();
    }

    @Override
    public long reserved() {
        return this.get();
    }

    @Override
    public boolean empty() {
        return this.get() == 0L;
    }

    @Override
    public Iterator<long[]> iterator() {
        return new GridEmptyIterator<long[]>();
    }

    public String toString() {
        return "Counter [init=" + this.initCntr + ", val=" + this.get() + ", clearCntr=" + this.clearCntr + ']';
    }

    @Override
    public CacheGroupContext context() {
        return this.grp;
    }

    @Override
    public synchronized void updateTombstoneClearCounter(long cntr) {
        if (cntr > this.clearCntr) {
            this.clearCntr = cntr;
        } else if (cntr == 0L) {
            this.clearCntr = this.get();
        }
    }

    @Override
    public synchronized long tombstoneClearCounter() {
        return this.clearCntr;
    }

    private void fromBytes(@Nullable byte[] raw) {
        if (raw == null) {
            return;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(raw);
            DataInputStream dis = new DataInputStream(bis);
            dis.readByte();
            this.clearCntr = dis.readLong();
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }
}

