/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdatePartitionDataRecordV2
extends MetaPageUpdatePartitionDataRecord {
    private long gapsLink;

    public MetaPageUpdatePartitionDataRecordV2(int grpId, long pageId, long updateCntr, long globalRmvId, int partSize, long cntrsPageId, byte state, int allocatedIdxCandidate, long gapsLink) {
        super(grpId, pageId, updateCntr, globalRmvId, partSize, cntrsPageId, state, allocatedIdxCandidate);
        this.gapsLink = gapsLink;
    }

    public MetaPageUpdatePartitionDataRecordV2(DataInput in) throws IOException {
        super(in);
        this.gapsLink = in.readLong();
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        super.applyDelta(pageMem, pageAddr);
        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
        io.setGapsLink(pageAddr, this.gapsLink);
    }

    public long gapsLink() {
        return this.gapsLink;
    }

    @Override
    public void toBytes(ByteBuffer buf) {
        super.toBytes(buf);
        buf.putLong(this.gapsLink());
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PARTITION_META_PAGE_UPDATE_COUNTERS_V2;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdatePartitionDataRecordV2.class, this, "partId", (Object)PageIdUtils.partId(this.pageId()), "super", (Object)super.toString());
    }
}

