/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageUpdateRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageFragmentedUpdateRecord
extends DataPageUpdateRecord {
    private final long linkToNextFragment;

    public DataPageFragmentedUpdateRecord(int grpId, long pageId, int itemId, long linkToNextFragment, byte[] payload) {
        super(grpId, pageId, itemId, payload);
        this.linkToNextFragment = linkToNextFragment;
    }

    public long linkToNextFragment() {
        return this.linkToNextFragment;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        assert (this.payload() != null);
        DataPageIO io = (DataPageIO)PageIO.getPageIO(pageAddr);
        io.updateFragmentedData(pageAddr, this.itemId(), pageMem.realPageSize(this.groupId()), this.linkToNextFragment, this.payload());
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.DATA_PAGE_FRAGMENTED_UPDATE_RECORD;
    }

    @Override
    public String toString() {
        return S.toString(DataPageFragmentedUpdateRecord.class, this, "super", (Object)super.toString());
    }
}

