/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlCacheException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

class JdbcBatchUpdateTask
implements IgniteCallable<int[]> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private Ignite ignite;
    private final String cacheName;
    private final String schemaName;
    private final String sql;
    private final List<String> sqlBatch;
    private final List<List<Object>> batchArgs;
    private final int fetchSize;
    private final boolean loc;
    private final boolean locQry;
    private final boolean collocatedQry;
    private final boolean distributedJoins;

    public JdbcBatchUpdateTask(Ignite ignite, String cacheName, String schemaName, String sql, List<String> sqlBatch, List<List<Object>> batchArgs, boolean loc, int fetchSize, boolean locQry, boolean collocatedQry, boolean distributedJoins) {
        this.ignite = ignite;
        this.cacheName = cacheName;
        this.schemaName = schemaName;
        this.sql = sql;
        this.sqlBatch = sqlBatch;
        this.batchArgs = batchArgs;
        this.fetchSize = fetchSize;
        this.loc = loc;
        this.locQry = locQry;
        this.collocatedQry = collocatedQry;
        this.distributedJoins = distributedJoins;
        assert ((!F.isEmpty(sql) && !F.isEmpty(batchArgs)) ^ !F.isEmpty(sqlBatch));
    }

    @Override
    public int[] call() throws Exception {
        int idx;
        IgniteCache cache = this.ignite.cache(this.cacheName);
        boolean start = this.ignite.configuration().isClientMode();
        if (cache == null && this.cacheName == null) {
            cache = ((IgniteKernal)this.ignite).context().cache().getOrStartPublicCache(start, !this.loc && this.locQry);
        }
        if (cache == null) {
            if (this.cacheName == null) {
                throw IgniteQueryErrorCode.createJdbcSqlException("Failed to execute query. No suitable caches found.", 4006);
            }
            throw IgniteQueryErrorCode.createJdbcSqlException("Cache not found [cacheName=" + this.cacheName + ']', 4006);
        }
        int batchSize = F.isEmpty(this.sql) ? this.sqlBatch.size() : this.batchArgs.size();
        int[] updCntrs = new int[batchSize];
        try {
            if (F.isEmpty(this.sql)) {
                for (idx = 0; idx < batchSize; ++idx) {
                    updCntrs[idx] = this.doSingleUpdate(cache, this.sqlBatch.get(idx), null);
                }
            } else {
                while (idx < batchSize) {
                    updCntrs[idx] = this.doSingleUpdate(cache, this.sql, this.batchArgs.get(idx));
                    ++idx;
                }
            }
        }
        catch (Exception e) {
            IgniteSQLException sqlEx = X.cause(e, IgniteSQLException.class);
            if (sqlEx != null) {
                throw new BatchUpdateException(sqlEx.getMessage(), sqlEx.sqlState(), Arrays.copyOf(updCntrs, idx), (Throwable)e);
            }
            SqlCacheException ex = X.cause(e, SqlCacheException.class);
            if (ex != null) {
                throw new BatchUpdateException(ex.getMessage(), ex.sqlState(), Arrays.copyOf(updCntrs, idx), (Throwable)e);
            }
            throw new BatchUpdateException(Arrays.copyOf(updCntrs, idx), (Throwable)e);
        }
        return updCntrs;
    }

    private Integer doSingleUpdate(IgniteCache<?, ?> cache, String sqlText, List<Object> args) throws SQLException {
        SqlFieldsQueryEx qry = new SqlFieldsQueryEx(sqlText, (Boolean)false);
        ((SqlFieldsQuery)qry).setPageSize(this.fetchSize);
        ((SqlFieldsQuery)qry).setLocal(this.locQry);
        ((SqlFieldsQuery)qry).setCollocated(this.collocatedQry);
        ((SqlFieldsQuery)qry).setDistributedJoins(this.distributedJoins);
        qry.setSchema(this.schemaName);
        ((SqlFieldsQuery)qry).setArgs(args == null ? null : args.toArray());
        QueryCursorImpl qryCursor = (QueryCursorImpl)cache.withKeepBinary().query(qry);
        if (qryCursor.isQuery()) {
            throw IgniteQueryErrorCode.createJdbcSqlException(this.getError("Query produced result set", qry), 3003);
        }
        List rows = qryCursor.getAll();
        if (F.isEmpty(rows)) {
            return -2;
        }
        if (rows.size() != 1) {
            throw new SQLException(this.getError("Expected single row for update operation result", qry));
        }
        List row = (List)rows.get(0);
        if (F.isEmpty(row) || row.size() != 1) {
            throw new SQLException(this.getError("Expected row size of 1 for update operation", qry));
        }
        Object objRes = row.get(0);
        if (!(objRes instanceof Long)) {
            throw new SQLException(this.getError("Unexpected update result type", qry));
        }
        Long longRes = (Long)objRes;
        if (longRes > Integer.MAX_VALUE) {
            IgniteLogger log = this.ignite.log();
            if (log != null) {
                log.warning(this.getError("Query updated row counter (" + longRes + ") exceeds integer range", qry));
            }
            return Integer.MAX_VALUE;
        }
        return longRes.intValue();
    }

    private String getError(String msg, SqlFieldsQuery qry) {
        return msg + " [qry='" + qry.getSql() + "', params=" + Arrays.deepToString(qry.getArgs()) + ']';
    }
}

