/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.SupportFeaturesUtils;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedLongProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.jetbrains.annotations.NotNull;

public class DistributedBaselineConfiguration {
    private static final int DEFAULT_PERSISTENCE_TIMEOUT = 300000;
    private static final int DEFAULT_IN_MEMORY_TIMEOUT = 0;
    private static final String AUTO_ADJUST_CONFIGURED_MESSAGE = "Baseline auto-adjust is '%s' with timeout='%d' ms";
    private static final String PROPERTY_UPDATE_MESSAGE = "Baseline parameter '%s' was changed from '%s' to '%s'";
    private volatile long dfltTimeout;
    private volatile boolean dfltEnabled;
    private final IgniteLogger log;
    private final DistributedChangeableProperty<Boolean> baselineAutoAdjustEnabled = DistributedBooleanProperty.detachedBooleanProperty("baselineAutoAdjustEnabled");
    private final DistributedChangeableProperty<Long> baselineAutoAdjustTimeout = DistributedLongProperty.detachedLongProperty("baselineAutoAdjustTimeout");
    final boolean persistenceEnabled;

    public DistributedBaselineConfiguration(GridInternalSubscriptionProcessor isp, final GridKernalContext ctx, final IgniteLogger log) {
        this.log = log;
        if (!(!SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE") || SupportFeaturesUtils.isFeatureEnabled("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE") && SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_FOR_IN_MEMORY_CACHES_FEATURE"))) {
            throw new IllegalArgumentException("IGNITE_BASELINE_AUTO_ADJUST_FEATURE depends on IGNITE_DISTRIBUTED_META_STORAGE_FEATURE and IGNITE_BASELINE_FOR_IN_MEMORY_CACHES_FEATURE so please keep all of them in same state");
        }
        this.persistenceEnabled = ctx.config() != null && CU.isPersistenceEnabled(ctx.config());
        this.dfltTimeout = this.persistenceEnabled ? 300000L : 0L;
        this.dfltEnabled = false;
        final boolean serverMode = ctx.config().isClientMode() == false;
        isp.registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedBaselineConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedBaselineConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled, DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout});
            }

            @Override
            public void onReadyToWrite() {
                if (SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE") && IgniteFeatures.allNodesSupport(ctx, IgniteFeatures.BASELINE_AUTO_ADJUSTMENT) && serverMode) {
                    DistributedBaselineConfiguration.this.initDfltAutoAdjustVars(ctx);
                    DistributedConfigurationUtils.setDefaultValue(DistributedBaselineConfiguration.this.baselineAutoAdjustEnabled, DistributedBaselineConfiguration.this.dfltEnabled, log);
                    DistributedConfigurationUtils.setDefaultValue(DistributedBaselineConfiguration.this.baselineAutoAdjustTimeout, DistributedBaselineConfiguration.this.dfltTimeout, log);
                }
            }
        });
    }

    public void initDfltAutoAdjustVars(GridKernalContext ctx) {
        if (SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE") && IgniteFeatures.allNodesSupport(ctx, IgniteFeatures.BASELINE_AUTO_ADJUSTMENT)) {
            this.dfltTimeout = this.persistenceEnabled ? 300000L : 0L;
            this.dfltEnabled = SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE") && !this.persistenceEnabled;
        }
    }

    public void listenAutoAdjustEnabled(DistributePropertyListener<? super Boolean> lsnr) {
        this.baselineAutoAdjustEnabled.addListener(lsnr);
    }

    public void listenAutoAdjustTimeout(DistributePropertyListener<? super Long> lsnr) {
        this.baselineAutoAdjustTimeout.addListener(lsnr);
    }

    public void onActivate() throws IgniteCheckedException {
        if (!SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE")) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format(AUTO_ADJUST_CONFIGURED_MESSAGE, this.isBaselineAutoAdjustEnabled() ? "enabled" : "disabled", this.getBaselineAutoAdjustTimeout()));
        }
    }

    public boolean isBaselineAutoAdjustEnabled() {
        return this.baselineAutoAdjustEnabled.getOrDefault(this.dfltEnabled);
    }

    public GridFutureAdapter<?> updateBaselineAutoAdjustEnabledAsync(GridKernalContext ctx, boolean baselineAutoAdjustEnabled) throws IgniteCheckedException {
        if (!SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE")) {
            return this.finishFuture();
        }
        if (!IgniteFeatures.allNodesSupport(ctx, IgniteFeatures.BASELINE_AUTO_ADJUSTMENT)) {
            throw new IgniteCheckedException("Not all nodes in the cluster support baseline auto-adjust.");
        }
        return this.baselineAutoAdjustEnabled.propagateAsync(!baselineAutoAdjustEnabled, baselineAutoAdjustEnabled);
    }

    public long getBaselineAutoAdjustTimeout() {
        return this.baselineAutoAdjustTimeout.getOrDefault(this.dfltTimeout);
    }

    public GridFutureAdapter<?> updateBaselineAutoAdjustTimeoutAsync(GridKernalContext ctx, long baselineAutoAdjustTimeout) throws IgniteCheckedException {
        if (!SupportFeaturesUtils.isFeatureEnabled("IGNITE_BASELINE_AUTO_ADJUST_FEATURE")) {
            return this.finishFuture();
        }
        if (!IgniteFeatures.allNodesSupport(ctx, IgniteFeatures.BASELINE_AUTO_ADJUSTMENT)) {
            throw new IgniteCheckedException("Not all nodes in the cluster support baseline auto-adjust.");
        }
        return this.baselineAutoAdjustTimeout.propagateAsync(baselineAutoAdjustTimeout);
    }

    @NotNull
    private GridFutureAdapter<?> finishFuture() {
        GridFutureAdapter adapter = new GridFutureAdapter();
        adapter.onDone();
        return adapter;
    }
}

