/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientReconnectedException;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.QueryPager;
import org.apache.ignite.internal.client.thin.ReliableChannel;

abstract class GenericQueryPager<T>
implements QueryPager<T> {
    private final ClientOperation qryOp;
    private final ClientOperation pageQryOp;
    private final Consumer<PayloadOutputChannel> qryWriter;
    private final ReliableChannel ch;
    private boolean hasNext = true;
    private Collection<T> firstPage;
    private Long cursorId = null;
    private ClientChannel clientCh;

    GenericQueryPager(ReliableChannel ch, ClientOperation qryOp, ClientOperation pageQryOp, Consumer<PayloadOutputChannel> qryWriter) {
        this.ch = ch;
        this.qryOp = qryOp;
        this.pageQryOp = pageQryOp;
        this.qryWriter = qryWriter;
    }

    @Override
    public void loadFirstPage() {
        assert (this.cursorId == null) : "Cursor already loaded";
        assert (this.firstPage == null) : "First page already loaded";
        this.firstPage = this.ch.service(this.qryOp, this.qryWriter, payloadCh -> this.readResult((PayloadInputChannel)payloadCh, true));
    }

    @Override
    public Collection<T> next() throws ClientException {
        if (this.firstPage != null) {
            Collection<T> res = this.firstPage;
            this.firstPage = null;
            return res;
        }
        if (!this.hasNext) {
            throw new IllegalStateException("No more query results");
        }
        if (this.cursorId == null) {
            this.loadFirstPage();
            Collection<T> res = this.firstPage;
            this.firstPage = null;
            return res;
        }
        return this.queryPage();
    }

    @Override
    public void close() throws Exception {
        if (this.cursorId != null && this.hasNext && !this.clientCh.closed()) {
            try {
                this.clientCh.service(ClientOperation.RESOURCE_CLOSE, req -> req.out().writeLong(this.cursorId), null);
            }
            catch (ClientConnectionException | ClientReconnectedException clientException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.firstPage != null && !this.firstPage.isEmpty() || this.hasNext;
    }

    @Override
    public boolean hasFirstPage() {
        return this.cursorId != null;
    }

    @Override
    public void reset() {
        this.firstPage = null;
        this.hasNext = true;
        this.cursorId = null;
        this.clientCh = null;
    }

    abstract Collection<T> readEntries(PayloadInputChannel var1, boolean var2);

    private Collection<T> readResult(PayloadInputChannel payloadCh, boolean firstPage) {
        if (firstPage) {
            long resCursorId = payloadCh.in().readLong();
            if (this.cursorId != null) {
                if (this.cursorId != resCursorId) {
                    throw new ClientProtocolError(String.format("Expected cursor [%s] but received cursor [%s]", this.cursorId, resCursorId));
                }
            } else {
                this.cursorId = resCursorId;
                this.clientCh = payloadCh.clientChannel();
            }
        }
        Collection<T> res = this.readEntries(payloadCh, firstPage);
        this.hasNext = payloadCh.in().readBoolean();
        return res;
    }

    private Collection<T> queryPage() throws ClientException {
        return this.clientCh.service(this.pageQryOp, req -> req.out().writeLong(this.cursorId), payloadCh -> this.readResult((PayloadInputChannel)payloadCh, false));
    }
}

