/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

class AbstractClientAtomic {
    @GridToStringInclude
    protected final String name;
    @GridToStringInclude
    protected final String groupName;
    protected final ReliableChannel ch;
    @GridToStringInclude
    protected final int cacheId;

    protected AbstractClientAtomic(String name, @Nullable String groupName, ReliableChannel ch) {
        this.name = name;
        this.groupName = groupName;
        this.ch = ch;
        this.cacheId = ClientUtils.atomicsCacheId(name, groupName);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return S.toString(AbstractClientAtomic.class, this);
    }

    protected void writeName(PayloadOutputChannel out) {
        try (BinaryWriterExImpl w = new BinaryWriterExImpl(null, out.out(), null, null);){
            w.writeString(this.name);
            w.writeString(this.groupName);
        }
    }

    protected String affinityKey() {
        return this.name;
    }
}

