/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query;

import org.apache.ignite.internal.cache.query.SqlBuilderContext;
import org.apache.ignite.internal.cache.query.SqlIndexQueryCriterion;

public class RangeIndexQueryCriterion
implements SqlIndexQueryCriterion {
    private static final long serialVersionUID = 0L;
    private final String field;
    private final Object lower;
    private final Object upper;
    private boolean lowerIncl;
    private boolean upperIncl;
    private boolean lowerNull;
    private boolean upperNull;

    public RangeIndexQueryCriterion(String field, Object lower, Object upper) {
        this.field = field;
        this.lower = lower;
        this.upper = upper;
    }

    public Object lower() {
        return this.lower;
    }

    public Object upper() {
        return this.upper;
    }

    public void lowerIncl(boolean lowerIncl) {
        this.lowerIncl = lowerIncl;
    }

    public boolean lowerIncl() {
        return this.lowerIncl;
    }

    public void upperIncl(boolean upperIncl) {
        this.upperIncl = upperIncl;
    }

    public boolean upperIncl() {
        return this.upperIncl;
    }

    public void lowerNull(boolean lowerNull) {
        this.lowerNull = lowerNull;
    }

    public boolean lowerNull() {
        return this.lowerNull;
    }

    public void upperNull(boolean upperNull) {
        this.upperNull = upperNull;
    }

    public boolean upperNull() {
        return this.upperNull;
    }

    @Override
    public String toSql(SqlBuilderContext ctx) {
        SqlBuilderContext.ColumnDescriptor column = ctx.resolveColumn(this.field);
        String columnName = column.name();
        if (this.lower != null && this.upper != null) {
            return this.between(columnName, ctx);
        }
        if (this.lower != null) {
            return this.greaterThan(columnName, ctx);
        }
        if (this.upper != null) {
            return this.lowerThan(columnName, ctx);
        }
        throw new IllegalArgumentException("Unsupported criterion [criterion=" + this + "]");
    }

    private String between(String column, SqlBuilderContext ctx) {
        if (!this.lowerIncl || !this.upperIncl || this.lowerNull || this.upperNull) {
            throw new IllegalArgumentException("Unsupported criterion [criterion=" + this + "]");
        }
        ctx.addArgument(this.lower);
        ctx.addArgument(this.upper);
        return column + " >= ? AND " + column + " <= ?";
    }

    private String lowerThan(String columnName, SqlBuilderContext ctx) {
        if (this.upperNull || !this.lowerIncl) {
            throw new IllegalArgumentException("Unsupported criterion [criterion=" + this + "]");
        }
        if (this.lowerNull && !this.upperIncl) {
            throw new IllegalArgumentException("Unsupported criterion [criterion=" + this + "]");
        }
        ctx.addArgument(this.upper);
        return columnName + (this.upperIncl ? " <= ?" : " < ?");
    }

    private String greaterThan(String column, SqlBuilderContext ctx) {
        if (this.lowerNull || !this.upperIncl) {
            throw new IllegalArgumentException("Unsupported criterion [criterion=" + this + "]");
        }
        if (this.upperNull) {
            if (!this.lowerIncl) {
                throw new IllegalArgumentException("Unsupported criterion [criterion=" + this + "]");
            }
            return "FALSE";
        }
        ctx.addArgument(this.lower);
        return column + (this.lowerIncl ? " >= ?" : " > ?");
    }

    @Override
    public String field() {
        return this.field;
    }

    public String toString() {
        return this.field + (this.lowerIncl ? "[" : "(") + this.lower + "; " + this.upper + (this.upperIncl ? "]" : ")");
    }
}

