/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReflectiveSerializer;
import org.apache.ignite.binary.BinarySerializer;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.UnregisteredClassException;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryFieldAccessor;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryInternalMapper;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataCollector;
import org.apache.ignite.internal.binary.BinaryMethodWriteReplacer;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySchemaRegistry;
import org.apache.ignite.internal.binary.BinaryTreeMap;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriteMode;
import org.apache.ignite.internal.binary.BinaryWriteReplacer;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.MarshallerExclusions;
import org.jetbrains.annotations.Nullable;

public class BinaryClassDescriptor {
    @GridToStringExclude
    private final BinaryContext ctx;
    private final Class<?> cls;
    private final BinarySerializer serializer;
    private final BinarySerializer initialSerializer;
    private final BinaryInternalMapper mapper;
    private final BinaryWriteMode mode;
    private final boolean userType;
    private final int typeId;
    private final String typeName;
    private final String affKeyFieldName;
    private final Constructor<?> ctor;
    private final BinaryFieldAccessor[] fields;
    private final BinaryWriteReplacer writeReplacer;
    private final Method readResolveMtd;
    private final Map<String, BinaryFieldMetadata> stableFieldsMeta;
    private final BinarySchema stableSchema;
    private final BinarySchemaRegistry schemaReg;
    private final boolean registered;
    private final boolean useOptMarshaller;
    private final boolean excluded;
    private final Class<?>[] intfs;
    private volatile boolean stableSchemaPublished;

    BinaryClassDescriptor(BinaryContext ctx, Class<?> cls, boolean userType, int typeId, String typeName, @Nullable String affKeyFieldName, @Nullable BinaryInternalMapper mapper, @Nullable BinarySerializer serializer, boolean metaDataEnabled, boolean registered) throws BinaryObjectException {
        this(ctx, cls, userType, typeId, typeName, affKeyFieldName, mapper, serializer, metaDataEnabled, registered, MarshallerExclusions.isExcluded(cls));
    }

    BinaryClassDescriptor(BinaryContext ctx, Class<?> cls, boolean userType, int typeId, String typeName, @Nullable String affKeyFieldName, @Nullable BinaryInternalMapper mapper, @Nullable BinarySerializer serializer, boolean metaDataEnabled, boolean registered, boolean excluded) throws BinaryObjectException {
        Method writeReplaceMthd;
        assert (ctx != null);
        assert (cls != null);
        assert (mapper != null);
        this.initialSerializer = serializer;
        boolean bl = this.useOptMarshaller = serializer == null || QueryUtils.isGeometryClass(cls);
        if (serializer instanceof BinaryReflectiveSerializer) {
            serializer = null;
        }
        this.ctx = ctx;
        this.cls = cls;
        this.typeId = typeId;
        this.userType = userType;
        this.typeName = typeName;
        this.affKeyFieldName = affKeyFieldName;
        this.serializer = serializer;
        this.mapper = mapper;
        this.registered = registered;
        this.schemaReg = ctx.schemaRegistry(typeId);
        this.excluded = excluded;
        if (excluded) {
            this.mode = BinaryWriteMode.EXCLUSION;
        } else if (this.useOptMarshaller) {
            this.mode = BinaryWriteMode.OPTIMIZED;
        } else if (cls == BinaryEnumObjectImpl.class) {
            this.mode = BinaryWriteMode.BINARY_ENUM;
        } else {
            BinaryWriteMode binaryWriteMode = this.mode = serializer != null ? BinaryWriteMode.BINARY : BinaryUtils.mode(cls);
        }
        if (this.useOptMarshaller && userType && !U.isIgnite(cls) && !U.isJdk(cls) && !QueryUtils.isGeometryClass(cls)) {
            U.warnDevOnly(ctx.log(), "Class \"" + cls.getName() + "\" cannot be serialized using " + BinaryMarshaller.class.getSimpleName() + " because it either implements Externalizable interface or have writeObject/readObject methods. " + OptimizedMarshaller.class.getSimpleName() + " will be used instead and class instances will be deserialized on the server. Please ensure that all nodes have this class in classpath. To enable binary serialization either implement " + Binarylizable.class.getSimpleName() + " interface or set explicit serializer using BinaryTypeConfiguration.setSerializer() method.");
        }
        switch (this.mode) {
            case P_BYTE: 
            case P_BOOLEAN: 
            case P_SHORT: 
            case P_CHAR: 
            case P_INT: 
            case P_LONG: 
            case P_FLOAT: 
            case P_DOUBLE: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case BOOLEAN: 
            case DECIMAL: 
            case STRING: 
            case UUID: 
            case DATE: 
            case TIMESTAMP: 
            case TIME: 
            case BYTE_ARR: 
            case SHORT_ARR: 
            case INT_ARR: 
            case LONG_ARR: 
            case FLOAT_ARR: 
            case DOUBLE_ARR: 
            case CHAR_ARR: 
            case BOOLEAN_ARR: 
            case DECIMAL_ARR: 
            case STRING_ARR: 
            case UUID_ARR: 
            case DATE_ARR: 
            case TIMESTAMP_ARR: 
            case TIME_ARR: 
            case OBJECT_ARR: 
            case COL: 
            case MAP: 
            case BINARY_OBJ: 
            case ENUM: 
            case BINARY_ENUM: 
            case ENUM_ARR: 
            case CLASS: 
            case OPTIMIZED: 
            case EXCLUSION: {
                this.ctor = null;
                this.fields = null;
                this.stableFieldsMeta = null;
                this.stableSchema = null;
                this.intfs = null;
                break;
            }
            case PROXY: {
                this.ctor = null;
                this.fields = null;
                this.stableFieldsMeta = null;
                this.stableSchema = null;
                this.intfs = cls.getInterfaces();
                break;
            }
            case BINARY: {
                this.ctor = BinaryClassDescriptor.constructor(cls);
                this.fields = null;
                this.stableFieldsMeta = null;
                this.stableSchema = null;
                this.intfs = null;
                break;
            }
            case OBJECT: {
                this.ctor = null;
                if (IgniteUtils.isLambda(cls)) {
                    if (!Serializable.class.isAssignableFrom(cls)) {
                        throw new BinaryObjectException("Lambda is not serializable: " + cls);
                    }
                    this.fields = null;
                    this.stableFieldsMeta = null;
                    this.stableSchema = null;
                } else {
                    AbstractMap fields0;
                    if (BinaryUtils.FIELDS_SORTED_ORDER) {
                        fields0 = new TreeMap();
                        this.stableFieldsMeta = metaDataEnabled ? new TreeMap() : null;
                    } else {
                        fields0 = new LinkedHashMap();
                        this.stableFieldsMeta = metaDataEnabled ? new LinkedHashMap() : null;
                    }
                    Set<String> duplicates = BinaryClassDescriptor.duplicateFields(cls);
                    HashSet<String> names = new HashSet<String>();
                    HashSet<Integer> ids = new HashSet<Integer>();
                    for (Class<?> c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                        for (Field f : c.getDeclaredFields()) {
                            if (!BinaryClassDescriptor.serializeField(f)) continue;
                            f.setAccessible(true);
                            String name = f.getName();
                            if (duplicates.contains(name)) {
                                name = BinaryUtils.qualifiedFieldName(c, name);
                            }
                            boolean added = names.add(name);
                            assert (added) : name;
                            int fieldId = this.mapper.fieldId(typeId, name);
                            if (!ids.add(fieldId)) {
                                throw new BinaryObjectException("Duplicate field ID: " + name);
                            }
                            BinaryFieldAccessor fieldInfo = BinaryFieldAccessor.create(f, fieldId);
                            fields0.put(name, fieldInfo);
                            if (!metaDataEnabled) continue;
                            this.stableFieldsMeta.put(name, new BinaryFieldMetadata(fieldInfo));
                        }
                    }
                    this.fields = fields0.values().toArray(new BinaryFieldAccessor[fields0.size()]);
                    BinarySchema.Builder schemaBuilder = BinarySchema.Builder.newBuilder();
                    for (BinaryFieldAccessor field : this.fields) {
                        schemaBuilder.addField(field.id);
                    }
                    this.stableSchema = schemaBuilder.build();
                }
                this.intfs = null;
                break;
            }
            default: {
                throw new BinaryObjectException("Invalid mode: " + (Object)((Object)this.mode));
            }
        }
        BinaryWriteReplacer writeReplacer0 = BinaryUtils.writeReplacer(cls);
        if (this.mode == BinaryWriteMode.BINARY || this.mode == BinaryWriteMode.OBJECT) {
            this.readResolveMtd = U.findInheritableMethod(cls, "readResolve", new Class[0]);
            writeReplaceMthd = U.findInheritableMethod(cls, "writeReplace", new Class[0]);
        } else {
            this.readResolveMtd = null;
            writeReplaceMthd = null;
        }
        if (writeReplaceMthd != null && writeReplacer0 == null) {
            writeReplacer0 = new BinaryMethodWriteReplacer(writeReplaceMthd);
        }
        this.writeReplacer = writeReplacer0;
    }

    private static Set<String> duplicateFields(Class cls) {
        HashSet<String> all = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (Class c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                String name;
                if (!BinaryClassDescriptor.serializeField(f) || all.add(name = f.getName())) continue;
                duplicates.add(name);
            }
        }
        return duplicates;
    }

    private static boolean serializeField(Field f) {
        int mod = f.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isTransient(mod);
    }

    boolean isEnum() {
        return this.mode == BinaryWriteMode.ENUM;
    }

    boolean isObject() {
        return this.mode == BinaryWriteMode.OBJECT;
    }

    boolean isBinary() {
        return this.mode == BinaryWriteMode.BINARY;
    }

    Class<?> describedClass() {
        return this.cls;
    }

    public int typeId() {
        return this.typeId;
    }

    String typeName() {
        return this.typeName;
    }

    BinaryInternalMapper mapper() {
        return this.mapper;
    }

    BinarySerializer serializer() {
        return this.serializer;
    }

    BinarySerializer initialSerializer() {
        return this.initialSerializer;
    }

    String affFieldKeyName() {
        return this.affKeyFieldName;
    }

    boolean userType() {
        return this.userType;
    }

    Map<String, BinaryFieldMetadata> fieldsMeta() {
        return this.stableFieldsMeta;
    }

    BinarySchema schema() {
        return this.stableSchema;
    }

    public boolean registered() {
        return this.registered;
    }

    public boolean useOptimizedMarshaller() {
        return this.useOptMarshaller;
    }

    public boolean excluded() {
        return this.excluded;
    }

    public boolean isWriteReplace() {
        return this.writeReplacer != null;
    }

    public Object writeReplace(Object obj) {
        assert (this.isWriteReplace());
        return this.writeReplacer.replace(obj);
    }

    public void registerStableSchema() {
        int schemaId;
        if (this.schemaReg != null && this.stableSchema != null && this.schemaReg.schema(schemaId = this.stableSchema.schemaId()) == null) {
            this.schemaReg.addSchema(this.stableSchema.schemaId(), this.stableSchema);
        }
    }

    @Nullable
    Method getReadResolveMethod() {
        return this.readResolveMtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
        try {
            assert (obj != null);
            assert (writer != null);
            assert (this.mode != BinaryWriteMode.OPTIMIZED) : "OptimizedMarshaller should not be used here: " + this.cls.getName();
            writer.typeId(this.typeId);
            switch (this.mode) {
                case P_BYTE: 
                case BYTE: {
                    writer.writeByteFieldPrimitive((Byte)obj);
                    break;
                }
                case P_SHORT: 
                case SHORT: {
                    writer.writeShortFieldPrimitive((Short)obj);
                    break;
                }
                case P_INT: 
                case INT: {
                    writer.writeIntFieldPrimitive((Integer)obj);
                    break;
                }
                case P_LONG: 
                case LONG: {
                    writer.writeLongFieldPrimitive((Long)obj);
                    break;
                }
                case P_FLOAT: 
                case FLOAT: {
                    writer.writeFloatFieldPrimitive(((Float)obj).floatValue());
                    break;
                }
                case P_DOUBLE: 
                case DOUBLE: {
                    writer.writeDoubleFieldPrimitive((Double)obj);
                    break;
                }
                case P_CHAR: 
                case CHAR: {
                    writer.writeCharFieldPrimitive(((Character)obj).charValue());
                    break;
                }
                case P_BOOLEAN: 
                case BOOLEAN: {
                    writer.writeBooleanFieldPrimitive((Boolean)obj);
                    break;
                }
                case DECIMAL: {
                    writer.doWriteDecimal((BigDecimal)obj);
                    break;
                }
                case STRING: {
                    writer.doWriteString((String)obj);
                    break;
                }
                case UUID: {
                    writer.doWriteUuid((UUID)obj);
                    break;
                }
                case DATE: {
                    writer.doWriteDate((Date)obj);
                    break;
                }
                case TIMESTAMP: {
                    writer.doWriteTimestamp((Timestamp)obj);
                    break;
                }
                case TIME: {
                    writer.doWriteTime((Time)obj);
                    break;
                }
                case BYTE_ARR: {
                    writer.doWriteByteArray((byte[])obj);
                    break;
                }
                case SHORT_ARR: {
                    writer.doWriteShortArray((short[])obj);
                    break;
                }
                case INT_ARR: {
                    writer.doWriteIntArray((int[])obj);
                    break;
                }
                case LONG_ARR: {
                    writer.doWriteLongArray((long[])obj);
                    break;
                }
                case FLOAT_ARR: {
                    writer.doWriteFloatArray((float[])obj);
                    break;
                }
                case DOUBLE_ARR: {
                    writer.doWriteDoubleArray((double[])obj);
                    break;
                }
                case CHAR_ARR: {
                    writer.doWriteCharArray((char[])obj);
                    break;
                }
                case BOOLEAN_ARR: {
                    writer.doWriteBooleanArray((boolean[])obj);
                    break;
                }
                case DECIMAL_ARR: {
                    writer.doWriteDecimalArray((BigDecimal[])obj);
                    break;
                }
                case STRING_ARR: {
                    writer.doWriteStringArray((String[])obj);
                    break;
                }
                case UUID_ARR: {
                    writer.doWriteUuidArray((UUID[])obj);
                    break;
                }
                case DATE_ARR: {
                    writer.doWriteDateArray((Date[])obj);
                    break;
                }
                case TIMESTAMP_ARR: {
                    writer.doWriteTimestampArray((Timestamp[])obj);
                    break;
                }
                case TIME_ARR: {
                    writer.doWriteTimeArray((Time[])obj);
                    break;
                }
                case OBJECT_ARR: {
                    writer.doWriteObjectArray((Object[])obj);
                    break;
                }
                case COL: {
                    writer.doWriteCollection((Collection)obj);
                    break;
                }
                case MAP: {
                    writer.doWriteMap((Map)obj);
                    break;
                }
                case ENUM: {
                    writer.doWriteEnum((Enum)obj);
                    break;
                }
                case BINARY_ENUM: {
                    writer.doWriteBinaryEnum((BinaryEnumObjectImpl)obj);
                    break;
                }
                case ENUM_ARR: {
                    writer.doWriteEnumArray((Object[])obj);
                    break;
                }
                case CLASS: {
                    writer.doWriteClass((Class)obj);
                    break;
                }
                case PROXY: {
                    writer.doWriteProxy((Proxy)obj, this.intfs);
                    break;
                }
                case BINARY_OBJ: {
                    writer.doWriteBinaryObject((BinaryObjectImpl)obj);
                    break;
                }
                case BINARY: {
                    if (!this.preWrite(writer, obj)) break;
                    try {
                        int n;
                        if (this.serializer != null) {
                            this.serializer.writeBinary(obj, writer);
                        } else {
                            ((Binarylizable)obj).writeBinary(writer);
                        }
                        this.postWrite(writer);
                        if (obj.getClass() != BinaryMetadata.class && obj.getClass() != BinaryTreeMap.class && this.schemaReg.schema(n = writer.schemaId()) == null) {
                            BinaryMetadataCollector collector = new BinaryMetadataCollector(this.typeId, this.typeName, this.mapper);
                            if (this.serializer != null) {
                                this.serializer.writeBinary(obj, collector);
                            } else {
                                ((Binarylizable)obj).writeBinary(collector);
                            }
                            BinarySchema newSchema = collector.schema();
                            this.schemaReg.addSchema(newSchema.schemaId(), newSchema);
                            if (this.userType) {
                                BinaryMetadata meta = new BinaryMetadata(this.typeId, this.typeName, collector.meta(), this.affKeyFieldName, Collections.singleton(newSchema), false, null);
                                this.ctx.updateMetadata(this.typeId, meta, writer.failIfUnregistered());
                            }
                        }
                        this.postWriteHashCode(writer, obj);
                        break;
                    }
                    finally {
                        writer.popSchema();
                    }
                }
                case OBJECT: {
                    if (this.userType && !this.stableSchemaPublished) {
                        BinaryMetadata binaryMetadata = new BinaryMetadata(this.typeId, this.typeName, this.stableFieldsMeta, this.affKeyFieldName, Collections.singleton(this.stableSchema), false, null);
                        this.ctx.updateMetadata(this.typeId, binaryMetadata, writer.failIfUnregistered());
                        this.schemaReg.addSchema(this.stableSchema.schemaId(), this.stableSchema);
                        this.stableSchemaPublished = true;
                    }
                    if (!this.preWrite(writer, obj)) break;
                    try {
                        for (BinaryFieldAccessor info : this.fields) {
                            info.write(obj, writer);
                        }
                        writer.schemaId(this.stableSchema.schemaId());
                        this.postWrite(writer);
                        this.postWriteHashCode(writer, obj);
                        break;
                    }
                    finally {
                        writer.popSchema();
                    }
                }
                default: {
                    assert (false) : "Invalid mode: " + (Object)((Object)this.mode);
                    break;
                }
            }
        }
        catch (UnregisteredBinaryTypeException | UnregisteredClassException igniteException) {
            throw igniteException;
        }
        catch (Exception exception) {
            String msg = S.includeSensitive() && !F.isEmpty(this.typeName) ? "Failed to serialize object [typeName=" + this.typeName + ']' : "Failed to serialize object [typeId=" + this.typeId + ']';
            U.error(this.ctx.log(), msg, exception);
            throw new BinaryObjectException(msg, exception);
        }
    }

    Object read(BinaryReaderExImpl reader) throws BinaryObjectException {
        try {
            Object res;
            assert (reader != null);
            assert (this.mode != BinaryWriteMode.OPTIMIZED) : "OptimizedMarshaller should not be used here: " + this.cls.getName();
            switch (this.mode) {
                case BINARY: {
                    res = this.newInstance();
                    reader.setHandle(res);
                    if (this.serializer != null) {
                        this.serializer.readBinary(res, reader);
                        break;
                    }
                    ((Binarylizable)res).readBinary(reader);
                    break;
                }
                case OBJECT: {
                    res = this.newInstance();
                    reader.setHandle(res);
                    for (BinaryFieldAccessor info : this.fields) {
                        info.read(res, reader);
                    }
                    break;
                }
                default: {
                    assert (false) : "Invalid mode: " + (Object)((Object)this.mode);
                    return null;
                }
            }
            if (this.readResolveMtd != null) {
                try {
                    res = this.readResolveMtd.invoke(res, new Object[0]);
                    reader.setHandle(res);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof BinaryObjectException) {
                        throw (BinaryObjectException)e.getTargetException();
                    }
                    throw new BinaryObjectException("Failed to execute readResolve() method on " + res, e);
                }
            }
            return res;
        }
        catch (Exception e) {
            String msg = S.includeSensitive() && !F.isEmpty(this.typeName) ? "Failed to deserialize object [typeName=" + this.typeName + ']' : "Failed to deserialize object [typeId=" + this.typeId + ']';
            U.error(this.ctx.log(), msg, e);
            throw new BinaryObjectException(msg, e);
        }
    }

    BinaryClassDescriptor makeRegistered() {
        if (this.registered) {
            return this;
        }
        return new BinaryClassDescriptor(this.ctx, this.cls, this.userType, this.typeId, this.typeName, this.affKeyFieldName, this.mapper, this.initialSerializer, this.stableFieldsMeta != null, true);
    }

    BinaryMetadata metadata() {
        return new BinaryMetadata(this.typeId, this.typeName, this.stableFieldsMeta, this.affKeyFieldName, null, this.isEnum(), this.cls.isEnum() ? BinaryClassDescriptor.enumMap(this.cls) : null);
    }

    private static Map<String, Integer> enumMap(Class<?> cls) {
        assert (cls.isEnum());
        ?[] enumVals = cls.getEnumConstants();
        LinkedHashMap<String, Integer> enumMap = new LinkedHashMap<String, Integer>(enumVals.length);
        for (Object enumVal : enumVals) {
            enumMap.put(((Enum)enumVal).name(), ((Enum)enumVal).ordinal());
        }
        return enumMap;
    }

    private boolean preWrite(BinaryWriterExImpl writer, Object obj) {
        if (writer.tryWriteAsHandle(obj)) {
            return false;
        }
        writer.preWrite(this.registered ? null : this.cls.getName());
        return true;
    }

    private void postWrite(BinaryWriterExImpl writer) {
        writer.postWrite(this.userType, this.registered);
    }

    private void postWriteHashCode(BinaryWriterExImpl writer, Object obj) {
        if (!(obj instanceof CacheObjectImpl)) {
            writer.postWriteHashCode(this.registered ? null : this.cls.getName());
        }
    }

    private Object newInstance() throws BinaryObjectException {
        try {
            return this.ctor != null ? this.ctor.newInstance(new Object[0]) : GridUnsafe.allocateInstance(this.cls);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BinaryObjectException("Failed to instantiate instance: " + this.cls, e);
        }
    }

    @Nullable
    private static Constructor<?> constructor(Class<?> cls) throws BinaryObjectException {
        assert (cls != null);
        try {
            Constructor<?> ctor = U.forceEmptyConstructor(cls);
            if (ctor == null) {
                throw new BinaryObjectException("Failed to find empty constructor for class: " + cls.getName());
            }
            ctor.setAccessible(true);
            return ctor;
        }
        catch (IgniteCheckedException e) {
            throw new BinaryObjectException("Failed to get constructor for class: " + cls.getName(), e);
        }
    }

    public String toString() {
        return S.toString(BinaryClassDescriptor.class, this);
    }
}

