/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import javax.management.JMException;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsAdapter;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.DataStorageMetricsAdapter;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteEncryption;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.Ignition;
import org.apache.ignite.MemoryMetrics;
import org.apache.ignite.PersistenceMetrics;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridDiagnostic;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridKernalContextImpl;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.GridKernalGatewayImpl;
import org.apache.ignite.internal.GridKernalState;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.GridPluginComponent;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteNeedReconnectException;
import org.apache.ignite.internal.IgniteSchedulerImpl;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.SkipDaemon;
import org.apache.ignite.internal.SupportFeaturesUtils;
import org.apache.ignite.internal.binary.BinaryEnumCache;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.maintenance.MaintenanceProcessor;
import org.apache.ignite.internal.managers.GridManager;
import org.apache.ignite.internal.managers.IgniteMBeansManager;
import org.apache.ignite.internal.managers.checkpoint.GridCheckpointManager;
import org.apache.ignite.internal.managers.collision.GridCollisionManager;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.DiscoveryLocalJoinData;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.failover.GridFailoverManager;
import org.apache.ignite.internal.managers.indexing.GridIndexingManager;
import org.apache.ignite.internal.managers.loadbalancer.GridLoadBalancerManager;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.managers.systemview.IgniteConfigurationIterable;
import org.apache.ignite.internal.managers.systemview.walker.ConfigurationViewWalker;
import org.apache.ignite.internal.managers.tracing.GridTracingManager;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.authentication.IgniteAuthenticationProcessor;
import org.apache.ignite.internal.processors.cache.CacheConfigurationOverride;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtilityKey;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsConsistentIdProcessor;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.cluster.ClusterProcessor;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.cluster.IGridClusterStateProcessor;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationProcessor;
import org.apache.ignite.internal.processors.continuous.GridContinuousProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.diagnostic.DiagnosticProcessor;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.job.GridJobProcessor;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetricsProcessor;
import org.apache.ignite.internal.processors.localtask.DurableBackgroundTasksProcessor;
import org.apache.ignite.internal.processors.marshaller.GridMarshallerMappingProcessor;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageImpl;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.nodevalidation.OsDiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.processors.platform.PlatformNoopProcessor;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.plugin.PlatformPluginProcessor;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.processors.port.GridPortProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.processors.rest.GridRestProcessor;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.IgniteSecurityProcessor;
import org.apache.ignite.internal.processors.security.NoOpIgniteSecurityProcessor;
import org.apache.ignite.internal.processors.segmentation.GridSegmentationProcessor;
import org.apache.ignite.internal.processors.service.GridServiceProcessor;
import org.apache.ignite.internal.processors.service.IgniteServiceProcessor;
import org.apache.ignite.internal.processors.session.GridTaskSessionProcessor;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.processors.task.GridTaskProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.processors.txdr.NoOpTransactionalDrProcessor;
import org.apache.ignite.internal.processors.txdr.TransactionalDrProcessor;
import org.apache.ignite.internal.suggestions.GridPerformanceSuggestions;
import org.apache.ignite.internal.suggestions.JvmConfigurationSuggestions;
import org.apache.ignite.internal.suggestions.OsConfigurationSuggestions;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.TimeBag;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridAbsClosure;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lifecycle.LifecycleBean;
import org.apache.ignite.lifecycle.LifecycleEventType;
import org.apache.ignite.marshaller.MarshallerExclusions;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.mxbean.IgniteMXBean;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiVersionCheckException;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.isolated.IsolatedDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.tracing.TracingConfigurationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteKernal
implements IgniteEx,
IgniteMXBean,
Externalizable {
    private static final long serialVersionUID = 0L;
    public static final String SITE = "gridgain.com";
    public static final String DOC = "gridgain.com/docs/index.html";
    public static final String NL = U.nl();
    public static final String CFG_VIEW = "configuration";
    public static final String CFG_VIEW_DESC = "Node configuration";
    private static final int MEGABYTE = 0x100000;
    public static final long DFLT_PERIODIC_STARVATION_CHECK_FREQ = 30000L;
    private static final Object STOP_RECONNECT = new Object();
    public static final String COORDINATOR_PROPERTIES_SEPARATOR = ",";
    public static final long DFLT_LONG_OPERATIONS_DUMP_TIMEOUT = 60000L;
    private static final long PERIODIC_COLLECTION_PDS_ALLOCATION_SIZE_FREQ = 60000L;
    private static final long PERIODIC_COLLECTION_PDS_ALLOCATION_SIZE_DELAY = 60000L;
    public static final boolean DFLT_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED = true;
    public static final boolean DFLT_LOG_CLASSPATH_CONTENT_ON_STARTUP = true;
    private LongJVMPauseDetector longJVMPauseDetector;
    @GridToStringExclude
    private GridKernalContextImpl ctx;
    @GridToStringExclude
    private IgniteMBeansManager mBeansMgr;
    private IgniteConfiguration cfg;
    @GridToStringExclude
    private GridLoggerProxy log;
    private String igniteInstanceName;
    private long startTime = U.currentTimeMillis();
    private GridSpringResourceContext rsrcCtx;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask starveTask;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask metricsLogTask;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask collectAllocationPDSTask;
    @GridToStringExclude
    private boolean errOnStop;
    @GridToStringExclude
    private IgniteScheduler scheduler;
    @GridToStringExclude
    private final AtomicReference<GridKernalGateway> gw = new AtomicReference();
    @GridToStringExclude
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ReconnectState reconnectState = new ReconnectState();

    public IgniteKernal() {
        this(null);
    }

    public IgniteKernal(@Nullable GridSpringResourceContext rsrcCtx) {
        this.rsrcCtx = rsrcCtx;
    }

    @Override
    public IgniteClusterEx cluster() {
        return this.ctx.cluster().get();
    }

    @Override
    public ClusterNode localNode() {
        return this.ctx.cluster().get().localNode();
    }

    @Override
    public IgniteCompute compute() {
        return ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).compute();
    }

    @Override
    public IgniteMessaging message() {
        return this.ctx.cluster().get().message();
    }

    @Override
    public IgniteEvents events() {
        return this.ctx.cluster().get().events();
    }

    @Override
    public IgniteServices services() {
        this.checkClusterState();
        return ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).services();
    }

    @Override
    public ExecutorService executorService() {
        return this.ctx.cluster().get().executorService();
    }

    @Override
    public final IgniteCompute compute(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).compute();
    }

    @Override
    public final IgniteMessaging message(ClusterGroup prj) {
        return ((ClusterGroupAdapter)prj).message();
    }

    @Override
    public final IgniteEvents events(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).events();
    }

    @Override
    public IgniteServices services(ClusterGroup grp) {
        this.checkClusterState();
        return ((ClusterGroupAdapter)grp).services();
    }

    @Override
    public ExecutorService executorService(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).executorService();
    }

    @Override
    public String name() {
        return this.igniteInstanceName;
    }

    @Override
    public String getCopyright() {
        return IgniteVersionUtils.COPYRIGHT;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTime;
    }

    @Override
    public String getStartTimestampFormatted() {
        return DateFormat.getDateTimeInstance().format(new Date(this.startTime));
    }

    @Override
    public boolean isRebalanceEnabled() {
        return this.ctx.cache().context().isRebalanceEnabled();
    }

    @Override
    public void rebalanceEnabled(boolean rebalanceEnabled) {
        this.ctx.cache().context().rebalanceEnabled(rebalanceEnabled);
    }

    @Override
    public long getUpTime() {
        return U.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getLongJVMPausesCount() {
        return this.longJVMPauseDetector != null ? this.longJVMPauseDetector.longPausesCount() : 0L;
    }

    @Override
    public long getLongJVMPausesTotalDuration() {
        return this.longJVMPauseDetector != null ? this.longJVMPauseDetector.longPausesTotalDuration() : 0L;
    }

    @Override
    public Map<Long, Long> getLongJVMPauseLastEvents() {
        return this.longJVMPauseDetector != null ? this.longJVMPauseDetector.longPauseEvents() : Collections.emptyMap();
    }

    @Override
    public String getUpTimeFormatted() {
        return X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime);
    }

    @Override
    public String getFullVersion() {
        return IgniteVersionUtils.VER_STR + '-' + IgniteVersionUtils.BUILD_TSTAMP_STR;
    }

    @Override
    public String getCheckpointSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getCheckpointSpi());
    }

    @Override
    public String getCurrentCoordinatorFormatted() {
        ClusterNode node = this.ctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
        if (node == null) {
            return "";
        }
        return node.addresses() + COORDINATOR_PROPERTIES_SEPARATOR + node.id() + COORDINATOR_PROPERTIES_SEPARATOR + node.order() + COORDINATOR_PROPERTIES_SEPARATOR + node.hostNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeInBaseline() {
        this.ctx.gateway().readLockAnyway();
        try {
            if (this.ctx.gateway().getState() != GridKernalState.STARTED) {
                boolean bl = false;
                return bl;
            }
            ClusterNode locNode = this.localNode();
            if (locNode.isClient() || locNode.isDaemon()) {
                boolean bl = false;
                return bl;
            }
            DiscoveryDataClusterState clusterState = this.ctx.state().clusterState();
            boolean bl = clusterState.hasBaselineTopology() && CU.baselineNode(locNode, clusterState);
            return bl;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public String getCommunicationSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getCommunicationSpi().toString();
    }

    @Override
    public String getDeploymentSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getDeploymentSpi().toString();
    }

    @Override
    public String getDiscoverySpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getDiscoverySpi().toString();
    }

    @Override
    public String getEventStorageSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getEventStorageSpi().toString();
    }

    @Override
    public String getCollisionSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getCollisionSpi().toString();
    }

    @Override
    public String getFailoverSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getFailoverSpi());
    }

    @Override
    public String getLoadBalancingSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getLoadBalancingSpi());
    }

    @Override
    public String getOsInformation() {
        return U.osString();
    }

    @Override
    public String getJdkInformation() {
        return U.jdkString();
    }

    @Override
    public String getOsUser() {
        return System.getProperty("user.name");
    }

    @Override
    public void printLastErrors() {
        this.ctx.exceptionRegistry().printErrors(this.log);
    }

    @Override
    public String getVmName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    @Override
    public String getInstanceName() {
        return this.igniteInstanceName;
    }

    @Override
    public String getExecutorServiceFormatted() {
        assert (this.cfg != null);
        return String.valueOf(this.cfg.getPublicThreadPoolSize());
    }

    @Override
    public int getPublicThreadPoolSize() {
        assert (this.cfg != null);
        return this.cfg.getPublicThreadPoolSize();
    }

    @Override
    public String getIgniteHome() {
        assert (this.cfg != null);
        return this.cfg.getIgniteHome();
    }

    @Override
    public String getGridLoggerFormatted() {
        assert (this.cfg != null);
        return this.cfg.getGridLogger().toString();
    }

    @Override
    public String getMBeanServerFormatted() {
        assert (this.cfg != null);
        return this.cfg.getMBeanServer().toString();
    }

    @Override
    public UUID getLocalNodeId() {
        assert (this.cfg != null);
        return this.cfg.getNodeId();
    }

    @Override
    public List<String> getUserAttributesFormatted() {
        assert (this.cfg != null);
        return (List)F.transform(this.cfg.getUserAttributes().entrySet(), new C1<Map.Entry<String, ?>, String>(){

            @Override
            public String apply(Map.Entry<String, ?> e) {
                return e.getKey() + ", " + e.getValue().toString();
            }
        });
    }

    @Override
    public boolean isPeerClassLoadingEnabled() {
        assert (this.cfg != null);
        return this.cfg.isPeerClassLoadingEnabled();
    }

    @Override
    public List<String> getLifecycleBeansFormatted() {
        LifecycleBean[] beans2 = this.cfg.getLifecycleBeans();
        if (F.isEmpty(beans2)) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(beans2.length);
        for (LifecycleBean bean2 : beans2) {
            res.add(String.valueOf(bean2));
        }
        return res;
    }

    private void add(String name, @Nullable Serializable val) throws IgniteCheckedException {
        assert (name != null);
        if (this.ctx.addNodeAttribute(name, val) != null) {
            if (name.endsWith("org.apache.ignite.spi.class")) {
                throw new IgniteCheckedException("Failed to set SPI attribute. Duplicated SPI name found: " + name.substring(0, name.length() - "org.apache.ignite.spi.class".length()));
            }
            assert (false) : "Duplicate attribute: " + name;
        }
    }

    private void notifyLifecycleBeans(LifecycleEventType evt) throws IgniteCheckedException {
        if (!this.cfg.isDaemon() && this.cfg.getLifecycleBeans() != null) {
            for (LifecycleBean bean2 : this.cfg.getLifecycleBeans()) {
                if (bean2 == null) continue;
                try {
                    bean2.onLifecycleEvent(evt);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException(e);
                }
            }
        }
    }

    private void notifyLifecycleBeansEx(LifecycleEventType evt) {
        block2: {
            try {
                this.notifyLifecycleBeans(evt);
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to notify lifecycle bean (safely ignored) [evt=" + (Object)((Object)evt) + (this.igniteInstanceName == null ? "" : ", igniteInstanceName=" + this.igniteInstanceName) + ']', e);
                if (!(e instanceof Error)) break block2;
                throw (Error)e;
            }
        }
    }

    private void ackClassPathElementRecursive(File clsPathEntry, SB clsPathContent) {
        if (clsPathEntry.isDirectory()) {
            String[] list;
            for (String listElement : list = clsPathEntry.list()) {
                this.ackClassPathElementRecursive(new File(clsPathEntry, listElement), clsPathContent);
            }
        } else {
            String path = clsPathEntry.getAbsolutePath();
            if (path.endsWith(".class")) {
                clsPathContent.a(path).a(";");
            }
        }
    }

    private void ackClassPathEntry(String clsPathEntry, SB clsPathContent) {
        File clsPathElementFile = new File(clsPathEntry);
        if (clsPathElementFile.isDirectory()) {
            this.ackClassPathElementRecursive(clsPathElementFile, clsPathContent);
        } else {
            String extension;
            String string = extension = clsPathEntry.length() >= 4 ? clsPathEntry.substring(clsPathEntry.length() - 4).toLowerCase() : null;
            if (".jar".equals(extension) || ".zip".equals(extension)) {
                clsPathContent.a(clsPathEntry).a(";");
            }
        }
    }

    private void ackClassPathWildCard(String clsPathEntry, SB clsPathContent) {
        int lastSeparatorIdx = clsPathEntry.lastIndexOf(File.separator);
        int asteriskIdx = clsPathEntry.indexOf(42);
        if (asteriskIdx >= 0 && asteriskIdx < lastSeparatorIdx) {
            throw new RuntimeException("Could not parse classpath entry");
        }
        int fileMaskFirstIdx = lastSeparatorIdx + 1;
        String fileMask = fileMaskFirstIdx >= clsPathEntry.length() ? "*.jar" : clsPathEntry.substring(fileMaskFirstIdx);
        Path path = Paths.get(lastSeparatorIdx > 0 ? clsPathEntry.substring(0, lastSeparatorIdx) : ".", new String[0]).toAbsolutePath().normalize();
        if (lastSeparatorIdx == 0) {
            path = path.getRoot();
        }
        try {
            DirectoryStream<Path> files = Files.newDirectoryStream(path, fileMask);
            for (Path f : files) {
                String s2 = f.toString();
                if (!s2.toLowerCase().endsWith(".jar")) continue;
                clsPathContent.a(f.toString()).a(";");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void ackClassPathContent() {
        assert (this.log != null);
        boolean enabled = IgniteSystemProperties.getBoolean("IGNITE_LOG_CLASSPATH_CONTENT_ON_STARTUP", true);
        if (enabled) {
            String clsPath = System.getProperty("java.class.path", ".");
            String[] clsPathElements = clsPath.split(File.pathSeparator);
            U.log(this.log, "Classpath value: " + clsPath);
            SB clsPathContent = new SB("List of files containing in classpath: ");
            for (String clsPathEntry : clsPathElements) {
                try {
                    if (clsPathEntry.contains("*")) {
                        this.ackClassPathWildCard(clsPathEntry, clsPathContent);
                        continue;
                    }
                    this.ackClassPathEntry(clsPathEntry, clsPathContent);
                }
                catch (Exception e) {
                    U.warn(this.log, String.format("Could not log class path entry '%s': %s", clsPathEntry, e.getMessage()));
                }
            }
            U.log(this.log, clsPathContent.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(IgniteConfiguration cfg, GridAbsClosure errHnd, WorkersRegistry workerRegistry, Thread.UncaughtExceptionHandler hnd, TimeBag startTimer) throws IgniteCheckedException {
        long metricsLogFreq;
        boolean starveCheck;
        this.gw.compareAndSet(null, new GridKernalGatewayImpl(cfg.getIgniteInstanceName()));
        GridKernalGateway gw = this.gw.get();
        gw.writeLock();
        try {
            switch (gw.getState()) {
                case STARTED: {
                    U.warn(this.log, "Grid has already been started (ignored).");
                    return;
                }
                case STARTING: {
                    U.warn(this.log, "Grid is already in process of being started (ignored).");
                    return;
                }
                case STOPPING: {
                    throw new IgniteCheckedException("Grid is in process of being stopped");
                }
            }
            gw.setState(GridKernalState.STARTING);
        }
        finally {
            gw.writeUnlock();
        }
        assert (cfg != null);
        this.validateCommon(cfg);
        this.igniteInstanceName = cfg.getIgniteInstanceName();
        this.cfg = cfg;
        this.log = (GridLoggerProxy)cfg.getGridLogger().getLogger(this.getClass().getName() + (this.igniteInstanceName != null ? '%' + this.igniteInstanceName : ""));
        this.longJVMPauseDetector = new LongJVMPauseDetector(this.log);
        this.longJVMPauseDetector.start();
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        this.ackAsciiLogo();
        this.ackConfigUrl();
        this.ackConfiguration(cfg);
        this.ackDaemon();
        this.ackOsInfo();
        this.ackLanguageRuntime();
        this.ackRemoteManagement();
        this.ackLogger();
        this.ackVmArguments(rtBean);
        this.ackClassPaths(rtBean);
        this.ackSystemProperties();
        this.ackEnvironmentVariables();
        this.ackMemoryConfiguration();
        this.ackCacheConfiguration();
        this.ackP2pConfiguration();
        this.ackRebalanceConfiguration();
        this.ackIPv4StackFlagIsSet();
        this.ackWaitForBackupsOnShutdownPropertyIsUsed();
        if (this.log.isInfoEnabled() && cfg.getIgniteHome() != null) {
            this.log.info("3-rd party licenses can be found at: " + cfg.getIgniteHome() + File.separatorChar + "libs" + File.separatorChar + "licenses");
        }
        for (String name : cfg.getUserAttributes().keySet()) {
            if (!name.startsWith("org.apache.ignite")) continue;
            throw new IgniteCheckedException("User attribute has illegal name: '" + name + "'. Note that all names starting with '" + "org.apache.ignite" + "' are reserved for internal use.");
        }
        this.logNodeUserAttributes();
        this.ackSpis();
        List<PluginProvider> plugins = cfg.getPluginProviders() != null && cfg.getPluginProviders().length > 0 ? Arrays.asList(cfg.getPluginProviders()) : U.allPluginProviders();
        try {
            boolean active;
            this.ctx = new GridKernalContextImpl(this.log, this, cfg, gw, plugins, MarshallerUtils.classNameFilter(this.getClass().getClassLoader()), workerRegistry, hnd, this.longJVMPauseDetector);
            this.startProcessor(new DiagnosticProcessor(this.ctx));
            this.mBeansMgr = new IgniteMBeansManager(this);
            cfg.getMarshaller().setContext(this.ctx.marshallerContext());
            this.startProcessor(new GridInternalSubscriptionProcessor(this.ctx));
            ClusterProcessor clusterProc = new ClusterProcessor(this.ctx);
            this.startProcessor(clusterProc);
            U.onGridStart();
            GridResourceProcessor rsrcProc = new GridResourceProcessor(this.ctx);
            rsrcProc.setSpringContext(this.rsrcCtx);
            this.scheduler = new IgniteSchedulerImpl(this.ctx);
            this.startProcessor(rsrcProc);
            if (!cfg.isDaemon() && cfg.getLifecycleBeans() != null) {
                for (LifecycleBean bean2 : cfg.getLifecycleBeans()) {
                    if (bean2 == null) continue;
                    rsrcProc.inject(bean2);
                }
            }
            this.notifyLifecycleBeans(LifecycleEventType.BEFORE_NODE_START);
            U.startLifecycleAware(this.lifecycleAwares(cfg));
            this.startProcessor(new IgnitePluginProcessor(this.ctx, cfg, plugins));
            this.startProcessor(new FailureProcessor(this.ctx));
            this.startProcessor(new PoolProcessor(this.ctx));
            GridDiagnostic.runBackgroundCheck(this.igniteInstanceName, this.ctx.pools().getExecutorService(), this.log);
            this.startProcessor(new GridClosureProcessor(this.ctx));
            this.startProcessor(new GridPortProcessor(this.ctx));
            this.startProcessor(new GridJobMetricsProcessor(this.ctx));
            this.startProcessor(new GridTimeoutProcessor(this.ctx));
            this.startProcessor(this.securityProcessor());
            try {
                this.startManager(new GridTracingManager((GridKernalContext)this.ctx, false));
            }
            catch (IgniteCheckedException e) {
                this.startManager(new GridTracingManager((GridKernalContext)this.ctx, true));
            }
            this.startManager(new GridMetricManager(this.ctx));
            this.startManager(new GridSystemViewManager(this.ctx));
            this.startManager(new GridIoManager(this.ctx));
            this.startManager(new GridCheckpointManager(this.ctx));
            this.startManager(new GridEventStorageManager(this.ctx));
            this.startManager(new GridDeploymentManager(this.ctx));
            this.startManager(new GridLoadBalancerManager(this.ctx));
            this.startManager(new GridFailoverManager(this.ctx));
            this.startManager(new GridCollisionManager(this.ctx));
            this.startManager(new GridIndexingManager(this.ctx));
            this.ackSecurity();
            GridDiscoveryManager discoMgr = new GridDiscoveryManager(this.ctx);
            this.ctx.add(discoMgr, false);
            this.startManager(new GridEncryptionManager(this.ctx));
            this.startProcessor(new PdsConsistentIdProcessor(this.ctx));
            MaintenanceProcessor mntcProcessor = new MaintenanceProcessor(this.ctx);
            this.startProcessor(mntcProcessor);
            if (mntcProcessor.isMaintenanceMode()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Node is being started in maintenance mode. Starting IsolatedDiscoverySpi instead of configured discovery SPI.");
                }
                cfg.setClusterStateOnStart(ClusterState.INACTIVE);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Overriding 'clusterStateOnStart' configuration to 'INACTIVE'.");
                }
                this.ctx.config().setDiscoverySpi(new IsolatedDiscoverySpi());
                discoMgr = new GridDiscoveryManager(this.ctx);
                discoMgr.consistentId(this.ctx.pdsFolderResolver().resolveFolders().consistentId());
                this.ctx.add(discoMgr, false);
            }
            try {
                this.startProcessor((GridProcessor)IgniteComponentType.COMPRESSION.createOptional(this.ctx));
                this.startProcessor(new GridMarshallerMappingProcessor(this.ctx));
                this.startProcessor(new MvccProcessorImpl(this.ctx));
                this.startProcessor(IgniteKernal.createComponent(DiscoveryNodeValidationProcessor.class, this.ctx));
                this.startProcessor(new GridAffinityProcessor(this.ctx));
                this.startProcessor(IgniteKernal.createComponent(GridSegmentationProcessor.class, this.ctx));
                startTimer.finishGlobalStage("Start managers");
                this.startProcessor(IgniteKernal.createComponent(IgniteCacheObjectProcessor.class, this.ctx));
                startTimer.finishGlobalStage("Configure binary metadata");
                this.startProcessor(IgniteKernal.createComponent(IGridClusterStateProcessor.class, this.ctx));
                this.startProcessor(new IgniteAuthenticationProcessor(this.ctx));
                this.startProcessor(new GridCacheProcessor(this.ctx));
                this.startProcessor(new GridQueryProcessor(this.ctx));
                this.startProcessor(new ClientListenerProcessor(this.ctx));
                this.startProcessor(this.createServiceProcessor());
                this.startProcessor(new GridTaskSessionProcessor(this.ctx));
                this.startProcessor(new GridJobProcessor(this.ctx));
                this.startProcessor(new GridTaskProcessor(this.ctx));
                this.startProcessor((GridProcessor)IgniteComponentType.SCHEDULE.createOptional(this.ctx));
                this.startProcessor(new GridRestProcessor(this.ctx));
                this.startProcessor(new DataStreamProcessor(this.ctx));
                this.startProcessor(new GridContinuousProcessor(this.ctx));
                this.startProcessor(new DataStructuresProcessor(this.ctx));
                this.startProcessor(IgniteKernal.createComponent(PlatformProcessor.class, this.ctx));
                if (SupportFeaturesUtils.isFeatureEnabled("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE")) {
                    this.startProcessor(new DistributedMetaStorageImpl(this.ctx));
                }
                this.startProcessor(new DistributedConfigurationProcessor(this.ctx));
                this.startProcessor(new DurableBackgroundTasksProcessor(this.ctx));
                this.startProcessor(IgniteKernal.createComponent(TransactionalDrProcessor.class, this.ctx));
                startTimer.finishGlobalStage("Start processors");
                for (PluginProvider provider : this.ctx.plugins().allProviders()) {
                    this.ctx.add(new GridPluginComponent(provider));
                    provider.start((PluginContext)this.ctx.plugins().pluginContextForProvider(provider));
                    startTimer.finishGlobalStage("Start '" + provider.name() + "' plugin");
                }
                if (this.ctx.config().getPlatformConfiguration() != null) {
                    this.startProcessor(new PlatformPluginProcessor(this.ctx));
                }
                this.mBeansMgr.registerMBeansDuringInitPhase();
                this.ctx.cluster().initDiagnosticListeners();
                this.fillNodeAttributes(clusterProc.updateNotifierEnabled());
                this.ctx.cache().context().database().notifyMetaStorageSubscribersOnReadyForRead();
                if (SupportFeaturesUtils.isFeatureEnabled("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE")) {
                    ((DistributedMetaStorageImpl)this.ctx.distributedMetastorage()).inMemoryReadyForRead();
                }
                startTimer.finishGlobalStage("Init metastore");
                this.ctx.cache().context().database().startMemoryRestore(this.ctx, startTimer);
                this.ctx.recoveryMode(false);
                startTimer.finishGlobalStage("Finish recovery");
            }
            catch (Throwable e) {
                U.error(this.log, "Exception during start processors, node will be stopped and close connections", e);
                this.ctx.discovery().stop(true);
                throw e;
            }
            mntcProcessor.prepareAndExecuteMaintenance();
            gw.writeLock();
            try {
                gw.setState(GridKernalState.STARTED);
                this.startManager(discoMgr);
            }
            finally {
                gw.writeUnlock();
            }
            startTimer.finishGlobalStage("Join topology");
            this.checkFileEncoding();
            this.checkPhysicalRam();
            this.suggestOptimizations(cfg);
            this.ctx.performance().addAll(JvmConfigurationSuggestions.getSuggestions());
            this.ctx.performance().addAll(OsConfigurationSuggestions.getSuggestions());
            DiscoveryLocalJoinData joinData = this.ctx.discovery().localJoin();
            IgniteInternalFuture<Boolean> transitionWaitFut = joinData.transitionWaitFuture();
            this.ctx.discovery().onKernalStart(true);
            this.ctx.io().onKernalStart(true);
            if (transitionWaitFut != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Join cluster while cluster state transition is in progress, waiting when transition finish.");
                }
                active = transitionWaitFut.get();
            } else {
                active = joinData.active();
            }
            startTimer.finishGlobalStage("Await transition");
            this.ctx.pools().registerMetrics();
            this.registerMetrics();
            this.registerConfigurationSystemView();
            this.ctx.cluster().registerMetrics();
            this.mBeansMgr.registerMBeansAfterNodeStarted();
            boolean recon = false;
            for (GridComponent comp : this.ctx) {
                if (comp instanceof GridDiscoveryManager || comp instanceof GridIoManager || comp instanceof GridPluginComponent || this.skipDaemon(comp)) continue;
                try {
                    comp.onKernalStart(active);
                }
                catch (IgniteNeedReconnectException e) {
                    ClusterNode locNode = this.ctx.discovery().localNode();
                    assert (locNode.isClient());
                    if (!this.ctx.discovery().reconnectSupported()) {
                        throw new IgniteCheckedException("Client node in forceServerMode is not allowed to reconnect to the cluster and will be stopped.");
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to start node components on node start, will wait for reconnect: " + e);
                    }
                    recon = true;
                }
            }
            for (PluginProvider provider : this.ctx.plugins().allProviders()) {
                provider.onIgniteStart();
            }
            if (recon) {
                this.reconnectState.waitFirstReconnect();
            }
            this.notifyLifecycleBeans(LifecycleEventType.AFTER_NODE_START);
        }
        catch (Throwable e) {
            IgniteSpiVersionCheckException verCheckErr = X.cause(e, IgniteSpiVersionCheckException.class);
            if (verCheckErr != null) {
                U.error(this.log, verCheckErr.getMessage());
            } else if (X.hasCause(e, InterruptedException.class, IgniteInterruptedCheckedException.class)) {
                U.warn(this.log, "Grid startup routine has been interrupted (will rollback).");
            } else {
                U.error(this.log, "Got exception while starting (will rollback startup routine).", e);
            }
            errHnd.apply();
            this.stop(true);
            if (e instanceof Error) {
                throw e;
            }
            if (e instanceof IgniteCheckedException) {
                throw (IgniteCheckedException)e;
            }
            throw new IgniteCheckedException(e);
        }
        this.startTime = U.currentTimeMillis();
        String intervalStr = IgniteSystemProperties.getString("IGNITE_STARVATION_CHECK_INTERVAL");
        boolean bl = starveCheck = !this.isDaemon() && !"0".equals(intervalStr);
        if (starveCheck) {
            final long interval = F.isEmpty(intervalStr) ? 30000L : Long.parseLong(intervalStr);
            this.starveTask = this.ctx.timeout().schedule(new Runnable(){
                private long lastCompletedCntPub;
                private long lastCompletedCntSys;
                private long lastCompletedCntQry;

                @Override
                public void run() {
                    ThreadPoolExecutor exec;
                    if (IgniteKernal.this.ctx.pools().getExecutorService() instanceof ThreadPoolExecutor) {
                        exec = (ThreadPoolExecutor)IgniteKernal.this.ctx.pools().getExecutorService();
                        this.lastCompletedCntPub = this.checkPoolStarvation(exec, this.lastCompletedCntPub, "public");
                    }
                    if (IgniteKernal.this.ctx.pools().getSystemExecutorService() instanceof ThreadPoolExecutor) {
                        exec = (ThreadPoolExecutor)IgniteKernal.this.ctx.pools().getSystemExecutorService();
                        this.lastCompletedCntSys = this.checkPoolStarvation(exec, this.lastCompletedCntSys, "system");
                    }
                    if (IgniteKernal.this.ctx.pools().getQueryExecutorService() instanceof ThreadPoolExecutor) {
                        exec = (ThreadPoolExecutor)IgniteKernal.this.ctx.pools().getQueryExecutorService();
                        this.lastCompletedCntQry = this.checkPoolStarvation(exec, this.lastCompletedCntQry, "query");
                    }
                    if (IgniteKernal.this.ctx.pools().getStripedExecutorService() != null) {
                        IgniteKernal.this.ctx.pools().getStripedExecutorService().detectStarvation();
                    }
                }

                private long checkPoolStarvation(ThreadPoolExecutor exec, long lastCompletedCnt, String pool) {
                    long completedCnt = exec.getCompletedTaskCount();
                    if (exec.getPoolSize() == exec.getActiveCount() && completedCnt == lastCompletedCnt && !exec.getQueue().isEmpty()) {
                        LT.warn(IgniteKernal.this.log, "Possible thread pool starvation detected (no task completed in last " + interval + "ms, is " + pool + " thread pool size large enough?)");
                        U.dumpThreads(IgniteKernal.this.log);
                    }
                    return completedCnt;
                }
            }, interval, interval);
        }
        if ((metricsLogFreq = cfg.getMetricsLogFrequency()) > 0L) {
            this.metricsLogTask = this.ctx.timeout().schedule(new Runnable(){
                private final DecimalFormat dblFmt = IgniteKernal.access$300();

                @Override
                public void run() {
                    IgniteKernal.this.ackNodeMetrics(this.dblFmt, IgniteKernal.this.ctx.pools().getExecutorService(), IgniteKernal.this.ctx.pools().getSystemExecutorService(), IgniteKernal.this.ctx.pools().getStripedExecutorService(), IgniteKernal.this.ctx.pools().customExecutors());
                }
            }, metricsLogFreq, metricsLogFreq);
        }
        this.collectAllocationPDSTask = this.ctx.timeout().schedule(new Runnable(){

            @Override
            public void run() {
                if (!(IgniteKernal.this.localNode() instanceof TcpDiscoveryNode)) {
                    return;
                }
                long allocatedPDSSize = IgniteKernal.this.allocatedPDSSize();
                TcpDiscoveryNode node = (TcpDiscoveryNode)IgniteKernal.this.localNode();
                HashMap<String, Object> attrs = new HashMap<String, Object>(node.getAttributes());
                attrs.put("org.apache.ignite.data.regions.allocated.size", allocatedPDSSize);
                node.setAttributes(attrs);
            }
        }, 60000L, 60000L);
        this.ctx.performance().add("Disable assertions (remove '-ea' from JVM options)", !U.assertionsEnabled());
        this.ctx.performance().logSuggestions(this.log, this.igniteInstanceName);
        U.quietAndInfo(this.log, "To start Console Management & Monitoring run ignitevisorcmd.{sh|bat}");
        if (!IgniteSystemProperties.getBoolean("IGNITE_QUIET", false)) {
            this.ackClassPathContent();
        }
        this.ackStart(rtBean);
        if (!this.isDaemon()) {
            this.ctx.discovery().ackTopology(this.ctx.discovery().localJoin().joinTopologyVersion().topologyVersion(), 10, this.localNode());
        }
        startTimer.finishGlobalStage("Await exchange");
    }

    private static DecimalFormat doubleFormat() {
        return new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));
    }

    private GridProcessor securityProcessor() throws IgniteCheckedException {
        GridSecurityProcessor prc = IgniteKernal.createComponent(GridSecurityProcessor.class, this.ctx);
        return prc != null && prc.enabled() ? new IgniteSecurityProcessor(this.ctx, prc) : new NoOpIgniteSecurityProcessor(this.ctx, prc);
    }

    private String createExecutorDescription(String execSvcName, ExecutorService execSvc) {
        ExecutorService exec;
        int poolSize = 0;
        int poolActiveThreads = 0;
        int poolQSize = 0;
        if (execSvc instanceof ThreadPoolExecutor) {
            exec = (ThreadPoolExecutor)execSvc;
            poolSize = ((ThreadPoolExecutor)exec).getPoolSize();
            poolActiveThreads = Math.min(poolSize, ((ThreadPoolExecutor)exec).getActiveCount());
            poolQSize = ((ThreadPoolExecutor)exec).getQueue().size();
        } else if (execSvc instanceof StripedExecutor) {
            exec = (StripedExecutor)execSvc;
            poolSize = ((StripedExecutor)exec).stripesCount();
            poolActiveThreads = ((StripedExecutor)exec).activeStripesCount();
            poolQSize = ((StripedExecutor)exec).queueSize();
        }
        int poolIdleThreads = poolSize - poolActiveThreads;
        return execSvcName + " [active=" + poolActiveThreads + ", idle=" + poolIdleThreads + ", qSize=" + poolQSize + "]";
    }

    private GridProcessorAdapter createServiceProcessor() {
        boolean srvcProcMode = IgniteSystemProperties.getBoolean("IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED", true);
        if (srvcProcMode) {
            return new IgniteServiceProcessor(this.ctx);
        }
        return new GridServiceProcessor(this.ctx);
    }

    private void validateCommon(IgniteConfiguration cfg) {
        A.notNull(cfg.getNodeId(), "cfg.getNodeId()");
        if (!U.IGNITE_MBEANS_DISABLED) {
            A.notNull(cfg.getMBeanServer(), "cfg.getMBeanServer()");
        }
        A.notNull(cfg.getGridLogger(), "cfg.getGridLogger()");
        A.notNull(cfg.getMarshaller(), "cfg.getMarshaller()");
        A.notNull(cfg.getUserAttributes(), "cfg.getUserAttributes()");
        A.notNull(cfg.getCheckpointSpi(), "cfg.getCheckpointSpi()");
        A.notNull(cfg.getCommunicationSpi(), "cfg.getCommunicationSpi()");
        A.notNull(cfg.getDeploymentSpi(), "cfg.getDeploymentSpi()");
        A.notNull(cfg.getDiscoverySpi(), "cfg.getDiscoverySpi()");
        A.notNull(cfg.getEventStorageSpi(), "cfg.getEventStorageSpi()");
        A.notNull(cfg.getCollisionSpi(), "cfg.getCollisionSpi()");
        A.notNull(cfg.getFailoverSpi(), "cfg.getFailoverSpi()");
        A.notNull(cfg.getLoadBalancingSpi(), "cfg.getLoadBalancingSpi()");
        A.notNull(cfg.getIndexingSpi(), "cfg.getIndexingSpi()");
        A.ensure(cfg.getNetworkTimeout() > 0L, "cfg.getNetworkTimeout() > 0");
        A.ensure(cfg.getNetworkSendRetryDelay() > 0L, "cfg.getNetworkSendRetryDelay() > 0");
        A.ensure(cfg.getNetworkSendRetryCount() > 0, "cfg.getNetworkSendRetryCount() > 0");
    }

    private void checkFileEncoding() {
        String encodingDisplayName = Charset.defaultCharset().displayName(Locale.ENGLISH);
        if (!"UTF-8".equals(encodingDisplayName)) {
            U.quietAndWarn(this.log, "Default character encoding is " + encodingDisplayName + ". Specify UTF-8 character encoding by setting -Dfile.encoding=UTF-8 JVM parameter. Differing character encodings across cluster may lead to erratic behavior.");
        }
    }

    private void checkPhysicalRam() {
        long ram = (Long)this.ctx.discovery().localNode().attribute("org.apache.ignite.phy.ram");
        if (ram != -1L) {
            long safeToUse;
            String macs = (String)this.ctx.discovery().localNode().attribute("org.apache.ignite.macs");
            long totalHeap = 0L;
            long totalOffheap = 0L;
            for (ClusterNode node : this.ctx.discovery().allNodes()) {
                if (!macs.equals(node.attribute("org.apache.ignite.macs"))) continue;
                long heap = node.metrics().getHeapMemoryMaximum();
                Long offheap = (Long)node.attribute("org.apache.ignite.offheap.size");
                if (heap != -1L) {
                    totalHeap += heap;
                }
                if (offheap == null) continue;
                totalOffheap += offheap.longValue();
            }
            long total = totalHeap + totalOffheap;
            if (total < 0L) {
                total = Long.MAX_VALUE;
            }
            if (total > (safeToUse = ram - Math.max(0x100000000L, (long)((double)ram * 0.2)))) {
                U.quietAndWarn(this.log, "Nodes started on local machine require more than 80% of physical RAM what can lead to significant slowdown due to swapping (please decrease JVM heap size, data region size or checkpoint buffer size) [required=" + (total >> 20) + "MB, available=" + (ram >> 20) + "MB]");
            }
        }
    }

    private void suggestOptimizations(IgniteConfiguration cfg) {
        GridPerformanceSuggestions perf = this.ctx.performance();
        if (this.ctx.collision().enabled()) {
            perf.add("Disable collision resolution (remove 'collisionSpi' from configuration)");
        }
        if (this.ctx.checkpoint().enabled()) {
            perf.add("Disable checkpoints (remove 'checkpointSpi' from configuration)");
        }
        if (cfg.isMarshalLocalJobs()) {
            perf.add("Disable local jobs marshalling (set 'marshalLocalJobs' to false)");
        }
        if (cfg.getIncludeEventTypes() != null && cfg.getIncludeEventTypes().length != 0) {
            perf.add("Disable grid events (remove 'includeEventTypes' from configuration)");
        }
        if (BinaryMarshaller.available() && cfg.getMarshaller() != null && !(cfg.getMarshaller() instanceof BinaryMarshaller)) {
            perf.add("Use default binary marshaller (do not set 'marshaller' explicitly)");
        }
    }

    private void fillNodeAttributes(boolean notifyEnabled) throws IgniteCheckedException {
        String portStr;
        this.ctx.addNodeAttribute("org.apache.ignite.rebalance.pool.size", this.configuration().getRebalanceThreadPoolSize());
        this.ctx.addNodeAttribute("org.apache.ignite.data.streamer.pool.size", this.configuration().getDataStreamerThreadPoolSize());
        String[] incProps = this.cfg.getIncludeProperties();
        try {
            for (Map.Entry<String, String> sysEntry : System.getenv().entrySet()) {
                String name = sysEntry.getKey();
                if (incProps != null && !U.containsStringArray(incProps, name, true) && !U.isVisorNodeStartProperty(name) && !U.isVisorRequiredProperty(name)) continue;
                this.ctx.addNodeAttribute(name, sysEntry.getValue());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added environment properties to node attributes.");
            }
        }
        catch (SecurityException e) {
            throw new IgniteCheckedException("Failed to add environment properties to node attributes due to security violation: " + e.getMessage());
        }
        try {
            for (Map.Entry<Object, Object> e : IgniteSystemProperties.snapshot().entrySet()) {
                String key = (String)e.getKey();
                if (incProps != null && !U.containsStringArray(incProps, key, true) && !U.isVisorRequiredProperty(key)) continue;
                Object val = this.ctx.nodeAttribute(key);
                if (val != null && !val.equals(e.getValue())) {
                    U.warn(this.log, "System property will override environment variable with the same name: " + key);
                }
                this.ctx.addNodeAttribute(key, e.getValue());
            }
            this.ctx.addNodeAttribute("org.apache.ignite.update.notifier.enabled", notifyEnabled);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added system properties to node attributes.");
            }
        }
        catch (SecurityException e) {
            throw new IgniteCheckedException("Failed to add system properties to node attributes due to security violation: " + e.getMessage());
        }
        String ips = F.concat(U.allLocalIps(), ", ");
        String macs = F.concat(U.allLocalMACs(), ", ");
        if (this.log.isInfoEnabled()) {
            this.log.info("Non-loopback local IPs: " + (F.isEmpty(ips) ? "N/A" : ips));
            this.log.info("Enabled local MACs: " + (F.isEmpty(macs) ? "N/A" : macs));
        }
        if (ips.isEmpty() && macs.isEmpty()) {
            U.warn(this.log, "Ignite is starting on loopback address... Only nodes on the same physical computer can participate in topology.");
        }
        this.add("org.apache.ignite.ips", (Serializable)((Object)(ips.isEmpty() ? "" : ips)));
        Map<String, ?> userAttrs = this.configuration().getUserAttributes();
        if (userAttrs != null && userAttrs.get("override.org.apache.ignite.macs") != null) {
            this.add("org.apache.ignite.macs", (Serializable)userAttrs.get("override.org.apache.ignite.macs"));
        } else {
            this.add("org.apache.ignite.macs", (Serializable)((Object)(macs.isEmpty() ? "" : macs)));
        }
        this.add("org.apache.ignite.jit.name", (Serializable)((Object)(U.getCompilerMx() == null ? "" : U.getCompilerMx().getName())));
        this.add("org.apache.ignite.build.ver", (Serializable)((Object)IgniteVersionUtils.VER_STR));
        this.add("org.apache.ignite.build.date", (Serializable)((Object)IgniteVersionUtils.BUILD_TSTAMP_STR));
        this.add("org.apache.ignite.marshaller", (Serializable)((Object)this.cfg.getMarshaller().getClass().getName()));
        this.add("org.apache.ignite.marshaller.useDefaultSUID", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID", OptimizedMarshaller.USE_DFLT_SUID)));
        this.add("org.apache.ignite.cache.lateAffinity", Boolean.valueOf(this.cfg.isLateAffinityAssignment()));
        if (this.cfg.getMarshaller() instanceof BinaryMarshaller) {
            this.add("org.apache.ignite.marshaller.compactFooter", Boolean.valueOf(this.cfg.getBinaryConfiguration() == null ? true : this.cfg.getBinaryConfiguration().isCompactFooter()));
            this.add("org.apache.ignite.marshaller.utf8SerializationVer2", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2", BinaryUtils.USE_STR_SERIALIZATION_VER_2)));
        }
        this.add("org.apache.ignite.user.name", (Serializable)((Object)System.getProperty("user.name")));
        this.add("org.apache.ignite.ignite.name", (Serializable)((Object)this.igniteInstanceName));
        this.add("org.apache.ignite.peer.classloading.enabled", Boolean.valueOf(this.cfg.isPeerClassLoadingEnabled()));
        this.add("org.apache.ignite.shutdown.policy", Integer.valueOf(this.cfg.getShutdownPolicy().index()));
        this.add("org.apache.ignite.ignite.dep.mode", (Serializable)((Object)this.cfg.getDeploymentMode()));
        this.add("org.apache.ignite.lang.rt", (Serializable)((Object)this.getLanguage()));
        this.add("org.apache.ignite.jvm.pid", Integer.valueOf(U.jvmPid()));
        this.add("org.apache.ignite.cache.client", this.cfg.isClientMode());
        this.add("org.apache.ignite.consistency.check.skipped", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK")));
        if (this.cfg.getConsistentId() != null) {
            this.add("org.apache.ignite.consistent.id", this.cfg.getConsistentId());
        }
        SB jvmArgs = new SB(512);
        for (String string : U.jvmArgs()) {
            if (string.startsWith("-")) {
                jvmArgs.a("@@@");
            } else {
                jvmArgs.a(' ');
            }
            jvmArgs.a(string);
        }
        this.add("org.apache.ignite.jvm.args", (Serializable)((Object)jvmArgs.toString()));
        if (this.isDaemon()) {
            this.add("org.apache.ignite.daemon", (Serializable)((Object)"true"));
        }
        if (this.isJmxRemoteEnabled() && (portStr = System.getProperty("com.sun.management.jmxremote.port")) != null) {
            try {
                this.add("org.apache.ignite.jmx.port", Integer.valueOf(Integer.parseInt(portStr)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.cfg.getConnectorConfiguration() != null) {
            this.add("org.apache.ignite.rest.port.range", Integer.valueOf(this.cfg.getConnectorConfiguration().getPortRange()));
        }
        this.add("org.apache.ignite.dynamic.cache.start.rollback.supported", Boolean.TRUE);
        this.addDataStorageConfigurationAttributes();
        this.add("org.apache.ignite.tx", this.cfg.getTransactionConfiguration());
        this.add("org.apache.ignite.features", (Serializable)IgniteFeatures.allFeatures(this.context()));
        this.addSpiAttributes(this.cfg.getCollisionSpi());
        this.addSpiAttributes(this.cfg.getDiscoverySpi());
        this.addSpiAttributes(this.cfg.getFailoverSpi());
        this.addSpiAttributes(this.cfg.getCommunicationSpi());
        this.addSpiAttributes(this.cfg.getEventStorageSpi());
        this.addSpiAttributes(this.cfg.getCheckpointSpi());
        this.addSpiAttributes(this.cfg.getLoadBalancingSpi());
        this.addSpiAttributes(this.cfg.getDeploymentSpi());
        this.addSpiAttributes(this.cfg.getTracingSpi());
        if (this.cfg.getUserAttributes() != null) {
            for (Map.Entry entry : this.cfg.getUserAttributes().entrySet()) {
                if (this.ctx.hasNodeAttribute((String)entry.getKey())) {
                    U.warn(this.log, "User or internal attribute has the same name as environment or system property and will take precedence: " + (String)entry.getKey());
                }
                this.ctx.addNodeAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        this.ctx.addNodeAttribute("org.apache.ignite.event.driven.service.processor.enabled", this.ctx.service() instanceof IgniteServiceProcessor);
    }

    private void addDataStorageConfigurationAttributes() throws IgniteCheckedException {
        MemoryConfiguration memCfg = this.cfg.getMemoryConfiguration();
        if (memCfg != null) {
            memCfg.setPageSize(this.cfg.getDataStorageConfiguration().getPageSize());
            this.add("org.apache.ignite.memory", memCfg);
        }
        this.add("org.apache.ignite.data.storage.config", (Serializable)new JdkMarshaller().marshal(this.cfg.getDataStorageConfiguration()));
    }

    private void addSpiAttributes(IgniteSpi ... spiList) throws IgniteCheckedException {
        for (IgniteSpi spi : spiList) {
            Class<?> spiCls = spi.getClass();
            this.add(U.spiAttribute(spi, "org.apache.ignite.spi.class"), (Serializable)((Object)spiCls.getName()));
        }
    }

    private void startManager(GridManager mgr) throws IgniteCheckedException {
        this.ctx.add(mgr);
        try {
            if (!this.skipDaemon(mgr)) {
                mgr.start();
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to start manager: " + mgr, e);
            throw new IgniteCheckedException("Failed to start manager: " + mgr, e);
        }
    }

    private void startProcessor(GridProcessor proc) throws IgniteCheckedException {
        this.ctx.add(proc);
        try {
            if (!this.skipDaemon(proc)) {
                proc.start();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to start processor: " + proc, e);
        }
    }

    private void addHelper(Object helper) {
        this.ctx.addHelper(helper);
    }

    private String onOff(boolean b) {
        return b ? "on" : "off";
    }

    private boolean isRestEnabled() {
        assert (this.cfg != null);
        return this.cfg.getConnectorConfiguration() != null && (!this.isClientNode() || this.isClientNode() && IgniteSystemProperties.getBoolean("IGNITE_REST_START_ON_CLIENT"));
    }

    private boolean isClientNode() {
        return this.cfg.isClientMode() != false || this.cfg.isDaemon();
    }

    private void ackRemoteManagement() {
        assert (this.log != null);
        if (!this.log.isInfoEnabled()) {
            return;
        }
        SB sb = new SB();
        sb.a("Remote Management [");
        boolean on = this.isJmxRemoteEnabled();
        sb.a("REST: ").a(this.onOff(this.isRestEnabled())).a(", ");
        sb.a("JMX (");
        sb.a("remote: ").a(this.onOff(on));
        if (on) {
            sb.a(", ");
            sb.a("port: ").a(System.getProperty("com.sun.management.jmxremote.port", "<n/a>")).a(", ");
            sb.a("auth: ").a(this.onOff(Boolean.getBoolean("com.sun.management.jmxremote.authenticate"))).a(", ");
            sb.a("ssl: ").a(this.onOff(Boolean.getBoolean("com.sun.management.jmxremote.ssl") || System.getProperty("com.sun.management.jmxremote.ssl") == null));
        }
        sb.a(")");
        sb.a(']');
        this.log.info(sb.toString());
    }

    private void ackConfigUrl() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Config URL: " + System.getProperty("IGNITE_CONFIG_URL", "n/a"));
        }
    }

    private void ackConfiguration(IgniteConfiguration cfg) {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info(cfg.toString());
        }
    }

    private void ackLogger() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Logger: " + this.log.getLoggerInfo());
        }
    }

    private void ackAsciiLogo() {
        assert (this.log != null);
        if (System.getProperty("IGNITE_NO_ASCII") == null) {
            String ver = "ver. " + IgniteVersionUtils.ACK_VER_STR;
            if (this.log.isInfoEnabled()) {
                this.log.info(NL + NL + ">>>    __________  ________________  " + NL + ">>>   /  _/ ___/ |/ /  _/_  __/ __/  " + NL + ">>>  _/ // (7 7    // /  / / / _/    " + NL + ">>> /___/\\___/_/|_/___/ /_/ /___/   " + NL + ">>> " + NL + ">>> " + ver + NL + ">>> " + IgniteVersionUtils.COPYRIGHT + NL + ">>> " + NL + ">>> GridGain documentation: http://" + DOC + NL);
            }
            if (this.log.isQuiet()) {
                U.quiet(false, "   __________  ________________ ", "  /  _/ ___/ |/ /  _/_  __/ __/ ", " _/ // (7 7    // /  / / / _/   ", "/___/\\___/_/|_/___/ /_/ /___/  ", "", ver, IgniteVersionUtils.COPYRIGHT, "", "GridGain documentation: http://gridgain.com/docs/index.html", "", "Quiet mode.");
                String fileName = this.log.fileName();
                if (fileName != null) {
                    U.quiet(false, "  ^-- Logging to file '" + fileName + '\'');
                }
                U.quiet(false, "  ^-- Logging by '" + this.log.getLoggerInfo() + '\'');
                U.quiet(false, "  ^-- To see **FULL** console log here add -DIGNITE_QUIET=false or \"-v\" to ignite.{sh|bat}", "");
            }
        }
    }

    private void ackStart(RuntimeMXBean rtBean) {
        ClusterNode locNode = this.localNode();
        if (this.log.isQuiet()) {
            U.quiet(false, "");
            U.quiet(false, "Ignite node started OK (id=" + U.id8(locNode.id()) + (F.isEmpty(this.igniteInstanceName) ? "" : ", instance name=" + this.igniteInstanceName) + ')');
        }
        if (this.log.isInfoEnabled()) {
            String ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR;
            String dash = U.dash(ack.length());
            SB sb = new SB();
            for (GridPortRecord rec : this.ctx.ports().records()) {
                sb.a((Object)rec.protocol()).a(":").a(rec.port()).a(" ");
            }
            String str = NL + NL + ">>> " + dash + NL + ">>> " + ack + NL + ">>> " + dash + NL + ">>> OS name: " + U.osString() + NL + ">>> CPU(s): " + locNode.metrics().getTotalCpus() + NL + ">>> Heap: " + U.heapSize(locNode, 2) + "GB" + NL + ">>> VM name: " + rtBean.getName() + NL + (this.igniteInstanceName == null ? "" : ">>> Ignite instance name: " + this.igniteInstanceName + NL) + ">>> Local node [ID=" + locNode.id().toString().toUpperCase() + ", order=" + locNode.order() + ", clientMode=" + this.ctx.clientNode() + "]" + NL + ">>> Local node addresses: " + U.addressesAsString(locNode) + NL + ">>> Local ports: " + sb + NL;
            this.log.info(str);
        }
        if (!ClusterState.active(this.ctx.state().clusterState().state())) {
            U.quietAndInfo(this.log, ">>> Ignite cluster is in " + (Object)((Object)ClusterState.INACTIVE) + " state (limited functionality available). Use control.(sh|bat) script or IgniteCluster.state(ClusterState.ACTIVE) or IgniteCluster.state(ClusterState.ACTIVE_READ_ONLY) to change the state.");
        }
    }

    private void ackOsInfo() {
        assert (this.log != null);
        if (this.log.isQuiet()) {
            U.quiet(false, "OS: " + U.osString());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("OS: " + U.osString());
            this.log.info("OS user: " + System.getProperty("user.name"));
            int jvmPid = U.jvmPid();
            this.log.info("PID: " + (jvmPid == -1 ? "N/A" : Integer.valueOf(jvmPid)));
        }
    }

    private void ackLanguageRuntime() {
        assert (this.log != null);
        if (this.log.isQuiet()) {
            U.quiet(false, "VM information: " + U.jdkString());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Language runtime: " + this.getLanguage());
            this.log.info("VM information: " + U.jdkString());
            this.log.info("VM total memory: " + U.heapSize(2) + "GB");
        }
    }

    private void ackNodeMetrics(DecimalFormat dblFmt, ExecutorService execSvc, ExecutorService sysExecSvc, ExecutorService stripedExecSvc, Map<String, ? extends ExecutorService> customExecSvcs) {
        if (!this.log.isInfoEnabled()) {
            return;
        }
        try {
            ClusterMetrics m4 = this.cluster().localNode().metrics();
            int localCpus = m4.getTotalCpus();
            double cpuLoadPct = m4.getCurrentCpuLoad() * 100.0;
            double avgCpuLoadPct = m4.getAverageCpuLoad() * 100.0;
            double gcPct = m4.getCurrentGcCpuLoad() * 100.0;
            long heapUsed = m4.getHeapMemoryUsed();
            long heapMax = m4.getHeapMemoryMaximum();
            long heapUsedInMBytes = heapUsed / 0x100000L;
            long heapCommInMBytes = m4.getHeapMemoryCommitted() / 0x100000L;
            double freeHeapPct = heapMax > 0L ? (double)((heapMax - heapUsed) * 100L) / (double)heapMax : -1.0;
            int hosts = 0;
            int servers = 0;
            int clients = 0;
            int cpus = 0;
            try {
                ClusterMetrics metrics = this.cluster().metrics();
                Collection<ClusterNode> nodes0 = this.cluster().nodes();
                hosts = U.neighborhood(nodes0).size();
                servers = this.cluster().forServers().nodes().size();
                clients = this.cluster().forClients().nodes().size();
                cpus = metrics.getTotalCpus();
            }
            catch (IgniteException metrics) {
                // empty catch block
            }
            String dataStorageInfo = IgniteKernal.dataStorageReport(this.ctx.cache().context().database(), dblFmt, true);
            String id = this.localNode().id().toString();
            AffinityTopologyVersion topVer = this.ctx.discovery().topologyVersionEx();
            ClusterNode locNode = this.ctx.discovery().localNode();
            String networkDetails = "";
            if (!F.isEmpty(this.cfg.getLocalHost())) {
                networkDetails = networkDetails + ", localHost=" + this.cfg.getLocalHost();
            }
            if (locNode instanceof TcpDiscoveryNode) {
                networkDetails = networkDetails + ", discoPort=" + ((TcpDiscoveryNode)locNode).discoveryPort();
            }
            if (this.cfg.getCommunicationSpi() instanceof TcpCommunicationSpi) {
                networkDetails = networkDetails + ", commPort=" + ((TcpCommunicationSpi)this.cfg.getCommunicationSpi()).boundPort();
            }
            SB msg = new SB();
            ClusterNode crdNode = this.ctx.discovery().discoCache().oldestAliveServerNode();
            String crdInfoStr = crdNode != null ? "    ^-- Coordinator [id=" + crdNode.id() + ", consistentId=" + crdNode.consistentId() + ", version=" + crdNode.version().toString() + "]" : "    ^-- Coordinator [id=null]";
            msg.nl().a("Metrics for local node (to disable set 'metricsLogFrequency' to 0)").nl().a("    ^-- Node [id=").a(id).a(", consistentId=").a(locNode.consistentId()).a(this.name() != null ? ", name=" + this.name() : "").a(", version=").a(IgniteVersionUtils.ACK_VER_STR).a(", uptime=").a(this.getUpTimeFormatted()).a("]").nl().a(crdInfoStr).nl().a("    ^-- Cluster [hosts=").a(hosts).a(", CPUs=").a(cpus).a(", servers=").a(servers).a(", clients=").a(clients).a(", topVer=").a(topVer.topologyVersion()).a(", minorTopVer=").a(topVer.minorTopologyVersion()).a(", state=").a(this.ctx.state().clusterState().state().name()).a(", clusterId=").a(this.ctx.cluster().getId()).a(", clusterTag=").a(this.ctx.cluster().getTag()).a("]").nl().a("    ^-- Network [addrs=").a(locNode.addresses()).a(networkDetails).a("]").nl().a("    ^-- CPU [CPUs=").a(localCpus).a(", curLoad=").a(dblFmt.format(cpuLoadPct)).a("%, avgLoad=").a(dblFmt.format(avgCpuLoadPct)).a("%, GC=").a(dblFmt.format(gcPct)).a("%]").nl().a("    ^-- Heap [used=").a(dblFmt.format(heapUsedInMBytes)).a("MB, free=").a(dblFmt.format(freeHeapPct)).a("%, comm=").a(dblFmt.format(heapCommInMBytes)).a("MB]").nl().a(dataStorageInfo).a("    ^-- Outbound messages queue [size=").a(m4.getOutboundMessagesQueueSize()).a("]").nl().a("    ^-- ").a(this.createExecutorDescription("Public thread pool", execSvc)).nl().a("    ^-- ").a(this.createExecutorDescription("System thread pool", sysExecSvc)).nl().a("    ^-- ").a(this.createExecutorDescription("Striped thread pool", stripedExecSvc));
            if (customExecSvcs != null) {
                for (Map.Entry<String, ? extends ExecutorService> entry : customExecSvcs.entrySet()) {
                    msg.nl().a("    ^-- ").a(this.createExecutorDescription(entry.getKey(), entry.getValue()));
                }
            }
            String pluginInfo = this.pluginInfoReport();
            msg.nl().a(F.isEmpty(pluginInfo) ? "    ^-- No plugins found" : pluginInfo);
            this.log.info(msg.toString());
            this.ctx.cache().context().database().dumpStatistics(this.log);
            if (IgniteUtils.isLocalNodeCoordinator(this.ctx.discovery())) {
                this.ctx.cache().context().affinity().printWaitInfo(this.log);
            }
        }
        catch (IgniteClientDisconnectedException igniteClientDisconnectedException) {
            // empty catch block
        }
    }

    private long allocatedPDSSize() {
        if (this.ctx.clientNode() || this.ctx.grid().cluster().state() == ClusterState.INACTIVE) {
            return 0L;
        }
        DataStorageConfiguration dsCfg = this.ctx.config().getDataStorageConfiguration();
        long res = this.ctx.grid().dataRegionMetrics(dsCfg.getDefaultDataRegionConfiguration().getName()).getTotalAllocatedSize();
        DataRegionConfiguration[] dataRegions = dsCfg.getDataRegionConfigurations();
        if (dataRegions != null) {
            for (DataRegionConfiguration dataReg : dataRegions) {
                if (!dataReg.isPersistenceEnabled()) continue;
                res += this.ctx.grid().dataRegionMetrics(dataReg.getName()).getTotalAllocatedSize();
            }
        }
        return res;
    }

    public static String dataStorageReport(IgniteCacheDatabaseSharedManager db, boolean includeMemoryStatistics) {
        return IgniteKernal.dataStorageReport(db, IgniteKernal.doubleFormat(), includeMemoryStatistics);
    }

    private static String dataStorageReport(IgniteCacheDatabaseSharedManager db, DecimalFormat dblFmt, boolean includeMemoryStatistics) {
        Collection<DataRegion> regions = db.dataRegions();
        SB dataRegionsInfo = new SB();
        long loadedPages = 0L;
        long offHeapUsedSummary = 0L;
        long offHeapMaxSummary = 0L;
        long offHeapCommSummary = 0L;
        long dataSizeSummary = 0L;
        long pdsUsedSummary = 0L;
        boolean persistenceEnabled = false;
        if (!F.isEmpty(regions)) {
            for (DataRegion region : regions) {
                DataRegionConfiguration regCfg = region.config();
                long pagesCnt = region.pageMemory().loadedPages();
                long offHeapUsed = (long)region.pageMemory().systemPageSize() * pagesCnt;
                long offHeapInit = regCfg.getInitialSize();
                long offHeapMax = regCfg.getMaxSize();
                long offHeapComm = region.metrics().getOffHeapSize();
                long dataSize = region.pageMemory().metrics().getSizeUsedByData();
                long offHeapUsedInMBytes = offHeapUsed / 0x100000L;
                long offHeapMaxInMBytes = offHeapMax / 0x100000L;
                long offHeapCommInMBytes = offHeapComm / 0x100000L;
                long offHeapInitInMBytes = offHeapInit / 0x100000L;
                long dataSizeInMBytes = dataSize / 0x100000L;
                double freeOffHeapPct = offHeapMax > 0L ? (double)((offHeapMax - offHeapUsed) * 100L) / (double)offHeapMax : -1.0;
                offHeapUsedSummary += offHeapUsed;
                offHeapMaxSummary += offHeapMax;
                offHeapCommSummary += offHeapComm;
                dataSizeSummary += dataSize;
                loadedPages += pagesCnt;
                String type = "user";
                try {
                    if (region == db.dataRegion(null)) {
                        type = "default";
                    } else if (IgniteCacheDatabaseSharedManager.INTERNAL_DATA_REGION_NAMES.contains(regCfg.getName())) {
                        type = "internal";
                    }
                }
                catch (IgniteCheckedException ice) {
                    ice.printStackTrace();
                }
                dataRegionsInfo.a("    ^--   ").a(regCfg.getName()).a(" region [type=").a(type).a(", persistence=").a(regCfg.isPersistenceEnabled()).a(", lazyAlloc=").a(regCfg.isLazyMemoryAllocation()).a(',').nl().a("      ...  ").a("initCfg=").a(dblFmt.format(offHeapInitInMBytes)).a("MB, maxCfg=").a(dblFmt.format(offHeapMaxInMBytes)).a("MB, sizeUsedByData=").a(dblFmt.format(dataSizeInMBytes)).a("MB, usedRam=").a(dblFmt.format(offHeapUsedInMBytes)).a("MB, freeRam=").a(dblFmt.format(freeOffHeapPct)).a("%, allocRam=").a(dblFmt.format(offHeapCommInMBytes)).a("MB");
                if (regCfg.isPersistenceEnabled()) {
                    long pdsUsed = region.metrics().getTotalAllocatedSize();
                    long pdsUsedInMBytes = pdsUsed / 0x100000L;
                    pdsUsedSummary += pdsUsed;
                    dataRegionsInfo.a(", allocTotal=").a(dblFmt.format(pdsUsedInMBytes)).a("MB");
                    persistenceEnabled = true;
                }
                dataRegionsInfo.a(']').nl();
            }
        }
        SB info = new SB();
        if (includeMemoryStatistics) {
            long offHeapUsedInMBytes = offHeapUsedSummary / 0x100000L;
            long offHeapCommInMBytes = offHeapCommSummary / 0x100000L;
            long dataSizeInMBytes = dataSizeSummary / 0x100000L;
            double freeOffHeapPct = offHeapMaxSummary > 0L ? (double)((offHeapMaxSummary - offHeapUsedSummary) * 100L) / (double)offHeapMaxSummary : -1.0;
            info.a("    ^-- Off-heap memory [sizeUsedByData=").a(dblFmt.format(dataSizeInMBytes)).a("MB, used=").a(dblFmt.format(offHeapUsedInMBytes)).a("MB, free=").a(dblFmt.format(freeOffHeapPct)).a("%, allocated=").a(dblFmt.format(offHeapCommInMBytes)).a("MB]").nl().a("    ^-- Page memory [pages=").a(loadedPages).a("]").nl();
        }
        info.a(dataRegionsInfo);
        if (persistenceEnabled) {
            long pdsUsedMBytes = pdsUsedSummary / 0x100000L;
            info.a("    ^-- Ignite persistence [used=").a(dblFmt.format(pdsUsedMBytes)).a("MB]").nl();
        }
        return info.toString();
    }

    private String pluginInfoReport() {
        return this.ctx.plugins().allProviders().stream().filter(plugin -> !F.isEmpty(plugin.metricsInfo())).map(plugin -> {
            Map<String, Object> metricsInfo = plugin.metricsInfo();
            String infoFormatted = metricsInfo.entrySet().stream().map(info -> (String)info.getKey() + "=" + (info.getValue() != null ? info.getValue().toString() : null)).collect(Collectors.joining(", "));
            return "    ^-- Plugin [name=" + plugin.name() + ", version=" + plugin.version() + ", info=[" + infoFormatted + "]";
        }).collect(Collectors.joining(NL));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLanguage() {
        boolean scala = false;
        boolean groovy = false;
        boolean clojure = false;
        for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
            String s2 = elem.getClassName().toLowerCase();
            if (s2.contains("scala")) {
                scala = true;
                break;
            }
            if (s2.contains("groovy")) {
                groovy = true;
                break;
            }
            if (!s2.contains("clojure")) continue;
            clojure = true;
            break;
        }
        if (scala) {
            try (InputStream in = this.getClass().getResourceAsStream("/library.properties");){
                Properties props = new Properties();
                if (in != null) {
                    props.load(in);
                }
                String string = "Scala ver. " + props.getProperty("version.number", "<unknown>");
                return string;
            }
            catch (Exception ignore) {
                return "Scala ver. <unknown>";
            }
        }
        if (groovy) {
            return "Groovy";
        }
        if (clojure) {
            return "Clojure";
        }
        String string = U.jdkName() + " ver. " + U.jdkVersion();
        return string;
    }

    public void stop(boolean cancel) {
        boolean interrupted = Thread.interrupted();
        try {
            this.stop0(cancel);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isStopping() {
        return this.stopGuard.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop0(boolean cancel) {
        this.gw.compareAndSet(null, new GridKernalGatewayImpl(this.igniteInstanceName));
        GridKernalGateway gw = this.gw.get();
        if (this.stopGuard.compareAndSet(false, true)) {
            boolean firstStop = false;
            GridKernalState state = gw.getState();
            if (state == GridKernalState.STARTED || state == GridKernalState.DISCONNECTED) {
                firstStop = true;
            } else if (state == GridKernalState.STARTING) {
                U.warn(this.log, "Attempt to stop starting grid. This operation cannot be guaranteed to be successful.");
            }
            if (firstStop) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying lifecycle beans.");
                }
                this.notifyLifecycleBeansEx(LifecycleEventType.BEFORE_NODE_STOP);
            }
            List<GridComponent> comps = this.ctx.components();
            ListIterator<GridComponent> it = comps.listIterator(comps.size());
            while (it.hasPrevious()) {
                GridComponent comp = it.previous();
                try {
                    if (this.skipDaemon(comp)) continue;
                    comp.onKernalStop(cancel);
                }
                catch (Throwable e) {
                    this.errOnStop = true;
                    U.error(this.log, "Failed to pre-stop processor: " + comp, e);
                    if (!(e instanceof Error)) continue;
                    throw e;
                }
            }
            if (this.starveTask != null) {
                this.starveTask.close();
            }
            if (this.metricsLogTask != null) {
                this.metricsLogTask.close();
            }
            if (this.collectAllocationPDSTask != null) {
                this.collectAllocationPDSTask.close();
            }
            if (this.longJVMPauseDetector != null) {
                this.longJVMPauseDetector.stop();
            }
            boolean interrupted = false;
            while (true) {
                try {
                    while (!gw.tryWriteLock(10L)) {
                    }
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            try {
                assert (gw.getState() == GridKernalState.STARTED || gw.getState() == GridKernalState.STARTING || gw.getState() == GridKernalState.DISCONNECTED);
                gw.setState(GridKernalState.STOPPING);
                this.ctx.cluster().get().clearNodeMap();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Grid " + (this.igniteInstanceName == null ? "" : '\'' + this.igniteInstanceName + "' ") + "is stopping.");
                }
            }
            finally {
                gw.writeUnlock();
            }
            GridCacheProcessor cache = this.ctx.cache();
            if (cache != null) {
                cache.blockGateways();
            }
            if (!this.mBeansMgr.unregisterAllMBeans()) {
                this.errOnStop = true;
            }
            ListIterator<GridComponent> it2 = comps.listIterator(comps.size());
            while (it2.hasPrevious()) {
                GridComponent comp = it2.previous();
                try {
                    if (this.skipDaemon(comp)) continue;
                    comp.stop(cancel);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Component stopped: " + comp);
                }
                catch (Throwable e) {
                    this.errOnStop = true;
                    U.error(this.log, "Failed to stop component (ignoring): " + comp, e);
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
            U.stopLifecycleAware(this.log, this.lifecycleAwares(this.cfg));
            this.notifyLifecycleBeansEx(LifecycleEventType.AFTER_NODE_STOP);
            U.clearClassCache();
            MarshallerExclusions.clearCache();
            BinaryEnumCache.clear();
            gw.writeLock();
            try {
                gw.setState(GridKernalState.STOPPED);
            }
            finally {
                gw.writeUnlock();
            }
            if (this.log.isQuiet()) {
                String nodeName;
                String string = nodeName = this.igniteInstanceName == null ? "" : "name=" + this.igniteInstanceName + ", ";
                if (!this.errOnStop) {
                    U.quiet(false, "Ignite node stopped OK [" + nodeName + "uptime=" + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + ']');
                } else {
                    U.quiet(true, "Ignite node stopped wih ERRORS [" + nodeName + "uptime=" + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + ']');
                }
            }
            if (this.log.isInfoEnabled()) {
                String dash;
                String ack;
                if (!this.errOnStop) {
                    ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped OK";
                    dash = U.dash(ack.length());
                    this.log.info(NL + NL + ">>> " + dash + NL + ">>> " + ack + NL + ">>> " + dash + NL + (this.igniteInstanceName == null ? "" : ">>> Ignite instance name: " + this.igniteInstanceName + NL) + ">>> Grid uptime: " + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + NL + NL);
                } else {
                    ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped with ERRORS";
                    dash = U.dash(ack.length());
                    this.log.info(NL + NL + ">>> " + ack + NL + ">>> " + dash + NL + (this.igniteInstanceName == null ? "" : ">>> Ignite instance name: " + this.igniteInstanceName + NL) + ">>> Grid uptime: " + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + NL + ">>> See log above for detailed error message." + NL + ">>> Note that some errors during stop can prevent grid from" + NL + ">>> maintaining correct topology since this node may have" + NL + ">>> not exited grid properly." + NL + NL);
                }
            }
            try {
                U.onGridStop();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        } else if (this.log.isDebugEnabled()) {
            if (gw.getState() == GridKernalState.STOPPED) {
                this.log.debug("Grid is already stopped. Nothing to do.");
            } else {
                this.log.debug("Grid is being stopped by another thread. Aborting this stop sequence allowing other thread to finish.");
            }
        }
    }

    public <K, V> GridCacheAdapter<K, V> internalCache(String name) {
        CU.validateCacheName(name);
        this.checkClusterState();
        return this.ctx.cache().internalCache(name);
    }

    @Override
    public GridKernalContext context() {
        return this.ctx;
    }

    private void ackSystemProperties() {
        assert (this.log != null);
        if (this.log.isDebugEnabled() && S.includeSensitive()) {
            for (Map.Entry<Object, Object> entry : IgniteSystemProperties.snapshot().entrySet()) {
                this.log.debug("System property [" + entry.getKey() + '=' + entry.getValue() + ']');
            }
        }
    }

    private void logNodeUserAttributes() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            for (Map.Entry<String, ?> attr : this.cfg.getUserAttributes().entrySet()) {
                this.log.info("Local node user attribute [" + attr.getKey() + '=' + attr.getValue() + ']');
            }
        }
    }

    private void ackEnvironmentVariables() {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            for (Map.Entry<String, String> envVar : System.getenv().entrySet()) {
                this.log.debug("Environment variable [" + envVar.getKey() + '=' + envVar.getValue() + ']');
            }
        }
    }

    private void ackDaemon() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Daemon mode: " + (this.isDaemon() ? "on" : "off"));
        }
    }

    private boolean isDaemon() {
        assert (this.cfg != null);
        return this.cfg.isDaemon() || IgniteSystemProperties.getBoolean("IGNITE_DAEMON");
    }

    @Override
    public boolean isJmxRemoteEnabled() {
        return System.getProperty("com.sun.management.jmxremote") != null;
    }

    private void ackSpis() {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("+-------------+");
            this.log.debug("START SPI LIST:");
            this.log.debug("+-------------+");
            this.log.debug("Grid checkpoint SPI     : " + Arrays.toString(this.cfg.getCheckpointSpi()));
            this.log.debug("Grid collision SPI      : " + this.cfg.getCollisionSpi());
            this.log.debug("Grid communication SPI  : " + this.cfg.getCommunicationSpi());
            this.log.debug("Grid deployment SPI     : " + this.cfg.getDeploymentSpi());
            this.log.debug("Grid discovery SPI      : " + this.cfg.getDiscoverySpi());
            this.log.debug("Grid event storage SPI  : " + this.cfg.getEventStorageSpi());
            this.log.debug("Grid failover SPI       : " + Arrays.toString(this.cfg.getFailoverSpi()));
            this.log.debug("Grid load balancing SPI : " + Arrays.toString(this.cfg.getLoadBalancingSpi()));
        }
    }

    private void ackRebalanceConfiguration() throws IgniteCheckedException {
        if (this.cfg.isClientMode().booleanValue()) {
            if (this.cfg.getRebalanceThreadPoolSize() != IgniteConfiguration.DFLT_REBALANCE_THREAD_POOL_SIZE) {
                U.warn(this.log, "Setting the rebalance pool size has no effect on the client mode");
            }
        } else {
            if (this.cfg.getRebalanceThreadPoolSize() < 1) {
                throw new IgniteCheckedException("Rebalance thread pool size minimal allowed value is 1. Change IgniteConfiguration.rebalanceThreadPoolSize property before next start.");
            }
            if (this.cfg.getRebalanceBatchesPrefetchCount() < 1L) {
                throw new IgniteCheckedException("Rebalance batches prefetch count minimal allowed value is 1. Change IgniteConfiguration.rebalanceBatchesPrefetchCount property before next start.");
            }
            if (this.cfg.getRebalanceBatchSize() <= 0) {
                throw new IgniteCheckedException("Rebalance batch size must be greater than zero. Change IgniteConfiguration.rebalanceBatchSize property before next start.");
            }
            if (this.cfg.getRebalanceThrottle() < 0L) {
                throw new IgniteCheckedException("Rebalance throttle can't have negative value. Change IgniteConfiguration.rebalanceThrottle property before next start.");
            }
            if (this.cfg.getRebalanceTimeout() < 0L) {
                throw new IgniteCheckedException("Rebalance message timeout can't have negative value. Change IgniteConfiguration.rebalanceTimeout property before next start.");
            }
            for (CacheConfiguration ccfg : this.cfg.getCacheConfiguration()) {
                if (ccfg.getRebalanceBatchesPrefetchCount() >= 1L) continue;
                throw new IgniteCheckedException("Rebalance batches prefetch count minimal allowed value is 1. Change CacheConfiguration.rebalanceBatchesPrefetchCount property before next start. [cache=" + ccfg.getName() + "]");
            }
        }
    }

    private void ackMemoryConfiguration() {
        DataStorageConfiguration memCfg = this.cfg.getDataStorageConfiguration();
        if (memCfg == null) {
            return;
        }
        U.log(this.log, "System cache's DataRegion size is configured to " + memCfg.getSystemRegionInitialSize() / 0x100000L + " MB. Use DataStorageConfiguration.systemRegionInitialSize property to change the setting.");
    }

    private void ackCacheConfiguration() {
        CacheConfiguration[] cacheCfgs = this.cfg.getCacheConfiguration();
        if (cacheCfgs == null || cacheCfgs.length == 0) {
            U.warn(this.log, "Cache is not configured - in-memory data grid is off.");
        } else {
            SB sb = new SB();
            HashMap memPlcNamesMapping = new HashMap();
            for (CacheConfiguration c : cacheCfgs) {
                String cacheName = U.maskName(c.getName());
                String memPlcName = c.getDataRegionName();
                if (CU.isSystemCache(cacheName)) {
                    memPlcName = "sysMemPlc";
                } else if (memPlcName == null && this.cfg.getDataStorageConfiguration() != null) {
                    memPlcName = this.cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName();
                }
                if (!memPlcNamesMapping.containsKey(memPlcName)) {
                    memPlcNamesMapping.put(memPlcName, new ArrayList());
                }
                ArrayList cacheNames = (ArrayList)memPlcNamesMapping.get(memPlcName);
                cacheNames.add(cacheName);
            }
            for (Map.Entry entry : memPlcNamesMapping.entrySet()) {
                sb.a("in '").a((String)entry.getKey()).a("' dataRegion: [");
                for (String s2 : (ArrayList)entry.getValue()) {
                    sb.a("'").a(s2).a("', ");
                }
                sb.d(sb.length() - 2, sb.length()).a("], ");
            }
            U.log(this.log, "Configured caches [" + sb.d(sb.length() - 2, sb.length()).toString() + ']');
        }
    }

    private void ackP2pConfiguration() {
        assert (this.cfg != null);
        if (this.cfg.isPeerClassLoadingEnabled()) {
            U.warn(this.log, "Peer class loading is enabled (disable it in production for performance and deployment consistency reasons)");
        }
    }

    private void ackSecurity() {
        assert (this.log != null);
        U.quietAndInfo(this.log, "Security status [authentication=" + this.onOff(this.ctx.security().enabled()) + ", tls/ssl=" + this.onOff(this.ctx.config().getSslContextFactory() != null) + ']');
    }

    private void ackVmArguments(RuntimeMXBean rtBean) {
        assert (this.log != null);
        if (this.log.isInfoEnabled() && S.includeSensitive()) {
            this.log.info("IGNITE_HOME=" + this.cfg.getIgniteHome());
            this.log.info("VM arguments: " + rtBean.getInputArguments());
        }
    }

    private void ackClassPaths(RuntimeMXBean rtBean) {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug("Boot class path: " + rtBean.getBootClassPath());
                this.log.debug("Class path: " + rtBean.getClassPath());
                this.log.debug("Library path: " + rtBean.getLibraryPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ackIPv4StackFlagIsSet() {
        boolean preferIPv4 = Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack"));
        if (!preferIPv4) {
            assert (this.log != null);
            U.quietAndWarn(this.log, "Please set system property '-Djava.net.preferIPv4Stack=true' to avoid possible problems in mixed environments.");
        }
    }

    private void ackWaitForBackupsOnShutdownPropertyIsUsed() {
        if (IgniteSystemProperties.getString("IGNITE_WAIT_FOR_BACKUPS_ON_SHUTDOWN") != null) {
            this.log.warning("IGNITE_WAIT_FOR_BACKUPS_ON_SHUTDOWN system property is deprecated and will be removed in a future version. Use ShutdownPolicy instead.");
        }
    }

    private Iterable<Object> lifecycleAwares(IgniteConfiguration cfg) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (cfg.getLifecycleBeans() != null) {
            Collections.addAll(objs, cfg.getLifecycleBeans());
        }
        if (cfg.getSegmentationResolvers() != null) {
            Collections.addAll(objs, cfg.getSegmentationResolvers());
        }
        if (cfg.getConnectorConfiguration() != null) {
            objs.add(cfg.getConnectorConfiguration().getMessageInterceptor());
            objs.add(cfg.getConnectorConfiguration().getSslContextFactory());
        }
        objs.add(cfg.getMarshaller());
        objs.add(cfg.getGridLogger());
        objs.add(cfg.getMBeanServer());
        if (cfg.getCommunicationFailureResolver() != null) {
            objs.add(cfg.getCommunicationFailureResolver());
        }
        return objs;
    }

    @Override
    public IgniteConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public IgniteLogger log() {
        return this.cfg.getGridLogger();
    }

    @Override
    public boolean removeCheckpoint(String key) {
        A.notNull(key, "key");
        this.guard();
        try {
            this.checkClusterState();
            boolean bl = this.ctx.checkpoint().removeCheckpoint(key);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public boolean pingNode(String nodeId) {
        A.notNull(nodeId, "nodeId");
        return this.cluster().pingNode(UUID.fromString(nodeId));
    }

    @Override
    public void undeployTaskFromGrid(String taskName) throws JMException {
        A.notNull(taskName, "taskName");
        try {
            this.compute().undeployTask(taskName);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public String executeTask(String taskName, String arg) throws JMException {
        try {
            return (String)this.compute().execute(taskName, arg);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public boolean pingNodeByAddress(String host) {
        this.guard();
        try {
            for (ClusterNode n : this.cluster().nodes()) {
                if (!n.addresses().contains(host)) continue;
                boolean bl = this.ctx.discovery().pingNode(n.id());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public boolean eventUserRecordable(int type) {
        this.guard();
        try {
            boolean bl = this.ctx.event().isUserRecordable(type);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public boolean allEventsUserRecordable(int[] types) {
        A.notNull(types, "types");
        this.guard();
        try {
            boolean bl = this.ctx.event().isAllUserRecordable(types);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteTransactions transactions() {
        this.guard();
        try {
            this.checkClusterState();
            IgniteTransactionsEx igniteTransactionsEx = this.ctx.cache().transactions();
            return igniteTransactionsEx;
        }
        finally {
            this.unguard();
        }
    }

    public <K, V> IgniteInternalCache<K, V> getCache(String name) {
        CU.validateCacheName(name);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache igniteInternalCache = this.ctx.cache().publicCache(name);
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> cache(String name) {
        CU.validateCacheName(name);
        this.guard();
        try {
            this.checkClusterState();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(name, false, true);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg, this.ctx.config().getDataStorageConfiguration());
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), null, true, true, true).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteCache> createCaches(Collection<CacheConfiguration> cacheCfgs) {
        A.notNull(cacheCfgs, "cacheCfgs");
        CU.validateConfigurationCacheNames(cacheCfgs, this.ctx.config().getDataStorageConfiguration());
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCaches(cacheCfgs, true, true, false).get();
            ArrayList createdCaches = new ArrayList(cacheCfgs.size());
            for (CacheConfiguration cacheCfg : cacheCfgs) {
                createdCaches.add(this.ctx.cache().publicJCache(cacheCfg.getName()));
            }
            ArrayList arrayList = createdCaches;
            return arrayList;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(String cacheName) {
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().createFromTemplate(cacheName).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheName);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg) {
        return this.getOrCreateCache0(cacheCfg, false).get1();
    }

    @Override
    public <K, V> IgniteBiTuple<IgniteCache<K, V>, Boolean> getOrCreateCache0(CacheConfiguration<K, V> cacheCfg, boolean sql) {
        A.notNull(cacheCfg, "cacheCfg");
        String cacheName = cacheCfg.getName();
        CU.validateNewCacheName(cacheCfg, this.ctx.config().getDataStorageConfiguration());
        this.guard();
        try {
            this.checkClusterState();
            Boolean res = false;
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName, false, true);
            if (cache == null) {
                res = sql ? this.ctx.cache().dynamicStartSqlCache(cacheCfg).get() : this.ctx.cache().dynamicStartCache(cacheCfg, cacheName, null, false, true, true).get();
                IgniteBiTuple<IgniteCache<K, V>, Boolean> igniteBiTuple = new IgniteBiTuple<IgniteCache<K, V>, Boolean>(this.ctx.cache().publicJCache(cacheName), res);
                return igniteBiTuple;
            }
            IgniteBiTuple<IgniteCache<K, V>, Boolean> igniteBiTuple = new IgniteBiTuple<IgniteCache<K, V>, Boolean>(cache, res);
            return igniteBiTuple;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteCache> getOrCreateCaches(Collection<CacheConfiguration> cacheCfgs) {
        A.notNull(cacheCfgs, "cacheCfgs");
        CU.validateConfigurationCacheNames(cacheCfgs, this.ctx.config().getDataStorageConfiguration());
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCaches(cacheCfgs, false, true, false).get();
            ArrayList createdCaches = new ArrayList(cacheCfgs.size());
            for (CacheConfiguration cacheCfg : cacheCfgs) {
                createdCaches.add(this.ctx.cache().publicJCache(cacheCfg.getName()));
            }
            ArrayList arrayList = createdCaches;
            return arrayList;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg, this.ctx.config().getDataStorageConfiguration());
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, true, true, true).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg, this.ctx.config().getDataStorageConfiguration());
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache cache = this.ctx.cache().cache(cacheCfg.getName());
            if (cache == null) {
                this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, false, true, true).get();
            } else if (cache.configuration().getNearConfiguration() == null) {
                this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, false, true, true).get();
            }
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        CU.validateNewCacheName(cacheName);
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, true, true, true).get();
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName);
            this.checkNearCacheStarted(cache);
            IgniteCacheProxy igniteCacheProxy = cache;
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        CU.validateNewCacheName(cacheName);
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache internalCache = this.ctx.cache().cache(cacheName);
            if (internalCache == null) {
                this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, false, true, true).get();
            } else if (internalCache.configuration().getNearConfiguration() == null) {
                this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, false, true, true).get();
            }
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName);
            this.checkNearCacheStarted(cache);
            IgniteCacheProxy igniteCacheProxy = cache;
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    private void checkNearCacheStarted(IgniteCacheProxy<?, ?> cache) throws IgniteCheckedException {
        if (!cache.context().isNear()) {
            throw new IgniteCheckedException("Failed to start near cache (a cache with the same name without near cache is already started)");
        }
    }

    @Override
    public void destroyCache(String cacheName) {
        this.destroyCache0(cacheName, false);
    }

    @Override
    public boolean destroyCache0(String cacheName, boolean sql) throws CacheException {
        CU.validateCacheName(cacheName);
        IgniteInternalFuture<Boolean> stopFut = this.destroyCacheAsync(cacheName, sql, true);
        try {
            return stopFut.get();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    @Override
    public void destroyCaches(Collection<String> cacheNames) {
        CU.validateCacheNames(cacheNames);
        IgniteInternalFuture<?> stopFut = this.destroyCachesAsync(cacheNames, true);
        try {
            stopFut.get();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<Boolean> destroyCacheAsync(String cacheName, boolean sql, boolean checkThreadTx) {
        CU.validateCacheName(cacheName);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.ctx.cache().dynamicDestroyCache(cacheName, sql, checkThreadTx, false, null);
            return igniteInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> destroyCachesAsync(Collection<String> cacheNames, boolean checkThreadTx) {
        CU.validateCacheNames(cacheNames);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalFuture<?> igniteInternalFuture = this.ctx.cache().dynamicDestroyCaches(cacheNames, checkThreadTx);
            return igniteInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(String cacheName) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName, false, true);
            if (cache == null) {
                this.ctx.cache().getOrCreateFromTemplate(cacheName, true).get();
                IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheName);
                return igniteCacheProxy;
            }
            IgniteCacheProxy igniteCacheProxy = cache;
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> getOrCreateCacheAsync(String cacheName, String templateName, CacheConfigurationOverride cfgOverride, boolean checkThreadTx) {
        this.guard();
        try {
            this.checkClusterState();
            if (this.ctx.cache().cache(cacheName) == null) {
                IgniteInternalFuture<?> igniteInternalFuture = this.ctx.cache().getOrCreateFromTemplate(cacheName, templateName, cfgOverride, checkThreadTx);
                return igniteInternalFuture;
            }
            GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
            return gridFinishedFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> void addCacheConfiguration(CacheConfiguration<K, V> cacheCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg, this.ctx.config().getDataStorageConfiguration());
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().addCacheConfiguration(cacheCfg);
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    public Collection<IgniteCacheProxy<?, ?>> caches() {
        this.guard();
        try {
            this.checkClusterState();
            Collection<IgniteCacheProxy<?, ?>> collection = this.ctx.cache().publicCaches();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<String> cacheNames() {
        this.guard();
        try {
            this.checkClusterState();
            Collection<String> collection = this.ctx.cache().publicCacheNames();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K extends GridCacheUtilityKey, V> IgniteInternalCache<K, V> utilityCache() {
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache igniteInternalCache = this.ctx.cache().utilityCache();
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteInternalCache<K, V> cachex(String name) {
        CU.validateCacheName(name);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache igniteInternalCache = this.ctx.cache().cache(name);
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteInternalCache<?, ?>> cachesx(IgnitePredicate<? super IgniteInternalCache<?, ?>>[] p) {
        this.guard();
        try {
            this.checkClusterState();
            Collection<IgniteInternalCache<?, ?>> collection = F.retain(this.ctx.cache().caches(), true, p);
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteDataStreamer<K, V> dataStreamer(String cacheName) {
        CU.validateCacheName(cacheName);
        this.guard();
        try {
            this.checkClusterState();
            DataStreamerImpl dataStreamerImpl = this.ctx.dataStream().dataStreamer(cacheName);
            return dataStreamerImpl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T extends IgnitePlugin> T plugin(String name) throws PluginNotFoundException {
        this.guard();
        try {
            this.checkClusterState();
            Object t2 = this.ctx.pluginProvider(name).plugin();
            return t2;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteBinary binary() {
        this.checkClusterState();
        IgniteCacheObjectProcessor objProc = this.ctx.cacheObjects();
        return objProc.binary();
    }

    @Override
    public IgniteProductVersion version() {
        return IgniteVersionUtils.VER;
    }

    @Override
    public String latestVersion() {
        this.ctx.gateway().readLock();
        try {
            String string = this.ctx.cluster().latestVersion();
            return string;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public IgniteScheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public void close() throws IgniteException {
        Ignition.stop(this.igniteInstanceName, true);
    }

    @Override
    public <K> Affinity<K> affinity(String cacheName) {
        CU.validateCacheName(cacheName);
        this.checkClusterState();
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        if (cache != null) {
            return cache.affinity();
        }
        return this.ctx.affinity().affinityProxy(cacheName);
    }

    @Override
    public boolean active() {
        this.guard();
        try {
            boolean bl = this.context().state().publicApiActiveState(true);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void active(boolean active) {
        this.cluster().active(active);
    }

    @Override
    public void resetLostPartitions(Collection<String> cacheNames) {
        CU.validateCacheNames(cacheNames);
        this.guard();
        try {
            Collection<String> cacheNames0 = cacheNames.isEmpty() ? this.ctx.cache().cacheNames() : cacheNames;
            this.ctx.cache().startCachesLocallyIfNotStarted(cacheNames0).get();
            this.ctx.cache().resetCacheState(cacheNames0).get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<DataRegionMetrics> dataRegionMetrics() {
        this.guard();
        try {
            Collection<DataRegionMetrics> collection = this.ctx.cache().context().database().memoryMetrics();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public DataRegionMetrics dataRegionMetrics(String memPlcName) {
        this.guard();
        try {
            DataRegionMetrics dataRegionMetrics = this.ctx.cache().context().database().memoryMetrics(memPlcName);
            return dataRegionMetrics;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public DataStorageMetrics dataStorageMetrics() {
        this.guard();
        try {
            DataStorageMetrics dataStorageMetrics = this.ctx.cache().context().database().persistentStoreMetrics();
            return dataStorageMetrics;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @NotNull
    public TracingConfigurationManager tracingConfiguration() {
        this.guard();
        try {
            TracingConfigurationManager tracingConfigurationManager = this.ctx.tracing().configuration();
            return tracingConfigurationManager;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteEncryption encryption() {
        return this.ctx.encryption();
    }

    @Override
    public Collection<MemoryMetrics> memoryMetrics() {
        return DataRegionMetricsAdapter.collectionOf(this.dataRegionMetrics());
    }

    @Override
    @Nullable
    public MemoryMetrics memoryMetrics(String memPlcName) {
        return DataRegionMetricsAdapter.valueOf(this.dataRegionMetrics(memPlcName));
    }

    @Override
    public PersistenceMetrics persistentStoreMetrics() {
        return DataStorageMetricsAdapter.valueOf(this.dataStorageMetrics());
    }

    @Override
    @Nullable
    public IgniteAtomicSequence atomicSequence(String name, long initVal, boolean create) {
        return this.atomicSequence(name, null, initVal, create);
    }

    @Override
    @Nullable
    public IgniteAtomicSequence atomicSequence(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicSequence igniteAtomicSequence = this.ctx.dataStructures().sequence(name, cfg, initVal, create);
            return igniteAtomicSequence;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteAtomicLong atomicLong(String name, long initVal, boolean create) {
        return this.atomicLong(name, null, initVal, create);
    }

    @Override
    @Nullable
    public IgniteAtomicLong atomicLong(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicLong igniteAtomicLong = this.ctx.dataStructures().atomicLong(name, cfg, initVal, create);
            return igniteAtomicLong;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteAtomicReference<T> atomicReference(String name, @Nullable T initVal, boolean create) {
        return this.atomicReference(name, null, initVal, create);
    }

    @Override
    public <T> IgniteAtomicReference<T> atomicReference(String name, AtomicConfiguration cfg, @Nullable T initVal, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicReference<T> igniteAtomicReference = this.ctx.dataStructures().atomicReference(name, cfg, initVal, create);
            return igniteAtomicReference;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, @Nullable T initVal, @Nullable S initStamp, boolean create) {
        return this.atomicStamped(name, null, initVal, initStamp, create);
    }

    @Override
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, AtomicConfiguration cfg, @Nullable T initVal, @Nullable S initStamp, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicStamped<T, S> igniteAtomicStamped = this.ctx.dataStructures().atomicStamped(name, cfg, initVal, initStamp, create);
            return igniteAtomicStamped;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteCountDownLatch countDownLatch(String name, int cnt, boolean autoDel, boolean create) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteCountDownLatch igniteCountDownLatch = this.ctx.dataStructures().countDownLatch(name, null, cnt, autoDel, create);
            return igniteCountDownLatch;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteSemaphore semaphore(String name, int cnt, boolean failoverSafe, boolean create) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteSemaphore igniteSemaphore = this.ctx.dataStructures().semaphore(name, null, cnt, failoverSafe, create);
            return igniteSemaphore;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteLock reentrantLock(String name, boolean failoverSafe, boolean fair, boolean create) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteLock igniteLock = this.ctx.dataStructures().reentrantLock(name, null, failoverSafe, fair, create);
            return igniteLock;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteQueue<T> queue(String name, int cap, CollectionConfiguration cfg) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteQueue igniteQueue = this.ctx.dataStructures().queue(name, null, cap, cfg);
            return igniteQueue;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteSet<T> set(String name, CollectionConfiguration cfg) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteSet igniteSet = this.ctx.dataStructures().set(name, null, cfg);
            return igniteSet;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T> IgniteSet<T> set(String name, int cacheId, boolean collocated, boolean separated) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteSet igniteSet = this.ctx.dataStructures().set(name, cacheId, collocated, separated);
            return igniteSet;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        assert (this.ctx != null);
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        assert (this.ctx != null);
        this.ctx.gateway().readUnlock();
    }

    private void checkClusterState() throws IgniteException {
        if (!this.ctx.state().publicApiActiveState(true)) {
            throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.active(true).");
        }
    }

    public void onDisconnected() {
        IgniteFutureImpl userFut;
        Throwable err = null;
        this.reconnectState.waitPreviousReconnect();
        GridFutureAdapter<?> reconnectFut = this.ctx.gateway().onDisconnected();
        if (reconnectFut == null) {
            assert (this.ctx.gateway().getState() != GridKernalState.STARTED) : this.ctx.gateway().getState();
            return;
        }
        IgniteFutureImpl curFut = (IgniteFutureImpl)this.ctx.cluster().get().clientReconnectFuture();
        if (curFut != null && curFut.internalFuture() == reconnectFut) {
            userFut = curFut;
        } else {
            userFut = new IgniteFutureImpl(reconnectFut);
            this.ctx.cluster().get().clientReconnectFuture(userFut);
        }
        this.ctx.disconnected(true);
        List<GridComponent> comps = this.ctx.components();
        ListIterator<GridComponent> it = comps.listIterator(comps.size());
        while (it.hasPrevious()) {
            GridComponent comp = it.previous();
            try {
                if (this.skipDaemon(comp)) continue;
                comp.onDisconnected(userFut);
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
            catch (Throwable e) {
                err = e;
                if (!(e instanceof Error)) continue;
                throw e;
            }
        }
        for (GridCacheContext cctx : this.ctx.cache().context().cacheContexts()) {
            cctx.gate().writeLock();
            cctx.gate().writeUnlock();
        }
        this.ctx.gateway().writeLock();
        this.ctx.gateway().writeUnlock();
        if (err != null) {
            reconnectFut.onDone(err);
            U.error(this.log, "Failed to reconnect, will stop node", err);
            this.close();
        }
    }

    public void onReconnected(boolean clusterRestarted) {
        Throwable err;
        block6: {
            err = null;
            try {
                this.ctx.disconnected(false);
                GridCompoundFuture curReconnectFut = this.reconnectState.curReconnectFut = new GridCompoundFuture();
                this.reconnectState.reconnectDone = new GridFutureAdapter();
                for (GridComponent comp : this.ctx.components()) {
                    IgniteInternalFuture<?> fut = comp.onReconnected(clusterRestarted);
                    if (fut == null) continue;
                    curReconnectFut.add(fut);
                }
                curReconnectFut.add(this.ctx.cache().context().exchange().reconnectExchangeFuture());
                curReconnectFut.markInitialized();
                final GridFutureAdapter reconnectDone = this.reconnectState.reconnectDone;
                curReconnectFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        try {
                            Object res = fut.get();
                            if (res == STOP_RECONNECT) {
                                return;
                            }
                            IgniteKernal.this.ctx.gateway().onReconnected();
                            IgniteKernal.this.reconnectState.firstReconnectFut.onDone();
                        }
                        catch (IgniteCheckedException e) {
                            if (!X.hasCause((Throwable)e, IgniteNeedReconnectException.class, IgniteClientDisconnectedCheckedException.class, IgniteInterruptedCheckedException.class)) {
                                U.error(IgniteKernal.this.log, "Failed to reconnect, will stop node.", e);
                                IgniteKernal.this.reconnectState.firstReconnectFut.onDone(e);
                                new Thread(() -> {
                                    U.error(IgniteKernal.this.log, "Stopping the node after a failed reconnect attempt.");
                                    IgniteKernal.this.close();
                                }, "node-stopper").start();
                            } else {
                                assert (IgniteKernal.this.ctx.discovery().reconnectSupported());
                                U.error(IgniteKernal.this.log, "Failed to finish reconnect, will retry [locNodeId=" + IgniteKernal.this.ctx.localNodeId() + ", err=" + e.getMessage() + ']');
                            }
                        }
                        finally {
                            reconnectDone.onDone();
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
            catch (Throwable e) {
                err = e;
                if (!(e instanceof Error)) break block6;
                throw e;
            }
        }
        if (err != null) {
            U.error(this.log, "Failed to reconnect, will stop node", err);
            if (!X.hasCause(err, NodeStoppingException.class)) {
                this.close();
            }
        }
    }

    private static <T extends GridComponent> T createComponent(Class<T> cls, GridKernalContext ctx) throws IgniteCheckedException {
        Constructor<?> constructor;
        assert (cls.isInterface()) : cls;
        GridComponent comp = (GridComponent)ctx.plugins().createComponent(cls);
        if (comp != null) {
            return (T)comp;
        }
        if (cls.equals(IgniteCacheObjectProcessor.class)) {
            return (T)new CacheObjectBinaryProcessorImpl(ctx);
        }
        if (cls.equals(DiscoveryNodeValidationProcessor.class)) {
            return (T)new OsDiscoveryNodeValidationProcessor(ctx);
        }
        if (cls.equals(IGridClusterStateProcessor.class)) {
            return (T)new GridClusterStateProcessor(ctx);
        }
        if (cls.equals(TransactionalDrProcessor.class)) {
            return (T)new NoOpTransactionalDrProcessor(ctx);
        }
        if (cls.equals(GridSecurityProcessor.class)) {
            return null;
        }
        Class<?> implCls = null;
        try {
            String clsName = cls.equals(PlatformProcessor.class) ? (ctx.config().getPlatformConfiguration() == null ? PlatformNoopProcessor.class.getName() : cls.getName() + "Impl") : IgniteKernal.componentClassName(cls);
            implCls = Class.forName(clsName);
        }
        catch (ClassNotFoundException clsName) {
            // empty catch block
        }
        if (implCls == null) {
            throw new IgniteCheckedException("Failed to find component implementation: " + cls.getName());
        }
        if (!cls.isAssignableFrom(implCls)) {
            throw new IgniteCheckedException("Component implementation does not implement component interface [component=" + cls.getName() + ", implementation=" + implCls.getName() + ']');
        }
        try {
            constructor = implCls.getConstructor(GridKernalContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new IgniteCheckedException("Component does not have expected constructor: " + implCls.getName(), e);
        }
        try {
            return (T)((GridComponent)constructor.newInstance(ctx));
        }
        catch (ReflectiveOperationException e) {
            throw new IgniteCheckedException("Failed to create component [component=" + cls.getName() + ", implementation=" + implCls.getName() + ']', e);
        }
    }

    private static String componentClassName(Class<?> cls) {
        return cls.getPackage().getName() + ".os." + cls.getSimpleName().replace("Grid", "GridOs");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.igniteInstanceName = U.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igniteInstanceName);
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return IgnitionEx.localIgnite();
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
    }

    private boolean skipDaemon(GridComponent comp) {
        return this.ctx.isDaemon() && U.hasAnnotation(comp.getClass(), SkipDaemon.class);
    }

    @Override
    public void dumpDebugInfo() {
        try {
            ClusterNode locNode;
            GridKernalContextImpl ctx = this.ctx;
            GridDiscoveryManager discoMrg = ctx != null ? ctx.discovery() : null;
            ClusterNode clusterNode = locNode = discoMrg != null ? discoMrg.localNode() : null;
            if (ctx != null && discoMrg != null && locNode != null) {
                boolean client = ctx.clientNode();
                UUID routerId = locNode instanceof TcpDiscoveryNode ? ((TcpDiscoveryNode)locNode).clientRouterNodeId() : null;
                U.warn(ctx.cluster().diagnosticLog(), "Dumping debug info for node [id=" + locNode.id() + ", name=" + ctx.igniteInstanceName() + ", order=" + locNode.order() + ", topVer=" + discoMrg.topologyVersion() + ", client=" + client + (client && routerId != null ? ", routerId=" + routerId : "") + ']');
                ctx.cache().context().exchange().dumpDebugInfo(null);
            } else {
                U.warn(this.log, "Dumping debug info for node, context is not initialized [name=" + this.igniteInstanceName + ']');
            }
        }
        catch (Exception e) {
            U.error(this.log, "Failed to dump debug info for node: " + e, e);
        }
    }

    public IgniteInternalFuture sendIoTest(ClusterNode node, byte[] payload, boolean procFromNioThread) {
        return this.ctx.io().sendIoTest(node, payload, procFromNioThread);
    }

    public IgniteInternalFuture sendIoTest(List<ClusterNode> nodes, byte[] payload, boolean procFromNioThread) {
        return this.ctx.io().sendIoTest(nodes, payload, procFromNioThread);
    }

    private void registerConfigurationSystemView() {
        this.ctx.systemView().registerInnerCollectionView(CFG_VIEW, CFG_VIEW_DESC, new ConfigurationViewWalker(), Collections.singleton(this.ctx.config()), IgniteConfigurationIterable::new, (cfg, view) -> view);
    }

    private void registerMetrics() {
        if (!this.ctx.metric().enabled()) {
            return;
        }
        MetricRegistry reg = this.ctx.metric().registry("ignite");
        reg.register("fullVersion", this::getFullVersion, String.class, "String presentation of the Ignite version.");
        reg.register("copyright", this::getCopyright, String.class, "Copyright statement for Ignite product.");
        reg.register("startTimestampFormatted", this::getStartTimestampFormatted, String.class, "String presentation of the kernal start timestamp.");
        reg.register("isRebalanceEnabled", this::isRebalanceEnabled, "Rebalance enabled flag.");
        reg.register("uptimeFormatted", this::getUpTimeFormatted, String.class, "String presentation of up-time for the kernal.");
        reg.register("startTimestamp", this::getStartTimestamp, "Start timestamp of the kernal.");
        reg.register("uptime", this::getUpTime, "Up-time of the kernal.");
        reg.register("osInformation", this::getOsInformation, String.class, "OS information.");
        reg.register("jdkInformation", this::getJdkInformation, String.class, "JDK information.");
        reg.register("osUser", this::getOsUser, String.class, "OS user name.");
        reg.register("vmName", this::getVmName, String.class, "VM name.");
        reg.register("instanceName", this::getInstanceName, String.class, "Optional kernal instance name.");
        reg.register("currentCoordinatorFormatted", this::getCurrentCoordinatorFormatted, String.class, "Formatted properties of current coordinator.");
        reg.register("isNodeInBaseline", this::isNodeInBaseline, "Baseline node flag.");
        reg.register("longJVMPausesCount", this::getLongJVMPausesCount, "Long JVM pauses count.");
        reg.register("longJVMPausesTotalDuration", this::getLongJVMPausesTotalDuration, "Long JVM pauses total duration.");
        reg.register("longJVMPauseLastEvents", this::getLongJVMPauseLastEvents, Map.class, "Long JVM pause last events.");
        reg.register("active", () -> ClusterState.active(this.ctx.state().clusterState().state()), Boolean.class, "Checks Ignite grid is active or is not active.");
        reg.register("clusterState", this::getClusterState, String.class, "Checks cluster state.");
        reg.register("lastClusterStateChangeTime", this::lastClusterStateChangeTime, "Unix time of last cluster state change operation.");
        reg.register("userAttributesFormatted", this::getUserAttributesFormatted, List.class, "Collection of formatted user-defined attributes added to this node.");
        reg.register("gridLoggerFormatted", this::getGridLoggerFormatted, String.class, "Formatted instance of logger that is in grid.");
        reg.register("executorServiceFormatted", this::getExecutorServiceFormatted, String.class, "Formatted instance of fully configured thread pool that is used in grid.");
        reg.register("igniteHome", this::getIgniteHome, String.class, "Ignite installation home folder.");
        reg.register("mBeanServerFormatted", this::getMBeanServerFormatted, String.class, "Formatted instance of MBean server instance.");
        reg.register("localNodeId", this::getLocalNodeId, UUID.class, "Unique identifier for this node within grid.");
        reg.register("isPeerClassLoadingEnabled", this::isPeerClassLoadingEnabled, Boolean.class, "Whether or not peer class loading (a.k.a. P2P class loading) is enabled.");
        reg.register("lifecycleBeansFormatted", this::getLifecycleBeansFormatted, List.class, "String representation of lifecycle beans.");
        reg.register("discoverySpiFormatted", this::getDiscoverySpiFormatted, String.class, "Formatted instance of configured discovery SPI implementation.");
        reg.register("communicationSpiFormatted", this::getCommunicationSpiFormatted, String.class, "Formatted instance of fully configured SPI communication implementation.");
        reg.register("deploymentSpiFormatted", this::getDeploymentSpiFormatted, String.class, "Formatted instance of fully configured deployment SPI implementation.");
        reg.register("checkpointSpiFormatted", this::getCheckpointSpiFormatted, String.class, "Formatted instance of configured checkpoint SPI implementation.");
        reg.register("collisionSpiFormatted", this::getCollisionSpiFormatted, String.class, "Formatted instance of configured collision SPI implementations.");
        reg.register("eventStorageSpiFormatted", this::getEventStorageSpiFormatted, String.class, "Formatted instance of fully configured event SPI implementation.");
        reg.register("failoverSpiFormatted", this::getFailoverSpiFormatted, String.class, "Formatted instance of fully configured failover SPI implementations.");
        reg.register("loadBalancingSpiFormatted", this::getLoadBalancingSpiFormatted, String.class, "Formatted instance of fully configured load balancing SPI implementations.");
    }

    @Override
    public void runIoTest(long warmup, long duration, int threads, long maxLatency, int rangesCnt, int payLoadSize, boolean procFromNioThread) {
        this.ctx.io().runIoTest(warmup, duration, threads, maxLatency, rangesCnt, payLoadSize, procFromNioThread, new ArrayList<ClusterNode>(this.ctx.cluster().get().forServers().forRemotes().nodes()));
    }

    @Override
    public void clearNodeLocalMap() {
        this.ctx.cluster().get().clearNodeMap();
    }

    @Override
    public void resetMetrics(String registry) {
        assert (registry != null);
        MetricRegistry mreg = this.ctx.metric().registry(registry);
        if (mreg != null) {
            mreg.reset();
        } else if (this.log.isInfoEnabled()) {
            this.log.info("\"" + registry + "\" not found.");
        }
    }

    @Override
    public void clusterState(String state) {
        ClusterState newState = ClusterState.valueOf(state);
        this.cluster().state(newState);
    }

    @Override
    public String getClusterState() {
        return this.ctx.state().clusterState().state().toString();
    }

    @Override
    public String clusterState() {
        return this.getClusterState();
    }

    @Override
    public long lastClusterStateChangeTime() {
        return this.ctx.state().lastStateChangeTime();
    }

    public String toString() {
        return S.toString(IgniteKernal.class, this);
    }

    static /* synthetic */ DecimalFormat access$300() {
        return IgniteKernal.doubleFormat();
    }

    private class ReconnectState {
        private final GridFutureAdapter firstReconnectFut = new GridFutureAdapter();
        private GridCompoundFuture<?, Object> curReconnectFut;
        private GridFutureAdapter<?> reconnectDone;

        private ReconnectState() {
        }

        void waitFirstReconnect() throws IgniteCheckedException {
            this.firstReconnectFut.get();
        }

        void waitPreviousReconnect() {
            if (this.curReconnectFut != null && !this.curReconnectFut.isDone()) {
                assert (this.reconnectDone != null);
                this.curReconnectFut.onDone(STOP_RECONNECT);
                try {
                    this.reconnectDone.get();
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return S.toString(ReconnectState.class, this);
        }
    }
}

