/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import java.util.Collection;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class DiscoveryEvent
extends EventAdapter {
    private static final long serialVersionUID = 0L;
    private ClusterNode evtNode;
    private long topVer;
    private Collection<ClusterNode> topSnapshot;
    private volatile String msgTemplate;
    @GridToStringExclude
    private transient Span span;

    @Override
    public String shortDisplay() {
        return this.name() + ": id8=" + U.id8(this.evtNode.id()) + ", ip=" + F.first(this.evtNode.addresses());
    }

    public DiscoveryEvent() {
    }

    public DiscoveryEvent(ClusterNode node, String msg, int type, ClusterNode evtNode) {
        super(node, msg, type);
        this.evtNode = evtNode;
    }

    public void eventNode(ClusterNode evtNode) {
        this.evtNode = evtNode;
    }

    public ClusterNode eventNode() {
        return this.evtNode;
    }

    public long topologyVersion() {
        return this.topVer;
    }

    public Collection<ClusterNode> topologyNodes() {
        return this.topSnapshot;
    }

    public void topologySnapshot(long topVer, Collection<ClusterNode> topSnapshot) {
        this.topVer = topVer;
        this.topSnapshot = topSnapshot;
    }

    public void messageTemplate(String msgTemplate) {
        this.msgTemplate = msgTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String message() {
        String msg = super.message();
        if (msg != null) {
            return msg;
        }
        if (this.msgTemplate == null) {
            return null;
        }
        DiscoveryEvent discoveryEvent = this;
        synchronized (discoveryEvent) {
            msg = super.message();
            if (msg != null) {
                return msg;
            }
            msg = this.msgTemplate + this.eventNode();
            this.message(msg);
        }
        return msg;
    }

    public Span span() {
        return this.span;
    }

    public void span(Span span) {
        this.span = span;
    }

    @Override
    public String toString() {
        return S.toString(DiscoveryEvent.class, this, "nodeId8", (Object)U.id8(this.node().id()), "msg", (Object)this.message(), "type", (Object)this.name(), "tstamp", (Object)this.timestamp());
    }
}

