/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.spring;

import javax.cache.integration.CacheWriterException;
import javax.sql.DataSource;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionIsolation;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class CacheSpringStoreSessionListener
implements CacheStoreSessionListener,
LifecycleAware {
    private PlatformTransactionManager txMgr;
    private DataSource dataSrc;
    @LoggerResource
    private IgniteLogger log;

    public void setTransactionManager(PlatformTransactionManager txMgr) {
        this.txMgr = txMgr;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.txMgr;
    }

    public void setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
    }

    public DataSource getDataSource() {
        return this.dataSrc;
    }

    @Override
    public void start() throws IgniteException {
        if (this.txMgr == null && this.dataSrc == null) {
            throw new IgniteException("Either transaction manager or data source is required by " + this.getClass().getSimpleName() + '.');
        }
        if (this.dataSrc != null) {
            if (this.txMgr == null) {
                this.txMgr = new DataSourceTransactionManager(this.dataSrc);
            } else {
                U.warn(this.log, "Data source configured in " + this.getClass().getSimpleName() + " will be ignored (transaction manager is already set).");
            }
        }
        assert (this.txMgr != null);
    }

    @Override
    public void stop() throws IgniteException {
    }

    @Override
    public void onSessionStart(CacheStoreSession ses) {
        if (ses.isWithinTransaction() && ses.attachment() == null) {
            try {
                TransactionDefinition def = this.definition(ses.transaction(), ses.cacheName());
                ses.attach(this.txMgr.getTransaction(def));
            }
            catch (TransactionException e) {
                throw new CacheWriterException("Failed to start store session [tx=" + ses.transaction() + ']', e);
            }
        }
    }

    @Override
    public void onSessionEnd(CacheStoreSession ses, boolean commit) {
        TransactionStatus tx;
        if (ses.isWithinTransaction() && (tx = (TransactionStatus)ses.attach(null)) != null) {
            try {
                if (commit) {
                    this.txMgr.commit(tx);
                } else {
                    this.txMgr.rollback(tx);
                }
            }
            catch (TransactionException e) {
                throw new CacheWriterException("Failed to end store session [tx=" + ses.transaction() + ']', e);
            }
        }
    }

    private TransactionDefinition definition(Transaction tx, String cacheName) {
        assert (tx != null);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("Ignite Tx [cache=" + (cacheName != null ? cacheName : "<default>") + ", id=" + tx.xid() + ']');
        def.setIsolationLevel(this.isolationLevel(tx.isolation()));
        long timeoutSec = (tx.timeout() + 500L) / 1000L;
        if (timeoutSec > 0L && timeoutSec < Integer.MAX_VALUE) {
            def.setTimeout((int)timeoutSec);
        }
        return def;
    }

    private int isolationLevel(TransactionIsolation isolation) {
        switch (isolation) {
            case READ_COMMITTED: {
                return 2;
            }
            case REPEATABLE_READ: {
                return 4;
            }
            case SERIALIZABLE: {
                return 8;
            }
        }
        throw new IllegalStateException();
    }
}

