/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import javax.cache.Cache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public final class VectorQuery<K, V>
extends Query<Cache.Entry<K, V>> {
    private static final long serialVersionUID = 0L;
    private String type;
    private String field;
    private float[] clauseVector;
    private int k;
    private float threshold = -1.0f;

    public VectorQuery(Class<?> type, String field, float[] clauseVector, int k) {
        this.setType(type);
        this.setField(field);
        this.setClauseVector(clauseVector);
        this.setK(k);
    }

    public VectorQuery(Class<?> type, String field, float[] clauseVector, int k, float threshold) {
        this.setType(type);
        this.setField(field);
        this.setClauseVector(clauseVector);
        this.setK(k);
        this.setThreshold(threshold);
    }

    public VectorQuery(String type, String field, float[] clauseVector, int k) {
        this.setType(type);
        this.setField(field);
        this.setClauseVector(clauseVector);
        this.setK(k);
    }

    public VectorQuery(String type, String field, float[] clauseVector, int k, float threshold) {
        this.setType(type);
        this.setField(field);
        this.setClauseVector(clauseVector);
        this.setK(k);
        this.setThreshold(threshold);
    }

    public String getType() {
        return this.type;
    }

    public VectorQuery<K, V> setType(String type) {
        this.type = type;
        return this;
    }

    public VectorQuery<K, V> setType(Class<?> type) {
        this.type = QueryUtils.typeName(type);
        return this;
    }

    public VectorQuery<K, V> setK(int k) {
        this.k = k;
        return this;
    }

    public int getK() {
        return this.k;
    }

    public VectorQuery<K, V> setThreshold(float threshold) {
        this.threshold = threshold;
        return this;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public String getField() {
        return this.field;
    }

    public VectorQuery<K, V> setField(String field) {
        this.field = field;
        return this;
    }

    public float[] getClauseVector() {
        return this.clauseVector;
    }

    public VectorQuery<K, V> setClauseVector(float[] clauseVector) {
        A.notNull(clauseVector, "clauseVector");
        this.clauseVector = clauseVector;
        return this;
    }

    public VectorQuery<K, V> setPageSize(int pageSize) {
        return (VectorQuery)super.setPageSize(pageSize);
    }

    public VectorQuery<K, V> setLocal(boolean loc) {
        return (VectorQuery)super.setLocal(loc);
    }

    @Override
    public String toString() {
        return S.toString(VectorQuery.class, this);
    }
}

