/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;
import org.gridgain.kafka.DataGrid;
import org.gridgain.kafka.LogFormat;
import org.gridgain.kafka.SystemEvent;
import org.gridgain.kafka.Version;
import org.gridgain.kafka.source.AvailableCachesMonitor;
import org.gridgain.kafka.source.BacklogService;
import org.gridgain.kafka.source.BacklogServiceImpl;
import org.gridgain.kafka.source.FailoverPolicy;
import org.gridgain.kafka.source.IgniteSourceConnectorConfig;
import org.gridgain.kafka.source.IgniteSourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IgniteSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(IgniteSourceConnector.class);
    private IgniteSourceConnectorConfig cfg;
    private AvailableCachesMonitor availableCachesMonitor;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> props) throws ConnectException {
        this.cfg = new IgniteSourceConnectorConfig(props);
        DataGrid.SOURCE.init(this.cfg.igniteCfg());
        this.availableCachesMonitor = new AvailableCachesMonitor(this::reconfigure, DataGrid.SOURCE::cacheNames, this.cfg.cacheListPollInterval(), this.cfg.cacheWhitelist(), this.cfg.cacheBlacklist(), this.cfg.backlogCacheName());
        this.availableCachesMonitor.start();
        if (this.shallUseBacklog()) {
            this.startBacklog();
        } else {
            this.stopBacklog();
        }
    }

    public Class<? extends Task> taskClass() {
        return IgniteSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks <= 0) {
            throw new IllegalArgumentException("Number of tasks must be a positive number.");
        }
        Set<String> cacheNames = this.availableCachesMonitor.cacheNames();
        if (cacheNames.isEmpty()) {
            log.warn(LogFormat.message(SystemEvent.MISCONFIGURATION, "No caches matching configuration found."));
            return new ArrayList<Map<String, String>>();
        }
        Collection<Collection<String>> groups = IgniteSourceConnector.assignCaches(cacheNames, maxTasks);
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(groups.size());
        for (Collection<String> grp : groups) {
            HashMap<String, String> taskProps = new HashMap<String, String>(this.cfg.originalsStrings());
            taskProps.put("caches", IgniteSourceConnector.joinStrings(grp));
            res.add(taskProps);
        }
        return res;
    }

    public void stop() {
        this.availableCachesMonitor.shutdown();
        try {
            this.availableCachesMonitor.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DataGrid.SOURCE.close();
    }

    private void reconfigure(AvailableCachesMonitor.Diff cachesDiff) {
        log.info(LogFormat.message(SystemEvent.RECONFIGURATION, "New caches were discovered, reconfiguration will be triggered: " + cachesDiff));
        this.context.requestTaskReconfiguration();
    }

    public ConfigDef config() {
        return IgniteSourceConnectorConfig.configDef();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        return super.validate(connectorConfigs);
    }

    private static Collection<Collection<String>> assignCaches(Collection<String> cacheNames, int taskCnt) {
        ArrayList<Collection<String>> res = new ArrayList<Collection<String>>(taskCnt);
        int perGrpCnt = cacheNames.size() / taskCnt;
        int leftover = cacheNames.size() - taskCnt * perGrpCnt;
        Iterator<String> cacheNamesIter = cacheNames.iterator();
        for (int grp = 0; grp < taskCnt; ++grp) {
            int numThisGrp = grp < leftover ? perGrpCnt + 1 : perGrpCnt;
            ArrayList<String> grpList = new ArrayList<String>(numThisGrp);
            for (int i = 0; i < numThisGrp; ++i) {
                grpList.add(cacheNamesIter.next());
            }
            res.add(grpList);
        }
        return res;
    }

    private static String joinStrings(Iterable<String> elements) {
        StringBuilder res = new StringBuilder();
        boolean first = true;
        for (String elem : elements) {
            if (first) {
                first = false;
            } else {
                res.append(",");
            }
            res.append(elem);
        }
        return res.toString();
    }

    private boolean shallUseBacklog() {
        return this.cfg.failoverPolicy() == FailoverPolicy.BACKLOG;
    }

    private void startBacklog() throws ConnectException {
        if (!DataGrid.SOURCE.isServiceDeployed(this.cfg.backlogServiceName(), BacklogService.class, BacklogService::test)) {
            this.validateBacklogConfiguration(DataGrid.SOURCE.ignite());
            DataGrid.SOURCE.deployService(this.cfg.backlogServiceName(), new BacklogServiceImpl(this.cfg));
            log.info("Kafka backlog service [" + this.cfg.backlogServiceName() + "] is deployed.");
        }
    }

    private void stopBacklog() throws ConnectException {
        if (DataGrid.SOURCE.isServiceDeployed(this.cfg.backlogServiceName(), BacklogService.class, BacklogService::test)) {
            DataGrid.SOURCE.removeService(this.cfg.backlogServiceName());
            log.info("Kafka backlog service [" + this.cfg.backlogServiceName() + "] is undeployed.");
        }
    }

    private void validateBacklogConfiguration(Ignite ignite) throws ConnectException {
        GridKernalContext ctx = ((IgniteEx)ignite).context();
        List srvs = ctx.discovery().discoCache().serverNodes();
        for (ClusterNode n : srvs) {
            DataRegionConfiguration dataRegionCfg = GridCacheUtils.findRemoteDataRegionConfiguration((ClusterNode)n, (JdkMarshaller)ctx.marshallerContext().jdkMarshaller(), (ClassLoader)U.resolveClassLoader((IgniteConfiguration)ctx.config()), (String)this.cfg.backlogDataRegionName());
            if (dataRegionCfg != null) continue;
            throw new ConnectException(LogFormat.message(SystemEvent.MISCONFIGURATION, "Kafka Backlog data region [%s] is not configured.", this.cfg.backlogDataRegionName()));
        }
    }
}

