/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.cache.event.CacheEntryEvent;
import org.apache.ignite.stream.StreamReceiver;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.ConfigOption;
import org.gridgain.kafka.EnumOption;
import org.gridgain.kafka.sink.KeyPolicy;
import org.gridgain.kafka.sink.PrefixTopicToCacheMapper;
import org.gridgain.kafka.sink.SinkErrorHandlingPolicy;
import org.gridgain.kafka.sink.TopicToCacheMapper;

public class IgniteSinkConnectorConfig
extends AbstractConfig {
    public static final ConfigOption<String> IGNITE_CFG = ConfigOption.high("igniteCfg", ConfigDef.Type.STRING, "", "Path to the Ignite configuration file. ``$IGNITE_HOME/config/default-config.xml`` is used if no Ignite config is configured");
    public static final ConfigOption<Long> PUSH_INTERVAL = ConfigOption.low("pushInterval", ConfigDef.Type.LONG, 2000L, "Frequency in milliseconds to push data to Ignite.");
    public static final ConfigOption<String> TOPIC_PREFIX = ConfigOption.low("topicPrefix", ConfigDef.Type.STRING, "ignite-", "Kafka topic is built from this prefix and cache name.");
    public static final ConfigOption<String> CACHE_PREFIX = ConfigOption.low("cachePrefix", ConfigDef.Type.STRING, "", "Sink cache name is built from this prefix and kafka topic without topic prefix. For example, if topic is ``ignite.person``, topicPrefix is ``ignite.`` and cachePrefix is ``ignite-`` then sink cache name is ``ignite-person``.");
    public static final ConfigOption<Boolean> SHALL_PROCESS_UPDATES = ConfigOption.medium("shallProcessUpdates", ConfigDef.Type.BOOLEAN, false, "Indicates if overwriting or removing existing values in the sink cache is enabled. Sink connector performs better if this flag is disabled.");
    public static final EnumOption<KeyPolicy> KEY_POLICY = EnumOption.low("keyPolicy", KeyPolicy.KEY, "Specifies what data to use for the Ignite cache key. The options are:\n**" + (Object)((Object)KeyPolicy.KEY) + "**: Fields from the record key are used.\n**" + (Object)((Object)KeyPolicy.VALUE) + "**: Fields from the record key are used.\n**" + (Object)((Object)KeyPolicy.KAFKA) + "**: Ignite Binary Object having 3 fields - Kafka record's topic, partition and offset - is used as the cache key.");
    public static final ConfigOption<List<String>> KEY_FIELDS = ConfigOption.low("keyFields", ConfigDef.Type.LIST, Collections.emptyList(), "A comma-separated list of field names to use for the Ignite cache key. Not applicable if " + KEY_POLICY.rst() + " is set to ``" + (Object)((Object)KeyPolicy.KAFKA) + "``. All fields are used if the setting is not specified.");
    public static final ConfigOption<Class<? extends Predicate<CacheEntryEvent<?, ?>>>> CACHE_FILTER = ConfigOption.low("cacheFilter", ConfigDef.Type.CLASS, null, "Class name of a custom ``java.util.function.Predicate<javax.cache.event.CacheEntryEvent>`` implementation to filter data pushed to Ignite caches.");
    public static final ConfigOption<Boolean> FLUSH_ON_OFFSET_COMMIT = ConfigOption.low("flushOnOffsetCommit", ConfigDef.Type.BOOLEAN, false, "Indicates if flush should be executed on offset commit instead of per each record. Deprecated, has no effect now, flush always happen per batch.");
    public static final ConfigOption<Class<? extends StreamReceiver<?, ?>>> STREAM_RECEIVER = ConfigOption.medium("streamReceiver", ConfigDef.Type.CLASS, null, "Allows to specify custom StreamReceiver");
    public static final ConfigOption<Class<? extends TopicToCacheMapper>> TOPIC_TO_CACHE_MAPPER = ConfigOption.medium("topic.to.cache.mapper", ConfigDef.Type.CLASS, PrefixTopicToCacheMapper.class, "Allows to specify custom topic to cache mapper");
    public static final EnumOption<SinkErrorHandlingPolicy> ERROR_POLICY = EnumOption.low("errorHandlingPolicy", SinkErrorHandlingPolicy.LOG_ONLY, "Controls how connector should handle errors during sink records processing (i.e. malformed record, key inference failure etc...). The options are:\n**" + (Object)((Object)SinkErrorHandlingPolicy.LOG_ONLY) + "**: Log problematic entry and skip it.\n**" + (Object)((Object)SinkErrorHandlingPolicy.STOP_TASK) + "**: Log problematic entry and transfer control to Kafka Connect which effectively will stop sink task");
    private static final ConfigDef cfgDef = ConfigOption.buildCfgWith(IGNITE_CFG, PUSH_INTERVAL, TOPIC_PREFIX, TOPIC_TO_CACHE_MAPPER, CACHE_PREFIX, SHALL_PROCESS_UPDATES, FLUSH_ON_OFFSET_COMMIT, KEY_POLICY, KEY_FIELDS, CACHE_FILTER, STREAM_RECEIVER, ERROR_POLICY);

    IgniteSinkConnectorConfig(ConfigDef cfg, Map<String, String> props) {
        super(cfg, props);
    }

    IgniteSinkConnectorConfig(Map<String, String> props) {
        this(cfgDef, props);
    }

    static ConfigDef conf() {
        return cfgDef;
    }

    String igniteCfg() {
        return this.getString(IGNITE_CFG.key());
    }

    String topicPrefix() {
        return this.getString(TOPIC_PREFIX.key());
    }

    String cachePrefix() {
        return this.getString(CACHE_PREFIX.key());
    }

    Boolean shallProcessUpdates() {
        return this.getBoolean(SHALL_PROCESS_UPDATES.key());
    }

    Class<?> cacheFilter() {
        return this.getClass(CACHE_FILTER.key());
    }

    KeyPolicy keyPolicy() {
        return KEY_POLICY.extractFrom(this);
    }

    List<String> keyFields() {
        return this.getList(KEY_FIELDS.key());
    }

    @Deprecated
    Boolean flushOnOffsetCommit() {
        return this.getBoolean(FLUSH_ON_OFFSET_COMMIT.key());
    }

    Class<?> streamReceiver() {
        return this.getClass(STREAM_RECEIVER.key());
    }

    <M extends TopicToCacheMapper> Class<M> topicToCacheMapper() {
        return this.getClass(TOPIC_TO_CACHE_MAPPER.key());
    }

    SinkErrorHandlingPolicy errorHandlingPolicy() {
        return ERROR_POLICY.extractFrom(this);
    }
}

