/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka;

import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.ConfigOption;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class EnumOption<E extends Enum<E>>
extends ConfigOption<E> {
    private EnumOption(String key, ConfigDef.Importance importance, E dflt, String doc) {
        super(key, ConfigDef.Type.STRING, importance, dflt, doc);
    }

    public static <T extends Enum<T>> EnumOption<T> high(String key, T dflt, String doc) {
        return new EnumOption<T>(key, ConfigDef.Importance.HIGH, dflt, doc);
    }

    public static <T extends Enum<T>> EnumOption<T> low(String key, T dflt, String doc) {
        return new EnumOption<T>(key, ConfigDef.Importance.LOW, dflt, doc);
    }

    @Override
    public void applyTo(ConfigDef cfgDef) {
        cfgDef.define(this.key, this.type, (Object)((Enum)this.dflt).name(), this.importance, this.doc);
    }

    public E extractFrom(@NotNull AbstractConfig cfg) {
        String val = cfg.getString(this.key);
        for (Enum e : (Enum[])((Enum)this.dflt).getDeclaringClass().getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(val)) continue;
            return (E)e;
        }
        LoggerFactory.getLogger(cfg.getClass()).warn("Unexpected value for <" + this.key + "> = " + val + ". Falling back to default value: " + this.dflt);
        return (E)((Enum)this.dflt);
    }
}

