/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.locate;

import java.util.List;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervalrtree.SortedPackedIntervalRTree;

public class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private final IntervalIndexedGeometry index;

    public IndexedPointInAreaLocator(Geometry g2) {
        if (!(g2 instanceof Polygonal) && !(g2 instanceof LinearRing)) {
            throw new IllegalArgumentException("Argument must be Polygonal or LinearRing");
        }
        this.index = new IntervalIndexedGeometry(g2);
    }

    public int locate(Coordinate p) {
        RayCrossingCounter rcc = new RayCrossingCounter(p);
        SegmentVisitor visitor = new SegmentVisitor(rcc);
        this.index.query(p.y, p.y, visitor);
        return rcc.getLocation();
    }

    private static class IntervalIndexedGeometry {
        private final SortedPackedIntervalRTree index = new SortedPackedIntervalRTree();

        public IntervalIndexedGeometry(Geometry geom) {
            this.init(geom);
        }

        private void init(Geometry geom) {
            List lines = LinearComponentExtracter.getLines(geom);
            for (LineString line : lines) {
                Coordinate[] pts = line.getCoordinates();
                this.addLine(pts);
            }
        }

        private void addLine(Coordinate[] pts) {
            for (int i = 1; i < pts.length; ++i) {
                LineSegment seg = new LineSegment(pts[i - 1], pts[i]);
                double min2 = Math.min(seg.p0.y, seg.p1.y);
                double max = Math.max(seg.p0.y, seg.p1.y);
                this.index.insert(min2, max, seg);
            }
        }

        public List query(double min2, double max) {
            ArrayListVisitor visitor = new ArrayListVisitor();
            this.index.query(min2, max, visitor);
            return visitor.getItems();
        }

        public void query(double min2, double max, ItemVisitor visitor) {
            this.index.query(min2, max, visitor);
        }
    }

    private static class SegmentVisitor
    implements ItemVisitor {
        private RayCrossingCounter counter;

        public SegmentVisitor(RayCrossingCounter counter) {
            this.counter = counter;
        }

        public void visitItem(Object item) {
            LineSegment seg = (LineSegment)item;
            this.counter.countSegment(seg.getCoordinate(0), seg.getCoordinate(1));
        }
    }
}

