/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;

public class Distance {
    public static double segmentToSegment(Coordinate A2, Coordinate B, Coordinate C5, Coordinate D2) {
        if (A2.equals(B)) {
            return Distance.pointToSegment(A2, C5, D2);
        }
        if (C5.equals(D2)) {
            return Distance.pointToSegment(D2, A2, B);
        }
        boolean noIntersection = false;
        if (!Envelope.intersects(A2, B, C5, D2)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A2.x) * (D2.y - C5.y) - (B.y - A2.y) * (D2.x - C5.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A2.y - C5.y) * (D2.x - C5.x) - (A2.x - C5.x) * (D2.y - C5.y);
                double s_num = (A2.y - C5.y) * (B.x - A2.x) - (A2.x - C5.x) * (B.y - A2.y);
                double s2 = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s2 < 0.0 || s2 > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil.min(Distance.pointToSegment(A2, C5, D2), Distance.pointToSegment(B, C5, D2), Distance.pointToSegment(C5, A2, B), Distance.pointToSegment(D2, A2, B));
        }
        return 0.0;
    }

    public static double pointToSegmentString(Coordinate p, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        for (int i = 0; i < line.length - 1; ++i) {
            double dist = Distance.pointToSegment(p, line[i], line[i + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double pointToSegment(Coordinate p, Coordinate A2, Coordinate B) {
        if (A2.x == B.x && A2.y == B.y) {
            return p.distance(A2);
        }
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y);
        double r = ((p.x - A2.x) * (B.x - A2.x) + (p.y - A2.y) * (B.y - A2.y)) / len2;
        if (r <= 0.0) {
            return p.distance(A2);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s2 = ((A2.y - p.y) * (B.x - A2.x) - (A2.x - p.x) * (B.y - A2.y)) / len2;
        return Math.abs(s2) * Math.sqrt(len2);
    }

    public static double pointToLinePerpendicular(Coordinate p, Coordinate A2, Coordinate B) {
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y);
        double s2 = ((A2.y - p.y) * (B.x - A2.x) - (A2.x - p.x) * (B.y - A2.y)) / len2;
        return Math.abs(s2) * Math.sqrt(len2);
    }
}

