/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.ConfigOption;
import org.gridgain.kafka.IgniteConnectUtils;
import org.gridgain.kafka.InvalidConfigurationException;
import org.gridgain.kafka.source.CacheToTopicMapper;
import org.gridgain.kafka.source.IgniteSourceConnectorConfig;

public class EnumeratedListCacheToTopicMapper
implements CacheToTopicMapper {
    public static final ConfigOption<List<String>> CACHE_TO_TOPIC_MAPPING = ConfigOption.high("cache.to.topic.mapping", ConfigDef.Type.LIST, Collections.emptyList(), "Text-based mapping between topic name and cache name");
    private Map<String, String> mapping;

    @Override
    public void init(Map<String, String> cfgMap) {
        boolean hasBlackList;
        Config cfg = new Config(cfgMap);
        List pairs = cfg.getList(CACHE_TO_TOPIC_MAPPING.key());
        this.mapping = IgniteConnectUtils.parseMapping(pairs);
        boolean hasWhiteList = cfg.originals().containsKey(IgniteSourceConnectorConfig.CACHE_WHITELIST.key());
        if (hasWhiteList) {
            this.validateAgainstWhiteList(cfg.getList(IgniteSourceConnectorConfig.CACHE_WHITELIST.key()));
        }
        if (hasBlackList = cfg.originals().containsKey(IgniteSourceConnectorConfig.CACHE_BLACKLIST.key())) {
            this.validateAgainstBlackList(cfg.getList(IgniteSourceConnectorConfig.CACHE_BLACKLIST.key()));
        }
    }

    @Override
    public String map(String cacheName) {
        String kafkaTopic = this.mapping.get(cacheName);
        if (kafkaTopic == null) {
            throw new IllegalArgumentException("Cache with name " + cacheName + " is not defined in mapper configuration: " + CACHE_TO_TOPIC_MAPPING.key());
        }
        return kafkaTopic;
    }

    private void validateAgainstWhiteList(List<String> whiteList) {
        List regexes = whiteList.stream().map(Pattern::compile).collect(Collectors.toList());
        for (String cacheName : this.mapping.keySet()) {
            boolean matched = regexes.stream().anyMatch(regex -> regex.matcher(cacheName).matches());
            if (matched) continue;
            throw new InvalidConfigurationException("Inconsistent values between " + IgniteSourceConnectorConfig.CACHE_WHITELIST.key() + " and " + CACHE_TO_TOPIC_MAPPING.key() + ": cacheName=" + cacheName);
        }
    }

    private void validateAgainstBlackList(List<String> blackList) {
        List regexes = blackList.stream().map(Pattern::compile).collect(Collectors.toList());
        for (String cacheName : this.mapping.keySet()) {
            boolean matched = regexes.stream().anyMatch(regex -> regex.matcher(cacheName).matches());
            if (!matched) continue;
            throw new InvalidConfigurationException("Inconsistent values between " + IgniteSourceConnectorConfig.CACHE_BLACKLIST.key() + " and " + CACHE_TO_TOPIC_MAPPING.key() + ": cacheName=" + cacheName);
        }
    }

    private static class Config
    extends AbstractConfig {
        private static final ConfigDef confDef = ConfigOption.buildCfgWith(CACHE_TO_TOPIC_MAPPING, IgniteSourceConnectorConfig.CACHE_WHITELIST, IgniteSourceConnectorConfig.CACHE_BLACKLIST);

        public Config(Map<?, ?> originals) {
            super(confDef, originals);
        }
    }
}

