/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class AvailableCachesMonitor
extends Thread {
    private final Consumer<Diff> changeHnd;
    private final Supplier<Collection<String>> cacheNamesGetter;
    private final CountDownLatch shutdownLatch;
    private final long pollIntervalMs;
    private final Collection<String> whitelist;
    private final Collection<String> blacklist;
    private final String backlogCacheName;
    private Set<String> cacheNames = new HashSet<String>();

    AvailableCachesMonitor(Consumer<Diff> changeHnd, Supplier<Collection<String>> cacheNamesGetter, long pollIntervalMs, Collection<String> whitelist, Collection<String> blacklist, String backlogCacheName) {
        if (changeHnd == null) {
            throw new IllegalArgumentException("Change handler must not be null.");
        }
        if (cacheNamesGetter == null) {
            throw new IllegalArgumentException("Cache names getter must not be null.");
        }
        if (pollIntervalMs <= 0L) {
            throw new IllegalArgumentException("Polling interval must be a positive number.");
        }
        this.changeHnd = changeHnd;
        this.cacheNamesGetter = cacheNamesGetter;
        this.pollIntervalMs = pollIntervalMs;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.backlogCacheName = backlogCacheName;
        this.shutdownLatch = new CountDownLatch(1);
        this.updateCacheNames();
    }

    @Override
    public void run() {
        while (this.shutdownLatch.getCount() > 0L) {
            Diff diff = this.updateCacheNames();
            if (!diff.isEmpty()) {
                this.changeHnd.accept(diff);
            }
            try {
                if (!this.shutdownLatch.await(this.pollIntervalMs, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    Set<String> cacheNames() {
        return this.cacheNames;
    }

    void shutdown() {
        this.shutdownLatch.countDown();
    }

    private static boolean matchesAny(String s2, Collection<String> regexes) {
        for (String regex : regexes) {
            if (!s2.equals(regex) && !s2.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private Diff updateCacheNames() {
        Set<String> filteredCacheNames;
        HashSet<String> currCacheNames = new HashSet<String>(this.cacheNamesGetter.get());
        Function<Set, Set> blacklistFilter = list -> {
            if (this.blacklist != null && !this.blacklist.isEmpty()) {
                HashSet<String> res = new HashSet<String>();
                for (String cache : list) {
                    if (AvailableCachesMonitor.matchesAny(cache, this.blacklist)) continue;
                    res.add(cache);
                }
                return res;
            }
            return list;
        };
        if (this.whitelist != null && !this.whitelist.isEmpty()) {
            filteredCacheNames = new HashSet<String>();
            for (String cache : currCacheNames) {
                if (!AvailableCachesMonitor.matchesAny(cache, this.whitelist)) continue;
                filteredCacheNames.add(cache);
            }
            filteredCacheNames = blacklistFilter.apply(filteredCacheNames);
        } else {
            filteredCacheNames = blacklistFilter.apply(currCacheNames);
        }
        filteredCacheNames.remove(this.backlogCacheName);
        Diff diff = Diff.create(this.cacheNames, filteredCacheNames);
        this.cacheNames = filteredCacheNames;
        return diff;
    }

    static final class Diff {
        private final Collection<String> added;
        private final Collection<String> rmv;

        private Diff(Collection<String> added, Collection<String> rmv) {
            this.added = added == null ? new ArrayList() : added;
            this.rmv = rmv == null ? new ArrayList() : rmv;
        }

        static Diff create(Collection<String> old, Collection<String> latest) {
            ArrayList<String> added = new ArrayList<String>(latest);
            added.removeAll(old);
            ArrayList<String> rmv = new ArrayList<String>(old);
            rmv.removeAll(latest);
            return new Diff(added, rmv);
        }

        Collection<String> added() {
            return this.added;
        }

        Collection<String> removed() {
            return this.rmv;
        }

        boolean isEmpty() {
            return this.added.size() == 0 && this.rmv.size() == 0;
        }

        public String toString() {
            return Stream.concat(this.added.stream().map(s2 -> "+" + s2), this.rmv.stream().map(s2 -> "-" + s2)).collect(Collectors.joining(", "));
        }
    }
}

