/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.schema.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Schema;
import org.gridgain.kafka.schema.cache.ResolvedSchemasCache;
import org.gridgain.kafka.schema.cache.SchemaIdentityKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaffeineSchemaCache
implements ResolvedSchemasCache {
    private final Cache<SchemaIdentityKey, Schema> delegate;

    private CaffeineSchemaCache(Cache<SchemaIdentityKey, Schema> delegate) {
        this.delegate = delegate;
    }

    public static CaffeineSchemaCache newInstance(int size, int lastAccessExpirationMillis, boolean isStatsEnabled) {
        Caffeine<Object, Object> builder = Caffeine.newBuilder().maximumSize(size);
        if (isStatsEnabled) {
            builder.recordStats();
        }
        if (lastAccessExpirationMillis > 0) {
            builder.expireAfterAccess(lastAccessExpirationMillis, TimeUnit.MILLISECONDS);
        }
        return new CaffeineSchemaCache(builder.build());
    }

    public static CaffeineSchemaCache newInstance(int size, int lastAccessExpirationMillis) {
        return CaffeineSchemaCache.newInstance(size, lastAccessExpirationMillis, false);
    }

    @Override
    @Nullable
    public Schema get(int typeId, int schemaId) {
        return this.delegate.getIfPresent(new SchemaIdentityKey(typeId, schemaId));
    }

    @Override
    @NotNull
    public Schema put(int typeId, int schemaId, @NotNull Schema schema) {
        this.delegate.put(new SchemaIdentityKey(typeId, schemaId), schema);
        return schema;
    }

    @Override
    public void clear() {
        this.delegate.invalidateAll();
        this.delegate.cleanUp();
    }
}

