/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.schema;

import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaUtils {
    public static final String GG_SCHEMA_PREFIX = "o.g.k.c.s.";
    static final String UNDEFINED_NAME = "o.g.k.c.s.undef";
    public static final Schema OPTIONAL_BIG_INT_SCHEMA = Decimal.builder((int)0).optional().build();
    public static final Schema OPTIONAL_TIMESTAMP_SCHEMA = Timestamp.builder().optional().build();
    public static final Schema OPTIONAL_TIME_SCHEMA = Time.builder().optional().build();
    public static final Schema OPTIONAL_DATE_SCHEMA = Date.builder().optional().build();
    public static final Schema UNDEFINED_SCHEMA = SchemaBuilder.struct().optional().name("o.g.k.c.s.undef").build();
    static final Schema SKIP_SCHEMA = SchemaBuilder.bool().optional().name("skip").build();

    public static boolean isApplicable(@Nullable Schema schema) {
        return schema != null && schema != SKIP_SCHEMA;
    }

    public static boolean isUndefined(Schema schema) {
        return Schema.Type.STRUCT == schema.type() && UNDEFINED_NAME.equals(schema.name()) && schema.fields().isEmpty();
    }

    @NotNull
    public static Schema mapSchema(@NotNull Schema keySchema, @NotNull Schema valSchema, @Nullable String schemaName) {
        SchemaBuilder builder = SchemaBuilder.map((Schema)keySchema, (Schema)valSchema).optional();
        return schemaName != null ? builder.name(schemaName).build() : builder.build();
    }

    @NotNull
    public static Schema mapSchemaOfUndefined(@Nullable String schemaName) {
        return SchemaBuilder.map((Schema)UNDEFINED_SCHEMA, (Schema)UNDEFINED_SCHEMA).name(schemaName).optional().build();
    }

    @Nullable
    public static Schema arraySchemaNullable(@Nullable Schema elementSchema, @Nullable String name) {
        return elementSchema == null ? null : SchemaUtils.arraySchema(name, elementSchema);
    }

    @NotNull
    public static Schema arraySchema(@Nullable String schemaName, @NotNull Schema elementSchema) {
        SchemaBuilder builder = SchemaBuilder.array((Schema)elementSchema).optional();
        return schemaName != null ? builder.name(schemaName).build() : builder.build();
    }

    @NotNull
    public static Schema arraySchema(@NotNull Schema elementSchema) {
        return SchemaUtils.arraySchema(null, elementSchema);
    }

    @NotNull
    public static Schema arraySchemaOfUndefined(@Nullable String schemaName) {
        return SchemaUtils.arraySchema(schemaName, UNDEFINED_SCHEMA);
    }

    public static boolean isPojo(Class<?> cls) {
        return cls != null && cls != Object.class && !cls.isInterface();
    }
}

