/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.schema;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.gridgain.kafka.schema.SchemaUtils;
import org.jetbrains.annotations.NotNull;

public interface ClassFieldsVisitor {
    public void visit(@NotNull Field var1) throws IllegalAccessException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withClassFields(@NotNull Class<?> startingClass, @NotNull ClassFieldsVisitor visitor) {
        Class<?> cls = startingClass;
        while (SchemaUtils.isPojo(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    visitor.visit(field);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                finally {
                    if (!accessible) {
                        field.setAccessible(false);
                    }
                }
            }
            cls = cls.getSuperclass();
        }
    }
}

