/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.ignite.stream.StreamReceiver;
import org.apache.kafka.connect.errors.ConnectException;
import org.gridgain.kafka.CacheEntry;
import org.gridgain.kafka.InvalidConfigurationException;
import org.gridgain.kafka.LogFormat;
import org.gridgain.kafka.SystemEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class IgniteConnectUtils {
    private static final Pattern splitPattern = Pattern.compile("(?<!\\\\)>");

    @Nullable
    public static Predicate<CacheEntry> createFilter(Class<?> cls) throws InstantiationException, IllegalAccessException {
        if (cls == null) {
            return null;
        }
        return (Predicate)cls.newInstance();
    }

    @Nullable
    public static Predicate<CacheEntry> createFilter(Class<?> cls, Logger log) {
        try {
            return IgniteConnectUtils.createFilter(cls);
        }
        catch (Exception ex) {
            log.error(LogFormat.message(SystemEvent.CREATE_FILTER_FAILURE, ex));
            throw new ConnectException(LogFormat.message(SystemEvent.CREATE_FILTER_FAILURE, ex));
        }
    }

    @Nullable
    public static StreamReceiver<?, ?> createStreamReceiver(Class<?> cls, Logger log) {
        try {
            if (cls == null) {
                return null;
            }
            return (StreamReceiver)cls.newInstance();
        }
        catch (Exception ex) {
            log.error(LogFormat.message(SystemEvent.CREATE_STREAM_RECEIVER_FAILURE, ex));
            throw new ConnectException(LogFormat.message(SystemEvent.CREATE_STREAM_RECEIVER_FAILURE, ex));
        }
    }

    public static Map<String, String> parseMapping(List<String> pairs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String pair : pairs) {
            String[] keyValue = splitPattern.split(pair);
            if (keyValue.length != 2 || keyValue[0].isEmpty() || keyValue[1].isEmpty()) {
                throw new InvalidConfigurationException("Malformed configuration part: " + pair + "; whole configuration: " + pairs);
            }
            String oldValue = result.put(keyValue[0].replace("\\>", ">"), keyValue[1].replace("\\>", ">"));
            if (oldValue == null) continue;
            throw new InvalidConfigurationException("Duplicated key in configuration :" + keyValue[0]);
        }
        return result;
    }
}

