/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka;

import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;
import org.gridgain.kafka.DataGrid;
import org.gridgain.kafka.LogFormat;
import org.gridgain.kafka.SystemEvent;

public class IgniteBinaryConverter
implements Converter {
    private Marshaller srcMarshaller;
    private Marshaller sinkMarshaller;

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] fromConnectData(String topic, Schema schema, Object val) {
        try {
            if (this.srcMarshaller == null) {
                this.srcMarshaller = DataGrid.SOURCE.marshaller();
            }
            return this.srcMarshaller.marshal(val);
        }
        catch (IgniteCheckedException e) {
            throw new DataException(LogFormat.message(SystemEvent.IGNITE_CONVERTER_FAILED, "Failed to convert object from topic %s", topic), (Throwable)e);
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] val) {
        Object obj;
        try {
            if (this.sinkMarshaller == null) {
                this.sinkMarshaller = DataGrid.SINK.marshaller();
            }
            obj = this.sinkMarshaller.unmarshal(val, this.getClass().getClassLoader());
        }
        catch (IgniteCheckedException e) {
            throw new DataException(LogFormat.message(SystemEvent.IGNITE_CONVERTER_FAILED, "Failed to convert object for topic %s", topic), (Throwable)e);
        }
        return obj == null ? SchemaAndValue.NULL : new SchemaAndValue(null, obj);
    }
}

