/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.gridgain.internal.h2.api.TimestampWithTimeZone;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.LocalDateTimeUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueTimestampTimeZone
extends Value {
    public static final int DEFAULT_PRECISION = 32;
    public static final int MAXIMUM_PRECISION = 35;
    static final int DEFAULT_SCALE = 6;
    static final int MAXIMUM_SCALE = 9;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    private ValueTimestampTimeZone(long dateValue, long timeNanos, short timeZoneOffsetMins) {
        if (timeNanos < 0L || timeNanos >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + timeNanos);
        }
        if (timeZoneOffsetMins < -1080 || timeZoneOffsetMins > 1080) {
            throw new IllegalArgumentException("timeZoneOffsetMins out of range " + timeZoneOffsetMins);
        }
        this.dateValue = dateValue;
        this.timeNanos = timeNanos;
        this.timeZoneOffsetMins = timeZoneOffsetMins;
    }

    public static ValueTimestampTimeZone fromDateValueAndNanos(long dateValue, long timeNanos, short timeZoneOffsetMins) {
        return (ValueTimestampTimeZone)Value.cache(new ValueTimestampTimeZone(dateValue, timeNanos, timeZoneOffsetMins));
    }

    public static ValueTimestampTimeZone get(TimestampWithTimeZone timestamp) {
        return ValueTimestampTimeZone.fromDateValueAndNanos(timestamp.getYMD(), timestamp.getNanosSinceMidnight(), timestamp.getTimeZoneOffsetMins());
    }

    public static ValueTimestampTimeZone parse(String s2) {
        try {
            return (ValueTimestampTimeZone)DateTimeUtils.parseTimestamp(s2, null, true);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIMESTAMP WITH TIME ZONE", s2);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    @Override
    public Timestamp getTimestamp() {
        return DateTimeUtils.convertTimestampTimeZoneToTimestamp(this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIMESTAMP_TZ;
    }

    @Override
    public int getValueType() {
        return 24;
    }

    @Override
    public int getMemory() {
        return 40;
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder(35);
        DateTimeUtils.appendTimestampTimeZone(builder, this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
        return builder.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append("TIMESTAMP WITH TIME ZONE '");
        DateTimeUtils.appendTimestampTimeZone(builder, this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
        return builder.append('\'');
    }

    @Override
    public boolean checkPrecision(long precision) {
        return true;
    }

    @Override
    public Value convertScale(boolean onlyToSmallerScale, int targetScale) {
        if (targetScale >= 9) {
            return this;
        }
        if (targetScale < 0) {
            throw DbException.getInvalidValueException("scale", targetScale);
        }
        long n = this.timeNanos;
        long n2 = DateTimeUtils.convertScale(n, targetScale);
        if (n2 == n) {
            return this;
        }
        long dv = this.dateValue;
        if (n2 >= 86400000000000L) {
            n2 -= 86400000000000L;
            dv = DateTimeUtils.incrementDateValue(dv);
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(dv, n2, this.timeZoneOffsetMins);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        ValueTimestampTimeZone t2 = (ValueTimestampTimeZone)o;
        long dateValueA = this.dateValue;
        long timeA = this.timeNanos - (long)this.timeZoneOffsetMins * 60000000000L;
        if (timeA < 0L) {
            timeA += 86400000000000L;
            dateValueA = DateTimeUtils.decrementDateValue(dateValueA);
        } else if (timeA >= 86400000000000L) {
            timeA -= 86400000000000L;
            dateValueA = DateTimeUtils.incrementDateValue(dateValueA);
        }
        long dateValueB = t2.dateValue;
        long timeB = t2.timeNanos - (long)t2.timeZoneOffsetMins * 60000000000L;
        if (timeB < 0L) {
            timeB += 86400000000000L;
            dateValueB = DateTimeUtils.decrementDateValue(dateValueB);
        } else if (timeB >= 86400000000000L) {
            timeB -= 86400000000000L;
            dateValueB = DateTimeUtils.incrementDateValue(dateValueB);
        }
        int cmp = Long.compare(dateValueA, dateValueB);
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(timeA, timeB);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueTimestampTimeZone)) {
            return false;
        }
        ValueTimestampTimeZone x = (ValueTimestampTimeZone)other;
        return this.dateValue == x.dateValue && this.timeNanos == x.timeNanos && this.timeZoneOffsetMins == x.timeZoneOffsetMins;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32 ^ (long)this.timeZoneOffsetMins);
    }

    @Override
    public Object getObject() {
        if (SysProperties.RETURN_OFFSET_DATE_TIME && LocalDateTimeUtils.isJava8DateApiPresent()) {
            return LocalDateTimeUtils.valueToOffsetDateTime(this);
        }
        return new TimestampWithTimeZone(this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setString(parameterIndex, this.getString());
    }

    @Override
    public Value add(Value v) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIME ZONE values is unsupported");
    }

    @Override
    public Value subtract(Value v) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIME ZONE values is unsupported");
    }
}

